/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.classes;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import org.revapi.Difference;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaTypeElement;

public final class Missing
extends CheckBase {
    @Override
    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.CLASS);
    }

    @Override
    public boolean isDescendingOnNonExisting() {
        return true;
    }

    @Override
    protected void doVisitClass(@Nullable JavaTypeElement oldType, @Nullable JavaTypeElement newType) {
        boolean newInApi;
        boolean oldMissing = oldType != null && this.isMissing(oldType.getDeclaringElement());
        boolean oldInApi = oldType != null && oldType.isInAPI();
        boolean newMissing = newType != null && this.isMissing(newType.getDeclaringElement());
        boolean bl = newInApi = newType != null && newType.isInAPI();
        if ((oldMissing || newMissing) && (oldInApi || newInApi)) {
            this.pushActive(oldType, newType, new Object[0]);
        }
    }

    @Override
    @Nullable
    protected List<Difference> doEnd() {
        CheckBase.ActiveElements types = this.popIfActive();
        if (types == null) {
            return null;
        }
        ArrayList<Difference> ret = new ArrayList<Difference>();
        if (types.oldElement != null) {
            ret.add(this.createDifferenceWithExplicitParams(Code.MISSING_IN_OLD_API, Code.attachmentsFor((JavaTypeElement)types.oldElement, (JavaTypeElement)types.newElement, new String[0]), ((JavaTypeElement)types.oldElement).getDeclaringElement().getQualifiedName().toString()));
        }
        if (types.newElement != null) {
            ret.add(this.createDifferenceWithExplicitParams(Code.MISSING_IN_NEW_API, Code.attachmentsFor((JavaTypeElement)types.oldElement, (JavaTypeElement)types.newElement, new String[0]), ((JavaTypeElement)types.newElement).getDeclaringElement().getQualifiedName().toString()));
        }
        return ret;
    }
}

