/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.classif;

import java.util.List;
import org.revapi.classif.ModelInspector;
import org.revapi.classif.progress.MatchingProgress;
import org.revapi.classif.statement.AbstractStatement;
import org.revapi.classif.util.execution.DependencyGraph;

public final class StructuralMatcher {
    private final DependencyGraph matchTree;
    private final Configuration configuration;

    public StructuralMatcher(Configuration configuration, List<String> namedMatches, List<AbstractStatement> statements) {
        this.matchTree = new DependencyGraph(namedMatches, statements);
        this.configuration = configuration;
    }

    public <M> MatchingProgress<M> with(ModelInspector<M> inspector) {
        return MatchingProgress.of(this.matchTree, inspector, this.configuration);
    }

    public String toString() {
        return this.configuration.toString() + "\n" + this.matchTree.toString();
    }

    public static final class Configuration {
        private final boolean strictHierarchy;

        public Configuration(boolean strictHierarchy) {
            this.strictHierarchy = strictHierarchy;
        }

        public boolean isStrictHierarchy() {
            return this.strictHierarchy;
        }

        public String toString() {
            if (this.strictHierarchy) {
                return "#strictHierarchy;";
            }
            return "";
        }
    }
}

