/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.classif;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public enum TestResult {
    PASSED,
    NOT_PASSED,
    DEFERRED;


    public static TestResult fromBoolean(boolean value) {
        return value ? PASSED : NOT_PASSED;
    }

    public boolean toBoolean(boolean undecidedValue) {
        switch (this) {
            case PASSED: {
                return true;
            }
            case NOT_PASSED: {
                return false;
            }
            case DEFERRED: {
                return undecidedValue;
            }
        }
        throw new IllegalStateException("Unhandled TestResult value: " + (Object)((Object)this));
    }

    public TestResult decide(boolean undecidedValue) {
        return TestResult.fromBoolean(this.toBoolean(undecidedValue));
    }

    public TestResult and(TestResult other) {
        switch (this) {
            case PASSED: {
                return Objects.requireNonNull(other);
            }
            case NOT_PASSED: {
                return this;
            }
            case DEFERRED: {
                return Objects.requireNonNull(other) == NOT_PASSED ? other : this;
            }
        }
        throw new IllegalStateException("Unhandled TestResult: " + (Object)((Object)this));
    }

    public TestResult and(Supplier<TestResult> other) {
        switch (this) {
            case PASSED: {
                return Objects.requireNonNull(other.get());
            }
            case NOT_PASSED: {
                return this;
            }
            case DEFERRED: {
                TestResult res = Objects.requireNonNull(other.get());
                return res == NOT_PASSED ? res : this;
            }
        }
        throw new IllegalStateException("Unhandled TestResult: " + (Object)((Object)this));
    }

    public TestResult or(TestResult other) {
        switch (this) {
            case PASSED: {
                return this;
            }
            case NOT_PASSED: {
                return Objects.requireNonNull(other);
            }
            case DEFERRED: {
                return Objects.requireNonNull(other) == PASSED ? other : this;
            }
        }
        throw new IllegalStateException("Unhandled TestResult: " + (Object)((Object)this));
    }

    public TestResult or(Supplier<TestResult> other) {
        switch (this) {
            case PASSED: {
                return this;
            }
            case NOT_PASSED: {
                return Objects.requireNonNull(other.get());
            }
            case DEFERRED: {
                TestResult res = Objects.requireNonNull(other.get());
                return res == PASSED ? res : this;
            }
        }
        throw new IllegalStateException("Unhandled TestResult: " + (Object)((Object)this));
    }

    public TestResult negate() {
        switch (this) {
            case PASSED: {
                return NOT_PASSED;
            }
            case NOT_PASSED: {
                return PASSED;
            }
            case DEFERRED: {
                return DEFERRED;
            }
        }
        throw new IllegalStateException("Unhandled TestResult: " + (Object)((Object)this));
    }

    public static class TestableStream<T>
    implements Stream<T> {
        private final Stream<T> wrapped;

        private TestableStream(Stream<T> wrapped) {
            this.wrapped = wrapped;
        }

        public static <T> TestableStream<T> testable(Stream<T> stream) {
            return new TestableStream<T>(stream);
        }

        public static <T> TestableStream<T> testable(Collection<T> collection) {
            return TestableStream.testable(collection.stream());
        }

        public TestResult testAny(Predicate<? super T> predicate) {
            return this.wrapped.reduce(NOT_PASSED, (res, next) -> res.or(() -> predicate.test(next)), TestResult::or);
        }

        public TestResult testAll(Predicate<? super T> predicate) {
            return this.wrapped.reduce(PASSED, (res, next) -> res.and(() -> predicate.test(next)), TestResult::and);
        }

        public TestResult testNone(Predicate<? super T> predicate) {
            return this.wrapped.reduce(PASSED, (res, next) -> res.and(() -> predicate.test(next)).negate(), TestResult::and);
        }

        @Override
        public TestableStream<T> filter(java.util.function.Predicate<? super T> predicate) {
            return TestableStream.testable(this.wrapped.filter(predicate));
        }

        @Override
        public <R> TestableStream<R> map(Function<? super T, ? extends R> mapper) {
            return TestableStream.testable(this.wrapped.map(mapper));
        }

        @Override
        public IntStream mapToInt(ToIntFunction<? super T> mapper) {
            return this.wrapped.mapToInt(mapper);
        }

        @Override
        public LongStream mapToLong(ToLongFunction<? super T> mapper) {
            return this.wrapped.mapToLong(mapper);
        }

        @Override
        public DoubleStream mapToDouble(ToDoubleFunction<? super T> mapper) {
            return this.wrapped.mapToDouble(mapper);
        }

        @Override
        public <R> TestableStream<R> flatMap(Function<? super T, ? extends Stream<? extends R>> mapper) {
            return TestableStream.testable(this.wrapped.flatMap(mapper));
        }

        @Override
        public IntStream flatMapToInt(Function<? super T, ? extends IntStream> mapper) {
            return this.wrapped.flatMapToInt(mapper);
        }

        @Override
        public LongStream flatMapToLong(Function<? super T, ? extends LongStream> mapper) {
            return this.wrapped.flatMapToLong(mapper);
        }

        @Override
        public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> mapper) {
            return this.wrapped.flatMapToDouble(mapper);
        }

        @Override
        public TestableStream<T> distinct() {
            return TestableStream.testable(this.wrapped.distinct());
        }

        @Override
        public TestableStream<T> sorted() {
            return TestableStream.testable(this.wrapped.sorted());
        }

        @Override
        public TestableStream<T> sorted(Comparator<? super T> comparator) {
            return TestableStream.testable(this.wrapped.sorted(comparator));
        }

        @Override
        public TestableStream<T> peek(Consumer<? super T> action) {
            return TestableStream.testable(this.wrapped.peek(action));
        }

        @Override
        public TestableStream<T> limit(long maxSize) {
            return TestableStream.testable(this.wrapped.limit(maxSize));
        }

        @Override
        public TestableStream<T> skip(long n) {
            return TestableStream.testable(this.wrapped.skip(n));
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            this.wrapped.forEach(action);
        }

        @Override
        public void forEachOrdered(Consumer<? super T> action) {
            this.wrapped.forEachOrdered(action);
        }

        @Override
        public Object[] toArray() {
            return this.wrapped.toArray();
        }

        @Override
        public <A> A[] toArray(IntFunction<A[]> generator) {
            return this.wrapped.toArray(generator);
        }

        @Override
        public T reduce(T identity, BinaryOperator<T> accumulator) {
            return this.wrapped.reduce(identity, accumulator);
        }

        @Override
        public Optional<T> reduce(BinaryOperator<T> accumulator) {
            return this.wrapped.reduce(accumulator);
        }

        @Override
        public <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
            return this.wrapped.reduce(identity, accumulator, combiner);
        }

        @Override
        public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
            return this.wrapped.collect(supplier, accumulator, combiner);
        }

        @Override
        public <R, A> R collect(Collector<? super T, A, R> collector) {
            return this.wrapped.collect(collector);
        }

        @Override
        public Optional<T> min(Comparator<? super T> comparator) {
            return this.wrapped.min(comparator);
        }

        @Override
        public Optional<T> max(Comparator<? super T> comparator) {
            return this.wrapped.max(comparator);
        }

        @Override
        public long count() {
            return this.wrapped.count();
        }

        @Override
        public boolean anyMatch(java.util.function.Predicate<? super T> predicate) {
            return this.wrapped.anyMatch(predicate);
        }

        @Override
        public boolean allMatch(java.util.function.Predicate<? super T> predicate) {
            return this.wrapped.allMatch(predicate);
        }

        @Override
        public boolean noneMatch(java.util.function.Predicate<? super T> predicate) {
            return this.wrapped.noneMatch(predicate);
        }

        @Override
        public Optional<T> findFirst() {
            return this.wrapped.findFirst();
        }

        @Override
        public Optional<T> findAny() {
            return this.wrapped.findAny();
        }

        @Override
        public Iterator<T> iterator() {
            return this.wrapped.iterator();
        }

        @Override
        public Spliterator<T> spliterator() {
            return this.wrapped.spliterator();
        }

        @Override
        public boolean isParallel() {
            return this.wrapped.isParallel();
        }

        @Override
        public TestableStream<T> sequential() {
            return TestableStream.testable((Stream)this.wrapped.sequential());
        }

        @Override
        public TestableStream<T> parallel() {
            return TestableStream.testable((Stream)this.wrapped.parallel());
        }

        @Override
        public TestableStream<T> unordered() {
            return TestableStream.testable((Stream)this.wrapped.unordered());
        }

        @Override
        public TestableStream<T> onClose(Runnable closeHandler) {
            return TestableStream.testable((Stream)this.wrapped.onClose(closeHandler));
        }

        @Override
        public void close() {
            this.wrapped.close();
        }
    }

    @FunctionalInterface
    public static interface BiPredicate<T, U> {
        public TestResult test(T var1, U var2);
    }

    @FunctionalInterface
    public static interface Predicate<T> {
        public TestResult test(T var1);
    }
}

