/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.classif.progress;

import org.revapi.classif.TestResult;

public final class WalkInstruction {
    private static final WalkInstruction DESCEND_PASSED = new WalkInstruction(true, TestResult.PASSED);
    private static final WalkInstruction DESCEND_NOT_PASSED = new WalkInstruction(true, TestResult.NOT_PASSED);
    private static final WalkInstruction DESCEND_DEFERRED = new WalkInstruction(true, TestResult.DEFERRED);
    private static final WalkInstruction NO_DESCEND_PASSED = new WalkInstruction(false, TestResult.PASSED);
    private static final WalkInstruction NO_DESCEND_NOT_PASSED = new WalkInstruction(false, TestResult.NOT_PASSED);
    private static final WalkInstruction NO_DESCEND_DEFERRED = new WalkInstruction(false, TestResult.DEFERRED);
    private final boolean descend;
    private final TestResult testResult;

    public static WalkInstruction of(boolean descend, TestResult testResult) {
        switch (testResult) {
            case PASSED: {
                return descend ? DESCEND_PASSED : NO_DESCEND_PASSED;
            }
            case NOT_PASSED: {
                return descend ? DESCEND_NOT_PASSED : NO_DESCEND_NOT_PASSED;
            }
            case DEFERRED: {
                return descend ? DESCEND_DEFERRED : NO_DESCEND_DEFERRED;
            }
        }
        throw new IllegalArgumentException("Unsupported test result value: " + (Object)((Object)testResult));
    }

    private WalkInstruction(boolean descend, TestResult testResult) {
        this.descend = descend;
        this.testResult = testResult;
    }

    public boolean isDescend() {
        return this.descend;
    }

    public TestResult getTestResult() {
        return this.testResult;
    }

    public String toString() {
        return "WalkInstruction{descend=" + this.descend + ", testResult=" + (Object)((Object)this.testResult) + '}';
    }
}

