/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.common;

import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import org.revapi.Difference;
import org.revapi.java.checks.ConfigurationAwareCheckBase;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;

public abstract class VisibilityChanged
extends ConfigurationAwareCheckBase {
    private final Code code;
    private final boolean reportIncrease;

    protected VisibilityChanged(Code code, boolean reportIncrease) {
        this.code = code;
        this.reportIncrease = reportIncrease;
    }

    protected final void doVisit(Element oldElement, Element newElement) {
        if (oldElement != null && newElement != null) {
            this.pushActive(oldElement, newElement, new Object[0]);
        }
    }

    @Override
    protected final List<Difference> doEnd() {
        CheckBase.ActiveElements elements = this.popIfActive();
        if (elements != null) {
            Modifier oldVisibility = this.getVisibility((Element)elements.oldElement);
            Modifier newVisibility = this.getVisibility((Element)elements.newElement);
            if (this.isProblem(this.getModifierRank(oldVisibility), this.getModifierRank(newVisibility))) {
                return Collections.singletonList(this.report(oldVisibility, newVisibility));
            }
        }
        return null;
    }

    private boolean isProblem(int oldVisibilityRank, int newVisibilityRank) {
        return this.reportIncrease && oldVisibilityRank > newVisibilityRank || !this.reportIncrease && oldVisibilityRank < newVisibilityRank;
    }

    private Modifier getVisibility(Element t) {
        for (Modifier m : t.getModifiers()) {
            if (m != Modifier.PUBLIC && m != Modifier.PROTECTED && m != Modifier.PRIVATE) continue;
            return m;
        }
        return null;
    }

    private int getModifierRank(Modifier modifier) {
        if (modifier == null) {
            return 2;
        }
        switch (modifier) {
            case PUBLIC: {
                return 0;
            }
            case PROTECTED: {
                return 1;
            }
            case PRIVATE: {
                return 3;
            }
        }
        return Integer.MAX_VALUE;
    }

    private Difference report(Modifier oldVisibility, Modifier newVisibility) {
        return this.createDifference(this.code, (Object[])new String[]{this.modifier(oldVisibility), this.modifier(newVisibility)}, new Object[]{oldVisibility, newVisibility});
    }

    private String modifier(Modifier m) {
        return m == null ? "package" : m.name().toLowerCase();
    }
}

