/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.fields;

import java.util.EnumSet;
import javax.lang.model.element.VariableElement;
import org.revapi.java.checks.ConfigurationAwareCheckBase;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.TypeEnvironment;

abstract class BothFieldsRequiringCheck
extends ConfigurationAwareCheckBase {
    BothFieldsRequiringCheck() {
    }

    @Override
    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.FIELD);
    }

    protected boolean shouldCheck(VariableElement oldField, VariableElement newField) {
        return BothFieldsRequiringCheck.shouldCheck(this, oldField, this.getOldTypeEnvironment(), newField, this.getNewTypeEnvironment());
    }

    protected static boolean shouldCheck(CheckBase check, VariableElement oldField, TypeEnvironment oldEnvironment, VariableElement newField, TypeEnvironment newEnvironment) {
        if (oldField == null || newField == null) {
            return false;
        }
        return !check.isBothPrivate(oldField, newField) && check.isBothAccessibleOrInApi(oldField.getEnclosingElement(), oldEnvironment, newField.getEnclosingElement(), newEnvironment);
    }
}

