/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.filters;

import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.element.AnnotationMirror;
import org.jboss.dmr.ModelNode;
import org.revapi.AnalysisContext;
import org.revapi.Element;
import org.revapi.ElementFilter;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.JavaMethodElement;
import org.revapi.java.spi.JavaModelElement;
import org.revapi.java.spi.JavaTypeElement;
import org.revapi.java.spi.Util;

public final class AnnotatedElementFilter
implements ElementFilter {
    private static final String CONFIG_ROOT_PATH = "revapi.java.filter.annotated";
    private final IdentityHashMap<Object, InclusionState> elementResults = new IdentityHashMap();
    private Predicate<String> includeTest;
    private Predicate<String> excludeTest;
    private boolean doNothing;

    private static Predicate<String> composeTest(List<String> fullMatches, List<Pattern> patterns) {
        if (fullMatches != null && fullMatches.size() > 0) {
            return s -> Collections.binarySearch(fullMatches, s) >= 0;
        }
        if (patterns != null && patterns.size() > 0) {
            return s -> patterns.stream().anyMatch(p -> p.matcher((CharSequence)s).matches());
        }
        return null;
    }

    public void close() throws Exception {
        this.elementResults.clear();
    }

    @Nullable
    public String[] getConfigurationRootPaths() {
        return new String[]{CONFIG_ROOT_PATH};
    }

    public Reader getJSONSchema(@Nonnull String configurationRootPath) {
        if (CONFIG_ROOT_PATH.equals(configurationRootPath)) {
            return new InputStreamReader(this.getClass().getResourceAsStream("/META-INF/annotated-elem-filter-schema.json"), Charset.forName("UTF-8"));
        }
        return null;
    }

    public void initialize(@Nonnull AnalysisContext analysisContext) {
        ModelNode root = analysisContext.getConfiguration().get("revapi", "java", "filter", "annotated");
        if (!root.isDefined()) {
            this.doNothing = true;
            return;
        }
        ModelNode regex = root.get("regex");
        boolean regexes = regex.isDefined() && regex.asBoolean();
        ArrayList<String> fullMatches = new ArrayList<String>();
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        this.readAnnotations(root.get("exclude"), regexes, fullMatches, patterns);
        this.excludeTest = AnnotatedElementFilter.composeTest(fullMatches, patterns);
        fullMatches = new ArrayList();
        patterns = new ArrayList();
        this.readAnnotations(root.get("include"), regexes, fullMatches, patterns);
        this.includeTest = AnnotatedElementFilter.composeTest(fullMatches, patterns);
        this.doNothing = this.includeTest == null && this.excludeTest == null;
    }

    public boolean applies(@Nullable Element element) {
        return this.decide(element);
    }

    public boolean shouldDescendInto(@Nullable Object element) {
        return this.doNothing || element instanceof JavaTypeElement || element instanceof JavaMethodElement;
    }

    private boolean decide(@Nullable Object element) {
        InclusionState parentInclusionState;
        if (this.doNothing || !(element instanceof JavaElement)) {
            return true;
        }
        InclusionState ret = this.elementResults.get(element);
        if (ret != null) {
            return ret.toBoolean();
        }
        JavaElement el = (JavaElement)element;
        Element parent = el.getParent();
        InclusionState inclusionState = parentInclusionState = parent == null ? InclusionState.UNDECIDED : this.elementResults.get(parent);
        if (parentInclusionState == null) {
            parentInclusionState = InclusionState.UNDECIDED;
        }
        if (!(element instanceof JavaModelElement)) {
            return parentInclusionState.toBoolean() && this.includeTest == null;
        }
        JavaModelElement javaElement = (JavaModelElement)element;
        List<? extends AnnotationMirror> annos = javaElement.getModelElement().getAnnotationMirrors();
        ret = parentInclusionState;
        switch (parentInclusionState) {
            case INCLUDED: {
                if (this.excludeTest == null || !annos.stream().map(Util::toHumanReadableString).anyMatch(s -> this.excludeTest.test((String)s))) break;
                ret = InclusionState.EXCLUDED;
                break;
            }
            case EXCLUDED: 
            case UNDECIDED: {
                List stringAnnos = null;
                if (this.includeTest != null || this.excludeTest != null) {
                    stringAnnos = annos.stream().map(Util::toHumanReadableString).collect(Collectors.toList());
                }
                if (this.includeTest != null) {
                    ret = !annos.isEmpty() ? (stringAnnos.stream().anyMatch(s -> this.includeTest.test((String)s)) ? InclusionState.INCLUDED : InclusionState.EXCLUDED) : InclusionState.EXCLUDED;
                }
                if (this.excludeTest == null || !stringAnnos.stream().anyMatch(s -> this.excludeTest.test((String)s))) break;
                ret = InclusionState.EXCLUDED;
            }
        }
        this.elementResults.put(element, ret);
        return ret.toBoolean();
    }

    private void readAnnotations(ModelNode array, boolean regexes, List<String> fullMatches, List<Pattern> patterns) {
        if (!array.isDefined()) {
            return;
        }
        for (ModelNode ann : array.asList()) {
            String name = ann.asString();
            if (regexes) {
                patterns.add(Pattern.compile(name));
                continue;
            }
            fullMatches.add(name);
        }
        if (!regexes) {
            Collections.sort(fullMatches);
        }
    }

    private static enum InclusionState {
        INCLUDED,
        EXCLUDED,
        UNDECIDED;


        boolean toBoolean() {
            switch (this) {
                case INCLUDED: 
                case UNDECIDED: {
                    return true;
                }
            }
            return false;
        }
    }
}

