/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Random;
import javax.media.j3d.BHInternalNode;
import javax.media.j3d.BHNode;
import javax.media.j3d.BHTree;

class BHInsertStructure {
    static boolean debug = false;
    static boolean debug2 = false;
    Random randomNumber = new Random(0L);
    ArrayList[] bhListArr = null;
    ArrayList[] oldBhListArr = null;
    BHNode[] bhListArrRef = null;
    BHNode[] oldBhListArrRef = null;
    int bhListArrCnt = 0;
    int bhListArrMaxCnt = 0;
    int blockSize = 0;

    BHInsertStructure(int length) {
        if (length > 50) {
            length = 50;
        }
        this.blockSize = 50;
        this.bhListArr = new ArrayList[length];
        this.bhListArrRef = new BHNode[length];
        this.bhListArrCnt = 0;
        this.bhListArrMaxCnt = length;
    }

    void clear() {
        for (int i = 0; i < this.bhListArrCnt; ++i) {
            this.bhListArr[i].clear();
            this.bhListArrRef[i] = null;
        }
        this.bhListArrCnt = 0;
    }

    void lookupAndInsert(BHNode parent, BHNode child) {
        boolean found = false;
        for (int i = 0; i < this.bhListArrCnt; ++i) {
            if (this.bhListArrRef[i] != parent) continue;
            this.bhListArr[i].add(child);
            found = true;
            break;
        }
        if (!found) {
            if (this.bhListArrCnt >= this.bhListArrMaxCnt) {
                if (debug) {
                    System.err.println("(1) Expanding bhListArr array ...");
                }
                this.bhListArrMaxCnt += this.blockSize;
                this.oldBhListArr = this.bhListArr;
                this.oldBhListArrRef = this.bhListArrRef;
                this.bhListArr = new ArrayList[this.bhListArrMaxCnt];
                this.bhListArrRef = new BHNode[this.bhListArrMaxCnt];
                System.arraycopy(this.oldBhListArr, 0, this.bhListArr, 0, this.oldBhListArr.length);
                System.arraycopy(this.oldBhListArrRef, 0, this.bhListArrRef, 0, this.oldBhListArrRef.length);
            }
            this.bhListArrRef[this.bhListArrCnt] = parent;
            this.bhListArr[this.bhListArrCnt] = new ArrayList();
            this.bhListArr[this.bhListArrCnt].add(child);
            ++this.bhListArrCnt;
        }
    }

    void updateBoundingTree(BHTree bhTree) {
        for (int i = 0; i < this.bhListArrCnt; ++i) {
            int cnt = 0;
            BHNode child1 = ((BHInternalNode)this.bhListArrRef[i]).getLeftChild();
            BHNode child2 = ((BHInternalNode)this.bhListArrRef[i]).getRightChild();
            if (child1 != null) {
                ++cnt;
            }
            if (child2 != null) {
                ++cnt;
            }
            int size = this.bhListArr[i].size();
            BHNode[] bhArr = new BHNode[cnt + size];
            this.bhListArr[i].toArray(bhArr);
            cnt = 0;
            if (child1 != null) {
                bhArr[size] = child1;
                bhArr[size + ++cnt] = child2;
            }
            if (debug2 && (child1 == null || child2 == null)) {
                System.err.println("child1 or child2 is null ...");
                System.err.println("This is bad, it shouldn't happen");
            }
            ((BHInternalNode)this.bhListArrRef[i]).setRightChild(null);
            ((BHInternalNode)this.bhListArrRef[i]).setLeftChild(null);
            bhTree.cluster((BHInternalNode)this.bhListArrRef[i], bhArr);
        }
    }
}

