/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.DepthComponent;
import javax.media.j3d.DepthComponentIntRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponent;

public class DepthComponentInt
extends DepthComponent {
    DepthComponentInt() {
    }

    public DepthComponentInt(int width, int height) {
        ((DepthComponentIntRetained)this.retained).initialize(width, height);
    }

    public void setDepthData(int[] depthData) {
        this.checkForLiveOrCompiled();
        ((DepthComponentIntRetained)this.retained).setDepthData(depthData);
    }

    public void getDepthData(int[] depthData) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("DepthComponentInt0"));
        }
        ((DepthComponentIntRetained)this.retained).getDepthData(depthData);
    }

    @Override
    void createRetained() {
        this.retained = new DepthComponentIntRetained();
        this.retained.setSource(this);
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        DepthComponentIntRetained rt = (DepthComponentIntRetained)this.retained;
        DepthComponentInt d = new DepthComponentInt(rt.width, rt.height);
        d.duplicateNodeComponent(this);
        return d;
    }

    @Override
    void duplicateAttributes(NodeComponent originalNodeComponent, boolean forceDuplicate) {
        super.duplicateAttributes(originalNodeComponent, forceDuplicate);
        int len = this.getWidth() * this.getHeight();
        int[] d = new int[len];
        ((DepthComponentIntRetained)originalNodeComponent.retained).getDepthData(d);
        ((DepthComponentIntRetained)this.retained).setDepthData(d);
    }
}

