/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.IntegerFreeList;
import javax.media.j3d.MemoryFreeList;

class FreeListManager {
    private static final boolean DEBUG = false;
    static final int DISPLAYLIST = 0;
    private static int maxFreeListNum = 0;
    private static int currlist = 0;
    static MemoryFreeList[] freelist = null;

    FreeListManager() {
    }

    static void createFreeLists() {
        maxFreeListNum = 0;
        freelist = new MemoryFreeList[maxFreeListNum + 1];
        FreeListManager.freelist[0] = new IntegerFreeList();
    }

    static void manageLists() {
        if (freelist[currlist] != null) {
            freelist[currlist].shrink();
        }
        if (++currlist > maxFreeListNum) {
            currlist = 0;
        }
    }

    static MemoryFreeList getFreeList(int list) {
        if (list < 0 || list > maxFreeListNum) {
            return null;
        }
        return freelist[list];
    }

    static Object getObject(int listId) {
        return freelist[listId].getObject();
    }

    static void freeObject(int listId, Object obj) {
        freelist[listId].add(obj);
    }

    static void clearList(int listId) {
        freelist[listId].clear();
    }
}

