/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BoundingBox;
import javax.media.j3d.CompressedGeometryRetained;
import javax.media.j3d.GeneralizedVertexList;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryDecompressor;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.J3dClock;
import javax.media.j3d.J3dI18N;
import javax.vecmath.Color4f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;

class GeometryDecompressorRetained
extends GeometryDecompressor {
    private static final boolean debug = false;
    private static final boolean benchmark = false;
    private static final boolean statistics = false;
    private static final boolean printInfo = false;
    private int bufferDataType;
    private int dataPresent;
    private int size;
    private Color4f curColor;
    private Vector3f curNormal;
    private GeneralizedVertexList vlist;
    private Point3d lbounds = new Point3d();
    private Point3d ubounds = new Point3d();
    private boolean boundsOnly = false;
    private boolean positionsOnly = false;
    private static final float bytesPerVertexFudge = 5.3f;
    private long startTime;
    private long endTime;
    private static final int TYPE_POINT = 1;
    private static final int TYPE_LINE = 2;
    private static final int TYPE_TRIANGLE = 4;
    private static final int FRONTFACE_CCW = 1;

    GeometryDecompressorRetained() {
    }

    void setDecompressBoundsOnly(boolean boundsOnly) {
        this.boundsOnly = boundsOnly;
        if (boundsOnly) {
            this.positionsOnly = false;
        }
    }

    void setDecompressPositionsOnly(boolean positionsOnly) {
        this.positionsOnly = positionsOnly;
        if (positionsOnly) {
            this.boundsOnly = false;
        }
    }

    GeometryRetained decompress(CompressedGeometryRetained cgr) {
        GeometryArray ga;
        if (!this.checkVersion(cgr.majorVersionNumber, cgr.minorVersionNumber)) {
            return null;
        }
        this.vlist = null;
        this.curColor = null;
        this.curNormal = null;
        this.lbounds.set(1.0, 1.0, 1.0);
        this.ubounds.set(-1.0, -1.0, -1.0);
        this.bufferDataType = cgr.bufferType;
        this.dataPresent = cgr.bufferContents;
        this.size = cgr.size;
        super.decompress(cgr.offset, this.size, cgr.compressedGeometry);
        if (this.boundsOnly) {
            return null;
        }
        switch (this.bufferDataType) {
            case 4: {
                ga = this.vlist.toTriangleStripArray();
                break;
            }
            case 2: {
                ga = this.vlist.toLineStripArray();
                break;
            }
            case 1: {
                ga = this.vlist.toPointArray();
                break;
            }
            default: {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryDecompressorRetained0"));
            }
        }
        ga.retained.setSource(null);
        return (GeometryRetained)ga.retained;
    }

    void getBoundingBox(BoundingBox bb) {
        bb.setLower(this.lbounds);
        bb.setUpper(this.ubounds);
    }

    @Override
    void outputVertexFormat(boolean bundlingNorm, boolean bundlingColor, boolean doingAlpha) {
        if (this.boundsOnly) {
            return;
        }
        if (this.vlist != null) {
            throw new IllegalStateException(J3dI18N.getString("GeometryDecompressorRetained1"));
        }
        int vertexFormat = 1;
        if (!this.positionsOnly) {
            if (bundlingNorm) {
                vertexFormat |= 2;
            }
            if (bundlingColor) {
                vertexFormat |= 4;
            }
            if (doingAlpha) {
                vertexFormat |= 8;
            }
        }
        this.vlist = new GeneralizedVertexList(vertexFormat, 1, (int)((float)this.size / 5.3f));
    }

    @Override
    void outputVertex(Point3f position, Vector3f normal, Color4f color, int vertexReplaceCode) {
        if ((double)position.x < this.lbounds.x) {
            this.lbounds.x = position.x;
        }
        if ((double)position.y < this.lbounds.y) {
            this.lbounds.y = position.y;
        }
        if ((double)position.z < this.lbounds.z) {
            this.lbounds.z = position.z;
        }
        if ((double)position.x > this.ubounds.x) {
            this.ubounds.x = position.x;
        }
        if ((double)position.y > this.ubounds.y) {
            this.ubounds.y = position.y;
        }
        if ((double)position.z > this.ubounds.z) {
            this.ubounds.z = position.z;
        }
        if (this.boundsOnly) {
            return;
        }
        if (this.curColor != null) {
            color = this.curColor;
        }
        if (this.curNormal != null) {
            normal = this.curNormal;
        }
        this.vlist.addVertex(position, normal, color, vertexReplaceCode);
    }

    @Override
    void outputColor(Color4f color) {
        if (this.boundsOnly || this.positionsOnly) {
            return;
        }
        if ((this.vlist.vertexFormat & 4) == 0) {
            if (this.vlist.size() > 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryDecompressorRetained2"));
            }
            this.vlist.setVertexFormat(this.vlist.vertexFormat | 4);
        }
        if (this.curColor == null) {
            this.curColor = new Color4f();
        }
        this.curColor.set((Tuple4f)color);
    }

    @Override
    void outputNormal(Vector3f normal) {
        if (this.boundsOnly || this.positionsOnly) {
            return;
        }
        if ((this.vlist.vertexFormat & 2) == 0) {
            if (this.vlist.size() > 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryDecompressorRetained3"));
            }
            this.vlist.setVertexFormat(this.vlist.vertexFormat | 2);
        }
        if (this.curNormal == null) {
            this.curNormal = new Vector3f();
        }
        this.curNormal.set((Tuple3f)normal);
    }

    private void beginPrint() {
        System.err.println("\nGeometryDecompressorRetained");
        switch (this.bufferDataType) {
            case 4: {
                System.err.println(" buffer TYPE_TRIANGLE");
                break;
            }
            case 2: {
                System.err.println(" buffer TYPE_LINE");
                break;
            }
            case 1: {
                System.err.println(" buffer TYPE_POINT");
                break;
            }
            default: {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryDecompressorRetained4"));
            }
        }
        System.err.print(" buffer data present: coords");
        if ((this.dataPresent & 1) != 0) {
            System.err.print(" normals");
        }
        if ((this.dataPresent & 2) != 0) {
            System.err.print(" colors");
        }
        if ((this.dataPresent & 4) != 0) {
            System.err.print(" alpha");
        }
        System.err.println();
        if (this.boundsOnly) {
            System.err.println(" computing bounds only");
        }
        if (this.positionsOnly) {
            System.err.println(" computing positions only");
        }
        this.startTime = J3dClock.currentTimeMillis();
    }

    private void endPrint() {
        this.endTime = J3dClock.currentTimeMillis();
    }

    private void printBench() {
        float t = (float)(this.endTime - this.startTime) / 1000.0f;
        if (this.boundsOnly) {
            System.err.println(" decompression took " + t + " sec.\n");
            return;
        }
        System.err.println(" decompression + strip conversion took " + t + " sec.");
        switch (this.bufferDataType) {
            case 1: {
                System.err.println(" decompressed " + this.vlist.size() + " points at " + (float)this.vlist.size() / t + " points/sec.\n");
                break;
            }
            case 2: {
                System.err.println(" decompressed " + (this.vlist.vertexCount - this.vlist.stripCount) + " lines at " + (float)(this.vlist.vertexCount - this.vlist.stripCount) / t + " lines/sec.\n");
                break;
            }
            case 4: {
                System.err.println(" decompressed " + (this.vlist.vertexCount - 2 * this.vlist.stripCount) + " triangles at " + (float)(this.vlist.vertexCount - 2 * this.vlist.stripCount) / t + " triangles/sec.\n");
            }
        }
    }

    private void printStats() {
        System.err.println(" bounding box:\n  lower " + this.lbounds.toString() + "\n  upper " + this.ubounds.toString());
        if (this.boundsOnly) {
            return;
        }
        System.err.print(" number of vertices in GeometryArray output: " + this.vlist.vertexCount + "\n" + " GeometryArray vertex data present: coords");
        if ((this.vlist.vertexFormat & 2) != 0) {
            System.err.print(" normals");
        }
        if ((this.vlist.vertexFormat & 4) != 0) {
            System.err.print(" colors");
        }
        if ((this.vlist.vertexFormat & 8) != 0) {
            System.err.print(" alpha");
        }
        System.err.println("\n number of strips: " + this.vlist.stripCount);
        if (this.vlist.stripCount > 0) {
            System.err.println(" vertices/strip: " + (float)this.vlist.vertexCount / (float)this.vlist.stripCount);
        }
    }
}

