/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

class GeometryLock {
    Thread threadId = null;
    boolean lockOwned = false;
    int count = 0;
    int waiting = 0;

    GeometryLock() {
    }

    synchronized void getLock() {
        Thread curThread = Thread.currentThread();
        if (this.threadId == curThread) {
            ++this.count;
            return;
        }
        while (this.lockOwned) {
            try {
                ++this.waiting;
                this.wait();
            }
            catch (InterruptedException e) {
                System.err.println(e);
            }
            --this.waiting;
        }
        ++this.count;
        this.lockOwned = true;
        this.threadId = curThread;
    }

    synchronized void unLock() {
        Thread curThread = Thread.currentThread();
        if (this.threadId == curThread) {
            if (--this.count > 0) {
                return;
            }
            this.lockOwned = false;
            this.threadId = null;
            if (this.waiting > 0) {
                this.notify();
            }
        }
    }
}

