/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Bounds;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GeometryLock;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.PickInfo;
import javax.media.j3d.PickShape;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point3d;

abstract class GeometryRetained
extends NodeComponentRetained {
    static final int GEO_TYPE_NONE = -1;
    static final int GEO_TYPE_QUAD_SET = 1;
    static final int GEO_TYPE_TRI_SET = 2;
    static final int GEO_TYPE_POINT_SET = 3;
    static final int GEO_TYPE_LINE_SET = 4;
    static final int GEO_TYPE_TRI_STRIP_SET = 5;
    static final int GEO_TYPE_TRI_FAN_SET = 6;
    static final int GEO_TYPE_LINE_STRIP_SET = 7;
    static final int GEO_TYPE_INDEXED_QUAD_SET = 8;
    static final int GEO_TYPE_INDEXED_TRI_SET = 9;
    static final int GEO_TYPE_INDEXED_POINT_SET = 10;
    static final int GEO_TYPE_INDEXED_LINE_SET = 11;
    static final int GEO_TYPE_INDEXED_TRI_STRIP_SET = 12;
    static final int GEO_TYPE_INDEXED_TRI_FAN_SET = 13;
    static final int GEO_TYPE_INDEXED_LINE_STRIP_SET = 14;
    static final int GEO_TYPE_RASTER = 15;
    static final int GEO_TYPE_TEXT3D = 16;
    static final int GEO_TYPE_COMPRESSED = 17;
    static final int GEO_TYPE_TOTAL = 17;
    static final int GEO_TYPE_GEOMETRYARRAY = 14;
    BoundingBox geoBounds = new BoundingBox();
    boolean boundsDirty = true;
    int computeGeoBounds = 0;
    int geoType = -1;
    int nativeId = -1;
    int isDirty = 65535;
    GeometryLock geomLock = new GeometryLock();
    Object liveStateLock = new Object();
    GeometryRetained mirrorGeometry = null;
    boolean isEditable = true;
    ArrayList<VirtualUniverse> universeList = new ArrayList();
    ArrayList<ArrayList<Shape3DRetained>> userLists = new ArrayList();
    boolean noAlpha = false;
    static final double EPSILON = 1.0E-6;
    Point3d centroid = new Point3d();
    boolean recompCentroid = true;
    int cachedChangedFrequent = 0;
    static final int POINT_TYPE = 1;
    static final int LINE_TYPE = 2;
    static final int TRIANGLE_TYPE = 3;
    static final int QUAD_TYPE = 4;
    static final int RASTER_TYPE = 5;
    static final int TEXT3D_TYPE = 6;
    static final int COMPRESS_TYPE = 7;

    GeometryRetained() {
    }

    abstract void update();

    boolean isEquivalenceClass(GeometryRetained geometry) {
        int t1 = this.getClassType();
        int t2 = geometry.getClassType();
        if (t1 == 4) {
            t1 = 3;
        }
        if (t2 == 4) {
            t2 = 3;
        }
        return t1 == t2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrComputeGeoBounds() {
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            ++this.computeGeoBounds;
            if (this.computeGeoBounds == 1 && this.source.isLive()) {
                this.computeBoundingBox();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decrComputeGeoBounds() {
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            --this.computeGeoBounds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addUser(Shape3DRetained s) {
        if (s.sourceNode.boundsAutoCompute) {
            this.incrComputeGeoBounds();
        }
        if (this instanceof GeometryArrayRetained && ((GeometryArrayRetained)this).isWriteStatic()) {
            return;
        }
        ArrayList<VirtualUniverse> arrayList = this.universeList;
        synchronized (arrayList) {
            if (this.universeList.contains(s.universe)) {
                int index = this.universeList.indexOf(s.universe);
                this.userLists.get(index).add(s);
            } else {
                this.universeList.add(s.universe);
                ArrayList<Shape3DRetained> shapeList = new ArrayList<Shape3DRetained>();
                shapeList.add(s);
                this.userLists.add(shapeList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeUser(Shape3DRetained s) {
        if (s.sourceNode.boundsAutoCompute) {
            this.decrComputeGeoBounds();
        }
        if (this instanceof GeometryArrayRetained && ((GeometryArrayRetained)this).isWriteStatic()) {
            return;
        }
        ArrayList<VirtualUniverse> arrayList = this.universeList;
        synchronized (arrayList) {
            int index = this.universeList.indexOf(s.universe);
            ArrayList<Shape3DRetained> shapeList = this.userLists.get(index);
            shapeList.remove(s);
            if (shapeList.size() == 0) {
                this.userLists.remove(index);
                this.universeList.remove(index);
            }
        }
    }

    public void updateObject() {
        this.update();
    }

    abstract void computeBoundingBox();

    @Override
    void setLive(boolean inBackgroundGroup, int refCount) {
        this.doSetLive(inBackgroundGroup, refCount);
        super.markAsLive();
    }

    @Override
    void doSetLive(boolean inBackgroundGroup, int refCount) {
        super.doSetLive(inBackgroundGroup, refCount);
        this.update();
        this.computeBoundingBox();
    }

    abstract void execute(Canvas3D var1, RenderAtom var2, boolean var3, boolean var4, float var5, int var6, boolean var7);

    int getVertexFormat() {
        return 0;
    }

    abstract boolean intersect(PickShape var1, PickInfo var2, int var3, Point3d var4, GeometryRetained var5, int var6);

    abstract boolean intersect(Bounds var1);

    abstract boolean intersect(Point3d[] var1);

    abstract boolean intersect(Transform3D var1, GeometryRetained var2);

    void storeInterestData(PickInfo pickInfo, int flags, GeometryRetained geom, int geomIndex, int[] vtxIndexArr, Point3d iPnt, double dist) {
        PickInfo.IntersectionInfo iInfo = null;
        if ((flags & 0x20) != 0) {
            PickInfo.IntersectionInfo[] iInfoArr = pickInfo.getIntersectionInfos();
            if (iInfoArr == null || iInfoArr.length == 0) {
                iInfo = pickInfo.createIntersectionInfo();
                pickInfo.insertIntersectionInfo(iInfo);
            } else {
                assert (iInfoArr.length == 1);
                iInfo = iInfoArr[0];
            }
        } else if ((flags & 0x40) != 0) {
            iInfo = pickInfo.createIntersectionInfo();
            pickInfo.insertIntersectionInfo(iInfo);
        } else assert (false);
        iInfo.setGeometry((Geometry)geom.source);
        iInfo.setGeometryIndex(geomIndex);
        iInfo.setDistance(dist);
        iInfo.setIntersectionPoint(iPnt);
        iInfo.setVertexIndices(vtxIndexArr);
    }

    boolean intersect(Transform3D thisLocalToVworld, Transform3D otherLocalToVworld, GeometryRetained geom) {
        Transform3D t3d = new Transform3D();
        t3d.invert(otherLocalToVworld);
        t3d.mul(thisLocalToVworld);
        return this.intersect(t3d, geom);
    }

    boolean intersect(Transform3D thisLocalToVworld, Bounds targetBound) {
        Bounds transBound = (Bounds)targetBound.clone();
        Transform3D t3d = new Transform3D();
        t3d.invert(thisLocalToVworld);
        transBound.transform(t3d);
        return this.intersect(transBound);
    }

    boolean canBeInDisplayList(boolean alphaEditable) {
        if (!VirtualUniverse.mc.isDisplayList) {
            return false;
        }
        if (this.isEditable) {
            if (this.cachedChangedFrequent != 0) {
                return false;
            }
            if (!VirtualUniverse.mc.buildDisplayListIfPossible) {
                return false;
            }
        }
        if (this instanceof GeometryArrayRetained) {
            int vFormat = ((GeometryArrayRetained)this).vertexFormat;
            if ((vFormat & 0x1000) != 0 && !VirtualUniverse.mc.vertexAttrsInDisplayList) {
                return false;
            }
            if (alphaEditable && (vFormat & 4) != 0) {
                return false;
            }
            if ((vFormat & 0x80) != 0) {
                if (!VirtualUniverse.mc.buildDisplayListIfPossible) {
                    return false;
                }
                if ((vFormat & 0x800) != 0) {
                    return false;
                }
                if ((vFormat & 0x200) != 0) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    void computeCentroid() {
        this.geoBounds.getCenter(this.centroid);
    }

    abstract int getClassType();
}

