/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import javax.media.j3d.BehaviorScheduler;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.MasterControl;
import javax.media.j3d.VirtualUniverse;

public class GraphicsConfigTemplate3D
extends GraphicsConfigTemplate {
    int depthSize = 16;
    int doubleBuffer = 1;
    int blueSize = 2;
    int greenSize = 2;
    int redSize = 2;
    int sceneAntialiasing = 3;
    int stereo = 3;
    int stencilSize = 0;
    Object testCfg;
    static Object globalLock = new Object();
    static Object monitorLock = new Object();
    static volatile boolean threadWaiting = false;

    public void setDoubleBuffer(int value) {
        if (value < 1 && value > 3) {
            return;
        }
        this.doubleBuffer = value;
    }

    public int getDoubleBuffer() {
        return this.doubleBuffer;
    }

    public void setStereo(int value) {
        if (value < 1 && value > 3) {
            return;
        }
        this.stereo = value;
    }

    public int getStereo() {
        return this.stereo;
    }

    public void setSceneAntialiasing(int value) {
        if (value < 1 && value > 3) {
            return;
        }
        this.sceneAntialiasing = value;
    }

    public int getSceneAntialiasing() {
        return this.sceneAntialiasing;
    }

    public void setDepthSize(int value) {
        if (value < 0) {
            return;
        }
        this.depthSize = value;
    }

    public int getDepthSize() {
        return this.depthSize;
    }

    public void setStencilSize(int value) {
        if (value < 0) {
            return;
        }
        this.stencilSize = value;
    }

    public int getStencilSize() {
        return this.stencilSize;
    }

    public void setRedSize(int value) {
        if (value < 0) {
            return;
        }
        this.redSize = value;
    }

    public int getRedSize() {
        return this.redSize;
    }

    public void setGreenSize(int value) {
        if (value < 0) {
            return;
        }
        this.greenSize = value;
    }

    public int getGreenSize() {
        return this.greenSize;
    }

    public void setBlueSize(int value) {
        if (value < 0) {
            return;
        }
        this.blueSize = value;
    }

    public int getBlueSize() {
        return this.blueSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphicsConfiguration getBestConfiguration(GraphicsConfiguration[] gc) {
        if (gc == null || gc.length == 0 || gc[0] == null) {
            return null;
        }
        Object object = globalLock;
        synchronized (object) {
            this.testCfg = gc;
            threadWaiting = true;
            if (Thread.currentThread() instanceof BehaviorScheduler) {
                VirtualUniverse.mc.sendRenderMessage(gc[0], this, MasterControl.GETBESTCONFIG);
            } else {
                VirtualUniverse.mc.postRequest(MasterControl.GETBESTCONFIG, this);
            }
            GraphicsConfigTemplate3D.runMonitor(0);
            return (GraphicsConfiguration)this.testCfg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isGraphicsConfigSupported(GraphicsConfiguration gc) {
        if (gc == null) {
            return false;
        }
        Object object = globalLock;
        synchronized (object) {
            this.testCfg = gc;
            threadWaiting = true;
            if (Thread.currentThread() instanceof BehaviorScheduler) {
                VirtualUniverse.mc.sendRenderMessage(gc, this, MasterControl.ISCONFIGSUPPORT);
            } else {
                VirtualUniverse.mc.postRequest(MasterControl.ISCONFIGSUPPORT, this);
            }
            GraphicsConfigTemplate3D.runMonitor(0);
            return (Boolean)this.testCfg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void getGraphicsConfigFeatures(Canvas3D c) {
        Object object = globalLock;
        synchronized (object) {
            threadWaiting = true;
            if (Thread.currentThread() instanceof BehaviorScheduler) {
                VirtualUniverse.mc.sendRenderMessage(c.graphicsConfiguration, c, MasterControl.SET_GRAPHICSCONFIG_FEATURES);
            } else {
                VirtualUniverse.mc.postRequest(MasterControl.SET_GRAPHICSCONFIG_FEATURES, c);
            }
            GraphicsConfigTemplate3D.runMonitor(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setQueryProps(Canvas3D c) {
        Object object = globalLock;
        synchronized (object) {
            threadWaiting = true;
            if (Thread.currentThread() instanceof BehaviorScheduler) {
                VirtualUniverse.mc.sendRenderMessage(c.graphicsConfiguration, c, MasterControl.SET_QUERYPROPERTIES);
            } else {
                VirtualUniverse.mc.postRequest(MasterControl.SET_QUERYPROPERTIES, c);
            }
            GraphicsConfigTemplate3D.runMonitor(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void runMonitor(int action) {
        Object object = monitorLock;
        synchronized (object) {
            switch (action) {
                case 0: {
                    while (threadWaiting) {
                        try {
                            monitorLock.wait();
                        }
                        catch (InterruptedException e) {
                            System.err.println(e);
                        }
                    }
                    break;
                }
                case 2: {
                    monitorLock.notify();
                    threadWaiting = false;
                }
            }
        }
    }

    private static final String enumStr(int val) {
        switch (val) {
            case 1: {
                return "REQUIRED";
            }
            case 2: {
                return "PREFERRED";
            }
            case 3: {
                return "UNNECESSARY";
            }
        }
        return "UNDEFINED";
    }

    public String toString() {
        return "redSize : " + this.redSize + ", " + "greenSize : " + this.greenSize + ", " + "blueSize : " + this.blueSize + ", " + "depthSize : " + this.depthSize + ", " + "doubleBuffer : " + GraphicsConfigTemplate3D.enumStr(this.doubleBuffer) + ", " + "sceneAntialiasing : " + GraphicsConfigTemplate3D.enumStr(this.sceneAntialiasing) + ", " + "stereo : " + GraphicsConfigTemplate3D.enumStr(this.stereo);
    }
}

