/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.AlternateAppearanceRetained;
import javax.media.j3d.BHLeafInterface;
import javax.media.j3d.BHLeafNode;
import javax.media.j3d.BehaviorRetained;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.BranchGroupRetained;
import javax.media.j3d.CachedTargets;
import javax.media.j3d.CompileState;
import javax.media.j3d.FogRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.J3dDebug;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.LightRetained;
import javax.media.j3d.LinkRetained;
import javax.media.j3d.Locale;
import javax.media.j3d.ModelClipRetained;
import javax.media.j3d.MorphRetained;
import javax.media.j3d.MultipleParentException;
import javax.media.j3d.Node;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.OrderedGroupRetained;
import javax.media.j3d.OrderedPath;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.SharedGroupRetained;
import javax.media.j3d.SwitchRetained;
import javax.media.j3d.SwitchState;
import javax.media.j3d.Targets;
import javax.media.j3d.TargetsInterface;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.UnorderList;
import javax.media.j3d.View;
import javax.media.j3d.ViewSpecificGroupRetained;
import javax.media.j3d.VirtualUniverse;

class GroupRetained
extends NodeRetained
implements BHLeafInterface {
    ArrayList<NodeRetained> children = new ArrayList(1);
    Bounds collisionBound = null;
    Locale locale = null;
    ArrayList<ArrayList<LightRetained>> lights = null;
    ArrayList<ArrayList<FogRetained>> fogs = null;
    ArrayList<ArrayList<ModelClipRetained>> modelClips = null;
    ArrayList<ArrayList<AlternateAppearanceRetained>> altAppearances = null;
    boolean collisionTarget = false;
    ArrayList<ArrayList<NodeRetained>> childrenSwitchLinks = null;
    int parentSwitchLinkChildIndex = -1;
    ArrayList<OrderedPath> orderedPaths = null;
    BoundingBox collisionVwcBounds;
    ArrayList<GroupRetained> mirrorGroup;
    HashKey key;
    GroupRetained sourceNode;
    BHLeafNode bhLeafNode = null;
    boolean isRoot = false;
    boolean allocatedLights = false;
    boolean allocatedFogs = false;
    boolean allocatedMclips = false;
    boolean allocatedAltApps = false;
    int scopingRefCount = 0;
    ArrayList<NodeRetained> compiledChildrenList = null;
    boolean isInClearLive = false;
    ArrayList<ArrayList<View>> viewLists = null;
    boolean inViewSpecificGroup = false;

    GroupRetained() {
        this.nodeType = 23;
        this.localBounds = VirtualUniverse.mc.useBoxForGroupBounds ? new BoundingBox((Bounds)null) : new BoundingSphere((Bounds)null);
    }

    void setCollisionBounds(Bounds bounds) {
        this.collisionBound = bounds == null ? null : (Bounds)bounds.clone();
        if (this.source.isLive()) {
            J3dMessage message = new J3dMessage();
            message.type = 34;
            message.threads = 8256;
            message.universe = this.universe;
            message.args[0] = this;
            VirtualUniverse.mc.processMessage(message);
        }
    }

    Bounds getCollisionBounds() {
        return this.collisionBound == null ? null : (Bounds)this.collisionBound.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setChild(Node child, int index) {
        this.checkValidChild(child, "GroupRetained0");
        if (this.source.isLive()) {
            this.universe.resetWaitMCFlag();
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                this.doSetChild(child, index);
                this.universe.setLiveState.clear();
            }
            this.universe.waitForMC();
        } else {
            this.doSetChild(child, index);
            if (this.universe != null) {
                Object object = this.universe.sceneGraphLock;
                synchronized (object) {
                    this.universe.setLiveState.clear();
                }
            }
        }
        this.dirtyBoundsCache();
    }

    void doSetChild(Node child, int index) {
        J3dMessage[] messages = null;
        int numMessages = 0;
        int attachStartIndex = 0;
        NodeRetained oldchildr = this.children.get(index);
        if (this.source.isLive()) {
            if (oldchildr != null) {
                numMessages += 3;
                attachStartIndex = 3;
            }
            if (child != null) {
                numMessages += 4;
            }
            messages = new J3dMessage[numMessages];
            for (int i = 0; i < numMessages; ++i) {
                messages[i] = new J3dMessage();
            }
        }
        if (oldchildr != null) {
            oldchildr.setParent(null);
            this.checkClearLive(oldchildr, messages, 0, index, null);
            if (this.source.isLive()) {
                this.universe.notifyStructureChangeListeners(false, (Object)this.source, (BranchGroup)oldchildr.source);
            }
        }
        this.removeChildrenData(index);
        if (child == null) {
            this.children.set(index, null);
            if (messages != null) {
                VirtualUniverse.mc.processMessage(messages);
            }
            return;
        }
        if (this.source.isLive()) {
            this.universe.notifyStructureChangeListeners(true, (Object)this.source, (BranchGroup)child);
        }
        NodeRetained childr = (NodeRetained)child.retained;
        childr.setParent(this);
        this.children.set(index, childr);
        this.insertChildrenData(index);
        this.checkSetLive(childr, index, messages, attachStartIndex, null);
        if (this.source.isLive()) {
            ((BranchGroupRetained)childr).isNew = true;
        }
        if (messages != null) {
            VirtualUniverse.mc.processMessage(messages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertChild(Node child, int index) {
        this.checkValidChild(child, "GroupRetained1");
        if (this.source.isLive()) {
            this.universe.resetWaitMCFlag();
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                this.universe.notifyStructureChangeListeners(true, (Object)this.source, (BranchGroup)child);
                this.doInsertChild(child, index);
                this.universe.setLiveState.clear();
            }
            this.universe.waitForMC();
        } else {
            this.doInsertChild(child, index);
            if (this.universe != null) {
                Object object = this.universe.sceneGraphLock;
                synchronized (object) {
                    this.universe.setLiveState.clear();
                }
            }
        }
        this.dirtyBoundsCache();
    }

    void doInsertChild(Node child, int index) {
        this.insertChildrenData(index);
        for (int i = index; i < this.children.size(); ++i) {
            NodeRetained childi = this.children.get(i);
            if (childi == null) continue;
            ++childi.childIndex;
        }
        if (child == null) {
            this.children.add(index, null);
            return;
        }
        NodeRetained childr = (NodeRetained)child.retained;
        childr.setParent(this);
        this.children.add(index, childr);
        this.checkSetLive(childr, index, null, 0, null);
        if (this.source.isLive()) {
            ((BranchGroupRetained)childr).isNew = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeChild(int index) {
        if (this.source.isLive()) {
            this.universe.resetWaitMCFlag();
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                NodeRetained childr = this.children.get(index);
                this.doRemoveChild(index, null, 0);
                this.universe.setLiveState.clear();
                this.universe.notifyStructureChangeListeners(false, (Object)this.source, (BranchGroup)childr.source);
            }
            this.universe.waitForMC();
        } else {
            this.doRemoveChild(index, null, 0);
            if (this.universe != null) {
                Object object = this.universe.sceneGraphLock;
                synchronized (object) {
                    this.universe.setLiveState.clear();
                }
            }
        }
        this.dirtyBoundsCache();
    }

    int indexOfChild(Node child) {
        if (child != null) {
            return this.children.indexOf((NodeRetained)child.retained);
        }
        return this.children.indexOf(null);
    }

    void removeChild(Node child) {
        int i = this.indexOfChild(child);
        if (i >= 0) {
            this.removeChild(i);
        }
    }

    void removeAllChildren() {
        int n = this.children.size();
        for (int i = n - 1; i >= 0; --i) {
            this.removeChild(i);
        }
    }

    void doRemoveChild(int index, J3dMessage[] messages, int messageIndex) {
        NodeRetained oldchildr = this.children.get(index);
        int size = this.children.size();
        for (int i = index; i < size; ++i) {
            NodeRetained child = this.children.get(i);
            if (child == null) continue;
            --child.childIndex;
        }
        if (oldchildr != null) {
            oldchildr.setParent(null);
            this.checkClearLive(oldchildr, messages, messageIndex, index, null);
        }
        this.children.remove(index);
        this.removeChildrenData(index);
        if (this.nodeType == 18) {
            SwitchRetained sg = (SwitchRetained)this;
            sg.setWhichChild(sg.whichChild, true);
        }
    }

    Node getChild(int index) {
        NodeRetained sgo = this.children.get(index);
        if (sgo == null) {
            return null;
        }
        return (Node)sgo.source;
    }

    Enumeration<Node> getAllChildren() {
        Vector<Node> userChildren = new Vector<Node>(this.children.size());
        for (int i = 0; i < this.children.size(); ++i) {
            NodeRetained sgo = this.children.get(i);
            if (sgo != null) {
                userChildren.add((Node)sgo.source);
                continue;
            }
            userChildren.add(null);
        }
        return userChildren.elements();
    }

    void checkValidChild(Node child, String s) {
        if (child != null && (child instanceof BranchGroup && ((BranchGroupRetained)child.retained).attachedToLocale || ((NodeRetained)child.retained).parent != null)) {
            throw new MultipleParentException(J3dI18N.getString(s));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChild(Node child) {
        this.checkValidChild(child, "GroupRetained2");
        if (this.source.isLive()) {
            this.universe.resetWaitMCFlag();
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                this.universe.notifyStructureChangeListeners(true, (Object)this.source, (BranchGroup)child);
                this.doAddChild(child, null, 0);
                this.universe.setLiveState.clear();
            }
            this.universe.waitForMC();
        } else {
            this.doAddChild(child, null, 0);
            if (this.universe != null) {
                Object object = this.universe.sceneGraphLock;
                synchronized (object) {
                    this.universe.setLiveState.clear();
                }
            }
        }
        this.dirtyBoundsCache();
    }

    void doAddChild(Node child, J3dMessage[] messages, int messageIndex) {
        this.appendChildrenData();
        if (child == null) {
            this.children.add(null);
            return;
        }
        NodeRetained childr = (NodeRetained)child.retained;
        childr.setParent(this);
        this.children.add(childr);
        this.checkSetLive(childr, this.children.size() - 1, messages, messageIndex, null);
        if (this.source.isLive()) {
            ((BranchGroupRetained)childr).isNew = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveTo(BranchGroup bg) {
        if (bg != null) {
            ((GroupRetained)bg.retained).dirtyBoundsCache();
        }
        if (this.source.isLive()) {
            this.universe.resetWaitMCFlag();
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                GroupRetained oldParent = (GroupRetained)((BranchGroupRetained)bg.retained).parent;
                this.doMoveTo(bg);
                this.universe.setLiveState.clear();
                if (oldParent == null) {
                    this.universe.notifyStructureChangeListeners(((BranchGroupRetained)bg.retained).locale, (Object)this.source, bg);
                } else {
                    this.universe.notifyStructureChangeListeners(oldParent.source, (Object)this.source, bg);
                }
            }
            this.universe.waitForMC();
        } else {
            this.doMoveTo(bg);
            if (this.universe != null) {
                Object object = this.universe.sceneGraphLock;
                synchronized (object) {
                    this.universe.setLiveState.clear();
                }
            }
        }
        this.dirtyBoundsCache();
    }

    void doMoveTo(BranchGroup branchGroup) {
        J3dMessage[] messages = null;
        int numMessages = 0;
        int detachStartIndex = 0;
        int attachStartIndex = 0;
        if (branchGroup != null) {
            BranchGroupRetained bg = (BranchGroupRetained)branchGroup.retained;
            GroupRetained g = (GroupRetained)bg.parent;
            if (g != null) {
                if (g.source.isLive()) {
                    numMessages = 3;
                    attachStartIndex = 3;
                } else {
                    numMessages = 0;
                    attachStartIndex = 0;
                }
            } else {
                numMessages = 3;
                attachStartIndex = 3;
            }
            if (this.source.isLive()) {
                numMessages += 4;
            }
            messages = new J3dMessage[numMessages];
            for (int i = 0; i < numMessages; ++i) {
                messages[i] = new J3dMessage();
                messages[i].type = -1;
            }
            if (g == null) {
                if (bg.locale != null) {
                    bg.locale.doRemoveBranchGraph(branchGroup, messages, detachStartIndex);
                }
            } else {
                g.doRemoveChild(g.children.indexOf(bg), messages, detachStartIndex);
            }
        }
        this.doAddChild(branchGroup, messages, attachStartIndex);
        if (numMessages > 0) {
            int count = 0;
            for (int i = 0; i < numMessages; ++i) {
                if (messages[i].type == -1) continue;
                ++count;
            }
            if (count == numMessages) {
                VirtualUniverse.mc.processMessage(messages);
            } else {
                J3dMessage[] ms = null;
                if (count > 0) {
                    ms = new J3dMessage[count];
                }
                int k = 0;
                for (int i = 0; i < numMessages; ++i) {
                    if (messages[i].type == -1) continue;
                    ms[k++] = messages[i];
                }
                if (ms != null) {
                    VirtualUniverse.mc.processMessage(ms);
                }
            }
        }
    }

    int numChildren() {
        return this.children.size();
    }

    void removeLight(int numLgt, LightRetained[] removelight, HashKey key) {
        block3: {
            block2: {
                if (!this.inSharedGroup) break block2;
                int hkIndex = key.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                ArrayList<LightRetained> l = this.lights.get(hkIndex);
                if (l == null) break block3;
                for (int i = 0; i < numLgt; ++i) {
                    int index = l.indexOf(removelight[i]);
                    l.remove(index);
                }
                break block3;
            }
            ArrayList<LightRetained> l = this.lights.get(0);
            for (int i = 0; i < numLgt; ++i) {
                int index = l.indexOf(removelight[i]);
                l.remove(index);
            }
        }
    }

    void addAllNodesForScopedLight(int numLgts, LightRetained[] ml, ArrayList list, HashKey k) {
        if (this.inSharedGroup) {
            for (int i = 0; i < this.localToVworldKeys.length; ++i) {
                k.set(this.localToVworldKeys[i]);
                this.processAllNodesForScopedLight(numLgts, ml, list, k);
            }
        } else {
            this.processAllNodesForScopedLight(numLgts, ml, list, k);
        }
    }

    void processAllNodesForScopedLight(int numLgts, LightRetained[] ml, ArrayList list, HashKey k) {
        if (this.allocatedLights) {
            this.addLight(ml, numLgts, k);
        }
        if (this.source.isLive() || this.isInSetLive()) {
            for (int i = this.children.size() - 1; i >= 0; --i) {
                NodeRetained child = this.children.get(i);
                if (child == null) continue;
                if (child instanceof GroupRetained && (child.source.isLive() || child.isInSetLive())) {
                    ((GroupRetained)child).processAllNodesForScopedLight(numLgts, ml, list, k);
                    continue;
                }
                if (child instanceof LinkRetained && (child.source.isLive() || child.isInSetLive())) {
                    int lastCount = k.count;
                    LinkRetained ln = (LinkRetained)child;
                    if (k.count == 0) {
                        k.append(this.locale.nodeId);
                    }
                    ln.sharedGroup.processAllNodesForScopedLight(numLgts, ml, list, k.append("+").append(ln.nodeId));
                    k.count = lastCount;
                    continue;
                }
                if (child instanceof Shape3DRetained && child.source.isLive()) {
                    ((Shape3DRetained)child).getMirrorObjects(list, k);
                    continue;
                }
                if (!(child instanceof MorphRetained) || !child.source.isLive()) continue;
                ((MorphRetained)child).getMirrorObjects(list, k);
            }
        }
    }

    void removeAllNodesForScopedLight(int numLgts, LightRetained[] ml, ArrayList list, HashKey k) {
        if (this.inSharedGroup) {
            for (int i = 0; i < this.localToVworldKeys.length; ++i) {
                k.set(this.localToVworldKeys[i]);
                this.processRemoveAllNodesForScopedLight(numLgts, ml, list, k);
            }
        } else {
            this.processRemoveAllNodesForScopedLight(numLgts, ml, list, k);
        }
    }

    void processRemoveAllNodesForScopedLight(int numLgts, LightRetained[] ml, ArrayList list, HashKey k) {
        if (this.allocatedLights) {
            this.removeLight(numLgts, ml, k);
        }
        if (this.source.isLive() && !this.isInClearLive) {
            for (int i = this.children.size() - 1; i >= 0; --i) {
                NodeRetained child = this.children.get(i);
                if (child == null) continue;
                if (child instanceof GroupRetained && child.source.isLive() && !((GroupRetained)child).isInClearLive) {
                    ((GroupRetained)child).processRemoveAllNodesForScopedLight(numLgts, ml, list, k);
                    continue;
                }
                if (child instanceof LinkRetained && child.source.isLive()) {
                    int lastCount = k.count;
                    LinkRetained ln = (LinkRetained)child;
                    if (k.count == 0) {
                        k.append(this.locale.nodeId);
                    }
                    ln.sharedGroup.processRemoveAllNodesForScopedLight(numLgts, ml, list, k.append("+").append(ln.nodeId));
                    k.count = lastCount;
                    continue;
                }
                if (child instanceof Shape3DRetained && child.source.isLive()) {
                    ((Shape3DRetained)child).getMirrorObjects(list, k);
                    continue;
                }
                if (!(child instanceof MorphRetained) || !child.source.isLive()) continue;
                ((MorphRetained)child).getMirrorObjects(list, k);
            }
        }
    }

    void addAllNodesForScopedFog(FogRetained mfog, ArrayList list, HashKey k) {
        if (this.inSharedGroup) {
            for (int i = 0; i < this.localToVworldKeys.length; ++i) {
                k.set(this.localToVworldKeys[i]);
                this.processAddNodesForScopedFog(mfog, list, k);
            }
        } else {
            this.processAddNodesForScopedFog(mfog, list, k);
        }
    }

    void processAddNodesForScopedFog(FogRetained mfog, ArrayList list, HashKey k) {
        if (this.allocatedFogs) {
            this.addFog(mfog, k);
        }
        if (this.source.isLive() || this.isInSetLive()) {
            for (int i = this.children.size() - 1; i >= 0; --i) {
                NodeRetained child = this.children.get(i);
                if (child == null) continue;
                if (child instanceof GroupRetained && (child.source.isLive() || child.isInSetLive())) {
                    ((GroupRetained)child).processAddNodesForScopedFog(mfog, list, k);
                    continue;
                }
                if (child instanceof LinkRetained && (child.source.isLive() || child.isInSetLive())) {
                    int lastCount = k.count;
                    LinkRetained ln = (LinkRetained)child;
                    if (k.count == 0) {
                        k.append(this.locale.nodeId);
                    }
                    ln.sharedGroup.processAddNodesForScopedFog(mfog, list, k.append("+").append(ln.nodeId));
                    k.count = lastCount;
                    continue;
                }
                if (child instanceof Shape3DRetained && child.source.isLive()) {
                    ((Shape3DRetained)child).getMirrorObjects(list, k);
                    continue;
                }
                if (!(child instanceof MorphRetained) || !child.source.isLive()) continue;
                ((MorphRetained)child).getMirrorObjects(list, k);
            }
        }
    }

    void removeAllNodesForScopedFog(FogRetained mfog, ArrayList list, HashKey k) {
        if (this.inSharedGroup) {
            for (int i = 0; i < this.localToVworldKeys.length; ++i) {
                k.set(this.localToVworldKeys[i]);
                this.processRemoveAllNodesForScopedFog(mfog, list, k);
            }
        } else {
            this.processRemoveAllNodesForScopedFog(mfog, list, k);
        }
    }

    void processRemoveAllNodesForScopedFog(FogRetained mfog, ArrayList list, HashKey k) {
        if (this.allocatedFogs) {
            this.removeFog(mfog, k);
        }
        if (this.source.isLive() && !this.isInClearLive) {
            for (int i = this.children.size() - 1; i >= 0; --i) {
                NodeRetained child = this.children.get(i);
                if (child == null) continue;
                if (child instanceof GroupRetained && child.source.isLive() && !((GroupRetained)child).isInClearLive) {
                    ((GroupRetained)child).processRemoveAllNodesForScopedFog(mfog, list, k);
                    continue;
                }
                if (child instanceof LinkRetained && child.source.isLive()) {
                    int lastCount = k.count;
                    LinkRetained ln = (LinkRetained)child;
                    if (k.count == 0) {
                        k.append(this.locale.nodeId);
                    }
                    ln.sharedGroup.processRemoveAllNodesForScopedFog(mfog, list, k.append("+").append(ln.nodeId));
                    k.count = lastCount;
                    continue;
                }
                if (child instanceof Shape3DRetained && child.source.isLive()) {
                    ((Shape3DRetained)child).getMirrorObjects(list, k);
                    continue;
                }
                if (!(child instanceof MorphRetained) || !child.source.isLive()) continue;
                ((MorphRetained)child).getMirrorObjects(list, k);
            }
        }
    }

    void addAllNodesForScopedModelClip(ModelClipRetained mModelClip, ArrayList list, HashKey k) {
        if (this.inSharedGroup) {
            for (int i = 0; i < this.localToVworldKeys.length; ++i) {
                k.set(this.localToVworldKeys[i]);
                this.processAddNodesForScopedModelClip(mModelClip, list, k);
            }
        } else {
            this.processAddNodesForScopedModelClip(mModelClip, list, k);
        }
    }

    void processAddNodesForScopedModelClip(ModelClipRetained mModelClip, ArrayList list, HashKey k) {
        if (this.allocatedMclips) {
            this.addModelClip(mModelClip, k);
        }
        if (this.source.isLive() || this.isInSetLive()) {
            for (int i = this.children.size() - 1; i >= 0; --i) {
                NodeRetained child = this.children.get(i);
                if (child == null) continue;
                if (child instanceof GroupRetained && (child.source.isLive() || child.isInSetLive())) {
                    ((GroupRetained)child).processAddNodesForScopedModelClip(mModelClip, list, k);
                    continue;
                }
                if (child instanceof LinkRetained && (child.source.isLive() || child.isInSetLive())) {
                    int lastCount = k.count;
                    LinkRetained ln = (LinkRetained)child;
                    if (k.count == 0) {
                        k.append(this.locale.nodeId);
                    }
                    ln.sharedGroup.processAddNodesForScopedModelClip(mModelClip, list, k.append("+").append(ln.nodeId));
                    k.count = lastCount;
                    continue;
                }
                if (child instanceof Shape3DRetained && child.source.isLive()) {
                    ((Shape3DRetained)child).getMirrorObjects(list, k);
                    continue;
                }
                if (!(child instanceof MorphRetained) || !child.source.isLive()) continue;
                ((MorphRetained)child).getMirrorObjects(list, k);
            }
        }
    }

    void removeAllNodesForScopedModelClip(ModelClipRetained mModelClip, ArrayList list, HashKey k) {
        if (this.inSharedGroup) {
            for (int i = 0; i < this.localToVworldKeys.length; ++i) {
                k.set(this.localToVworldKeys[i]);
                this.processRemoveAllNodesForScopedModelClip(mModelClip, list, k);
            }
        } else {
            this.processRemoveAllNodesForScopedModelClip(mModelClip, list, k);
        }
    }

    void processRemoveAllNodesForScopedModelClip(ModelClipRetained mModelClip, ArrayList list, HashKey k) {
        if (this.allocatedMclips) {
            this.removeModelClip(mModelClip, k);
        }
        if (this.source.isLive() && !this.isInClearLive) {
            for (int i = this.children.size() - 1; i >= 0; --i) {
                NodeRetained child = this.children.get(i);
                if (child == null) continue;
                if (child instanceof GroupRetained && child.source.isLive() && !((GroupRetained)child).isInClearLive) {
                    ((GroupRetained)child).processRemoveAllNodesForScopedModelClip(mModelClip, list, k);
                    continue;
                }
                if (child instanceof LinkRetained && child.source.isLive()) {
                    int lastCount = k.count;
                    LinkRetained ln = (LinkRetained)child;
                    if (k.count == 0) {
                        k.append(this.locale.nodeId);
                    }
                    ln.sharedGroup.processRemoveAllNodesForScopedModelClip(mModelClip, list, k.append("+").append(ln.nodeId));
                    k.count = lastCount;
                    continue;
                }
                if (child instanceof Shape3DRetained && child.source.isLive()) {
                    ((Shape3DRetained)child).getMirrorObjects(list, k);
                    continue;
                }
                if (!(child instanceof MorphRetained) || !child.source.isLive()) continue;
                ((MorphRetained)child).getMirrorObjects(list, k);
            }
        }
    }

    void addAllNodesForScopedAltApp(AlternateAppearanceRetained mAltApp, ArrayList list, HashKey k) {
        if (this.inSharedGroup) {
            for (int i = 0; i < this.localToVworldKeys.length; ++i) {
                k.set(this.localToVworldKeys[i]);
                this.processAddNodesForScopedAltApp(mAltApp, list, k);
            }
        } else {
            this.processAddNodesForScopedAltApp(mAltApp, list, k);
        }
    }

    void processAddNodesForScopedAltApp(AlternateAppearanceRetained mAltApp, ArrayList list, HashKey k) {
        if (this.allocatedAltApps) {
            this.addAltApp(mAltApp, k);
        }
        if (this.source.isLive() || this.isInSetLive()) {
            for (int i = this.children.size() - 1; i >= 0; --i) {
                NodeRetained child = this.children.get(i);
                if (child == null) continue;
                if (child instanceof GroupRetained && (child.source.isLive() || child.isInSetLive())) {
                    ((GroupRetained)child).processAddNodesForScopedAltApp(mAltApp, list, k);
                    continue;
                }
                if (child instanceof LinkRetained && child.source.isLive()) {
                    int lastCount = k.count;
                    LinkRetained ln = (LinkRetained)child;
                    if (k.count == 0) {
                        k.append(this.locale.nodeId);
                    }
                    ln.sharedGroup.processAddNodesForScopedAltApp(mAltApp, list, k.append("+").append(ln.nodeId));
                    k.count = lastCount;
                    continue;
                }
                if (child instanceof Shape3DRetained && child.source.isLive()) {
                    ((Shape3DRetained)child).getMirrorObjects(list, k);
                    continue;
                }
                if (!(child instanceof MorphRetained) || !child.source.isLive()) continue;
                ((MorphRetained)child).getMirrorObjects(list, k);
            }
        }
    }

    void removeAllNodesForScopedAltApp(AlternateAppearanceRetained mAltApp, ArrayList list, HashKey k) {
        if (this.inSharedGroup) {
            for (int i = 0; i < this.localToVworldKeys.length; ++i) {
                k.set(this.localToVworldKeys[i]);
                this.processRemoveNodesForScopedAltApp(mAltApp, list, k);
            }
        } else {
            this.processAddNodesForScopedAltApp(mAltApp, list, k);
        }
    }

    void processRemoveNodesForScopedAltApp(AlternateAppearanceRetained mAltApp, ArrayList list, HashKey k) {
        if (this.allocatedAltApps) {
            this.removeAltApp(mAltApp, k);
        }
        if (this.source.isLive() && !this.isInClearLive) {
            for (int i = this.children.size() - 1; i >= 0; --i) {
                NodeRetained child = this.children.get(i);
                if (child == null) continue;
                if (child instanceof GroupRetained && child.source.isLive() && !((GroupRetained)child).isInClearLive) {
                    ((GroupRetained)child).processRemoveNodesForScopedAltApp(mAltApp, list, k);
                    continue;
                }
                if (child instanceof LinkRetained && child.source.isLive()) {
                    int lastCount = k.count;
                    LinkRetained ln = (LinkRetained)child;
                    if (k.count == 0) {
                        k.append(this.locale.nodeId);
                    }
                    ln.sharedGroup.processRemoveNodesForScopedAltApp(mAltApp, list, k.append("+").append(ln.nodeId));
                    k.count = lastCount;
                    continue;
                }
                if (child instanceof Shape3DRetained && child.source.isLive()) {
                    ((Shape3DRetained)child).getMirrorObjects(list, k);
                    continue;
                }
                if (!(child instanceof MorphRetained) || !child.source.isLive()) continue;
                ((MorphRetained)child).getMirrorObjects(list, k);
            }
        }
    }

    synchronized void setLightScope() {
        if (!this.allocatedLights) {
            ArrayList newLights;
            this.allocatedLights = true;
            if (this.lights != null) {
                newLights = new ArrayList(this.lights.size());
                int size = this.lights.size();
                for (int i = 0; i < size; ++i) {
                    ArrayList<LightRetained> l = this.lights.get(i);
                    if (l != null) {
                        newLights.add(new ArrayList<LightRetained>(l));
                        continue;
                    }
                    newLights.add(null);
                }
            } else if (this.inSharedGroup) {
                newLights = new ArrayList();
                for (int i = 0; i < this.localToVworldKeys.length; ++i) {
                    newLights.add(new ArrayList());
                }
            } else {
                newLights = new ArrayList();
                newLights.add(new ArrayList());
            }
            this.lights = newLights;
        }
        ++this.scopingRefCount;
    }

    synchronized void removeLightScope() {
        --this.scopingRefCount;
    }

    synchronized void setFogScope() {
        if (!this.allocatedFogs) {
            ArrayList newFogs;
            this.allocatedFogs = true;
            if (this.fogs != null) {
                newFogs = new ArrayList(this.fogs.size());
                int size = this.fogs.size();
                for (int i = 0; i < size; ++i) {
                    ArrayList<FogRetained> l = this.fogs.get(i);
                    if (l != null) {
                        newFogs.add(new ArrayList<FogRetained>(l));
                        continue;
                    }
                    newFogs.add(null);
                }
            } else if (this.inSharedGroup) {
                newFogs = new ArrayList();
                for (int i = 0; i < this.localToVworldKeys.length; ++i) {
                    newFogs.add(new ArrayList());
                }
            } else {
                newFogs = new ArrayList();
                newFogs.add(new ArrayList());
            }
            this.fogs = newFogs;
        }
        ++this.scopingRefCount;
    }

    synchronized void removeFogScope() {
        --this.scopingRefCount;
    }

    synchronized void setMclipScope() {
        if (!this.allocatedMclips) {
            ArrayList newMclips;
            this.allocatedMclips = true;
            if (this.modelClips != null) {
                newMclips = new ArrayList(this.modelClips.size());
                int size = this.modelClips.size();
                for (int i = 0; i < size; ++i) {
                    ArrayList<ModelClipRetained> l = this.modelClips.get(i);
                    if (l != null) {
                        newMclips.add(new ArrayList<ModelClipRetained>(l));
                        continue;
                    }
                    newMclips.add(null);
                }
            } else if (this.inSharedGroup) {
                newMclips = new ArrayList();
                for (int i = 0; i < this.localToVworldKeys.length; ++i) {
                    newMclips.add(new ArrayList());
                }
            } else {
                newMclips = new ArrayList();
                newMclips.add(new ArrayList());
            }
            this.modelClips = newMclips;
        }
        ++this.scopingRefCount;
    }

    synchronized void removeMclipScope() {
        --this.scopingRefCount;
    }

    synchronized void setAltAppScope() {
        if (!this.allocatedAltApps) {
            ArrayList newAltApps;
            this.allocatedAltApps = true;
            if (this.altAppearances != null) {
                newAltApps = new ArrayList(this.altAppearances.size());
                int size = this.altAppearances.size();
                for (int i = 0; i < size; ++i) {
                    ArrayList<AlternateAppearanceRetained> l = this.altAppearances.get(i);
                    if (l != null) {
                        newAltApps.add(new ArrayList<AlternateAppearanceRetained>(l));
                        continue;
                    }
                    newAltApps.add(null);
                }
            } else if (this.inSharedGroup) {
                newAltApps = new ArrayList();
                for (int i = 0; i < this.localToVworldKeys.length; ++i) {
                    newAltApps.add(new ArrayList());
                }
            } else {
                newAltApps = new ArrayList();
                newAltApps.add(new ArrayList());
            }
            this.altAppearances = newAltApps;
        }
        ++this.scopingRefCount;
    }

    synchronized void removeAltAppScope() {
        --this.scopingRefCount;
    }

    synchronized boolean usedInScoping() {
        return this.scopingRefCount > 0;
    }

    void addLight(LightRetained[] addlight, int numLgts, HashKey key) {
        block3: {
            block2: {
                if (!this.inSharedGroup) break block2;
                int hkIndex = key.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                ArrayList<LightRetained> l = this.lights.get(hkIndex);
                if (l == null) break block3;
                for (int i = 0; i < numLgts; ++i) {
                    l.add(addlight[i]);
                }
                break block3;
            }
            ArrayList<LightRetained> l = this.lights.get(0);
            for (int i = 0; i < numLgts; ++i) {
                l.add(addlight[i]);
            }
        }
    }

    void addFog(FogRetained fog, HashKey key) {
        if (this.inSharedGroup) {
            int hkIndex = key.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
            ArrayList<FogRetained> l = this.fogs.get(hkIndex);
            if (l != null) {
                l.add(fog);
            }
        } else {
            ArrayList<FogRetained> l = this.fogs.get(0);
            l.add(fog);
        }
    }

    void addModelClip(ModelClipRetained modelClip, HashKey key) {
        if (this.inSharedGroup) {
            int hkIndex = key.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
            ArrayList<ModelClipRetained> l = this.modelClips.get(hkIndex);
            if (l != null) {
                l.add(modelClip);
            }
        } else {
            ArrayList<ModelClipRetained> l = this.modelClips.get(0);
            l.add(modelClip);
        }
    }

    void addAltApp(AlternateAppearanceRetained altApp, HashKey key) {
        if (this.inSharedGroup) {
            int hkIndex = key.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
            ArrayList<AlternateAppearanceRetained> l = this.altAppearances.get(hkIndex);
            if (l != null) {
                l.add(altApp);
            }
        } else {
            ArrayList<AlternateAppearanceRetained> l = this.altAppearances.get(0);
            l.add(altApp);
        }
    }

    void removeFog(FogRetained fog, HashKey key) {
        if (this.inSharedGroup) {
            int hkIndex = key.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
            ArrayList<FogRetained> l = this.fogs.get(hkIndex);
            if (l != null) {
                int index = l.indexOf(fog);
                l.remove(index);
            }
        } else {
            ArrayList<FogRetained> l = this.fogs.get(0);
            int index = l.indexOf(fog);
            l.remove(index);
        }
    }

    void removeModelClip(ModelClipRetained modelClip, HashKey key) {
        if (this.inSharedGroup) {
            int hkIndex = key.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
            ArrayList<ModelClipRetained> l = this.modelClips.get(hkIndex);
            if (l != null) {
                int index = l.indexOf(modelClip);
                l.remove(index);
            }
        } else {
            ArrayList<ModelClipRetained> l = this.modelClips.get(0);
            int index = l.indexOf(modelClip);
            l.remove(index);
        }
    }

    void removeAltApp(AlternateAppearanceRetained altApp, HashKey key) {
        if (this.inSharedGroup) {
            int hkIndex = key.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
            ArrayList<AlternateAppearanceRetained> l = this.altAppearances.get(hkIndex);
            if (l != null) {
                int index = l.indexOf(altApp);
                l.remove(index);
            }
        } else {
            ArrayList<AlternateAppearanceRetained> l = this.altAppearances.get(0);
            int index = l.indexOf(altApp);
            l.remove(index);
        }
    }

    @Override
    void updatePickable(HashKey[] keys, boolean[] pick) {
        NodeRetained child;
        int numChildLessOne = this.children.size() - 1;
        super.updatePickable(keys, pick);
        int i = 0;
        if (numChildLessOne < 0) {
            return;
        }
        for (i = 0; i < numChildLessOne; ++i) {
            child = this.children.get(i);
            if (child == null) continue;
            child.updatePickable(keys, (boolean[])pick.clone());
        }
        child = this.children.get(i);
        if (child != null) {
            child.updatePickable(keys, pick);
        }
    }

    @Override
    void updateCollidable(HashKey[] keys, boolean[] collide) {
        NodeRetained child;
        int numChildLessOne = this.children.size() - 1;
        super.updateCollidable(keys, collide);
        int i = 0;
        if (numChildLessOne < 0) {
            return;
        }
        for (i = 0; i < numChildLessOne; ++i) {
            child = this.children.get(i);
            if (child == null) continue;
            child.updateCollidable(keys, (boolean[])collide.clone());
        }
        child = this.children.get(i);
        if (child != null) {
            child.updateCollidable(keys, collide);
        }
    }

    void setAlternateCollisionTarget(boolean target) {
        if (this.collisionTarget == target) {
            return;
        }
        this.collisionTarget = target;
        if (this.source.isLive()) {
            J3dMessage message = new J3dMessage();
            message.threads = 64;
            message.universe = this.universe;
            CachedTargets[] newCtArr = null;
            if (target) {
                this.createMirrorGroup();
                TargetsInterface ti = this.getClosestTargetsInterface(0);
                if (ti != null) {
                    Targets targets = new Targets();
                    int numPath = this.mirrorGroup.size();
                    newCtArr = new CachedTargets[numPath];
                    for (int i = 0; i < numPath; ++i) {
                        CachedTargets ct = ti.getCachedTargets(0, i, -1);
                        if (ct != null) {
                            targets.addNode(this.mirrorGroup.get(i), 6);
                            newCtArr[i] = targets.snapShotAdd(ct);
                            continue;
                        }
                        newCtArr[i] = null;
                    }
                    ti.updateTargetThreads(0, newCtArr);
                    ti.resetCachedTargets(0, newCtArr, -1);
                }
                message.type = 0;
                message.args[0] = this.mirrorGroup.toArray();
                message.args[1] = ti;
                message.args[2] = newCtArr;
            } else {
                TargetsInterface ti = this.getClosestTargetsInterface(0);
                if (ti != null) {
                    Targets targets = new Targets();
                    int numPath = this.mirrorGroup.size();
                    newCtArr = new CachedTargets[numPath];
                    for (int i = 0; i < numPath; ++i) {
                        CachedTargets ct = ti.getCachedTargets(0, i, -1);
                        if (ct != null) {
                            targets.addNode(this.mirrorGroup.get(i), 6);
                            newCtArr[i] = targets.snapShotRemove(ct);
                            continue;
                        }
                        newCtArr[i] = null;
                    }
                    ti.updateTargetThreads(0, newCtArr);
                    ti.resetCachedTargets(0, newCtArr, -1);
                }
                message.type = 1;
                message.args[0] = this.mirrorGroup.toArray();
                message.args[1] = ti;
                message.args[2] = newCtArr;
                this.mirrorGroup = null;
            }
            VirtualUniverse.mc.processMessage(message);
        }
    }

    boolean getAlternateCollisionTarget() {
        return this.collisionTarget;
    }

    void checkSetLive(NodeRetained child, int childIndex, J3dMessage[] messages, int messageIndex, NodeRetained linkNode) {
        this.checkSetLive(child, childIndex, this.localToVworldKeys, this.inSharedGroup, messages, messageIndex, linkNode);
    }

    void checkSetLive(NodeRetained child, int childIndex, HashKey[] keys, boolean isShared, J3dMessage[] messages, int messageIndex, NodeRetained linkNode) {
        SceneGraphObject me = this.source;
        boolean sendMessages = false;
        boolean sendOGMessage = true;
        boolean sendVSGMessage = true;
        if (me.isLive()) {
            J3dMessage createMessage;
            boolean[] collide;
            boolean[] pick;
            SetLiveState s = this.universe.setLiveState;
            s.reset(this.locale);
            s.refCount = this.refCount;
            s.inSharedGroup = isShared;
            s.inBackgroundGroup = this.inBackgroundGroup;
            s.inViewSpecificGroup = this.inViewSpecificGroup;
            s.geometryBackground = this.geometryBackground;
            s.keys = keys;
            s.viewLists = this.viewLists;
            s.parentBranchGroupPaths = this.branchGroupPaths;
            s.branchGroupPaths = new ArrayList(this.branchGroupPaths);
            s.orderedPaths = this.orderedPaths;
            s.lights = this.lights;
            s.altAppearances = this.altAppearances;
            s.fogs = this.fogs;
            s.modelClips = this.modelClips;
            if (!this.inSharedGroup) {
                pick = new boolean[1];
                collide = new boolean[1];
            } else {
                pick = new boolean[this.localToVworldKeys.length];
                collide = new boolean[this.localToVworldKeys.length];
            }
            this.findPickableFlags(pick);
            super.updatePickable(null, pick);
            s.pickable = pick;
            this.findCollidableFlags(collide);
            super.updateCollidable(null, collide);
            s.collidable = collide;
            TargetsInterface transformInterface = this.initTransformStates(s, true);
            TargetsInterface switchInterface = this.initSwitchStates(s, this, child, linkNode, true);
            if (s.inViewSpecificGroup && s.changedViewGroup == null) {
                s.changedViewGroup = new ArrayList();
                s.changedViewList = new ArrayList();
                s.keyList = new int[10];
                s.viewScopedNodeList = new ArrayList();
                s.scopedNodesViewList = new ArrayList();
            }
            this.childCheckSetLive(child, childIndex, s, linkNode);
            CachedTargets[] newCtArr = null;
            newCtArr = this.updateTransformStates(s, transformInterface, true);
            this.updateSwitchStates(s, switchInterface, true);
            if (messages == null) {
                int numMessages = 2;
                if (s.ogList.size() > 0) {
                    ++numMessages;
                } else {
                    sendOGMessage = false;
                }
                if (s.changedViewGroup != null) {
                    ++numMessages;
                } else {
                    sendVSGMessage = false;
                }
                messages = new J3dMessage[numMessages];
                messageIndex = 0;
                for (int mIndex = 0; mIndex < numMessages; ++mIndex) {
                    messages[mIndex] = new J3dMessage();
                }
                sendMessages = true;
            }
            if (sendOGMessage) {
                createMessage = messages[messageIndex++];
                createMessage.threads = 4224;
                createMessage.type = 32;
                createMessage.universe = this.universe;
                createMessage.args[0] = s.ogList.toArray();
                createMessage.args[1] = s.ogChildIdList.toArray();
                createMessage.args[2] = s.ogOrderedIdList.toArray();
                createMessage.args[3] = s.ogCIOList.toArray();
                createMessage.args[4] = s.ogCIOTableList.toArray();
            }
            if (sendVSGMessage) {
                createMessage = messages[messageIndex++];
                createMessage.threads = 4096;
                createMessage.type = 57;
                createMessage.universe = this.universe;
                createMessage.args[0] = s.changedViewGroup;
                createMessage.args[1] = s.changedViewList;
                createMessage.args[2] = s.keyList;
            }
            createMessage = messages[messageIndex++];
            createMessage.threads = s.notifyThreads;
            createMessage.type = 0;
            createMessage.universe = this.universe;
            createMessage.args[0] = s.nodeList.toArray();
            if (newCtArr != null) {
                createMessage.args[1] = transformInterface;
                createMessage.args[2] = newCtArr;
            } else {
                createMessage.args[1] = null;
                createMessage.args[2] = null;
            }
            if (s.viewScopedNodeList != null) {
                createMessage.args[3] = s.viewScopedNodeList;
                createMessage.args[4] = s.scopedNodesViewList;
            }
            int sz = s.behaviorNodes.size();
            for (int i = 0; i < sz; ++i) {
                BehaviorRetained b = s.behaviorNodes.get(i);
                b.executeInitialize();
            }
            s.behaviorNodes.clear();
            createMessage = messages[messageIndex++];
            createMessage.threads = 256;
            createMessage.type = 49;
            createMessage.universe = this.universe;
            if (sendMessages) {
                VirtualUniverse.mc.processMessage(messages);
            }
            if (this.nodeType == 18) {
                SwitchRetained sw = (SwitchRetained)this;
                sw.setWhichChild(sw.whichChild, true);
            }
            s.reset(null);
        }
    }

    void checkClearLive(NodeRetained child, J3dMessage[] messages, int messageIndex, int childIndex, NodeRetained linkNode) {
        this.checkClearLive(child, this.localToVworldKeys, this.inSharedGroup, messages, messageIndex, childIndex, linkNode);
    }

    void checkClearLive(NodeRetained child, HashKey[] keys, boolean isShared, J3dMessage[] messages, int messageIndex, int childIndex, NodeRetained linkNode) {
        SceneGraphObject me = this.source;
        boolean sendMessages = false;
        boolean sendOGMessage = true;
        boolean sendVSGMessage = true;
        if (me.isLive()) {
            J3dMessage destroyMessage;
            SetLiveState s = this.universe.setLiveState;
            s.reset(this.locale);
            s.refCount = this.refCount;
            s.inSharedGroup = isShared;
            s.inBackgroundGroup = this.inBackgroundGroup;
            s.inViewSpecificGroup = this.inViewSpecificGroup;
            s.keys = keys;
            s.fogs = this.fogs;
            s.lights = this.lights;
            s.altAppearances = this.altAppearances;
            s.modelClips = this.modelClips;
            if (s.inViewSpecificGroup && s.changedViewGroup == null) {
                s.changedViewGroup = new ArrayList();
                s.changedViewList = new ArrayList();
                s.keyList = new int[10];
                s.viewScopedNodeList = new ArrayList();
                s.scopedNodesViewList = new ArrayList();
            }
            if (this instanceof OrderedGroupRetained && linkNode == null) {
                OrderedGroupRetained og = (OrderedGroupRetained)this;
                s.ogList.add(og);
                s.ogChildIdList.add(new Integer(childIndex));
                s.ogCIOList.add(og);
                int[] newArr = null;
                if (og.userChildIndexOrder != null) {
                    newArr = new int[og.userChildIndexOrder.length];
                    System.arraycopy(og.userChildIndexOrder, 0, newArr, 0, og.userChildIndexOrder.length);
                }
                s.ogCIOTableList.add(newArr);
            }
            s.viewLists = this.viewLists;
            TargetsInterface transformInterface = this.initTransformStates(s, false);
            TargetsInterface switchInterface = this.initSwitchStates(s, this, child, linkNode, false);
            child.clearLive(s);
            CachedTargets[] newCtArr = null;
            newCtArr = this.updateTransformStates(s, transformInterface, false);
            this.updateSwitchStates(s, switchInterface, false);
            if (messages == null) {
                int numMessages = 1;
                if (s.ogList.size() > 0) {
                    ++numMessages;
                } else {
                    sendOGMessage = false;
                }
                if (s.changedViewGroup != null) {
                    ++numMessages;
                } else {
                    sendVSGMessage = false;
                }
                messages = new J3dMessage[numMessages];
                messageIndex = 0;
                for (int mIndex = 0; mIndex < numMessages; ++mIndex) {
                    messages[mIndex] = new J3dMessage();
                }
                sendMessages = true;
            }
            if (sendOGMessage) {
                destroyMessage = messages[messageIndex++];
                destroyMessage.threads = 4224;
                destroyMessage.type = 33;
                destroyMessage.universe = this.universe;
                destroyMessage.args[0] = s.ogList.toArray();
                destroyMessage.args[1] = s.ogChildIdList.toArray();
                destroyMessage.args[3] = s.ogCIOList.toArray();
                destroyMessage.args[4] = s.ogCIOTableList.toArray();
            }
            destroyMessage = messages[messageIndex++];
            destroyMessage.threads = s.notifyThreads;
            destroyMessage.type = 1;
            destroyMessage.universe = this.universe;
            destroyMessage.args[0] = s.nodeList.toArray();
            if (newCtArr != null) {
                destroyMessage.args[1] = transformInterface;
                destroyMessage.args[2] = newCtArr;
            } else {
                destroyMessage.args[1] = null;
                destroyMessage.args[2] = null;
            }
            if (s.viewScopedNodeList != null) {
                destroyMessage.args[3] = s.viewScopedNodeList;
                destroyMessage.args[4] = s.scopedNodesViewList;
            }
            if (sendVSGMessage) {
                destroyMessage = messages[messageIndex++];
                destroyMessage.threads = 4096;
                destroyMessage.type = 58;
                destroyMessage.universe = this.universe;
                destroyMessage.args[0] = s.changedViewGroup;
                destroyMessage.args[1] = s.keyList;
            }
            if (sendMessages) {
                VirtualUniverse.mc.processMessage(messages);
            }
            s.reset(null);
        }
    }

    TargetsInterface initTransformStates(SetLiveState s, boolean isSetLive) {
        int numPaths = this.inSharedGroup ? s.keys.length : 1;
        TargetsInterface ti = this.getClosestTargetsInterface(0);
        if (isSetLive) {
            s.currentTransforms = this.localToVworld;
            s.currentTransformsIndex = this.localToVworldIndex;
            s.localToVworldKeys = this.localToVworldKeys;
            s.localToVworld = s.currentTransforms;
            s.localToVworldIndex = s.currentTransformsIndex;
            s.parentTransformLink = this.parentTransformLink;
            if (this.parentTransformLink != null) {
                if (this.parentTransformLink instanceof TransformGroupRetained) {
                    TransformGroupRetained tg = (TransformGroupRetained)this.parentTransformLink;
                    s.childTransformLinks = tg.childTransformLinks;
                } else {
                    SharedGroupRetained sg = (SharedGroupRetained)this.parentTransformLink;
                    s.childTransformLinks = sg.childTransformLinks;
                }
            }
        }
        int[] transformLevels = new int[numPaths];
        this.findTransformLevels(transformLevels);
        s.transformLevels = transformLevels;
        if (ti != null) {
            Targets[] newTargets = new Targets[numPaths];
            for (int i = 0; i < numPaths; ++i) {
                newTargets[i] = s.transformLevels[i] >= 0 ? new Targets() : null;
            }
            s.transformTargets = newTargets;
        }
        return ti;
    }

    CachedTargets[] updateTransformStates(SetLiveState s, TargetsInterface ti, boolean isSetLive) {
        CachedTargets[] newCtArr = null;
        if (ti != null) {
            if (isSetLive) {
                boolean newTargetThreads = false;
                newCtArr = new CachedTargets[this.localToVworld.length];
                if (!this.inSharedGroup) {
                    if (s.transformTargets[0] != null) {
                        CachedTargets ct = ti.getCachedTargets(0, 0, -1);
                        if (ct != null) {
                            newCtArr[0] = s.transformTargets[0].snapShotAdd(ct);
                        }
                    } else {
                        newCtArr[0] = null;
                    }
                } else {
                    for (int i = 0; i < s.keys.length; ++i) {
                        if (s.transformTargets[i] != null) {
                            CachedTargets ct = ti.getCachedTargets(0, i, -1);
                            if (ct == null) continue;
                            newCtArr[i] = s.transformTargets[i].snapShotAdd(ct);
                            continue;
                        }
                        newCtArr[i] = null;
                    }
                }
            } else {
                newCtArr = new CachedTargets[this.localToVworld.length];
                if (!this.inSharedGroup) {
                    if (s.transformTargets[0] != null) {
                        CachedTargets ct = ti.getCachedTargets(0, 0, -1);
                        if (ct != null) {
                            newCtArr[0] = s.transformTargets[0].snapShotRemove(ct);
                        }
                    } else {
                        newCtArr[0] = null;
                    }
                } else {
                    for (int i = 0; i < s.keys.length; ++i) {
                        if (s.transformTargets[i] != null) {
                            CachedTargets ct = ti.getCachedTargets(0, i, -1);
                            if (ct == null) continue;
                            newCtArr[i] = s.transformTargets[i].snapShotRemove(ct);
                            continue;
                        }
                        newCtArr[i] = null;
                    }
                }
            }
            ti.updateTargetThreads(0, newCtArr);
            ti.resetCachedTargets(0, newCtArr, -1);
        }
        return newCtArr;
    }

    TargetsInterface initSwitchStates(SetLiveState s, NodeRetained parentNode, NodeRetained childNode, NodeRetained linkNode, boolean isSetLive) {
        int i;
        this.findSwitchInfo(s, parentNode, childNode, linkNode);
        TargetsInterface ti = this.getClosestTargetsInterface(1);
        if (ti != null) {
            Targets[] newTargets = null;
            int numPaths = this.inSharedGroup ? s.keys.length : 1;
            newTargets = new Targets[numPaths];
            for (i = 0; i < numPaths; ++i) {
                newTargets[i] = s.switchLevels[i] >= 0 ? new Targets() : null;
            }
            s.switchTargets = newTargets;
        }
        if (isSetLive) {
            if (this.nodeType == 18) {
                i = this.parentSwitchLinkChildIndex;
                s.childSwitchLinks = this.childrenSwitchLinks.get(i);
                s.parentSwitchLink = this;
            } else if (this.nodeType == 22) {
                i = this.parentSwitchLinkChildIndex;
                s.childSwitchLinks = this.childrenSwitchLinks.get(i);
                s.parentSwitchLink = this;
            } else {
                s.parentSwitchLink = this.parentSwitchLink;
                if (this.parentSwitchLink != null) {
                    i = this.parentSwitchLinkChildIndex;
                    s.childSwitchLinks = this.parentSwitchLink.childrenSwitchLinks.get(i);
                }
            }
            if (ti != null) {
                s.switchStates = ti.getTargetsData(1, this.parentSwitchLinkChildIndex);
            } else {
                s.switchStates = new ArrayList(1);
                s.switchStates.add(new SwitchState(false));
            }
        }
        return ti;
    }

    void updateSwitchStates(SetLiveState s, TargetsInterface ti, boolean isSetLive) {
        if (ti != null) {
            if (isSetLive) {
                CachedTargets[] newCtArr = null;
                newCtArr = new CachedTargets[this.localToVworld.length];
                if (!this.inSharedGroup) {
                    CachedTargets ct;
                    newCtArr[0] = s.switchTargets[0] != null ? ((ct = ti.getCachedTargets(1, 0, this.parentSwitchLinkChildIndex)) != null ? s.switchTargets[0].snapShotAdd(ct) : s.switchTargets[0].snapShotInit()) : null;
                } else {
                    for (int i = 0; i < s.keys.length; ++i) {
                        if (s.switchTargets[i] != null) {
                            CachedTargets ct = ti.getCachedTargets(1, i, this.parentSwitchLinkChildIndex);
                            if (ct != null) {
                                newCtArr[i] = s.switchTargets[i].snapShotAdd(ct);
                                continue;
                            }
                            newCtArr[i] = s.switchTargets[i].snapShotInit();
                            continue;
                        }
                        newCtArr[i] = null;
                    }
                }
                ti.resetCachedTargets(1, newCtArr, this.parentSwitchLinkChildIndex);
                if (ti instanceof SwitchRetained) {
                    ((SwitchRetained)ti).traverseSwitchParent();
                } else if (ti instanceof SharedGroupRetained) {
                    ((SharedGroupRetained)ti).traverseSwitchParent();
                }
            } else {
                CachedTargets[] newCtArr = new CachedTargets[this.localToVworld.length];
                if (!this.inSharedGroup) {
                    if (s.switchTargets[0] != null) {
                        CachedTargets ct = ti.getCachedTargets(1, 0, this.parentSwitchLinkChildIndex);
                        if (ct != null) {
                            newCtArr[0] = s.switchTargets[0].snapShotRemove(ct);
                        }
                    } else {
                        newCtArr[0] = null;
                    }
                } else {
                    for (int i = 0; i < s.keys.length; ++i) {
                        if (s.switchTargets[i] != null) {
                            CachedTargets ct = ti.getCachedTargets(1, i, this.parentSwitchLinkChildIndex);
                            if (ct == null) continue;
                            newCtArr[i] = s.switchTargets[i].snapShotRemove(ct);
                            continue;
                        }
                        newCtArr[i] = null;
                    }
                }
                ti.resetCachedTargets(1, newCtArr, this.parentSwitchLinkChildIndex);
            }
        }
    }

    void appendChildrenData() {
    }

    void insertChildrenData(int index) {
    }

    void removeChildrenData(int index) {
    }

    TargetsInterface getClosestTargetsInterface(int type) {
        return type == 0 ? (TargetsInterface)((Object)this.parentTransformLink) : (TargetsInterface)((Object)this.parentSwitchLink);
    }

    @Override
    synchronized void updateLocalToVworld() {
        for (int i = this.children.size() - 1; i >= 0; --i) {
            NodeRetained child = this.children.get(i);
            if (child == null) continue;
            child.updateLocalToVworld();
        }
    }

    @Override
    void setNodeData(SetLiveState s) {
        super.setNodeData(s);
        this.orderedPaths = s.orderedPaths;
    }

    @Override
    void removeNodeData(SetLiveState s) {
        this.orderedPaths = !this.inSharedGroup || s.keys.length == this.localToVworld.length ? null : s.orderedPaths;
        super.removeNodeData(s);
    }

    @Override
    void setLive(SetLiveState s) {
        this.doSetLive(s);
        super.markAsLive();
    }

    void childDoSetLive(NodeRetained child, int childIndex, SetLiveState s) {
        if (child != null) {
            child.setLive(s);
        }
    }

    void childCheckSetLive(NodeRetained child, int childIndex, SetLiveState s, NodeRetained linkNode) {
        child.setLive(s);
    }

    @Override
    void doSetLive(SetLiveState s) {
        super.doSetLive(s);
        this.locale = s.locale;
        this.inViewSpecificGroup = s.inViewSpecificGroup;
        int nchildren = this.children.size();
        ArrayList<ArrayList<LightRetained>> savedScopedLights = s.lights;
        ArrayList<ArrayList<FogRetained>> savedScopedFogs = s.fogs;
        ArrayList<ArrayList<AlternateAppearanceRetained>> savedScopedAltApps = s.altAppearances;
        ArrayList<ArrayList<ModelClipRetained>> savedScopedMclips = s.modelClips;
        boolean[] oldpickableArray = (boolean[])s.pickable.clone();
        boolean[] oldcollidableArray = (boolean[])s.collidable.clone();
        boolean[] workingpickableArray = new boolean[oldpickableArray.length];
        boolean[] workingcollidableArray = new boolean[oldcollidableArray.length];
        ArrayList<BranchGroupRetained[]> oldBranchGroupPaths = s.branchGroupPaths;
        this.setScopingInfo(s);
        if (!(this instanceof ViewSpecificGroupRetained)) {
            this.viewLists = s.viewLists;
        }
        for (int i = 0; i < nchildren; ++i) {
            NodeRetained child = this.children.get(i);
            System.arraycopy(oldpickableArray, 0, workingpickableArray, 0, oldpickableArray.length);
            System.arraycopy(oldcollidableArray, 0, workingcollidableArray, 0, oldcollidableArray.length);
            s.pickable = workingpickableArray;
            s.collidable = workingcollidableArray;
            s.parentBranchGroupPaths = this.branchGroupPaths;
            s.branchGroupPaths = new ArrayList<BranchGroupRetained[]>(oldBranchGroupPaths);
            s.inViewSpecificGroup = this.inViewSpecificGroup;
            this.childDoSetLive(child, i, s);
        }
        if (this.collisionTarget) {
            this.processCollisionTarget(s);
        }
        s.lights = savedScopedLights;
        s.fogs = savedScopedFogs;
        s.altAppearances = savedScopedAltApps;
        s.modelClips = savedScopedMclips;
    }

    void setScopingInfo(SetLiveState s) {
        int k;
        int size;
        ArrayList<LeafRetained> src;
        ArrayList<LeafRetained> l;
        int hkIndex;
        int i;
        if (this.allocatedLights) {
            if (s.lights != null) {
                if (this.inSharedGroup) {
                    for (i = 0; i < s.keys.length; ++i) {
                        hkIndex = s.keys[i].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                        l = this.lights.get(hkIndex);
                        src = s.lights.get(i);
                        if (src == null) continue;
                        size = src.size();
                        for (k = 0; k < size; ++k) {
                            l.add(src.get(k));
                        }
                    }
                } else {
                    l = this.lights.get(0);
                    src = s.lights.get(0);
                    size = src.size();
                    for (i = 0; i < size; ++i) {
                        l.add((LightRetained)src.get(i));
                    }
                }
            }
            s.lights = this.lights;
        } else {
            this.lights = s.lights;
        }
        if (this.allocatedFogs) {
            if (s.fogs != null) {
                if (this.inSharedGroup) {
                    for (i = 0; i < s.keys.length; ++i) {
                        hkIndex = s.keys[i].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                        l = this.fogs.get(hkIndex);
                        src = s.fogs.get(i);
                        if (src == null) continue;
                        size = src.size();
                        for (k = 0; k < size; ++k) {
                            l.add(src.get(k));
                        }
                    }
                } else {
                    l = this.fogs.get(0);
                    src = s.fogs.get(0);
                    size = src.size();
                    for (i = 0; i < size; ++i) {
                        l.add(src.get(i));
                    }
                }
            }
            s.fogs = this.fogs;
        } else {
            this.fogs = s.fogs;
        }
        if (this.allocatedMclips) {
            if (s.modelClips != null) {
                if (this.inSharedGroup) {
                    for (i = 0; i < s.keys.length; ++i) {
                        hkIndex = s.keys[i].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                        l = this.modelClips.get(hkIndex);
                        src = s.modelClips.get(i);
                        if (src == null) continue;
                        size = src.size();
                        for (k = 0; k < size; ++k) {
                            l.add(src.get(k));
                        }
                    }
                } else {
                    l = this.modelClips.get(0);
                    src = s.modelClips.get(0);
                    size = src.size();
                    for (i = 0; i < size; ++i) {
                        l.add(src.get(i));
                    }
                }
            }
            s.modelClips = this.modelClips;
        } else {
            this.modelClips = s.modelClips;
        }
        if (this.allocatedAltApps) {
            if (s.altAppearances != null) {
                if (this.inSharedGroup) {
                    for (i = 0; i < s.keys.length; ++i) {
                        hkIndex = s.keys[i].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                        l = this.altAppearances.get(hkIndex);
                        src = s.altAppearances.get(i);
                        if (src == null) continue;
                        size = src.size();
                        for (k = 0; k < size; ++k) {
                            l.add(src.get(k));
                        }
                    }
                } else {
                    l = this.altAppearances.get(0);
                    src = s.altAppearances.get(0);
                    size = src.size();
                    for (i = 0; i < size; ++i) {
                        l.add(src.get(i));
                    }
                }
            }
            s.altAppearances = this.altAppearances;
        } else {
            this.altAppearances = s.altAppearances;
        }
    }

    void processCollisionTarget(SetLiveState s) {
        Bounds bound;
        if (this.mirrorGroup == null) {
            this.mirrorGroup = new ArrayList();
        }
        Bounds bounds = bound = this.collisionBound != null ? this.collisionBound : this.getEffectiveBounds();
        if (this.inSharedGroup) {
            for (int i = 0; i < s.keys.length; ++i) {
                GroupRetained g = new GroupRetained();
                g.key = s.keys[i];
                g.localToVworld = new Transform3D[1][];
                g.localToVworldIndex = new int[1][];
                int j = s.keys[i].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                if (j < 0) {
                    System.err.println("GroupRetained : Can't find hashKey");
                }
                g.localToVworld[0] = this.localToVworld[j];
                g.localToVworldIndex[0] = this.localToVworldIndex[j];
                g.collisionVwcBounds = new BoundingBox();
                g.collisionVwcBounds.transform(bound, g.getCurrentLocalToVworld(0));
                g.sourceNode = this;
                g.locale = this.locale;
                this.mirrorGroup.add(g);
                if (s.transformTargets != null && s.transformTargets[i] != null) {
                    s.transformTargets[i].addNode(g, 6);
                }
                s.nodeList.add(g);
            }
        } else {
            GroupRetained g = new GroupRetained();
            g.localToVworld = new Transform3D[1][];
            g.localToVworldIndex = new int[1][];
            g.localToVworld[0] = this.localToVworld[0];
            g.localToVworldIndex[0] = this.localToVworldIndex[0];
            g.collisionVwcBounds = new BoundingBox();
            g.collisionVwcBounds.transform(bound, g.getCurrentLocalToVworld(0));
            g.sourceNode = this;
            g.locale = this.locale;
            this.mirrorGroup.add(g);
            if (s.transformTargets != null && s.transformTargets[0] != null) {
                s.transformTargets[0].addNode(g, 6);
            }
            s.nodeList.add(g);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void computeCombineBounds(Bounds bounds) {
        if (!VirtualUniverse.mc.cacheAutoComputedBounds) {
            if (this.boundsAutoCompute) {
                for (int i = this.children.size() - 1; i >= 0; --i) {
                    NodeRetained child = this.children.get(i);
                    if (child == null) continue;
                    child.computeCombineBounds(bounds);
                }
            } else {
                Bounds i = this.localBounds;
                synchronized (i) {
                    bounds.combine(this.localBounds);
                }
            }
        } else {
            if (this.validCachedBounds && this.boundsAutoCompute) {
                bounds.combine(this.cachedBounds);
                return;
            }
            if (this.boundsAutoCompute) {
                this.cachedBounds = VirtualUniverse.mc.useBoxForGroupBounds ? new BoundingBox((Bounds)null) : new BoundingSphere((Bounds)null);
                for (int i = this.children.size() - 1; i >= 0; --i) {
                    NodeRetained child = this.children.get(i);
                    if (child == null) continue;
                    child.computeCombineBounds(this.cachedBounds);
                }
                bounds.combine(this.cachedBounds);
            } else {
                Bounds bounds2 = this.localBounds;
                synchronized (bounds2) {
                    bounds.combine(this.localBounds);
                }
            }
        }
    }

    @Override
    Bounds getBounds() {
        if (this.boundsAutoCompute) {
            if (this.validCachedBounds) {
                return (Bounds)this.cachedBounds.clone();
            }
            Bounds boundingObject = null;
            boundingObject = VirtualUniverse.mc.useBoxForGroupBounds ? new BoundingBox((Bounds)null) : new BoundingSphere((Bounds)null);
            for (int i = this.children.size() - 1; i >= 0; --i) {
                NodeRetained child = this.children.get(i);
                if (child == null) continue;
                child.computeCombineBounds(boundingObject);
            }
            return boundingObject;
        }
        return super.getBounds();
    }

    @Override
    Bounds getEffectiveBounds() {
        if (this.boundsAutoCompute) {
            return this.getBounds();
        }
        return super.getEffectiveBounds();
    }

    boolean isStaticChildren() {
        if (this.source.getCapability(12) || this.source.getCapability(13)) {
            return false;
        }
        for (int i = this.children.size() - 1; i >= 0; --i) {
            NodeRetained nodeR = this.children.get(i);
            if (nodeR == null || !nodeR.source.getCapability(46)) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean isStatic() {
        return super.isStatic() && this.isStaticChildren();
    }

    @Override
    void setCompiled() {
        super.setCompiled();
        for (int i = this.children.size() - 1; i >= 0; --i) {
            NodeRetained node = this.children.get(i);
            if (node == null) continue;
            node.setCompiled();
        }
    }

    @Override
    void traverse(boolean sameLevel, int level) {
        if (!sameLevel) {
            super.traverse(true, level);
            if (this.source.getCapability(12)) {
                System.err.print(" (r)");
            } else if (this.isStatic()) {
                System.err.print(" (s)");
            } else if (this.source.getCapability(13)) {
                System.err.print(" (w)");
            }
        }
        ++level;
        for (int i = 0; i < this.children.size(); ++i) {
            NodeRetained node = this.children.get(i);
            if (node == null) continue;
            node.traverse(false, level);
        }
    }

    @Override
    void compile(CompileState compState) {
        super.compile(compState);
        this.mergeFlag = 1;
        if (!this.isStatic()) {
            compState.keepTG = true;
            this.mergeFlag = 0;
        }
        if (this.isRoot || this.usedInScoping() || this.parent instanceof SwitchRetained) {
            this.mergeFlag = 0;
        }
        this.compiledChildrenList = new ArrayList(5);
        for (int i = 0; i < this.children.size(); ++i) {
            NodeRetained node = this.children.get(i);
            if (node == null) continue;
            node.compile(compState);
        }
        if (J3dDebug.debug) {
            ++compState.numGroups;
        }
    }

    @Override
    void merge(CompileState compState) {
        GroupRetained saveParentGroup = null;
        if (this.mergeFlag != 2) {
            if (this.mergeFlag == 0) {
                super.merge(compState);
                saveParentGroup = compState.parentGroup;
                compState.parentGroup = this;
            }
            for (int i = 0; i < this.children.size(); ++i) {
                NodeRetained node = this.children.get(i);
                if (node == null) continue;
                node.merge(compState);
            }
            if (compState.parentGroup == this) {
                this.children = this.compiledChildrenList;
                compState.doShapeMerge();
                this.compiledChildrenList = null;
                compState.parentGroup = saveParentGroup;
            } else {
                this.children.clear();
                if (J3dDebug.debug) {
                    ++compState.numMergedGroups;
                }
            }
            this.mergeFlag = 2;
        } else if (compState.parentGroup != null) {
            compState.parentGroup.compiledChildrenList.add(this);
            this.parent = compState.parentGroup;
        }
    }

    @Override
    void clearLive(SetLiveState s) {
        int k;
        int size;
        ArrayList<LeafRetained> gl;
        ArrayList<LeafRetained> l;
        int hkIndex;
        int i;
        boolean parentScopedLtSize = false;
        boolean parentScopedFogSize = false;
        boolean parentScopedMcSize = false;
        boolean parentScopedAltAppSize = false;
        boolean groupScopedLtSize = false;
        boolean groupScopedFogSize = false;
        boolean groupScopedMcSize = false;
        boolean groupScopedAltAppSize = false;
        this.isInClearLive = true;
        HashKey[] savedLocalToVworldKeys = this.localToVworldKeys;
        super.clearLive(s);
        int nchildren = this.children.size();
        if (!(this instanceof ViewSpecificGroupRetained)) {
            this.viewLists = s.viewLists;
        }
        ArrayList<ArrayList<LightRetained>> savedParentLights = s.lights;
        if (this.allocatedLights) {
            s.lights = this.lights;
        }
        ArrayList<ArrayList<FogRetained>> savedParentFogs = s.fogs;
        if (this.allocatedFogs) {
            s.fogs = this.fogs;
        }
        ArrayList<ArrayList<ModelClipRetained>> savedParentMclips = s.modelClips;
        if (this.allocatedMclips) {
            s.modelClips = this.modelClips;
        }
        ArrayList<ArrayList<AlternateAppearanceRetained>> savedParentAltApps = s.altAppearances;
        if (this.allocatedAltApps) {
            s.altAppearances = this.altAppearances;
        }
        for (i = nchildren - 1; i >= 0; --i) {
            NodeRetained child = this.children.get(i);
            if (this instanceof OrderedGroupRetained) {
                OrderedGroupRetained og = (OrderedGroupRetained)this;
                if (this.refCount + 1 == s.refCount) {
                    s.ogList.add(og);
                    s.ogChildIdList.add(new Integer(i));
                }
                s.orderedPaths = og.childrenOrderedPaths.get(i);
            }
            if (child == null) continue;
            child.clearLive(s);
        }
        if (savedParentLights != null && this.allocatedLights) {
            if (this.inSharedGroup) {
                for (i = 0; i < s.keys.length; ++i) {
                    hkIndex = s.keys[i].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                    l = savedParentLights.get(hkIndex);
                    gl = this.lights.get(hkIndex);
                    if (l == null) continue;
                    size = l.size();
                    for (k = 0; k < size; ++k) {
                        gl.remove(l.get(k));
                    }
                }
            } else {
                l = savedParentLights.get(0);
                gl = this.lights.get(0);
                size = l.size();
                for (int m = 0; m < size; ++m) {
                    gl.remove(l.get(m));
                }
            }
        }
        if (savedParentFogs != null && this.allocatedFogs) {
            if (this.inSharedGroup) {
                for (i = 0; i < s.keys.length; ++i) {
                    hkIndex = s.keys[i].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                    l = savedParentFogs.get(hkIndex);
                    gl = this.fogs.get(hkIndex);
                    if (l == null) continue;
                    size = l.size();
                    for (k = 0; k < size; ++k) {
                        gl.remove(l.get(k));
                    }
                }
            } else {
                l = savedParentFogs.get(0);
                size = l.size();
                for (int m = 0; m < size; ++m) {
                    this.fogs.remove(l.get(m));
                }
            }
        }
        if (savedParentMclips != null && this.allocatedMclips) {
            if (this.inSharedGroup) {
                for (i = 0; i < s.keys.length; ++i) {
                    hkIndex = s.keys[i].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                    l = savedParentMclips.get(hkIndex);
                    ArrayList<ModelClipRetained> gl2 = this.modelClips.get(hkIndex);
                    if (l == null) continue;
                    size = l.size();
                    for (k = 0; k < size; ++k) {
                        gl2.remove(l.get(k));
                    }
                }
            } else {
                l = savedParentMclips.get(0);
                size = l.size();
                for (int m = 0; m < size; ++m) {
                    this.modelClips.remove(l.get(m));
                }
            }
        }
        if (savedParentAltApps != null && this.allocatedAltApps) {
            if (this.inSharedGroup) {
                for (i = 0; i < s.keys.length; ++i) {
                    hkIndex = s.keys[i].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                    l = savedParentAltApps.get(hkIndex);
                    ArrayList<AlternateAppearanceRetained> gl3 = this.altAppearances.get(hkIndex);
                    if (l == null) continue;
                    size = l.size();
                    for (k = 0; k < size; ++k) {
                        gl3.remove(l.get(k));
                    }
                }
            } else {
                l = savedParentAltApps.get(0);
                size = l.size();
                for (int m = 0; m < size; ++m) {
                    this.altAppearances.remove(l.get(m));
                }
            }
        }
        if (this.collisionTarget) {
            GroupRetained g;
            if (this.inSharedGroup) {
                block13: for (i = s.keys.length - 1; i >= 0; --i) {
                    HashKey hkey = s.keys[i];
                    for (int j = this.mirrorGroup.size() - 1; j >= 0; --j) {
                        g = this.mirrorGroup.get(j);
                        if (!g.key.equals((Object)hkey)) continue;
                        s.nodeList.add(this.mirrorGroup.remove(j));
                        if (s.transformTargets == null || s.transformTargets[j] == null) continue block13;
                        s.transformTargets[j].addNode(g, 6);
                        continue block13;
                    }
                }
            } else {
                g = this.mirrorGroup.get(0);
                if (s.transformTargets != null && s.transformTargets[0] != null) {
                    s.transformTargets[0].addNode(g, 6);
                }
                s.nodeList.add(this.mirrorGroup.remove(0));
            }
        }
        s.lights = savedParentLights;
        s.modelClips = savedParentMclips;
        s.fogs = savedParentFogs;
        s.altAppearances = savedParentAltApps;
        this.isInClearLive = false;
    }

    @Override
    public BoundingBox computeBoundingHull() {
        return this.collisionVwcBounds;
    }

    @Override
    public boolean isEnable() {
        return GroupRetained.isNodeSwitchOn(this.sourceNode, this.key);
    }

    @Override
    public boolean isEnable(int vis) {
        return GroupRetained.isNodeSwitchOn(this.sourceNode, this.key);
    }

    @Override
    public Locale getLocale2() {
        return this.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isNodeSwitchOn(NodeRetained node, HashKey key) {
        NodeRetained prevNode = null;
        if (key != null) {
            key = new HashKey(key);
        }
        Object object = node.universe.sceneGraphLock;
        synchronized (object) {
            do {
                if (node instanceof SwitchRetained && prevNode != null && !GroupRetained.validSwitchChild((SwitchRetained)node, prevNode)) {
                    return false;
                }
                prevNode = node;
                if (node instanceof SharedGroupRetained) {
                    String nodeId = key.getLastNodeId();
                    Vector<NodeRetained> parents = ((SharedGroupRetained)node).parents;
                    for (int i = parents.size() - 1; i >= 0; --i) {
                        NodeRetained link = parents.get(i);
                        if (!link.nodeId.equals(nodeId)) continue;
                        node = link;
                        break;
                    }
                    if (node != prevNode) continue;
                    return false;
                }
                node = node.parent;
            } while (node != null);
        }
        return true;
    }

    static boolean validSwitchChild(SwitchRetained sw, NodeRetained node) {
        int whichChild = sw.whichChild;
        if (whichChild == -1) {
            return false;
        }
        if (whichChild == -2) {
            return true;
        }
        ArrayList children = sw.children;
        if (whichChild >= 0) {
            return children.get(whichChild) == node;
        }
        for (int i = children.size() - 1; i >= 0; --i) {
            if (!sw.childMask.get(i) || children.get(i) != node) continue;
            return true;
        }
        return false;
    }

    void createMirrorGroup() {
        Bounds bound;
        this.mirrorGroup = new ArrayList();
        Bounds bounds = bound = this.collisionBound != null ? this.collisionBound : this.getEffectiveBounds();
        if (this.inSharedGroup) {
            for (int i = 0; i < this.localToVworldKeys.length; ++i) {
                GroupRetained g = new GroupRetained();
                g.key = this.localToVworldKeys[i];
                g.localToVworld = new Transform3D[1][];
                g.localToVworldIndex = new int[1][];
                g.localToVworld[0] = this.localToVworld[i];
                g.localToVworldIndex[0] = this.localToVworldIndex[i];
                g.collisionVwcBounds = new BoundingBox();
                g.collisionVwcBounds.transform(bound, g.getCurrentLocalToVworld());
                g.sourceNode = this;
                g.locale = this.locale;
                this.mirrorGroup.add(g);
            }
        } else {
            GroupRetained g = new GroupRetained();
            g.localToVworld = new Transform3D[1][];
            g.localToVworldIndex = new int[1][];
            g.localToVworld[0] = this.localToVworld[0];
            g.localToVworldIndex[0] = this.localToVworldIndex[0];
            g.collisionVwcBounds = new BoundingBox();
            g.collisionVwcBounds.transform(bound, g.getCurrentLocalToVworld());
            g.sourceNode = this;
            g.locale = this.locale;
            this.mirrorGroup.add(g);
        }
    }

    @Override
    void setBoundsAutoCompute(boolean autoCompute) {
        if (autoCompute != this.boundsAutoCompute) {
            super.setBoundsAutoCompute(autoCompute);
            if (!autoCompute) {
                this.localBounds = this.getEffectiveBounds();
            }
            if (this.source.isLive() && this.collisionBound == null && autoCompute && this.mirrorGroup != null) {
                J3dMessage message = new J3dMessage();
                message.type = 34;
                message.threads = 8256;
                message.universe = this.universe;
                message.args[0] = this;
                VirtualUniverse.mc.processMessage(message);
            }
        }
    }

    @Override
    void setBounds(Bounds bounds) {
        super.setBounds(bounds);
        if (this.source.isLive() && !this.boundsAutoCompute && this.collisionBound == null && this.mirrorGroup != null) {
            J3dMessage message = new J3dMessage();
            message.type = 34;
            message.threads = 8256;
            message.universe = this.universe;
            message.args[0] = this;
            VirtualUniverse.mc.processMessage(message);
        }
    }

    @Override
    int[] processViewSpecificInfo(int mode, HashKey k, View v, ArrayList vsgList, int[] keyList, ArrayList leafList) {
        int nchildren = this.children.size();
        if (this.source.isLive()) {
            for (int i = 0; i < nchildren; ++i) {
                NodeRetained child = this.children.get(i);
                if (child instanceof LeafRetained) {
                    if (child instanceof LinkRetained) {
                        int lastCount = k.count;
                        LinkRetained ln = (LinkRetained)child;
                        if (k.count == 0) {
                            k.append(this.locale.nodeId);
                        }
                        keyList = ln.sharedGroup.processViewSpecificInfo(mode, k.append("+").append(ln.nodeId), v, vsgList, keyList, leafList);
                        k.count = lastCount;
                        continue;
                    }
                    ((LeafRetained)child).getMirrorObjects(leafList, k);
                    continue;
                }
                keyList = child.processViewSpecificInfo(mode, k, v, vsgList, keyList, leafList);
            }
        }
        return keyList;
    }

    void findSwitchInfo(SetLiveState s, NodeRetained parentNode, NodeRetained childNode, NodeRetained linkNode) {
        block14: {
            int i;
            block13: {
                this.parentSwitchLinkChildIndex = -1;
                if (this.inSharedGroup) break block13;
                NodeRetained child = linkNode == null ? childNode : linkNode;
                NodeRetained parent = parentNode;
                while (parent != null) {
                    if (parent instanceof SwitchRetained) {
                        s.switchLevels[0] = s.switchLevels[0] + 1;
                        if (s.closestSwitchParents[0] == null) {
                            s.closestSwitchParents[0] = (SwitchRetained)parent;
                            ++((SwitchRetained)parent).switchIndexCount;
                        }
                        if (this.parentSwitchLinkChildIndex == -1) {
                            this.parentSwitchLinkChildIndex = ((GroupRetained)parent).children.indexOf(child);
                        }
                    } else if (parent instanceof SharedGroupRetained && this.parentSwitchLinkChildIndex == -1) {
                        this.parentSwitchLinkChildIndex = ((GroupRetained)parent).children.indexOf(child);
                    }
                    child = parent;
                    parent = child.parent;
                }
                break block14;
            }
            s.switchLevels = new int[this.localToVworldKeys.length];
            s.closestSwitchParents = new SwitchRetained[this.localToVworldKeys.length];
            s.closestSwitchIndices = new int[this.localToVworldKeys.length];
            for (i = 0; i < this.localToVworldKeys.length; ++i) {
                s.switchLevels[i] = -1;
                s.closestSwitchParents[i] = null;
                s.closestSwitchIndices[i] = -1;
            }
            for (i = 0; i < this.localToVworldKeys.length; ++i) {
                NodeRetained child = linkNode == null ? childNode : linkNode;
                NodeRetained parent = parentNode;
                HashKey key = new HashKey(this.localToVworldKeys[i]);
                while (parent != null) {
                    block16: {
                        block15: {
                            if (!(parent instanceof SwitchRetained)) break block15;
                            int n = i;
                            s.switchLevels[n] = s.switchLevels[n] + 1;
                            if (s.closestSwitchParents[i] == null) {
                                s.closestSwitchParents[i] = (SwitchRetained)parent;
                                ++((SwitchRetained)parent).switchIndexCount;
                            }
                            if (this.parentSwitchLinkChildIndex != -1) break block16;
                            this.parentSwitchLinkChildIndex = ((GroupRetained)parent).children.indexOf(child);
                            break block16;
                        }
                        if (parent instanceof SharedGroupRetained) {
                            String nodeId = key.getLastNodeId();
                            Vector<NodeRetained> parents = ((SharedGroupRetained)parent).parents;
                            if (this.parentSwitchLinkChildIndex == -1) {
                                this.parentSwitchLinkChildIndex = ((GroupRetained)parent).children.indexOf(child);
                            }
                            for (int j = 0; j < parents.size(); ++j) {
                                NodeRetained ln = parents.get(j);
                                if (!ln.nodeId.equals(nodeId)) continue;
                                parent = ln;
                                break;
                            }
                        }
                    }
                    child = parent;
                    parent = child.parent;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void gatherBlUsers(ArrayList blUsers, Object[] blArr) {
        for (int i = 0; i < blArr.length; ++i) {
            ArrayList users;
            ArrayList arrayList = users = ((BoundingLeafRetained)blArr[i]).users;
            synchronized (arrayList) {
                blUsers.addAll(users);
                continue;
            }
        }
    }

    @Override
    void searchGeometryAtoms(UnorderList list) {
        for (int i = this.children.size() - 1; i >= 0; --i) {
            NodeRetained child = this.children.get(i);
            child.searchGeometryAtoms(list);
        }
    }
}

