/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

class HashKey {
    char[] value;
    int count = 0;

    HashKey() {
        this(16);
    }

    HashKey(int length) {
        this.value = new char[length];
    }

    HashKey(HashKey hashkey) {
        this.set(hashkey);
    }

    HashKey(String str) {
        this(str.length() + 16);
        this.append(str);
    }

    void set(HashKey hashkey) {
        if (this.count < hashkey.count) {
            this.value = new char[hashkey.count];
        }
        for (int i = 0; i < hashkey.count; ++i) {
            this.value[i] = hashkey.value[i];
        }
        this.count = hashkey.count;
    }

    void reset() {
        this.count = 0;
    }

    void ensureCapacity(int minimumCapacity) {
        int maxCapacity = this.value.length;
        if (minimumCapacity > maxCapacity) {
            int newCapacity = (maxCapacity + 1) * 2;
            if (minimumCapacity > newCapacity) {
                newCapacity = minimumCapacity;
            }
            char[] newValue = new char[newCapacity];
            System.arraycopy(this.value, 0, newValue, 0, this.count);
            this.value = newValue;
        }
    }

    HashKey append(String str) {
        int len = 0;
        if (str == null) {
            return this;
        }
        len = str.length();
        this.ensureCapacity(this.count + len);
        str.getChars(0, len, this.value, this.count);
        this.count += len;
        return this;
    }

    public int hashCode() {
        int h = 0;
        int off = 0;
        char[] val = this.value;
        int len = this.count;
        if (len < 16) {
            for (int i = len; i > 0; --i) {
                h = h * 37 + val[off++];
            }
        } else {
            int skip = len / 8;
            int i = len;
            while (i > 0) {
                h = h * 39 + val[off];
                i -= skip;
                off += skip;
            }
        }
        return h;
    }

    public boolean equals(Object anObject) {
        if (anObject != null && anObject instanceof HashKey) {
            HashKey anotherHashKey = (HashKey)anObject;
            int n = this.count;
            if (n == anotherHashKey.count) {
                char[] v1 = this.value;
                char[] v2 = anotherHashKey.value;
                int i = 0;
                int j = 0;
                while (n-- != 0) {
                    if (v1[i++] == v2[j++]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private int equals(HashKey hk) {
        for (int index = 0; index < this.count && index < hk.count; ++index) {
            if (this.value[index] < hk.value[index]) {
                return -1;
            }
            if (this.value[index] <= hk.value[index]) continue;
            return 1;
        }
        if (this.count == hk.count) {
            return 0;
        }
        if (this.count < hk.count) {
            return -1;
        }
        return 1;
    }

    int equals(HashKey[] localToVworldKeys, int start, int end) {
        int mid = start + (end - start) / 2;
        if (localToVworldKeys[mid] != null) {
            int test = this.equals(localToVworldKeys[mid]);
            if (test < 0 && start != mid) {
                return this.equals(localToVworldKeys, start, mid);
            }
            if (test > 0 && start != mid) {
                return this.equals(localToVworldKeys, mid, end);
            }
            if (test == 0) {
                return mid;
            }
            return -1;
        }
        return -2;
    }

    boolean equals(HashKey[] localToVworldKeys, int[] index, int start, int end) {
        int mid = start + (end - start) / 2;
        if (localToVworldKeys[mid] != null) {
            int test = this.equals(localToVworldKeys[mid]);
            if (start != mid) {
                if (test < 0) {
                    return this.equals(localToVworldKeys, index, start, mid);
                }
                if (test > 0) {
                    return this.equals(localToVworldKeys, index, mid, end);
                }
            } else {
                if (test < 0) {
                    index[0] = mid;
                    return false;
                }
                if (test > 0) {
                    index[0] = mid + 1;
                    return false;
                }
            }
            index[0] = mid;
            return true;
        }
        index[0] = mid;
        return false;
    }

    public String toString() {
        return new String(this.value, 0, this.count);
    }

    String getLastNodeId() {
        int i;
        for (i = this.count - 1; i > 0 && this.value[i] != '+'; --i) {
        }
        if (i > 0) {
            this.value[i++] = '\u0000';
            int temp = this.count - i;
            char[] v1 = new char[temp];
            int j = 0;
            while (j < temp) {
                v1[j] = this.value[i];
                this.value[i] = '\u0000';
                ++j;
                ++i;
            }
            this.count -= temp + 1;
            return new String(v1);
        }
        return new String(this.value, 0, this.count);
    }
}

