/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.IndexedLineArrayRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponent;

public class IndexedLineArray
extends IndexedGeometryArray {
    IndexedLineArray() {
    }

    public IndexedLineArray(int vertexCount, int vertexFormat, int indexCount) {
        super(vertexCount, vertexFormat, indexCount);
        if (vertexCount < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedLineArray0"));
        }
        if (indexCount < 2 || indexCount % 2 != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedLineArray1"));
        }
    }

    public IndexedLineArray(int vertexCount, int vertexFormat, int texCoordSetCount, int[] texCoordSetMap, int indexCount) {
        super(vertexCount, vertexFormat, texCoordSetCount, texCoordSetMap, indexCount);
        if (vertexCount < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedLineArray0"));
        }
        if (indexCount < 2 || indexCount % 2 != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedLineArray1"));
        }
    }

    public IndexedLineArray(int vertexCount, int vertexFormat, int texCoordSetCount, int[] texCoordSetMap, int vertexAttrCount, int[] vertexAttrSizes, int indexCount) {
        super(vertexCount, vertexFormat, texCoordSetCount, texCoordSetMap, vertexAttrCount, vertexAttrSizes, indexCount);
        if (vertexCount < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedLineArray0"));
        }
        if (indexCount < 2 || indexCount % 2 != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedLineArray1"));
        }
    }

    @Override
    void createRetained() {
        this.retained = new IndexedLineArrayRetained();
        this.retained.setSource(this);
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        IndexedLineArrayRetained rt = (IndexedLineArrayRetained)this.retained;
        int texSetCount = rt.getTexCoordSetCount();
        int[] texMap = null;
        int vertexAttrCount = rt.getVertexAttrCount();
        int[] vertexAttrSizes = null;
        if (texSetCount > 0) {
            texMap = new int[rt.getTexCoordSetMapLength()];
            rt.getTexCoordSetMap(texMap);
        }
        if (vertexAttrCount > 0) {
            vertexAttrSizes = new int[vertexAttrCount];
            rt.getVertexAttrSizes(vertexAttrSizes);
        }
        IndexedLineArray l = new IndexedLineArray(rt.getVertexCount(), rt.getVertexFormat(), texSetCount, texMap, vertexAttrCount, vertexAttrSizes, rt.getIndexCount());
        l.duplicateNodeComponent(this);
        return l;
    }
}

