/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Bounds;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.IndexedGeometryArrayRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.PickBounds;
import javax.media.j3d.PickCone;
import javax.media.j3d.PickCylinder;
import javax.media.j3d.PickInfo;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickSegment;
import javax.media.j3d.PickShape;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

class IndexedPointArrayRetained
extends IndexedGeometryArrayRetained {
    IndexedPointArrayRetained() {
        this.geoType = 10;
    }

    @Override
    boolean intersect(PickShape pickShape, PickInfo pickInfo, int flags, Point3d iPnt, GeometryRetained geom, int geomIndex) {
        double[] sdist = new double[1];
        double minDist = Double.MAX_VALUE;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        Point3d pnt = new Point3d();
        int[] vtxIndexArr = new int[1];
        int i = (this.vertexFormat & 0x80) == 0 ? this.initialVertexIndex : this.initialCoordIndex;
        switch (pickShape.getPickType()) {
            case 1: {
                PickRay pickRay = (PickRay)pickShape;
                while (i < this.validVertexCount) {
                    vtxIndexArr[0] = this.indexCoord[i];
                    this.getVertexData(this.indexCoord[i++], pnt);
                    if (!this.intersectPntAndRay(pnt, pickRay.origin, pickRay.direction, sdist)) continue;
                    if (flags == 0) {
                        return true;
                    }
                    if (sdist[0] < minDist) {
                        minDist = sdist[0];
                        x = pnt.x;
                        y = pnt.y;
                        z = pnt.z;
                        if ((flags & 0x20) != 0) {
                            this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                        }
                    }
                    if ((flags & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                }
                break;
            }
            case 2: {
                PickSegment pickSegment = (PickSegment)pickShape;
                Vector3d dir = new Vector3d(pickSegment.end.x - pickSegment.start.x, pickSegment.end.y - pickSegment.start.y, pickSegment.end.z - pickSegment.start.z);
                while (i < this.validVertexCount) {
                    vtxIndexArr[0] = this.indexCoord[i];
                    this.getVertexData(this.indexCoord[i++], pnt);
                    if (!this.intersectPntAndRay(pnt, pickSegment.start, dir, sdist) || !(sdist[0] <= 1.0)) continue;
                    if (flags == 0) {
                        return true;
                    }
                    if (sdist[0] < minDist) {
                        minDist = sdist[0];
                        x = pnt.x;
                        y = pnt.y;
                        z = pnt.z;
                        if ((flags & 0x20) != 0) {
                            this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                        }
                    }
                    if ((flags & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                }
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                Bounds bounds = ((PickBounds)pickShape).bounds;
                while (i < this.validVertexCount) {
                    vtxIndexArr[0] = this.indexCoord[i];
                    this.getVertexData(this.indexCoord[i++], pnt);
                    if (!bounds.intersect(pnt)) continue;
                    if (flags == 0) {
                        return true;
                    }
                    sdist[0] = pickShape.distance(pnt);
                    if (sdist[0] < minDist) {
                        minDist = sdist[0];
                        x = pnt.x;
                        y = pnt.y;
                        z = pnt.z;
                        if ((flags & 0x20) != 0) {
                            this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                        }
                    }
                    if ((flags & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                }
                break;
            }
            case 4: {
                PickCylinder pickCylinder = (PickCylinder)pickShape;
                while (i < this.validVertexCount) {
                    vtxIndexArr[0] = this.indexCoord[i];
                    this.getVertexData(this.indexCoord[i++], pnt);
                    if (!this.intersectCylinder(pnt, pickCylinder, sdist)) continue;
                    if (flags == 0) {
                        return true;
                    }
                    if (sdist[0] < minDist) {
                        minDist = sdist[0];
                        x = pnt.x;
                        y = pnt.y;
                        z = pnt.z;
                        if ((flags & 0x20) != 0) {
                            this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                        }
                    }
                    if ((flags & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                }
                break;
            }
            case 5: {
                PickCone pickCone = (PickCone)pickShape;
                while (i < this.validVertexCount) {
                    vtxIndexArr[0] = this.indexCoord[i];
                    this.getVertexData(this.indexCoord[i++], pnt);
                    if (!this.intersectCone(pnt, pickCone, sdist)) continue;
                    if (flags == 0) {
                        return true;
                    }
                    if (sdist[0] < minDist) {
                        minDist = sdist[0];
                        x = pnt.x;
                        y = pnt.y;
                        z = pnt.z;
                        if ((flags & 0x20) != 0) {
                            this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                        }
                    }
                    if ((flags & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                }
                break;
            }
            case 3: {
                throw new IllegalArgumentException(J3dI18N.getString("IndexedPointArrayRetained0"));
            }
            default: {
                throw new RuntimeException("PickShape not supported for intersection");
            }
        }
        if (minDist < Double.MAX_VALUE) {
            iPnt.x = x;
            iPnt.y = y;
            iPnt.z = z;
            return true;
        }
        return false;
    }

    @Override
    boolean intersect(Point3d[] pnts) {
        Point3d point = new Point3d();
        int i = (this.vertexFormat & 0x80) == 0 ? this.initialVertexIndex : this.initialCoordIndex;
        switch (pnts.length) {
            case 3: {
                while (i < this.validVertexCount) {
                    this.getVertexData(this.indexCoord[i++], point);
                    if (!this.intersectTriPnt(pnts[0], pnts[1], pnts[2], point)) continue;
                    return true;
                }
                break;
            }
            case 4: {
                while (i < this.validVertexCount) {
                    this.getVertexData(this.indexCoord[i++], point);
                    if (!this.intersectTriPnt(pnts[0], pnts[1], pnts[2], point) && !this.intersectTriPnt(pnts[0], pnts[2], pnts[3], point)) continue;
                    return true;
                }
                break;
            }
            case 2: {
                double[] dist = new double[1];
                Vector3d dir = new Vector3d();
                while (i < this.validVertexCount) {
                    this.getVertexData(this.indexCoord[i++], point);
                    dir.x = pnts[1].x - pnts[0].x;
                    dir.y = pnts[1].y - pnts[0].y;
                    dir.z = pnts[1].z - pnts[0].z;
                    if (!this.intersectPntAndRay(point, pnts[0], dir, dist) || !(dist[0] <= 1.0)) continue;
                    return true;
                }
                break;
            }
            case 1: {
                while (i < this.validVertexCount) {
                    this.getVertexData(this.indexCoord[i++], point);
                    if (pnts[0].x != point.x || pnts[0].y != point.y || pnts[0].z != point.z) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    @Override
    boolean intersect(Transform3D thisToOtherVworld, GeometryRetained geom) {
        Point3d[] pnt = new Point3d[1];
        int i = (this.vertexFormat & 0x80) == 0 ? this.initialVertexIndex : this.initialCoordIndex;
        pnt[0] = new Point3d();
        while (i < this.validVertexCount) {
            this.getVertexData(this.indexCoord[i++], pnt[0]);
            thisToOtherVworld.transform(pnt[0]);
            if (!geom.intersect(pnt)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean intersect(Bounds targetBound) {
        int i = (this.vertexFormat & 0x80) == 0 ? this.initialVertexIndex : this.initialCoordIndex;
        Point3d pnt = new Point3d();
        while (i < this.validVertexCount) {
            this.getVertexData(this.indexCoord[i++], pnt);
            if (!targetBound.intersect(pnt)) continue;
            return true;
        }
        return false;
    }

    @Override
    int getClassType() {
        return 1;
    }
}

