/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.AmbientLightRetained;
import javax.media.j3d.BackgroundRetained;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.Bounds;
import javax.media.j3d.Context;
import javax.media.j3d.EnvironmentSet;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.Group;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.UnorderList;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3f;

abstract class LightRetained
extends LeafRetained {
    static final int ENABLE_CHANGED = 1;
    static final int SCOPE_CHANGED = 2;
    static final int BOUNDS_CHANGED = 4;
    static final int COLOR_CHANGED = 8;
    static final int BOUNDINGLEAF_CHANGED = 16;
    static final int INIT_MIRROR = 32;
    static final int CLEAR_MIRROR = 64;
    static final int LAST_DEFINED_BIT = 64;
    boolean lightOn = true;
    Color3f color = new Color3f(1.0f, 1.0f, 1.0f);
    Vector<GroupRetained> scopes = new Vector();
    Bounds regionOfInfluence = null;
    BoundingLeafRetained boundingLeaf = null;
    Bounds region = null;
    int lightDirty = 65535;
    int sgLightDirty = 65535;
    int lightType = -1;
    boolean isNeeded = false;
    boolean inImmCtx = false;
    LightRetained sgLight = null;
    HashKey key = null;
    LightRetained[] mirrorLights = new LightRetained[1];
    int numMirrorLights = 0;
    boolean isScoped = false;
    HashKey tempKey = new HashKey(250);
    UnorderList environmentSets = new UnorderList(1, EnvironmentSet.class);
    boolean isViewScoped = false;
    ArrayList<LightRetained> newlyAddedMirrorLights = new ArrayList();
    static final int targetThreads = 4224;

    LightRetained() {
    }

    void initEnable(boolean state) {
        this.lightOn = state;
    }

    void setEnable(boolean state) {
        this.initEnable(state);
        this.sendMessage(1, state ? Boolean.TRUE : Boolean.FALSE);
    }

    boolean getEnable() {
        return this.lightOn;
    }

    void initColor(Color3f color) {
        this.color.set((Tuple3f)color);
    }

    void setColor(Color3f color) {
        this.initColor(color);
        this.sendMessage(8, new Color3f(color));
    }

    void getColor(Color3f color) {
        color.set((Tuple3f)this.color);
    }

    void initScope(Group scope, int index) {
        GroupRetained group = (GroupRetained)scope.retained;
        this.scopes.setElementAt(group, index);
    }

    void setScope(Group scope, int index) {
        ArrayList addScopeList = new ArrayList();
        ArrayList removeScopeList = new ArrayList();
        Object[] scopeInfo = new Object[3];
        GroupRetained group = this.scopes.get(index);
        this.tempKey.reset();
        group.removeAllNodesForScopedLight(this.inSharedGroup ? this.numMirrorLights : 1, this.mirrorLights, removeScopeList, this.tempKey);
        group = (GroupRetained)scope.retained;
        this.tempKey.reset();
        group.addAllNodesForScopedLight(this.inSharedGroup ? this.numMirrorLights : 1, this.mirrorLights, addScopeList, this.tempKey);
        this.initScope(scope, index);
        scopeInfo[0] = addScopeList;
        scopeInfo[1] = removeScopeList;
        scopeInfo[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(2, scopeInfo);
    }

    void initInsertScope(Group scope, int index) {
        GroupRetained group = (GroupRetained)scope.retained;
        this.scopes.insertElementAt(group, index);
        group.setLightScope();
    }

    void insertScope(Group scope, int index) {
        Object[] scopeInfo = new Object[3];
        ArrayList addScopeList = new ArrayList();
        GroupRetained group = (GroupRetained)scope.retained;
        this.tempKey.reset();
        group.addAllNodesForScopedLight(this.inSharedGroup ? this.numMirrorLights : 1, this.mirrorLights, addScopeList, this.tempKey);
        this.initInsertScope(scope, index);
        scopeInfo[0] = addScopeList;
        scopeInfo[1] = null;
        scopeInfo[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(2, scopeInfo);
    }

    void initRemoveScope(int index) {
        GroupRetained group = this.scopes.remove(index);
        group.removeLightScope();
    }

    void removeScope(int index) {
        Object[] scopeInfo = new Object[3];
        ArrayList removeScopeList = new ArrayList();
        GroupRetained group = this.scopes.elementAt(index);
        this.tempKey.reset();
        group.removeAllNodesForScopedLight(this.inSharedGroup ? this.numMirrorLights : 1, this.mirrorLights, removeScopeList, this.tempKey);
        this.initRemoveScope(index);
        scopeInfo[0] = null;
        scopeInfo[1] = removeScopeList;
        scopeInfo[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(2, scopeInfo);
    }

    void removeScope(Group scope) {
        int ind = this.indexOfScope(scope);
        if (ind >= 0) {
            this.removeScope(ind);
        }
    }

    void initRemoveScope(Group scope) {
        int ind = this.indexOfScope(scope);
        if (ind >= 0) {
            this.initRemoveScope(ind);
        }
    }

    void removeAllScopes() {
        int n = this.scopes.size();
        Object[] scopeInfo = new Object[3];
        ArrayList removeScopeList = new ArrayList();
        for (int index = n - 1; index >= 0; --index) {
            GroupRetained group = this.scopes.elementAt(index);
            this.tempKey.reset();
            group.removeAllNodesForScopedLight(this.inSharedGroup ? this.numMirrorLights : 1, this.mirrorLights, removeScopeList, this.tempKey);
            this.initRemoveScope(index);
        }
        scopeInfo[0] = null;
        scopeInfo[1] = removeScopeList;
        scopeInfo[2] = Boolean.FALSE;
        this.sendMessage(2, scopeInfo);
    }

    void initRemoveAllScopes() {
        int n = this.scopes.size();
        for (int i = n - 1; i >= 0; --i) {
            this.initRemoveScope(i);
        }
    }

    Group getScope(int index) {
        return (Group)this.scopes.elementAt((int)index).source;
    }

    Enumeration<Group> getAllScopes() {
        Enumeration<GroupRetained> elm = this.scopes.elements();
        Vector<Group> v = new Vector<Group>(this.scopes.size());
        while (elm.hasMoreElements()) {
            v.add((Group)elm.nextElement().source);
        }
        return v.elements();
    }

    void initAddScope(Group scope) {
        GroupRetained group = (GroupRetained)scope.retained;
        this.scopes.addElement(group);
        group.setLightScope();
    }

    void addScope(Group scope) {
        Object[] scopeInfo = new Object[3];
        ArrayList addScopeList = new ArrayList();
        GroupRetained group = (GroupRetained)scope.retained;
        this.initAddScope(scope);
        this.tempKey.reset();
        group.addAllNodesForScopedLight(this.inSharedGroup ? this.numMirrorLights : 1, this.mirrorLights, addScopeList, this.tempKey);
        scopeInfo[0] = addScopeList;
        scopeInfo[1] = null;
        scopeInfo[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(2, scopeInfo);
    }

    int numScopes() {
        return this.scopes.size();
    }

    int indexOfScope(Group scope) {
        if (scope != null) {
            return this.scopes.indexOf(scope.retained);
        }
        return this.scopes.indexOf(null);
    }

    void initInfluencingBounds(Bounds region) {
        if (region != null) {
            this.regionOfInfluence = (Bounds)region.clone();
            if (this.staticTransform != null) {
                this.regionOfInfluence.transform(this.staticTransform.transform);
            }
        } else {
            this.regionOfInfluence = null;
        }
    }

    void setInfluencingBounds(Bounds region) {
        this.initInfluencingBounds(region);
        this.sendMessage(4, region != null ? region.clone() : null);
    }

    Bounds getInfluencingBounds() {
        Bounds b = null;
        if (this.regionOfInfluence != null) {
            b = (Bounds)this.regionOfInfluence.clone();
            if (this.staticTransform != null) {
                Transform3D invTransform = this.staticTransform.getInvTransform();
                b.transform(invTransform);
            }
        }
        return b;
    }

    void initInfluencingBoundingLeaf(BoundingLeaf region) {
        this.boundingLeaf = region != null ? (BoundingLeafRetained)region.retained : null;
    }

    void setInfluencingBoundingLeaf(BoundingLeaf region) {
        int i;
        int numLgts = this.numMirrorLights;
        if (this.numMirrorLights == 0) {
            numLgts = 1;
        }
        if (this.boundingLeaf != null) {
            for (i = 0; i < numLgts; ++i) {
                this.boundingLeaf.mirrorBoundingLeaf.removeUser(this.mirrorLights[i]);
            }
        }
        if (region != null) {
            this.boundingLeaf = (BoundingLeafRetained)region.retained;
            for (i = 0; i < numLgts; ++i) {
                this.boundingLeaf.mirrorBoundingLeaf.addUser(this.mirrorLights[i]);
            }
        } else {
            this.boundingLeaf = null;
        }
        this.sendMessage(16, this.boundingLeaf != null ? this.boundingLeaf.mirrorBoundingLeaf : null);
    }

    BoundingLeaf getInfluencingBoundingLeaf() {
        return this.boundingLeaf != null ? (BoundingLeaf)this.boundingLeaf.source : null;
    }

    void setInImmCtx(boolean inCtx) {
        this.inImmCtx = inCtx;
    }

    boolean getInImmCtx() {
        return this.inImmCtx;
    }

    void initMirrorObject(Object[] args) {
        int k;
        Object[] scopeInfo = (Object[])((Object[])args[4])[5];
        ArrayList gAtomList = (ArrayList)scopeInfo[1];
        Boolean scoped = (Boolean)scopeInfo[0];
        BoundingLeafRetained bl = (BoundingLeafRetained)((Object[])args[4])[0];
        Bounds bnds = (Bounds)((Object[])args[4])[1];
        int numLgts = (Integer)args[2];
        LightRetained[] mLgts = (LightRetained[])args[3];
        for (k = 0; k < numLgts; ++k) {
            for (int i = 0; i < gAtomList.size(); ++i) {
                Shape3DRetained shape = ((GeometryAtom)gAtomList.get((int)i)).source;
                shape.addLight(mLgts[k]);
            }
            mLgts[k].isScoped = scoped;
        }
        for (k = 0; k < numLgts; ++k) {
            mLgts[k].inBackgroundGroup = (Boolean)((Object[])args[4])[2];
            mLgts[k].geometryBackground = (BackgroundRetained)((Object[])args[4])[3];
            if (bl != null) {
                mLgts[k].boundingLeaf = bl.mirrorBoundingLeaf;
                mLgts[k].region = mLgts[k].boundingLeaf.transformedRegion;
            } else {
                mLgts[k].boundingLeaf = null;
                mLgts[k].region = null;
            }
            if (bnds != null) {
                mLgts[k].regionOfInfluence = bnds;
                if (mLgts[k].region == null) {
                    mLgts[k].region = (Bounds)this.regionOfInfluence.clone();
                    mLgts[k].region.transform(this.regionOfInfluence, this.getLastLocalToVworld());
                }
            } else {
                mLgts[k].regionOfInfluence = null;
            }
            mLgts[k].lightOn = (Boolean)((Object[])args[4])[4];
        }
        if (this instanceof AmbientLightRetained) {
            Color3f clr = (Color3f)((Object[])args[4])[6];
            for (int i = 0; i < numLgts; ++i) {
                mLgts[i].color.set((Tuple3f)clr);
            }
        }
    }

    abstract void update(Context var1, int var2, double var3);

    void updateImmediateMirrorObject(Object[] objs) {
        block14: {
            Shape3DRetained obj;
            int j;
            int i;
            LightRetained[] mLgts;
            int numLgts;
            int component;
            block17: {
                block16: {
                    block15: {
                        block13: {
                            component = (Integer)objs[1];
                            numLgts = (Integer)objs[2];
                            mLgts = (LightRetained[])objs[3];
                            if ((component & 8) == 0) break block13;
                            for (int i2 = 0; i2 < numLgts; ++i2) {
                                mLgts[i2].color.set((Tuple3f)((Color3f)objs[4]));
                            }
                            break block14;
                        }
                        if ((component & 1) == 0) break block15;
                        for (int i3 = 0; i3 < numLgts; ++i3) {
                            mLgts[i3].lightOn = (Boolean)objs[4];
                        }
                        break block14;
                    }
                    if ((component & 4) == 0) break block16;
                    for (int i4 = 0; i4 < numLgts; ++i4) {
                        mLgts[i4].regionOfInfluence = (Bounds)objs[4];
                        if (mLgts[i4].boundingLeaf != null) continue;
                        if (objs[4] != null) {
                            mLgts[i4].region = mLgts[i4].regionOfInfluence.copy(mLgts[i4].region);
                            mLgts[i4].region.transform(mLgts[i4].regionOfInfluence, mLgts[i4].getCurrentLocalToVworld());
                            continue;
                        }
                        mLgts[i4].region = null;
                    }
                    break block14;
                }
                if ((component & 0x10) == 0) break block17;
                for (int i5 = 0; i5 < numLgts; ++i5) {
                    mLgts[i5].boundingLeaf = (BoundingLeafRetained)objs[4];
                    if (objs[4] != null) {
                        mLgts[i5].region = mLgts[i5].boundingLeaf.transformedRegion;
                        continue;
                    }
                    if (mLgts[i5].regionOfInfluence != null) {
                        mLgts[i5].region = mLgts[i5].regionOfInfluence.copy(mLgts[i5].region);
                        mLgts[i5].region.transform(mLgts[i5].regionOfInfluence, mLgts[i5].getCurrentLocalToVworld());
                        continue;
                    }
                    mLgts[i5].region = null;
                }
                break block14;
            }
            if ((component & 2) == 0) break block14;
            Object[] scopeList = (Object[])objs[4];
            ArrayList addList = (ArrayList)scopeList[0];
            ArrayList removeList = (ArrayList)scopeList[1];
            boolean isScoped = (Boolean)scopeList[2];
            if (addList != null) {
                for (i = 0; i < numLgts; ++i) {
                    mLgts[i].isScoped = isScoped;
                    for (j = 0; j < addList.size(); ++j) {
                        obj = ((GeometryAtom)addList.get((int)j)).source;
                        obj.addLight(mLgts[i]);
                    }
                }
            }
            if (removeList != null) {
                for (i = 0; i < numLgts; ++i) {
                    mLgts[i].isScoped = isScoped;
                    for (j = 0; j < removeList.size(); ++j) {
                        obj = ((GeometryAtom)removeList.get((int)j)).source;
                        obj.removeLight(mLgts[i]);
                    }
                }
            }
        }
    }

    @Override
    void updateMirrorObject(Object[] objs) {
        int i;
        int component = (Integer)objs[1];
        int numLgts = (Integer)objs[2];
        LightRetained[] mLgts = (LightRetained[])objs[3];
        if ((component & 8) != 0) {
            for (i = 0; i < numLgts; ++i) {
                mLgts[i].color.set((Tuple3f)((Color3f)objs[4]));
            }
        }
        if ((component & 0x20) != 0) {
            for (i = 0; i < numLgts; ++i) {
                Color3f clr = (Color3f)((Object[])objs[4])[6];
                mLgts[i].color.set((Tuple3f)clr);
            }
        }
    }

    @Override
    void updateBoundingLeaf() {
        if (this.boundingLeaf != null && this.boundingLeaf.switchState.currentSwitchOn) {
            this.region = this.boundingLeaf.transformedRegion;
        } else if (this.regionOfInfluence != null) {
            this.region = this.regionOfInfluence.copy(this.region);
            this.region.transform(this.regionOfInfluence, this.getCurrentLocalToVworld());
        } else {
            this.region = null;
        }
    }

    @Override
    void getMirrorObjects(ArrayList leafList, HashKey key) {
        if (!this.inSharedGroup) {
            leafList.add(this.mirrorLights[0]);
        } else {
            for (int i = 0; i < this.numMirrorLights; ++i) {
                if (!this.mirrorLights[i].key.equals((Object)key)) continue;
                leafList.add(this.mirrorLights[i]);
                break;
            }
        }
    }

    LightRetained getMirrorLight(HashKey key) {
        if (this.inSharedGroup) {
            int i;
            for (i = 0; i < this.numMirrorLights; ++i) {
                if (!this.mirrorLights[i].key.equals((Object)key)) continue;
                return this.mirrorLights[i];
            }
            if (this.numMirrorLights == this.mirrorLights.length) {
                LightRetained[] newLights = new LightRetained[this.numMirrorLights * 2];
                for (i = 0; i < this.numMirrorLights; ++i) {
                    newLights[i] = this.mirrorLights[i];
                }
                this.mirrorLights = newLights;
            }
            this.mirrorLights[this.numMirrorLights] = (LightRetained)this.clone();
            if (this.boundingLeaf != null) {
                this.mirrorLights[this.numMirrorLights].boundingLeaf = this.boundingLeaf.mirrorBoundingLeaf;
                if (this.mirrorLights[this.numMirrorLights].boundingLeaf != null) {
                    this.mirrorLights[this.numMirrorLights].boundingLeaf.addUser(this.mirrorLights[this.numMirrorLights]);
                }
            }
            this.mirrorLights[this.numMirrorLights].key = key;
            this.mirrorLights[this.numMirrorLights].sgLight = this;
            return this.mirrorLights[this.numMirrorLights++];
        }
        if (this.mirrorLights[0] == null) {
            this.mirrorLights[0] = (LightRetained)this.clone();
            if (this.boundingLeaf != null) {
                this.mirrorLights[0].boundingLeaf = this.boundingLeaf.mirrorBoundingLeaf;
                if (this.mirrorLights[0].boundingLeaf != null) {
                    this.mirrorLights[0].boundingLeaf.addUser(this.mirrorLights[0]);
                }
            }
            this.mirrorLights[0].sgLight = this;
        }
        return this.mirrorLights[0];
    }

    @Override
    void setLive(SetLiveState s) {
        this.newlyAddedMirrorLights.clear();
        if (this.inImmCtx) {
            throw new IllegalSharingException(J3dI18N.getString("LightRetained0"));
        }
        super.doSetLive(s);
        if (s.inSharedGroup) {
            for (int i = 0; i < s.keys.length; ++i) {
                LightRetained ml = this.getMirrorLight(s.keys[i]);
                ml.localToVworld = new Transform3D[1][];
                ml.localToVworldIndex = new int[1][];
                int j = s.keys[i].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                if (j < 0) {
                    System.err.println("LightRetained : Can't find hashKey");
                }
                ml.localToVworld[0] = this.localToVworld[j];
                ml.localToVworldIndex[0] = this.localToVworldIndex[j];
                if (s.viewScopedNodeList != null && s.viewLists != null) {
                    s.viewScopedNodeList.add(ml);
                    s.scopedNodesViewList.add(s.viewLists.get(i));
                } else {
                    s.nodeList.add(ml);
                }
                this.newlyAddedMirrorLights.add(ml);
                if (this.boundingLeaf != null) {
                    this.boundingLeaf.mirrorBoundingLeaf.addUser(ml);
                }
                if (s.transformTargets != null && s.transformTargets[i] != null) {
                    s.transformTargets[i].addNode(ml, 1);
                    s.notifyThreads |= 0x2000;
                }
                if (s.switchTargets != null && s.switchTargets[i] != null) {
                    s.switchTargets[i].addNode(ml, 1);
                }
                ml.switchState = s.switchStates.get(j);
            }
        } else {
            LightRetained ml = this.getMirrorLight(null);
            ml.localToVworld = new Transform3D[1][];
            ml.localToVworldIndex = new int[1][];
            ml.localToVworld[0] = this.localToVworld[0];
            ml.localToVworldIndex[0] = this.localToVworldIndex[0];
            if (s.viewScopedNodeList != null && s.viewLists != null) {
                s.viewScopedNodeList.add(ml);
                s.scopedNodesViewList.add(s.viewLists.get(0));
            } else {
                s.nodeList.add(ml);
            }
            this.newlyAddedMirrorLights.add(ml);
            if (this.boundingLeaf != null) {
                this.boundingLeaf.mirrorBoundingLeaf.addUser(ml);
            }
            if (s.transformTargets != null && s.transformTargets[0] != null) {
                s.transformTargets[0].addNode(ml, 1);
                s.notifyThreads |= 0x2000;
            }
            if (s.switchTargets != null && s.switchTargets[0] != null) {
                s.switchTargets[0].addNode(ml, 1);
            }
            ml.switchState = s.switchStates.get(0);
        }
        s.notifyThreads |= 0x1080;
        super.markAsLive();
    }

    J3dMessage initMessage(int num) {
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 4096;
        createMessage.universe = this.universe;
        createMessage.type = 19;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(32);
        LightRetained[] mlts = new LightRetained[this.newlyAddedMirrorLights.size()];
        for (int i = 0; i < mlts.length; ++i) {
            mlts[i] = this.newlyAddedMirrorLights.get(i);
        }
        createMessage.args[2] = new Integer(mlts.length);
        createMessage.args[3] = mlts;
        Object[] obj = new Object[num];
        obj[0] = this.boundingLeaf;
        obj[1] = this.regionOfInfluence != null ? this.regionOfInfluence.clone() : null;
        obj[2] = this.inBackgroundGroup ? Boolean.TRUE : Boolean.FALSE;
        obj[3] = this.geometryBackground;
        obj[4] = this.lightOn ? Boolean.TRUE : Boolean.FALSE;
        ArrayList addScopeList = new ArrayList();
        for (int i = 0; i < this.scopes.size(); ++i) {
            GroupRetained group = this.scopes.get(i);
            this.tempKey.reset();
            group.addAllNodesForScopedLight(mlts.length, mlts, addScopeList, this.tempKey);
        }
        Object[] scopeInfo = new Object[]{this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE, addScopeList};
        obj[5] = scopeInfo;
        Color3f clr = new Color3f(this.color);
        obj[6] = clr;
        createMessage.args[4] = obj;
        return createMessage;
    }

    @Override
    void clearLive(SetLiveState s) {
        LightRetained ml;
        this.newlyAddedMirrorLights.clear();
        super.clearLive(s);
        if (this.inSharedGroup) {
            for (int i = 0; i < s.keys.length; ++i) {
                ml = this.getMirrorLight(s.keys[i]);
                if (s.transformTargets != null && s.transformTargets[i] != null) {
                    s.transformTargets[i].addNode(ml, 1);
                    s.notifyThreads |= 0x2000;
                }
                this.newlyAddedMirrorLights.add(ml);
                if (ml.boundingLeaf != null) {
                    ml.boundingLeaf.removeUser(ml);
                    ml.boundingLeaf = null;
                }
                if (s.switchTargets != null && s.switchTargets[i] != null) {
                    s.switchTargets[i].addNode(ml, 1);
                }
                if (s.viewScopedNodeList != null && s.viewLists != null) {
                    s.viewScopedNodeList.add(ml);
                    s.scopedNodesViewList.add(s.viewLists.get(i));
                    continue;
                }
                s.nodeList.add(ml);
            }
        } else {
            ml = this.getMirrorLight(null);
            if (ml.boundingLeaf != null) {
                ml.boundingLeaf.removeUser(ml);
                ml.boundingLeaf = null;
            }
            if (s.switchTargets != null && s.switchTargets[0] != null) {
                s.switchTargets[0].addNode(ml, 1);
            }
            if (s.viewScopedNodeList != null && s.viewLists != null) {
                s.viewScopedNodeList.add(ml);
                s.scopedNodesViewList.add(s.viewLists.get(0));
            } else {
                s.nodeList.add(ml);
            }
            if (s.transformTargets != null && s.transformTargets[0] != null) {
                s.transformTargets[0].addNode(ml, 1);
                s.notifyThreads |= 0x2000;
            }
            this.newlyAddedMirrorLights.add(ml);
        }
        s.notifyThreads |= 0x1080;
        if (this.scopes.size() > 0) {
            J3dMessage createMessage = new J3dMessage();
            LightRetained[] mlts = new LightRetained[this.newlyAddedMirrorLights.size()];
            for (int i = 0; i < mlts.length; ++i) {
                mlts[i] = this.newlyAddedMirrorLights.get(i);
            }
            createMessage.threads = 4096;
            createMessage.universe = this.universe;
            createMessage.type = 19;
            createMessage.args[0] = this;
            createMessage.args[1] = new Integer(64);
            ArrayList removeScopeList = new ArrayList();
            for (int i = 0; i < this.scopes.size(); ++i) {
                GroupRetained group = this.scopes.get(i);
                this.tempKey.reset();
                group.removeAllNodesForScopedLight(mlts.length, mlts, removeScopeList, this.tempKey);
            }
            createMessage.args[2] = removeScopeList;
            createMessage.args[3] = new Integer(mlts.length);
            createMessage.args[4] = mlts;
            VirtualUniverse.mc.processMessage(createMessage);
        }
    }

    void clearMirrorObject(Object[] args) {
        ArrayList shapeList = (ArrayList)args[2];
        LightRetained[] mLgts = (LightRetained[])args[4];
        int numLgts = (Integer)args[3];
        for (int k = 0; k < numLgts; ++k) {
            for (int i = 0; i < shapeList.size(); ++i) {
                Shape3DRetained shape = ((GeometryAtom)shapeList.get((int)i)).source;
                shape.removeLight(mLgts[k]);
            }
            mLgts[k].isScoped = false;
        }
    }

    @Override
    protected Object clone() {
        LightRetained lr = (LightRetained)super.clone();
        lr.color = new Color3f(this.color);
        lr.scopes = new Vector<GroupRetained>(this.scopes);
        lr.initInfluencingBoundingLeaf(this.getInfluencingBoundingLeaf());
        lr.region = null;
        lr.lightDirty = 65535;
        lr.sgLightDirty = 65535;
        lr.universe = null;
        lr.isNeeded = false;
        lr.inImmCtx = false;
        lr.sgLight = null;
        lr.key = null;
        lr.mirrorLights = new LightRetained[1];
        lr.numMirrorLights = 0;
        lr.environmentSets = new UnorderList(1, EnvironmentSet.class);
        return lr;
    }

    @Override
    void updateTransformChange() {
    }

    void updateImmediateTransformChange() {
        if (this.boundingLeaf == null && this.regionOfInfluence != null) {
            this.region = this.regionOfInfluence.copy(this.region);
            this.region.transform(this.regionOfInfluence, this.getCurrentLocalToVworld());
        }
    }

    void sendMessage(int attrMask, Object attr) {
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 4224;
        createMessage.type = 19;
        createMessage.universe = this.universe;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(attrMask);
        createMessage.args[2] = this.inSharedGroup ? new Integer(this.numMirrorLights) : new Integer(1);
        createMessage.args[3] = this.mirrorLights.clone();
        createMessage.args[4] = attr;
        VirtualUniverse.mc.processMessage(createMessage);
    }

    @Override
    void mergeTransform(TransformGroupRetained xform) {
        super.mergeTransform(xform);
        if (this.regionOfInfluence != null) {
            this.regionOfInfluence.transform(xform.transform);
        }
    }
}

