/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.Fog;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.LinearFogRetained;
import javax.media.j3d.Node;
import javax.vecmath.Color3f;

public class LinearFog
extends Fog {
    public static final int ALLOW_DISTANCE_READ = 16;
    public static final int ALLOW_DISTANCE_WRITE = 17;
    private static final int[] readCapabilities = new int[]{16};

    public LinearFog() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public LinearFog(Color3f color) {
        super(color);
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public LinearFog(Color3f color, double frontDistance, double backDistance) {
        super(color);
        this.setDefaultReadCapabilities(readCapabilities);
        ((LinearFogRetained)this.retained).initFrontDistance(frontDistance);
        ((LinearFogRetained)this.retained).initBackDistance(backDistance);
    }

    public LinearFog(float r, float g, float b) {
        super(r, g, b);
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public LinearFog(float r, float g, float b, double frontDistance, double backDistance) {
        super(r, g, b);
        this.setDefaultReadCapabilities(readCapabilities);
        ((LinearFogRetained)this.retained).initFrontDistance(frontDistance);
        ((LinearFogRetained)this.retained).initBackDistance(backDistance);
    }

    public void setFrontDistance(double frontDistance) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("LinearFog0"));
        }
        if (this.isLive()) {
            ((LinearFogRetained)this.retained).setFrontDistance(frontDistance);
        } else {
            ((LinearFogRetained)this.retained).initFrontDistance(frontDistance);
        }
    }

    public double getFrontDistance() {
        if (this.isLiveOrCompiled() && !this.getCapability(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("LinearFog1"));
        }
        return ((LinearFogRetained)this.retained).getFrontDistance();
    }

    public void setBackDistance(double backDistance) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("LinearFog0"));
        }
        if (this.isLive()) {
            ((LinearFogRetained)this.retained).setBackDistance(backDistance);
        } else {
            ((LinearFogRetained)this.retained).initBackDistance(backDistance);
        }
    }

    public double getBackDistance() {
        if (this.isLiveOrCompiled() && !this.getCapability(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("LinearFog1"));
        }
        return ((LinearFogRetained)this.retained).getBackDistance();
    }

    @Override
    void createRetained() {
        this.retained = new LinearFogRetained();
        this.retained.setSource(this);
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        LinearFog lf = new LinearFog();
        lf.duplicateNode(this, forceDuplicate);
        return lf;
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        LinearFogRetained attr = (LinearFogRetained)originalNode.retained;
        LinearFogRetained rt = (LinearFogRetained)this.retained;
        rt.initFrontDistance(attr.getFrontDistance());
        rt.initBackDistance(attr.getBackDistance());
    }
}

