/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Leaf;
import javax.media.j3d.LinkRetained;
import javax.media.j3d.Node;
import javax.media.j3d.SharedGroup;

public class Link
extends Leaf {
    public static final int ALLOW_SHARED_GROUP_READ = 12;
    public static final int ALLOW_SHARED_GROUP_WRITE = 13;
    private static final int[] readCapabilities = new int[]{12};

    public Link() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public Link(SharedGroup sharedGroup) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((LinkRetained)this.retained).setSharedGroup(sharedGroup);
    }

    @Override
    void createRetained() {
        this.retained = new LinkRetained();
        this.retained.setSource(this);
    }

    public void setSharedGroup(SharedGroup sharedGroup) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Link0"));
        }
        ((LinkRetained)this.retained).setSharedGroup(sharedGroup);
    }

    public SharedGroup getSharedGroup() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Link1"));
        }
        return ((LinkRetained)this.retained).getSharedGroup();
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        Link l = new Link();
        l.duplicateNode(this, forceDuplicate);
        return l;
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        ((LinkRetained)this.retained).setSharedGroup(((LinkRetained)originalNode.retained).getSharedGroup());
    }
}

