/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.AppearanceRetained;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.EnvironmentSet;
import javax.media.j3d.FogRetained;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.LightRetained;
import javax.media.j3d.ModelClipRetained;
import javax.media.j3d.ObjectUpdate;
import javax.media.j3d.OrientedShape3DRetained;
import javax.media.j3d.RenderAtomListInfo;
import javax.media.j3d.RenderMolecule;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransparencyAttributesRetained;
import javax.media.j3d.TransparentRenderingInfo;

class RenderAtom
implements ObjectUpdate {
    GeometryAtom geometryAtom = null;
    RenderMolecule renderMolecule = null;
    LightRetained[] lights = null;
    FogRetained fog = null;
    ModelClipRetained modelClip = null;
    AppearanceRetained app = null;
    static int IN_RENDERBIN = 1;
    static int HAS_SEPARATE_LOCALE_VWC_BOUNDS = 2;
    static int NEED_SEPARATE_LOCALE_VWC_BOUNDS = 4;
    static int ON_UPDATELIST = 8;
    static int ON_LOCALE_VWC_BOUNDS_UPDATELIST = 16;
    static int IS_ORIENTED = 32;
    static int IN_DIRTY_ORIENTED_RAs = 64;
    static int IN_SORTED_POS_DIRTY_TRANSP_LIST = 128;
    int dirtyMask = 0;
    EnvironmentSet envSet;
    BoundingBox localeVwcBounds = null;
    long lastVisibleTime = -1L;
    RenderAtomListInfo[] rListInfo;
    TransparentRenderingInfo[] parentTInfo = null;
    int[] dlistIds = null;
    static int TEXT3D = 1;
    static int DLIST = 2;
    static int CG = 4;
    static int OTHER = 8;
    static int SEPARATE_DLIST_PER_GEO = 16;
    static int VARRAY = 32;
    static int SEPARATE_DLIST_PER_RINFO = 64;
    static int PRIMARY = TEXT3D | DLIST | CG | OTHER | SEPARATE_DLIST_PER_RINFO;
    RenderMolecule added = null;
    RenderMolecule removed = null;
    RenderAtom nextAdd = null;
    RenderAtom prevAdd = null;
    RenderAtom nextRemove = null;
    RenderAtom prevRemove = null;

    RenderAtom() {
    }

    synchronized void setRenderBin(boolean value) {
        if (!value) {
            this.app = null;
            this.dirtyMask &= ~IN_RENDERBIN;
            this.dirtyMask &= ~ON_LOCALE_VWC_BOUNDS_UPDATELIST;
            this.dirtyMask &= ~ON_UPDATELIST;
        } else {
            this.dirtyMask |= IN_RENDERBIN;
        }
    }

    boolean isOpaque() {
        AppearanceRetained app = this.geometryAtom.source.appearance;
        if (app == null) {
            return true;
        }
        TransparencyAttributesRetained ta = app.transparencyAttributes;
        switch (this.geometryAtom.geoType) {
            case 3: 
            case 10: {
                if (app.pointAttributes == null || !app.pointAttributes.pointAntialiasing) break;
                return false;
            }
            case 4: 
            case 7: 
            case 11: 
            case 14: {
                if (app.lineAttributes == null || !app.lineAttributes.lineAntialiasing) break;
                return false;
            }
            case 15: 
            case 17: {
                break;
            }
            default: {
                if (app.polygonAttributes == null) break;
                if (app.polygonAttributes.polygonMode == 0 && app.pointAttributes != null && app.pointAttributes.pointAntialiasing) {
                    return false;
                }
                if (app.polygonAttributes.polygonMode != 1 || app.lineAttributes == null || !app.lineAttributes.lineAntialiasing) break;
                return false;
            }
        }
        return !TransparencyAttributesRetained.useAlpha(ta);
    }

    boolean inRenderBin() {
        return (this.dirtyMask & IN_RENDERBIN) != 0;
    }

    boolean hasSeparateLocaleVwcBounds() {
        return (this.dirtyMask & HAS_SEPARATE_LOCALE_VWC_BOUNDS) != 0;
    }

    boolean needSeparateLocaleVwcBounds() {
        return (this.dirtyMask & NEED_SEPARATE_LOCALE_VWC_BOUNDS) != 0;
    }

    boolean onUpdateList() {
        return (this.dirtyMask & ON_UPDATELIST) != 0;
    }

    boolean onLocaleVwcBoundsUpdateList() {
        return (this.dirtyMask & ON_LOCALE_VWC_BOUNDS_UPDATELIST) != 0;
    }

    boolean isOriented() {
        return (this.dirtyMask & IS_ORIENTED) != 0;
    }

    boolean inDepthSortList() {
        return (this.dirtyMask & IN_SORTED_POS_DIRTY_TRANSP_LIST) != 0;
    }

    boolean inDirtyOrientedRAs() {
        return (this.dirtyMask & IN_DIRTY_ORIENTED_RAs) != 0;
    }

    @Override
    public void updateObject() {
        if (this.inRenderBin()) {
            int lastLVWIndex = this.renderMolecule.localToVworldIndex[0];
            for (int i = 0; i < this.rListInfo.length; ++i) {
                if (this.rListInfo[i].geometry() == null) continue;
                if (this.geometryAtom.source.inBackgroundGroup) {
                    if (this.rListInfo[i].infLocalToVworld == null) {
                        this.rListInfo[i].infLocalToVworld = new Transform3D();
                    }
                    this.renderMolecule.localToVworld[lastLVWIndex].getRotation(this.rListInfo[i].infLocalToVworld);
                    this.rListInfo[i].infLocalToVworld.mul(this.geometryAtom.lastLocalTransformArray[i]);
                    continue;
                }
                this.rListInfo[i].localToVworld.mul(this.renderMolecule.localeLocalToVworld[lastLVWIndex], this.geometryAtom.lastLocalTransformArray[i]);
            }
        }
        this.dirtyMask &= ~ON_UPDATELIST;
    }

    void updateOrientedTransform() {
        int lastLVWIndex = this.renderMolecule.localToVworldIndex[0];
        Transform3D orientedTransform = ((OrientedShape3DRetained)this.geometryAtom.source).getOrientedTransform(this.renderMolecule.renderBin.view.viewIndex);
        for (int i = 0; i < this.rListInfo.length; ++i) {
            if (this.geometryAtom.geoType == 16 && this.geometryAtom.lastLocalTransformArray[i] != null) {
                if (this.geometryAtom.source.inBackgroundGroup) {
                    if (this.rListInfo[i].infLocalToVworld == null) {
                        this.rListInfo[i].infLocalToVworld = new Transform3D();
                    }
                    this.rListInfo[i].infLocalToVworld.mul(this.renderMolecule.infLocalToVworld[lastLVWIndex], orientedTransform);
                    this.rListInfo[i].infLocalToVworld.mul(this.geometryAtom.lastLocalTransformArray[i]);
                    continue;
                }
                this.rListInfo[i].localToVworld.mul(this.renderMolecule.localeLocalToVworld[lastLVWIndex], orientedTransform);
                this.rListInfo[i].localToVworld.mul(this.geometryAtom.lastLocalTransformArray[i]);
                continue;
            }
            if (this.geometryAtom.source.inBackgroundGroup) {
                if (this.rListInfo[i].infLocalToVworld == null) {
                    this.rListInfo[i].infLocalToVworld = new Transform3D();
                }
                this.rListInfo[i].infLocalToVworld.mul(this.renderMolecule.infLocalToVworld[lastLVWIndex], orientedTransform);
                continue;
            }
            this.rListInfo[i].localToVworld.mul(this.renderMolecule.localeLocalToVworld[lastLVWIndex], orientedTransform);
        }
    }

    void updateLocaleVwcBounds() {
        if (this.inRenderBin()) {
            if (this.renderMolecule.renderBin.locale != this.geometryAtom.source.locale) {
                this.geometryAtom.source.locale.hiRes.difference(this.renderMolecule.renderBin.locale.hiRes, this.renderMolecule.renderBin.localeTranslation);
                this.localeVwcBounds.translate(this.geometryAtom.source.vwcBounds, this.renderMolecule.renderBin.localeTranslation);
            } else {
                this.localeVwcBounds.set(this.geometryAtom.source.vwcBounds);
            }
            this.dirtyMask &= ~ON_LOCALE_VWC_BOUNDS_UPDATELIST;
        }
    }
}

