/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Alpha;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Node;
import javax.media.j3d.PathInterpolator;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;

public class RotPosPathInterpolator
extends PathInterpolator {
    private Transform3D rotation = new Transform3D();
    private Vector3f pos = new Vector3f();
    private Quat4f tQuat = new Quat4f();
    private Matrix4d tMat = new Matrix4d();
    private Quat4f[] quats;
    private Point3f[] positions;
    private float prevInterpolationValue = Float.NaN;
    private float prevAlphaValue = Float.NaN;
    private WakeupCriterion passiveWakeupCriterion = new WakeupOnElapsedFrames(0, true);

    RotPosPathInterpolator() {
    }

    public RotPosPathInterpolator(Alpha alpha, TransformGroup target, Transform3D axisOfTransform, float[] knots, Quat4f[] quats, Point3f[] positions) {
        super(alpha, target, axisOfTransform, knots);
        if (knots.length != positions.length) {
            throw new IllegalArgumentException(J3dI18N.getString("RotPosPathInterpolator0"));
        }
        if (knots.length != quats.length) {
            throw new IllegalArgumentException(J3dI18N.getString("RotPosPathInterpolator0"));
        }
        this.setPathArrays(quats, positions);
    }

    public void setQuat(int index, Quat4f quat) {
        this.quats[index].set((Tuple4f)quat);
    }

    public void getQuat(int index, Quat4f quat) {
        quat.set((Tuple4f)this.quats[index]);
    }

    public void setPosition(int index, Point3f position) {
        this.positions[index].set((Tuple3f)position);
    }

    public void getPosition(int index, Point3f position) {
        position.set((Tuple3f)this.positions[index]);
    }

    public void setPathArrays(float[] knots, Quat4f[] quats, Point3f[] positions) {
        if (knots.length != quats.length) {
            throw new IllegalArgumentException(J3dI18N.getString("RotPosPathInterpolator0"));
        }
        if (knots.length != positions.length) {
            throw new IllegalArgumentException(J3dI18N.getString("RotPosPathInterpolator0"));
        }
        this.setKnots(knots);
        this.setPathArrays(quats, positions);
    }

    private void setPathArrays(Quat4f[] quats, Point3f[] positions) {
        int i;
        this.quats = new Quat4f[quats.length];
        for (i = 0; i < quats.length; ++i) {
            this.quats[i] = new Quat4f();
            this.quats[i].set((Tuple4f)quats[i]);
        }
        this.positions = new Point3f[positions.length];
        for (i = 0; i < positions.length; ++i) {
            this.positions[i] = new Point3f();
            this.positions[i].set((Tuple3f)positions[i]);
        }
    }

    public void getQuats(Quat4f[] quats) {
        for (int i = 0; i < this.quats.length; ++i) {
            quats[i].set((Tuple4f)this.quats[i]);
        }
    }

    public void getPositions(Point3f[] positions) {
        for (int i = 0; i < this.positions.length; ++i) {
            positions[i].set((Tuple3f)this.positions[i]);
        }
    }

    public void setAxisOfRotPos(Transform3D axisOfRotPos) {
        this.setTransformAxis(axisOfRotPos);
    }

    public Transform3D getAxisOfRotPos() {
        return this.getTransformAxis();
    }

    @Override
    public void computeTransform(float alphaValue, Transform3D transform) {
        this.computePathInterpolation(alphaValue);
        if (this.currentKnotIndex == 0 && this.currentInterpolationValue == 0.0f) {
            this.tQuat.x = this.quats[0].x;
            this.tQuat.y = this.quats[0].y;
            this.tQuat.z = this.quats[0].z;
            this.tQuat.w = this.quats[0].w;
            this.pos.x = this.positions[0].x;
            this.pos.y = this.positions[0].y;
            this.pos.z = this.positions[0].z;
        } else {
            double quatDot = this.quats[this.currentKnotIndex].x * this.quats[this.currentKnotIndex + 1].x + this.quats[this.currentKnotIndex].y * this.quats[this.currentKnotIndex + 1].y + this.quats[this.currentKnotIndex].z * this.quats[this.currentKnotIndex + 1].z + this.quats[this.currentKnotIndex].w * this.quats[this.currentKnotIndex + 1].w;
            if (quatDot < 0.0) {
                this.tQuat.x = this.quats[this.currentKnotIndex].x + (-this.quats[this.currentKnotIndex + 1].x - this.quats[this.currentKnotIndex].x) * this.currentInterpolationValue;
                this.tQuat.y = this.quats[this.currentKnotIndex].y + (-this.quats[this.currentKnotIndex + 1].y - this.quats[this.currentKnotIndex].y) * this.currentInterpolationValue;
                this.tQuat.z = this.quats[this.currentKnotIndex].z + (-this.quats[this.currentKnotIndex + 1].z - this.quats[this.currentKnotIndex].z) * this.currentInterpolationValue;
                this.tQuat.w = this.quats[this.currentKnotIndex].w + (-this.quats[this.currentKnotIndex + 1].w - this.quats[this.currentKnotIndex].w) * this.currentInterpolationValue;
            } else {
                this.tQuat.x = this.quats[this.currentKnotIndex].x + (this.quats[this.currentKnotIndex + 1].x - this.quats[this.currentKnotIndex].x) * this.currentInterpolationValue;
                this.tQuat.y = this.quats[this.currentKnotIndex].y + (this.quats[this.currentKnotIndex + 1].y - this.quats[this.currentKnotIndex].y) * this.currentInterpolationValue;
                this.tQuat.z = this.quats[this.currentKnotIndex].z + (this.quats[this.currentKnotIndex + 1].z - this.quats[this.currentKnotIndex].z) * this.currentInterpolationValue;
                this.tQuat.w = this.quats[this.currentKnotIndex].w + (this.quats[this.currentKnotIndex + 1].w - this.quats[this.currentKnotIndex].w) * this.currentInterpolationValue;
            }
            this.pos.x = this.positions[this.currentKnotIndex].x + (this.positions[this.currentKnotIndex + 1].x - this.positions[this.currentKnotIndex].x) * this.currentInterpolationValue;
            this.pos.y = this.positions[this.currentKnotIndex].y + (this.positions[this.currentKnotIndex + 1].y - this.positions[this.currentKnotIndex].y) * this.currentInterpolationValue;
            this.pos.z = this.positions[this.currentKnotIndex].z + (this.positions[this.currentKnotIndex + 1].z - this.positions[this.currentKnotIndex].z) * this.currentInterpolationValue;
        }
        this.tQuat.normalize();
        this.tMat.set(this.tQuat);
        this.tMat.m03 = this.pos.x;
        this.tMat.m13 = this.pos.y;
        this.tMat.m23 = this.pos.z;
        this.rotation.set(this.tMat);
        transform.mul(this.axis, this.rotation);
        transform.mul(transform, this.axisInverse);
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        RotPosPathInterpolator rppi = new RotPosPathInterpolator();
        rppi.duplicateNode(this, forceDuplicate);
        return rppi;
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        RotPosPathInterpolator ri = (RotPosPathInterpolator)originalNode;
        int len = ri.getArrayLengths();
        this.positions = new Point3f[len];
        this.quats = new Quat4f[len];
        Point3f point = new Point3f();
        Quat4f quat = new Quat4f();
        for (int i = 0; i < len; ++i) {
            this.positions[i] = new Point3f();
            ri.getPosition(i, point);
            this.setPosition(i, point);
            this.quats[i] = new Quat4f();
            ri.getQuat(i, quat);
            this.setQuat(i, quat);
        }
    }
}

