/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Alpha;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransformInterpolator;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnElapsedFrames;

public class RotationInterpolator
extends TransformInterpolator {
    float minimumAngle;
    float maximumAngle;
    private Transform3D rotation = new Transform3D();
    private float prevAlphaValue = Float.NaN;
    private WakeupCriterion passiveWakeupCriterion = new WakeupOnElapsedFrames(0, true);

    RotationInterpolator() {
    }

    public RotationInterpolator(Alpha alpha, TransformGroup target) {
        super(alpha, target);
        this.minimumAngle = 0.0f;
        this.maximumAngle = (float)Math.PI * 2;
    }

    public RotationInterpolator(Alpha alpha, TransformGroup target, Transform3D axisOfTransform, float minimumAngle, float maximumAngle) {
        super(alpha, target, axisOfTransform);
        this.minimumAngle = minimumAngle;
        this.maximumAngle = maximumAngle;
    }

    public void setMinimumAngle(float angle) {
        this.minimumAngle = angle;
    }

    public float getMinimumAngle() {
        return this.minimumAngle;
    }

    public void setMaximumAngle(float angle) {
        this.maximumAngle = angle;
    }

    public float getMaximumAngle() {
        return this.maximumAngle;
    }

    public void setAxisOfRotation(Transform3D axisOfRotation) {
        this.setTransformAxis(axisOfRotation);
    }

    public Transform3D getAxisOfRotation() {
        return this.getTransformAxis();
    }

    @Override
    public void computeTransform(float alphaValue, Transform3D transform) {
        double val = (1.0 - (double)alphaValue) * (double)this.minimumAngle + (double)(alphaValue * this.maximumAngle);
        this.rotation.rotY(val);
        transform.mul(this.axis, this.rotation);
        transform.mul(transform, this.axisInverse);
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        RotationInterpolator ri = new RotationInterpolator();
        ri.duplicateNode(this, forceDuplicate);
        return ri;
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        RotationInterpolator ri = (RotationInterpolator)originalNode;
        this.setMinimumAngle(ri.getMinimumAngle());
        this.setMaximumAngle(ri.getMaximumAngle());
    }
}

