/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.AppearanceRetained;
import javax.media.j3d.CompileState;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.ShaderAttributeSet;
import javax.media.j3d.ShaderAttributeSetRetained;
import javax.media.j3d.ShaderProgram;
import javax.media.j3d.ShaderProgramRetained;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.VirtualUniverse;

class ShaderAppearanceRetained
extends AppearanceRetained {
    static final int SHADER_PROGRAM = 2048;
    static final int SHADER_ATTRIBUTE_SET = 4096;
    protected ShaderProgramRetained shaderProgram = null;
    protected ShaderAttributeSetRetained shaderAttributeSet = null;
    protected boolean isMirror = false;

    ShaderAppearanceRetained() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setShaderProgram(ShaderProgram sp) {
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source.isLive()) {
                if (this.shaderProgram != null) {
                    this.shaderProgram.clearLive(this.refCount);
                    this.shaderProgram.removeMirrorUsers(this);
                }
                if (sp != null) {
                    ((ShaderProgramRetained)sp.retained).setLive(this.inBackgroundGroup, this.refCount);
                    ((ShaderProgramRetained)sp.retained).copyMirrorUsers(this);
                }
                this.sendMessage(2048, sp != null ? ((ShaderProgramRetained)sp.retained).mirror : null);
            }
            this.shaderProgram = sp == null ? null : (ShaderProgramRetained)sp.retained;
        }
    }

    ShaderProgram getShaderProgram() {
        return this.shaderProgram == null ? null : (ShaderProgram)this.shaderProgram.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setShaderAttributeSet(ShaderAttributeSet sas) {
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source.isLive()) {
                if (this.shaderAttributeSet != null) {
                    this.shaderAttributeSet.clearLive(this.refCount);
                    this.shaderAttributeSet.removeMirrorUsers(this);
                }
                if (sas != null) {
                    ((ShaderAttributeSetRetained)sas.retained).setLive(this.inBackgroundGroup, this.refCount);
                    ((ShaderAttributeSetRetained)sas.retained).copyMirrorUsers(this);
                }
                this.sendMessage(4096, sas != null ? ((ShaderAttributeSetRetained)sas.retained).mirror : null);
            }
            this.shaderAttributeSet = sas == null ? null : (ShaderAttributeSetRetained)sas.retained;
        }
    }

    ShaderAttributeSet getShaderAttributeSet() {
        return this.shaderAttributeSet == null ? null : (ShaderAttributeSet)this.shaderAttributeSet.source;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof ShaderAppearanceRetained && this.equals((ShaderAppearanceRetained)obj);
    }

    boolean equals(ShaderAppearanceRetained sApp) {
        boolean flag;
        boolean bl = flag = sApp == this;
        if (flag) {
            return flag;
        }
        boolean bl2 = flag = sApp != null && this.shaderProgram == sApp.shaderProgram && this.shaderAttributeSet == sApp.shaderAttributeSet;
        if (!flag) {
            return flag;
        }
        return super.equals(sApp);
    }

    @Override
    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            this.mirror = new ShaderAppearanceRetained();
            ((ShaderAppearanceRetained)this.mirror).isMirror = true;
        }
        this.initMirrorObject();
    }

    @Override
    synchronized void initMirrorObject() {
        super.initMirrorObject();
        ShaderAppearanceRetained mirrorApp = (ShaderAppearanceRetained)this.mirror;
        mirrorApp.shaderProgram = this.shaderProgram != null ? (ShaderProgramRetained)this.shaderProgram.mirror : null;
        mirrorApp.shaderAttributeSet = this.shaderAttributeSet != null ? (ShaderAttributeSetRetained)this.shaderAttributeSet.mirror : null;
    }

    @Override
    synchronized void updateMirrorObject(int component, Object value) {
        super.updateMirrorObject(component, value);
        ShaderAppearanceRetained mirrorApp = (ShaderAppearanceRetained)this.mirror;
        if ((component & 0x800) != 0) {
            mirrorApp.shaderProgram = (ShaderProgramRetained)value;
        } else if ((component & 0x1000) != 0) {
            mirrorApp.shaderAttributeSet = (ShaderAttributeSetRetained)value;
        }
    }

    @Override
    void doSetLive(boolean backgroundGroup, int refCount) {
        if (this.shaderProgram != null) {
            this.shaderProgram.setLive(backgroundGroup, refCount);
        }
        if (this.shaderAttributeSet != null) {
            this.shaderAttributeSet.setLive(backgroundGroup, refCount);
        }
        super.doSetLive(backgroundGroup, refCount);
    }

    @Override
    void clearLive(int refCount) {
        super.clearLive(refCount);
        if (this.shaderProgram != null) {
            this.shaderProgram.clearLive(refCount);
        }
        if (this.shaderAttributeSet != null) {
            this.shaderAttributeSet.clearLive(refCount);
        }
    }

    @Override
    synchronized void addAMirrorUser(Shape3DRetained shape) {
        super.addAMirrorUser(shape);
        if (this.shaderProgram != null) {
            this.shaderProgram.addAMirrorUser(shape);
        }
        if (this.shaderAttributeSet != null) {
            this.shaderAttributeSet.addAMirrorUser(shape);
        }
    }

    @Override
    synchronized void removeAMirrorUser(Shape3DRetained shape) {
        super.removeAMirrorUser(shape);
        if (this.shaderProgram != null) {
            this.shaderProgram.removeAMirrorUser(shape);
        }
        if (this.shaderAttributeSet != null) {
            this.shaderAttributeSet.removeAMirrorUser(shape);
        }
    }

    final void sendMessage(int attrMask, Object attr) {
        ArrayList<VirtualUniverse> univList = new ArrayList<VirtualUniverse>();
        ArrayList<ArrayList<GeometryAtom>> gaList = Shape3DRetained.getGeomAtomsList(this.mirror.users, univList);
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 1024;
        createMessage.type = 65;
        createMessage.universe = null;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(attrMask);
        createMessage.args[2] = attr;
        createMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(createMessage);
        for (int i = 0; i < univList.size(); ++i) {
            createMessage = new J3dMessage();
            createMessage.threads = 128;
            createMessage.type = 65;
            createMessage.universe = univList.get(i);
            createMessage.args[0] = this;
            createMessage.args[1] = new Integer(attrMask);
            createMessage.args[2] = attr;
            ArrayList<GeometryAtom> gL = gaList.get(i);
            GeometryAtom[] gaArr = new GeometryAtom[gL.size()];
            gL.toArray(gaArr);
            createMessage.args[3] = gaArr;
            VirtualUniverse.mc.processMessage(createMessage);
        }
    }

    @Override
    boolean isStatic() {
        if (!super.isStatic()) {
            return false;
        }
        boolean flag = !(!this.source.capabilityBitsEmpty() || this.shaderProgram != null && !this.shaderProgram.source.capabilityBitsEmpty() || this.shaderAttributeSet != null && !this.shaderAttributeSet.source.capabilityBitsEmpty());
        return flag;
    }

    @Override
    void compile(CompileState compState) {
        super.compile(compState);
        if (this.shaderProgram != null) {
            this.shaderProgram.compile(compState);
        }
        if (this.shaderAttributeSet != null) {
            this.shaderAttributeSet.compile(compState);
        }
    }

    @Override
    boolean isOpaque(int geoType) {
        return super.isOpaque(geoType);
    }

    @Override
    void handleFrequencyChange(int bit) {
        super.handleFrequencyChange(bit);
        int mask = 0;
        if (bit == 23) {
            mask = 2048;
        } else if (bit == 25) {
            mask = 4096;
        }
        if (mask != 0) {
            this.setFrequencyChangeMask(bit, mask);
        }
    }
}

