/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.Enumeration;
import javax.media.j3d.Appearance;
import javax.media.j3d.Bounds;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.Geometry;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Leaf;
import javax.media.j3d.Node;
import javax.media.j3d.PickPoint;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickShape;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Shape3DRetained;

public class Shape3D
extends Leaf {
    int id;
    public static final int ALLOW_GEOMETRY_READ = 12;
    public static final int ALLOW_GEOMETRY_WRITE = 13;
    public static final int ALLOW_APPEARANCE_READ = 14;
    public static final int ALLOW_APPEARANCE_WRITE = 15;
    public static final int ALLOW_COLLISION_BOUNDS_READ = 16;
    public static final int ALLOW_COLLISION_BOUNDS_WRITE = 17;
    public static final int ALLOW_APPEARANCE_OVERRIDE_READ = 18;
    public static final int ALLOW_APPEARANCE_OVERRIDE_WRITE = 19;
    private static final int[] readCapabilities = new int[]{12, 14, 16, 18};

    public Shape3D() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public Shape3D(Geometry geometry) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((Shape3DRetained)this.retained).setGeometry(geometry, 0);
    }

    public Shape3D(Geometry geometry, Appearance appearance) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((Shape3DRetained)this.retained).setGeometry(geometry, 0);
        ((Shape3DRetained)this.retained).setAppearance(appearance);
    }

    @Override
    void createRetained() {
        this.retained = new Shape3DRetained();
        this.retained.setSource(this);
    }

    public void setCollisionBounds(Bounds bounds) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Shape3D0"));
        }
        ((Shape3DRetained)this.retained).setCollisionBounds(bounds);
    }

    public Bounds getCollisionBounds() {
        if (this.isLiveOrCompiled() && !this.getCapability(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Shape3D1"));
        }
        return ((Shape3DRetained)this.retained).getCollisionBounds(this.id);
    }

    public void setGeometry(Geometry geometry) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Shape3D2"));
        }
        ((Shape3DRetained)this.retained).setGeometry(geometry, 0);
    }

    public Geometry getGeometry() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Shape3D3"));
        }
        return ((Shape3DRetained)this.retained).getGeometry(0, this.id);
    }

    public void setGeometry(Geometry geometry, int index) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Shape3D2"));
        }
        ((Shape3DRetained)this.retained).setGeometry(geometry, index);
    }

    public Geometry getGeometry(int index) {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Shape3D3"));
        }
        return ((Shape3DRetained)this.retained).getGeometry(index, this.id);
    }

    public void insertGeometry(Geometry geometry, int index) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Shape3D2"));
        }
        ((Shape3DRetained)this.retained).insertGeometry(geometry, index);
    }

    public void removeGeometry(int index) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Shape3D2"));
        }
        ((Shape3DRetained)this.retained).removeGeometry(index);
    }

    public Enumeration getAllGeometries() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Shape3D3"));
        }
        return ((Shape3DRetained)this.retained).getAllGeometries(this.id);
    }

    public void addGeometry(Geometry geometry) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Shape3D2"));
        }
        ((Shape3DRetained)this.retained).addGeometry(geometry);
    }

    public int numGeometries() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Shape3D3"));
        }
        return ((Shape3DRetained)this.retained).numGeometries(this.id);
    }

    public int indexOfGeometry(Geometry geometry) {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Shape3D3"));
        }
        return ((Shape3DRetained)this.retained).indexOfGeometry(geometry);
    }

    public void removeGeometry(Geometry geometry) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Shape3D2"));
        }
        ((Shape3DRetained)this.retained).removeGeometry(geometry);
    }

    public void removeAllGeometries() {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Shape3D2"));
        }
        ((Shape3DRetained)this.retained).removeAllGeometries();
    }

    public void setAppearance(Appearance appearance) {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Shape3D4"));
        }
        ((Shape3DRetained)this.retained).setAppearance(appearance);
    }

    public Appearance getAppearance() {
        if (this.isLiveOrCompiled() && !this.getCapability(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Shape3D5"));
        }
        return ((Shape3DRetained)this.retained).getAppearance();
    }

    public boolean intersect(SceneGraphPath path, PickShape pickShape) {
        return this.intersect(path, pickShape, null);
    }

    public boolean intersect(SceneGraphPath path, PickRay pickRay, double[] dist) {
        if (this.isLiveOrCompiled() && !((Shape3DRetained)this.retained).allowIntersect()) {
            throw new CapabilityNotSetException(J3dI18N.getString("Shape3D6"));
        }
        return ((Shape3DRetained)this.retained).intersect(path, (PickShape)pickRay, dist);
    }

    public boolean intersect(SceneGraphPath path, PickShape pickShape, double[] dist) {
        if (this.isLiveOrCompiled() && !((Shape3DRetained)this.retained).allowIntersect()) {
            throw new CapabilityNotSetException(J3dI18N.getString("Shape3D6"));
        }
        if (pickShape instanceof PickPoint) {
            throw new IllegalArgumentException(J3dI18N.getString("Shape3D7"));
        }
        return ((Shape3DRetained)this.retained).intersect(path, pickShape, dist);
    }

    public void setAppearanceOverrideEnable(boolean flag) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Shape3D8"));
        }
        ((Shape3DRetained)this.retained).setAppearanceOverrideEnable(flag);
    }

    public boolean getAppearanceOverrideEnable() {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Shape3D9"));
        }
        return ((Shape3DRetained)this.retained).getAppearanceOverrideEnable();
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        Shape3D s = new Shape3D();
        s.duplicateNode(this, forceDuplicate);
        return s;
    }

    @Override
    public void duplicateNode(Node originalNode, boolean forceDuplicate) {
        this.checkDuplicateNode(originalNode, forceDuplicate);
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        Shape3DRetained attr = (Shape3DRetained)originalNode.retained;
        Shape3DRetained rt = (Shape3DRetained)this.retained;
        rt.setAppearance((Appearance)this.getNodeComponent(attr.getAppearance(), forceDuplicate, originalNode.nodeHashtable));
        int num = attr.numGeometries(this.id);
        if (num > 0) {
            rt.setGeometry((Geometry)this.getNodeComponent(attr.getGeometry(0, this.id), forceDuplicate, originalNode.nodeHashtable), 0);
            for (int i = 1; i < num; ++i) {
                rt.addGeometry((Geometry)this.getNodeComponent(attr.getGeometry(i, this.id), forceDuplicate, originalNode.nodeHashtable));
            }
        }
        rt.setCollisionBounds(attr.getCollisionBounds(this.id));
    }

    @Override
    public Bounds getBounds() {
        if (this.isLiveOrCompiled()) {
            if (!this.getCapability(3)) {
                throw new CapabilityNotSetException(J3dI18N.getString("Node2"));
            }
        } else {
            this.checkForCycle();
        }
        return ((Shape3DRetained)this.retained).getBounds();
    }
}

