/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Bounds;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.IndexedLineArrayRetained;
import javax.media.j3d.IndexedLineStripArrayRetained;
import javax.media.j3d.IndexedPointArrayRetained;
import javax.media.j3d.IndexedQuadArrayRetained;
import javax.media.j3d.IndexedTriangleArrayRetained;
import javax.media.j3d.IndexedTriangleFanArrayRetained;
import javax.media.j3d.IndexedTriangleStripArrayRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.LineArrayRetained;
import javax.media.j3d.LineStripArrayRetained;
import javax.media.j3d.PickInfo;
import javax.media.j3d.PickShape;
import javax.media.j3d.PointArrayRetained;
import javax.media.j3d.QuadArrayRetained;
import javax.media.j3d.SceneGraphObjectRetained;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TriangleArrayRetained;
import javax.media.j3d.TriangleFanArrayRetained;
import javax.media.j3d.TriangleStripArrayRetained;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;

class Shape3DCompileRetained
extends Shape3DRetained {
    int numShapes = 0;
    ArrayList<ArrayList<Geometry>> geometryInfo = null;
    Object[] srcList = null;

    Shape3DCompileRetained(Shape3DRetained[] shapes, int nShapes, int compileFlags) {
        int i;
        ArrayList[] mergedList = new ArrayList[15];
        ArrayList[] separateList = new ArrayList[15];
        this.numShapes = nShapes;
        this.srcList = new Object[nShapes];
        if (nShapes > 0) {
            this.boundsAutoCompute = shapes[0].boundsAutoCompute;
            this.source = shapes[0].source;
        }
        this.geometryList.remove(0);
        this.boundsAutoCompute = shapes[0].boundsAutoCompute;
        this.isPickable = shapes[0].isPickable;
        this.isCollidable = shapes[0].isCollidable;
        this.appearanceOverrideEnable = shapes[0].appearanceOverrideEnable;
        this.appearance = shapes[0].appearance;
        this.collisionBound = shapes[0].collisionBound;
        this.localBounds = shapes[0].localBounds;
        if ((compileFlags & 2) != 0) {
            this.geometryInfo = new ArrayList();
        }
        for (i = 0; i < nShapes; ++i) {
            int j;
            Shape3DRetained shape = shapes[i];
            ((Shape3D)shape.source).id = i;
            shape.source.retained = this;
            this.srcList[i] = shape.source;
            for (j = 0; j < shape.geometryList.size(); ++j) {
                GeometryArrayRetained geo = (GeometryArrayRetained)shape.geometryList.get(j);
                if (geo == null) continue;
                if (shape.willRemainOpaque(geo.geoType) && geo.isMergeable()) {
                    if (mergedList[geo.geoType] == null) {
                        mergedList[geo.geoType] = new ArrayList();
                    }
                    mergedList[geo.geoType].add(geo);
                    continue;
                }
                if (separateList[geo.geoType] == null) {
                    separateList[geo.geoType] = new ArrayList();
                }
                separateList[geo.geoType].add(geo);
            }
            if ((compileFlags & 2) == 0) continue;
            ArrayList<Geometry> sList = new ArrayList<Geometry>();
            for (j = 0; j < shape.geometryList.size(); ++j) {
                GeometryRetained g = shape.geometryList.get(j);
                if (g != null) {
                    sList.add((Geometry)g.source);
                    continue;
                }
                sList.add(null);
            }
            this.geometryInfo.add(sList);
        }
        block19: for (i = 1; i <= 14; ++i) {
            switch (i) {
                case 1: {
                    if (mergedList[i] != null) {
                        this.addMergedList(mergedList[i], new QuadArrayRetained());
                    }
                    this.addSeparateList(separateList[i]);
                    continue block19;
                }
                case 2: {
                    if (mergedList[i] != null) {
                        this.addMergedList(mergedList[i], new TriangleArrayRetained());
                    }
                    this.addSeparateList(separateList[i]);
                    continue block19;
                }
                case 3: {
                    if (mergedList[i] != null) {
                        this.addMergedList(mergedList[i], new PointArrayRetained());
                    }
                    this.addSeparateList(separateList[i]);
                    continue block19;
                }
                case 4: {
                    if (mergedList[i] != null) {
                        this.addMergedList(mergedList[i], new LineArrayRetained());
                    }
                    this.addSeparateList(separateList[i]);
                    continue block19;
                }
                case 5: {
                    if (mergedList[i] != null) {
                        this.addMergedList(mergedList[i], new TriangleStripArrayRetained());
                    }
                    this.addSeparateList(separateList[i]);
                    continue block19;
                }
                case 6: {
                    if (mergedList[i] != null) {
                        this.addMergedList(mergedList[i], new TriangleFanArrayRetained());
                    }
                    this.addSeparateList(separateList[i]);
                    continue block19;
                }
                case 7: {
                    if (mergedList[i] != null) {
                        this.addMergedList(mergedList[i], new LineStripArrayRetained());
                    }
                    this.addSeparateList(separateList[i]);
                    continue block19;
                }
                case 8: {
                    if (mergedList[i] != null) {
                        this.addMergedList(mergedList[i], new IndexedQuadArrayRetained());
                    }
                    this.addSeparateList(separateList[i]);
                    continue block19;
                }
                case 9: {
                    if (mergedList[i] != null) {
                        this.addMergedList(mergedList[i], new IndexedTriangleArrayRetained());
                    }
                    this.addSeparateList(separateList[i]);
                    continue block19;
                }
                case 10: {
                    if (mergedList[i] != null) {
                        this.addMergedList(mergedList[i], new IndexedPointArrayRetained());
                    }
                    this.addSeparateList(separateList[i]);
                    continue block19;
                }
                case 11: {
                    if (mergedList[i] != null) {
                        this.addMergedList(mergedList[i], new IndexedLineArrayRetained());
                    }
                    this.addSeparateList(separateList[i]);
                    continue block19;
                }
                case 12: {
                    if (mergedList[i] != null) {
                        this.addMergedList(mergedList[i], new IndexedTriangleStripArrayRetained());
                    }
                    this.addSeparateList(separateList[i]);
                    continue block19;
                }
                case 13: {
                    if (mergedList[i] != null) {
                        this.addMergedList(mergedList[i], new IndexedTriangleFanArrayRetained());
                    }
                    this.addSeparateList(separateList[i]);
                    continue block19;
                }
                case 14: {
                    if (mergedList[i] != null) {
                        this.addMergedList(mergedList[i], new IndexedLineStripArrayRetained());
                    }
                    this.addSeparateList(separateList[i]);
                }
            }
        }
    }

    private void addMergedList(ArrayList<GeometryArrayRetained> glist, GeometryArrayRetained cgeo) {
        cgeo.setCompiled(glist);
        this.geometryList.add(cgeo);
        cgeo.setSource(((SceneGraphObjectRetained)glist.get((int)0)).source);
    }

    private void addSeparateList(ArrayList<GeometryArrayRetained> glist) {
        if (glist == null) {
            return;
        }
        for (int k = 0; k < glist.size(); ++k) {
            this.geometryList.add(glist.get(k));
        }
    }

    @Override
    Bounds getCollisionBounds(int childIndex) {
        return this.collisionBound;
    }

    @Override
    int numGeometries(int childIndex) {
        return this.geometryInfo.get(childIndex).size();
    }

    @Override
    Geometry getGeometry(int i, int childIndex) {
        return this.geometryInfo.get(childIndex).get(i);
    }

    @Override
    Enumeration<Geometry> getAllGeometries(int childIndex) {
        ArrayList<Geometry> geoInfo = this.geometryInfo.get(childIndex);
        Vector<Geometry> geomList = new Vector<Geometry>();
        for (int i = 0; i < geoInfo.size(); ++i) {
            geomList.add(geoInfo.get(i));
        }
        return geomList.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bounds getBounds(int childIndex) {
        if (!this.boundsAutoCompute) {
            return super.getBounds();
        }
        ArrayList<Geometry> glist = this.geometryInfo.get(childIndex);
        if (glist == null) {
            return null;
        }
        BoundingBox bbox = new BoundingBox((Bounds)null);
        for (int i = 0; i < glist.size(); ++i) {
            Geometry g = glist.get(i);
            if (g == null) continue;
            GeometryRetained geometry = (GeometryRetained)g.retained;
            if (geometry.geoType == -1) continue;
            geometry.computeBoundingBox();
            BoundingBox boundingBox = geometry.geoBounds;
            synchronized (boundingBox) {
                bbox.combine(geometry.geoBounds);
                continue;
            }
        }
        return bbox;
    }

    @Override
    boolean intersect(SceneGraphPath path, PickShape pickShape, double[] dist) {
        PickInfo pickInfo = new PickInfo();
        Transform3D localToVworld = path.getTransform();
        if (localToVworld == null) {
            throw new IllegalArgumentException(J3dI18N.getString("Shape3DRetained3"));
        }
        pickInfo.setLocalToVWorldRef(localToVworld);
        Shape3D shape = (Shape3D)path.getObject();
        ArrayList<Geometry> glist = this.geometryInfo.get(shape.id);
        if (dist == null) {
            return this.intersect(pickInfo, pickShape, 0, glist);
        }
        int flags = 16;
        if (this.intersect(pickInfo, pickShape, flags, glist)) {
            dist[0] = pickInfo.getClosestDistance();
            return true;
        }
        return false;
    }

    boolean intersect(PickInfo pickInfo, PickShape pickShape, int flags, ArrayList<Geometry> geometryList) {
        Transform3D localToVworld = pickInfo.getLocalToVWorldRef();
        Transform3D t3d = new Transform3D();
        t3d.invert(localToVworld);
        PickShape newPS = pickShape.transform(t3d);
        int geomListSize = geometryList.size();
        if ((flags & 8) == 0 && (flags & 0x10) == 0 && (flags & 0x20) == 0 && (flags & 0x40) == 0) {
            for (int i = 0; i < geomListSize; ++i) {
                GeometryRetained geometry = (GeometryRetained)geometryList.get((int)i).retained;
                if (geometry == null) continue;
                if (geometry.mirrorGeometry != null) {
                    geometry = geometry.mirrorGeometry;
                }
                if (!geometry.intersect(newPS, null, 0, null, null, 0)) continue;
                return true;
            }
        } else {
            double minDist = Double.POSITIVE_INFINITY;
            Point3d closestIPnt = new Point3d();
            Point3d iPnt = new Point3d();
            Point3d iPntVW = new Point3d();
            for (int i = 0; i < geomListSize; ++i) {
                GeometryRetained geometry = (GeometryRetained)geometryList.get((int)i).retained;
                if (geometry == null) continue;
                if (geometry.mirrorGeometry != null) {
                    geometry = geometry.mirrorGeometry;
                }
                if (!geometry.intersect(newPS, pickInfo, flags, iPnt, geometry, i)) continue;
                iPntVW.set((Tuple3d)iPnt);
                localToVworld.transform(iPntVW);
                double distance = pickShape.distance(iPntVW);
                if (!(minDist > distance)) continue;
                minDist = distance;
                closestIPnt.set((Tuple3d)iPnt);
            }
            if (minDist < Double.POSITIVE_INFINITY) {
                if ((flags & 0x10) != 0) {
                    pickInfo.setClosestDistance(minDist);
                }
                if ((flags & 8) != 0) {
                    pickInfo.setClosestIntersectionPoint(closestIPnt);
                }
                return true;
            }
        }
        return false;
    }
}

