/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.AWTEvent;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import javax.media.j3d.AudioDevice;
import javax.media.j3d.AudioDevice3D;
import javax.media.j3d.AudioDevice3DL2;
import javax.media.j3d.AuralAttributes;
import javax.media.j3d.AuralAttributesRetained;
import javax.media.j3d.BackgroundSoundRetained;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ConeSoundRetained;
import javax.media.j3d.GraphicsContext3D;
import javax.media.j3d.J3dClock;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dStructure;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.MediaContainer;
import javax.media.j3d.MediaContainerRetained;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.PointSoundRetained;
import javax.media.j3d.Sound;
import javax.media.j3d.SoundRetained;
import javax.media.j3d.SoundSchedulerAtom;
import javax.media.j3d.SoundscapeRetained;
import javax.media.j3d.UnorderList;
import javax.media.j3d.UpdateTargets;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.ViewPlatformRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point2f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

class SoundScheduler
extends J3dStructure {
    View view = null;
    boolean ready = false;
    ViewPlatformRetained viewPlatform = null;
    GraphicsContext3D graphicsCtx = null;
    AuralAttributesRetained lastAA = null;
    boolean resetAA = true;
    AudioDevice audioDevice = null;
    AudioDevice3D audioDevice3D = null;
    AudioDevice3DL2 audioDevice3DL2 = null;
    int totalChannels = 0;
    SoundscapeRetained[] intersectedSoundscapes = new SoundscapeRetained[32];
    Bounds[] intersectedRegions = new Bounds[32];
    Bounds region = null;
    ArrayList<SoundSchedulerAtom> prioritizedSounds = new ArrayList();
    int nRetainedSounds = -1;
    int nImmedSounds = -1;
    AuralAttributesRetained aaRetained = null;
    boolean transformMsg = false;
    UpdateTargets targets = null;
    AuralAttributesRetained aaImmed = null;
    static final int EAR_POSITIONS_CHANGED = 1;
    static final int EYE_POSITIONS_CHANGED = 2;
    static final int IMAGE_PLATE_TO_VWORLD_CHANGED = 4;
    static final int HEAD_TO_VWORLD_CHANGED = 8;
    static final int LISTENER_CHANGED = 15;
    private int listenerUpdated = 15;
    private boolean positionalSoundUpdated = false;
    private boolean auralAttribsChanged = true;
    private boolean stallThread = false;
    int lastEventReceived = 202;
    static final boolean debugFlag = false;
    static final boolean internalErrors = false;

    SoundScheduler(VirtualUniverse u, View v) {
        super(u, 2);
        if (v == null) {
            System.err.println("WARNING: SoundScheduler constructed with null view");
        }
        if (u == null) {
            System.err.println("WARNING: SoundScheduler constructed with null universe");
        }
        this.universe = u;
        this.view = v;
        this.reset();
    }

    @Override
    void processMessages(long referenceTime) {
        Object[] messages = this.getMessages(referenceTime);
        int nMsg = this.getNumMessage();
        if (nMsg > 0) {
            for (int i = 0; i < nMsg; ++i) {
                J3dMessage m = messages[i];
                switch (m.type) {
                    case 0: {
                        this.insertNodes(m);
                        break;
                    }
                    case 1: {
                        this.removeNodes(m);
                        break;
                    }
                    case 38: {
                        this.changeNodeAttrib(m);
                        break;
                    }
                    case 45: {
                        this.changeNodeState(m);
                        break;
                    }
                    case 23: {
                        this.processBoundingLeafChanged(m);
                        break;
                    }
                    case 40: {
                        SoundscapeRetained ss = (SoundscapeRetained)m.args[0];
                        if (!this.universe.soundStructure.isSoundscapeScopedToView(ss, this.view)) break;
                        this.auralAttribsChanged = true;
                        this.changeNodeAttrib(m);
                        break;
                    }
                    case 39: {
                        this.auralAttribsChanged = true;
                        this.changeNodeAttrib(m);
                        break;
                    }
                    case 51: {
                        this.changeNodeAttrib(m);
                        break;
                    }
                    case 3: {
                        this.transformMsg = true;
                        this.auralAttribsChanged = true;
                        break;
                    }
                    case 44: {
                        this.processImmediateNodes(m.args, referenceTime);
                        break;
                    }
                    case 56: {
                        this.processViewSpecificGroupChanged(m);
                        break;
                    }
                    case 4: {
                        if (!this.prioritizedSounds.isEmpty()) break;
                        int nSounds = this.prioritizeSounds();
                        break;
                    }
                }
                m.decRefcount();
            }
            if (this.transformMsg) {
                this.targets = this.universe.transformStructure.getTargetList();
                this.updateTransformChange(this.targets, referenceTime);
                this.transformMsg = false;
                this.targets = null;
            }
            Arrays.fill(messages, 0, nMsg, null);
        }
        try {
            this.renderChanges();
        }
        catch (RuntimeException e) {
            System.err.println("Exception occurred during Sound rendering:");
            e.printStackTrace();
        }
        catch (Error e) {
            System.err.println("Error occurred during Sound rendering:");
            e.printStackTrace();
        }
        long waitTime = this.shortestTimeToFinish();
        if (waitTime == 0L) {
            VirtualUniverse.mc.sendRunMessage(this.universe, 2);
        } else if (waitTime > 0L) {
            VirtualUniverse.mc.sendRunMessage(waitTime, this.view, 2);
        }
    }

    void insertNodes(J3dMessage m) {
        Object[] nodes = (Object[])m.args[0];
        ArrayList viewScopedNodes = (ArrayList)m.args[3];
        ArrayList scopedNodesViewList = (ArrayList)m.args[4];
        for (int i = 0; i < nodes.length; ++i) {
            Object node = nodes[i];
            if (node instanceof SoundRetained) {
                ++this.nRetainedSounds;
                this.addSound((SoundRetained)node);
                continue;
            }
            if (node instanceof SoundscapeRetained) {
                this.auralAttribsChanged = true;
                continue;
            }
            if (node instanceof AuralAttributesRetained) {
                this.auralAttribsChanged = true;
                continue;
            }
            if (!(node instanceof ViewPlatformRetained)) continue;
        }
        if (viewScopedNodes != null) {
            int size = viewScopedNodes.size();
            for (int i = 0; i < size; ++i) {
                NodeRetained node = (NodeRetained)viewScopedNodes.get(i);
                ArrayList vl = (ArrayList)scopedNodesViewList.get(i);
                if (!vl.contains(this.view)) continue;
                if (node instanceof SoundRetained) {
                    ++this.nRetainedSounds;
                    this.addSound((SoundRetained)node);
                    continue;
                }
                if (!(node instanceof SoundscapeRetained)) continue;
                this.auralAttribsChanged = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSound(SoundRetained sound) {
        if (sound == null) {
            return;
        }
        ArrayList<SoundSchedulerAtom> arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            this.addPrioritizedSound(sound);
        }
    }

    @Override
    void removeNodes(J3dMessage m) {
        Object[] nodes = (Object[])m.args[0];
        ArrayList viewScopedNodes = (ArrayList)m.args[3];
        ArrayList scopedNodesViewList = (ArrayList)m.args[4];
        for (int i = 0; i < nodes.length; ++i) {
            Object node = nodes[i];
            if (node instanceof SoundRetained) {
                SoundSchedulerAtom soundAtom = null;
                int arrIndx = 1;
                while ((soundAtom = this.findSoundAtom((SoundRetained)node, arrIndx)) != null) {
                    this.stopSound(soundAtom, false);
                    ++arrIndx;
                }
                continue;
            }
            if (!(node instanceof SoundscapeRetained)) continue;
            this.auralAttribsChanged = true;
        }
        if (viewScopedNodes != null) {
            int size = viewScopedNodes.size();
            for (int i = 0; i < size; ++i) {
                NodeRetained node = (NodeRetained)viewScopedNodes.get(i);
                ArrayList vl = (ArrayList)scopedNodesViewList.get(i);
                if (!vl.contains(this.view)) continue;
                if (node instanceof SoundRetained) {
                    SoundSchedulerAtom soundAtom = null;
                    int arrIndx = 1;
                    while ((soundAtom = this.findSoundAtom((SoundRetained)node, arrIndx)) != null) {
                        this.stopSound(soundAtom, false);
                        ++arrIndx;
                    }
                    continue;
                }
                if (!(node instanceof SoundscapeRetained)) continue;
                this.auralAttribsChanged = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteSound(SoundRetained sound) {
        if (sound != null) {
            return;
        }
        ArrayList<SoundSchedulerAtom> arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            if (!this.prioritizedSounds.isEmpty()) {
                int arrSize = this.prioritizedSounds.size();
                for (int index = 0; index < arrSize; ++index) {
                    SoundSchedulerAtom soundAtom = this.prioritizedSounds.get(index);
                    if (soundAtom.sound != sound && soundAtom.sound.sgSound != sound) continue;
                    this.stopSound(soundAtom, false);
                    this.prioritizedSounds.remove(index);
                }
            }
        }
    }

    void changeNodeAttrib(J3dMessage m) {
        Object node = m.args[0];
        Object value = m.args[1];
        int attribDirty = (Integer)value;
        if (node instanceof SoundRetained && this.universe.soundStructure.isSoundScopedToView(node, this.view)) {
            this.setAttribsDirtyFlag((SoundRetained)node, attribDirty);
            if ((attribDirty & 0x20) > 0) {
                this.shuffleSound((SoundRetained)node);
            }
            if ((attribDirty & 1) > 0) {
                this.loadSound((SoundRetained)node, true);
            }
            if ((attribDirty & 0x40) > 0) {
                this.muteSound((SoundRetained)node);
            }
            if ((attribDirty & 0x80) > 0) {
                this.pauseSound((SoundRetained)node);
            }
        } else if (node instanceof SoundscapeRetained && this.universe.soundStructure.isSoundscapeScopedToView(node, this.view)) {
            this.auralAttribsChanged = true;
        } else if (node instanceof AuralAttributesRetained) {
            this.auralAttribsChanged = true;
        } else if (node instanceof MediaContainerRetained) {
            int listSize = (Integer)m.args[2];
            ArrayList userList = (ArrayList)m.args[3];
            for (int i = 0; i < listSize; ++i) {
                SoundRetained sound = (SoundRetained)userList.get(i);
                if (sound == null) continue;
                this.loadSound(sound, true);
            }
        }
    }

    void changeNodeState(J3dMessage m) {
        Object node = m.args[0];
        Object value = m.args[1];
        if (node instanceof SoundRetained && this.universe.soundStructure.isSoundScopedToView(node, this.view)) {
            int stateDirty = (Integer)value;
            this.setStateDirtyFlag((SoundRetained)node, stateDirty);
            if ((stateDirty & 1) > 0) {
                this.loadSound((SoundRetained)node, false);
            }
            if ((stateDirty & 0x20) > 0) {
                if (((Boolean)m.args[4]).booleanValue()) {
                    this.enableSound((SoundRetained)node);
                } else {
                    SoundRetained soundRetained = (SoundRetained)node;
                    for (int i = this.prioritizedSounds.size() - 1; i >= 0; --i) {
                        SoundSchedulerAtom soundAtom = this.prioritizedSounds.get(i);
                        if (soundAtom.sound.sgSound != soundRetained) continue;
                        this.turnOff(soundAtom);
                        soundAtom.enable(soundRetained.enable);
                    }
                }
            }
        }
    }

    void shuffleSound(SoundRetained sound) {
        this.deleteSound(sound);
        this.addSound(sound);
    }

    void loadSound(SoundRetained sound, boolean forceReload) {
        SoundSchedulerAtom soundAtom = null;
        int i = 1;
        while ((soundAtom = this.findSoundAtom(sound, i)) != null) {
            MediaContainer mediaContainer = sound.getSoundData();
            if (forceReload || soundAtom.loadStatus != 2) {
                this.attachSoundData(soundAtom, mediaContainer, forceReload);
            }
            ++i;
        }
    }

    void enableSound(SoundRetained sound) {
        SoundSchedulerAtom soundAtom = null;
        int i = 1;
        while ((soundAtom = this.findSoundAtom(sound, i)) != null) {
            soundAtom.enable(sound.enable);
            ++i;
        }
    }

    void muteSound(SoundRetained sound) {
        SoundSchedulerAtom soundAtom = null;
        int i = 1;
        while ((soundAtom = this.findSoundAtom(sound, i)) != null) {
            soundAtom.mute(sound.mute);
            ++i;
        }
    }

    void pauseSound(SoundRetained sound) {
        SoundSchedulerAtom soundAtom = null;
        int i = 1;
        while ((soundAtom = this.findSoundAtom(sound, i)) != null) {
            soundAtom.pause(sound.pause);
            ++i;
        }
    }

    void processImmediateNodes(Object[] args, long referenceTime) {
        Object command = args[0];
        Object newNode = args[1];
        Object oldNode = args[2];
        Sound oldSound = (Sound)oldNode;
        Sound newSound = (Sound)newNode;
        int action = (Integer)command;
        switch (action) {
            case 15: 
            case 17: {
                this.addSound((SoundRetained)newSound.retained);
                ++this.nImmedSounds;
                break;
            }
            case 16: {
                this.deleteSound((SoundRetained)oldSound.retained);
                --this.nImmedSounds;
                break;
            }
            case 14: {
                this.deleteSound((SoundRetained)oldSound.retained);
                this.addSound((SoundRetained)newSound.retained);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTransformChange(UpdateTargets targets, long referenceTime) {
        UnorderList arrList = targets.targetList[3];
        if (arrList != null) {
            int size = arrList.size();
            Object[] nodesArr = arrList.toArray(false);
            for (int j = 0; j < size; ++j) {
                Object[] nodes = (Object[])nodesArr[j];
                for (int i = 0; i < nodes.length; ++i) {
                    LeafRetained leafRetained;
                    if (nodes[i] instanceof ConeSoundRetained && this.universe.soundStructure.isSoundScopedToView(nodes[i], this.view)) {
                        ConeSoundRetained cnSndNode;
                        leafRetained = cnSndNode = (ConeSoundRetained)nodes[i];
                        synchronized (leafRetained) {
                            cnSndNode.updateTransformChange();
                        }
                        this.setStateDirtyFlag((SoundRetained)nodes[i], 32768);
                        continue;
                    }
                    if (nodes[i] instanceof PointSoundRetained && this.universe.soundStructure.isSoundScopedToView(nodes[i], this.view)) {
                        PointSoundRetained ptSndNode = (PointSoundRetained)nodes[i];
                        leafRetained = ptSndNode;
                        synchronized (leafRetained) {
                            ptSndNode.updateTransformChange();
                        }
                        this.setStateDirtyFlag((SoundRetained)nodes[i], 32768);
                        continue;
                    }
                    if (!(nodes[i] instanceof SoundscapeRetained) || !this.universe.soundStructure.isSoundscapeScopedToView(nodes[i], this.view)) continue;
                    SoundscapeRetained sndScapeNode = (SoundscapeRetained)nodes[i];
                    leafRetained = sndScapeNode;
                    synchronized (leafRetained) {
                        sndScapeNode.updateTransformChange();
                        continue;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTransformedFields(SoundRetained mirSound) {
        if (mirSound instanceof ConeSoundRetained && this.universe.soundStructure.isSoundScopedToView(mirSound, this.view)) {
            ConeSoundRetained cnSndNode;
            ConeSoundRetained coneSoundRetained = cnSndNode = (ConeSoundRetained)mirSound;
            synchronized (coneSoundRetained) {
                cnSndNode.updateTransformChange();
            }
        }
        if (mirSound instanceof PointSoundRetained && this.universe.soundStructure.isSoundScopedToView(mirSound, this.view)) {
            PointSoundRetained ptSndNode;
            PointSoundRetained pointSoundRetained = ptSndNode = (PointSoundRetained)mirSound;
            synchronized (pointSoundRetained) {
                ptSndNode.updateTransformChange();
            }
        }
    }

    void activate() {
        this.updateThread.active = true;
        VirtualUniverse.mc.sendRunMessage(this.universe, 2);
    }

    void deactivate() {
        if (this.checkState()) {
            try {
                this.deactivateAllSounds();
            }
            catch (RuntimeException e) {
                System.err.println("Exception occurred during sound deactivation:");
                e.printStackTrace();
            }
            catch (Error e) {
                System.err.println("Error occurred during sound deactivation:");
                e.printStackTrace();
            }
            this.updateThread.active = false;
        }
    }

    boolean checkState() {
        boolean runState = false;
        if (this.stallThread) {
            runState = false;
        }
        if (this.ready) {
            runState = true;
        } else {
            this.reset();
            runState = this.ready;
        }
        return runState;
    }

    synchronized void reset() {
        if (this.universe == null || this.view == null || this.view.physicalEnvironment == null || this.view.physicalEnvironment.audioDevice == null) {
            this.audioDevice = null;
            this.ready = false;
            return;
        }
        this.audioDevice = this.view.physicalEnvironment.audioDevice;
        ViewPlatform vp = this.view.getViewPlatform();
        if (vp == null || vp.retained == null) {
            this.viewPlatform = null;
            this.ready = false;
            return;
        }
        this.viewPlatform = (ViewPlatformRetained)vp.retained;
        if (!vp.isLive()) {
            this.ready = false;
            return;
        }
        Canvas3D canvas = this.view.getFirstCanvas();
        if (canvas != null) {
            this.graphicsCtx = canvas.getGraphicsContext3D();
        }
        this.audioDevice3DL2 = null;
        this.audioDevice3D = null;
        if (this.audioDevice instanceof AudioDevice3DL2) {
            this.audioDevice3DL2 = (AudioDevice3DL2)this.audioDevice;
        }
        if (this.audioDevice instanceof AudioDevice3D) {
            this.audioDevice3D = (AudioDevice3D)this.audioDevice;
            this.audioDevice3D.setView(this.view);
            this.totalChannels = this.audioDevice.getTotalChannels();
        } else {
            this.totalChannels = 0;
        }
        if (this.totalChannels == 0) {
            this.ready = false;
            return;
        }
        this.ready = true;
        this.view.setUserHeadToVworldEnable(true);
    }

    void receiveAWTEvent(AWTEvent evt) {
        int eventId = evt.getID();
        if (this.ready && eventId == 203) {
            this.lastEventReceived = eventId;
        } else if (this.ready && this.lastEventReceived == 203 && eventId == 204) {
            this.lastEventReceived = eventId;
        }
    }

    void renderChanges() {
        int nIntersected;
        boolean nSounds = false;
        boolean totalChannelsUsed = false;
        int nPrioritizedSound = 0;
        int numActiveSounds = 0;
        if (!this.checkState()) {
            return;
        }
        nPrioritizedSound = this.prioritizedSounds.size();
        if (nPrioritizedSound == 0) {
            return;
        }
        if (this.auralAttribsChanged && (nIntersected = this.findActiveSoundscapes()) > 0) {
            this.aaRetained = (AuralAttributesRetained)this.findClosestAAttribs(nIntersected).clone();
        }
        if (nPrioritizedSound > 0) {
            this.calcSchedulingAction();
            this.muteSilentSounds();
            this.positionalSoundUpdated = false;
            if (this.testListenerFlag()) {
                this.audioDevice3D.setView(this.view);
            }
            numActiveSounds = this.performActions();
            if (this.positionalSoundUpdated) {
                this.clearListenerFlag();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int prioritizeSounds() {
        int size;
        ArrayList<SoundSchedulerAtom> arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            if (!this.prioritizedSounds.isEmpty()) {
                this.prioritizedSounds.clear();
            }
            UnorderList retainedSounds = this.universe.soundStructure.getSoundList(this.view);
            this.nRetainedSounds = 0;
            this.nImmedSounds = 0;
            for (int i = 0; i < retainedSounds.size(); ++i) {
                this.addPrioritizedSound((SoundRetained)retainedSounds.get(i));
                ++this.nRetainedSounds;
            }
            Enumeration<Canvas3D> canvases = this.view.getAllCanvas3Ds();
            while (canvases.hasMoreElements()) {
                Canvas3D canvas = canvases.nextElement();
                GraphicsContext3D graphicsContext = canvas.getGraphicsContext3D();
                Enumeration<Sound> nonretainedSounds = graphicsContext.getAllSounds();
                while (nonretainedSounds.hasMoreElements()) {
                    Sound sound = nonretainedSounds.nextElement();
                    if (sound == null) continue;
                    this.addPrioritizedSound((SoundRetained)sound.retained);
                    ++this.nImmedSounds;
                }
            }
            this.debugPrint(" prioritizeSound , num of processed non-retained sounds" + this.nImmedSounds);
            size = this.prioritizedSounds.size();
        }
        return size;
    }

    void addPrioritizedSound(SoundRetained mirSound) {
        SoundRetained sound = mirSound.sgSound;
        if (sound == null) {
            mirSound.sgSound = mirSound;
            sound = mirSound;
        }
        boolean addAtom = false;
        SoundSchedulerAtom atom = null;
        atom = this.findSoundAtom(mirSound, 1);
        if (atom == null) {
            atom = new SoundSchedulerAtom();
            atom.soundScheduler = this;
            addAtom = true;
        }
        atom.sound = mirSound;
        this.updateTransformedFields(mirSound);
        if (!addAtom) {
            return;
        }
        atom.enable(sound.enable);
        if (this.prioritizedSounds.isEmpty()) {
            this.prioritizedSounds.add(atom);
        } else {
            int j;
            int jsounds = this.prioritizedSounds.size() - 1;
            float soundPriority = sound.priority;
            for (j = jsounds; j >= 0; --j) {
                SoundSchedulerAtom jAtom = this.prioritizedSounds.get(j);
                SoundRetained jSound = jAtom.sound;
                if (!(soundPriority <= jSound.sgSound.priority)) continue;
                if (j == jsounds) {
                    this.prioritizedSounds.add(atom);
                    break;
                }
                this.prioritizedSounds.add(j + 1, atom);
                break;
            }
            if (j < 0) {
                this.prioritizedSounds.add(0, atom);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int findActiveSoundscapes() {
        int nSscapes = 0;
        int nSelectedSScapes = 0;
        Object ss = null;
        SoundscapeRetained lss = null;
        boolean intersected = false;
        int nUnivSscapes = 0;
        UnorderList soundScapes = null;
        if (this.universe == null) {
            return 0;
        }
        soundScapes = this.universe.soundStructure.getSoundscapeList(this.view);
        if (soundScapes == null) {
            return 0;
        }
        UnorderList unorderList = soundScapes;
        synchronized (unorderList) {
            nUnivSscapes = soundScapes.size;
            if (nUnivSscapes == 0) {
                return 0;
            }
            if (this.intersectedRegions.length < nSscapes) {
                this.intersectedRegions = new Bounds[nSscapes + 32];
            }
            if (this.intersectedSoundscapes.length < nSscapes) {
                this.intersectedSoundscapes = new SoundscapeRetained[nSscapes + 32];
            }
            nSelectedSScapes = 0;
            for (int k = 0; k < nUnivSscapes; ++k) {
                lss = (SoundscapeRetained)soundScapes.get(k);
                if (lss.transformedRegion == null) continue;
                if (this.region instanceof BoundingSphere && lss.transformedRegion instanceof BoundingSphere || this.region instanceof BoundingBox && lss.transformedRegion instanceof BoundingBox || this.region instanceof BoundingPolytope && lss.transformedRegion instanceof BoundingPolytope) {
                    lss.transformedRegion.getWithLock(this.region);
                } else {
                    this.region = (Bounds)lss.transformedRegion.clone();
                }
                if (this.region == null || !this.viewPlatform.schedSphere.intersect(this.region)) continue;
                this.intersectedRegions[nSelectedSScapes] = (Bounds)this.region.clone();
                this.intersectedSoundscapes[nSelectedSScapes] = lss;
                ++nSelectedSScapes;
            }
        }
        return nSelectedSScapes;
    }

    AuralAttributesRetained findClosestAAttribs(int nSelectedSScapes) {
        AuralAttributes aa = null;
        SoundscapeRetained ss = null;
        boolean intersected = false;
        ss = null;
        if (nSelectedSScapes == 1) {
            ss = this.intersectedSoundscapes[0];
        } else if (nSelectedSScapes > 1) {
            Bounds closestRegions = this.viewPlatform.schedSphere.closestIntersection(this.intersectedRegions);
            for (int j = 0; j < this.intersectedRegions.length; ++j) {
                if (this.intersectedRegions[j] != closestRegions) continue;
                ss = this.intersectedSoundscapes[j];
                break;
            }
        }
        if (ss == null || (aa = ss.getAuralAttributes()) != null) {
            // empty if block
        }
        return (AuralAttributesRetained)aa.retained;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateAuralAttribs(AuralAttributesRetained attribs) {
        if (this.auralAttribsChanged) {
            if (attribs != null) {
                AuralAttributesRetained auralAttributesRetained = attribs;
                synchronized (auralAttributesRetained) {
                    Bounds reverbVolume;
                    this.audioDevice3D.setRolloff(attribs.rolloff);
                    int arraySize = attribs.getDistanceFilterLength();
                    if (attribs.filterType == -1 || arraySize == 0) {
                        this.audioDevice3D.setDistanceFilter(-1, null, null);
                    } else {
                        Point2f[] attenuation = new Point2f[arraySize];
                        for (int i = 0; i < arraySize; ++i) {
                            attenuation[i] = new Point2f();
                        }
                        attribs.getDistanceFilter(attenuation);
                        double[] distance = new double[arraySize];
                        float[] cutoff = new float[arraySize];
                        for (int i = 0; i < arraySize; ++i) {
                            distance[i] = attenuation[i].x;
                            cutoff[i] = attenuation[i].y;
                        }
                        this.audioDevice3D.setDistanceFilter(attribs.filterType, distance, cutoff);
                    }
                    this.audioDevice3D.setFrequencyScaleFactor(attribs.frequencyScaleFactor);
                    this.audioDevice3D.setVelocityScaleFactor(attribs.velocityScaleFactor);
                    this.audioDevice3D.setReflectionCoefficient(attribs.reflectionCoefficient);
                    if (this.audioDevice3DL2 != null) {
                        this.audioDevice3DL2.setReverbCoefficient(attribs.reverbCoefficient);
                        this.audioDevice3DL2.setDecayFilter(attribs.decayFilter);
                        this.audioDevice3DL2.setDiffusion(attribs.diffusion);
                        this.audioDevice3DL2.setDensity(attribs.density);
                    }
                    if ((reverbVolume = attribs.reverbBounds) == null) {
                        this.audioDevice3D.setReverbDelay(attribs.reverbDelay);
                    } else {
                        float reverbDelay;
                        if (reverbVolume instanceof BoundingSphere) {
                            reverbDelay = (float)(2.0 * ((BoundingSphere)reverbVolume).radius / (double)0.344f);
                        } else {
                            BoundingSphere tempSphere = new BoundingSphere(reverbVolume);
                            reverbDelay = (float)(2.0 * tempSphere.radius / (double)0.344f);
                        }
                        this.audioDevice3D.setReverbDelay(reverbDelay);
                    }
                    this.audioDevice3D.setReverbOrder(attribs.reverbOrder);
                    if (this.audioDevice3DL2 != null) {
                        this.audioDevice3DL2.setDecayTime(attribs.decayTime);
                    }
                }
                this.resetAA = true;
            } else if (this.lastAA != null) {
                this.audioDevice3D.setRolloff(1.0f);
                this.audioDevice3D.setReflectionCoefficient(0.0f);
                this.audioDevice3D.setReverbDelay(40.0f);
                this.audioDevice3D.setReverbOrder(0);
                this.audioDevice3D.setDistanceFilter(-1, null, null);
                this.audioDevice3D.setFrequencyScaleFactor(1.0f);
                this.audioDevice3D.setVelocityScaleFactor(0.0f);
                if (this.audioDevice3DL2 != null) {
                    this.audioDevice3DL2.setReverbCoefficient(0.0f);
                    this.audioDevice3DL2.setReflectionDelay(20.0f);
                    this.audioDevice3DL2.setDecayTime(1000.0f);
                    this.audioDevice3DL2.setDecayFilter(5000.0f);
                    this.audioDevice3DL2.setDiffusion(1.0f);
                    this.audioDevice3DL2.setDensity(1.0f);
                }
                this.resetAA = true;
            }
            this.lastAA = attribs;
            this.auralAttribsChanged = false;
        }
    }

    /*
     * Unable to fully structure code
     */
    void processSoundAtom(SoundSchedulerAtom soundAtom) {
        mirSound = soundAtom.sound;
        sound = mirSound.sgSound;
        if (soundAtom.status == 4 && soundAtom.enabled != 2) {
            return;
        }
        if (soundAtom.loadStatus != 2) {
            this.attachSoundData(soundAtom, sound.soundData, false);
        }
        if (soundAtom.loadStatus != 2) {
            return;
        }
        if (this.resetAA) {
            soundAtom.setAttribsDirtyFlag(2);
        }
        intersected = false;
        if (!this.updateThread.active) {
            this.region = null;
            intersected = false;
        } else if (sound.getInImmCtx()) {
            this.region = null;
            intersected = true;
        } else {
            if (sound.schedulingRegion != null && mirSound.transformedRegion != null) {
                if (this.region instanceof BoundingSphere != false && mirSound.transformedRegion instanceof BoundingSphere != false || this.region instanceof BoundingBox != false && mirSound.transformedRegion instanceof BoundingBox != false || this.region instanceof BoundingPolytope && mirSound.transformedRegion instanceof BoundingPolytope) {
                    mirSound.transformedRegion.getWithLock(this.region);
                } else {
                    this.region = (Bounds)mirSound.transformedRegion.clone();
                }
            } else {
                this.region = null;
            }
            intersected = this.region != null ? this.viewPlatform.schedSphere.intersect(this.region) : false;
        }
        if (!sound.getInImmCtx() && (!intersected || mirSound.switchState == null || !mirSound.switchState.currentSwitchOn)) ** GOTO lbl-1000
        if (soundAtom.muted == 0) ** GOTO lbl-1000
        if (soundAtom.muted == 2) lbl-1000:
        // 2 sources

        {
            soundAtom.schedulingAction = soundAtom.calcActiveSchedAction();
        } else lbl-1000:
        // 2 sources

        {
            soundAtom.schedulingAction = soundAtom.calcInactiveSchedAction();
        }
        if (soundAtom.schedulingAction == 3 && (soundAtom.testDirtyFlags() || this.testListenerFlag() && !(sound instanceof BackgroundSoundRetained))) {
            soundAtom.schedulingAction = 18;
        }
        switch (soundAtom.schedulingAction) {
            case 17: {
                soundAtom.status = 0;
                this.turnOff(soundAtom);
                soundAtom.schedulingAction = 1;
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                currentTime = J3dClock.currentTimeMillis();
                if (soundAtom.endTime <= 0L || soundAtom.endTime > currentTime) break;
                soundAtom.schedulingAction = 19;
                soundAtom.status = 4;
                this.turnOff(soundAtom);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            default: {
                soundAtom.schedulingAction = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int calcSchedulingAction() {
        int nSounds = 0;
        int numSoundsToProcess = 0;
        if (this.universe == null) {
            return 0;
        }
        if (this.universe.soundStructure == null) {
            return 0;
        }
        ArrayList<SoundSchedulerAtom> arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            nSounds = this.prioritizedSounds.size();
            for (int i = 0; i < nSounds; ++i) {
                SoundSchedulerAtom soundAtom = this.prioritizedSounds.get(i);
                SoundRetained mirSound = soundAtom.sound;
                SoundRetained sound = mirSound.sgSound;
                boolean processSound = false;
                if (!sound.source.isLive() && !sound.getInImmCtx()) {
                    if (soundAtom.playing || soundAtom.enabled == 1) {
                        soundAtom.setEnableState(3);
                        processSound = true;
                    } else if (soundAtom.enabled == 3) {
                        processSound = true;
                    } else if (soundAtom.enabled == 2) {
                        soundAtom.setEnableState(0);
                    }
                } else {
                    processSound = true;
                }
                if (processSound) {
                    ++numSoundsToProcess;
                    this.processSoundAtom(soundAtom);
                    continue;
                }
                soundAtom.schedulingAction = 0;
            }
        }
        return numSoundsToProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void muteSilentSounds() {
        int totalChannelsUsed = 0;
        ArrayList<SoundSchedulerAtom> arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            int nAtoms = this.prioritizedSounds.size();
            for (int i = 0; i < nAtoms; ++i) {
                int numberChannels;
                SoundSchedulerAtom soundAtom = this.prioritizedSounds.get(i);
                SoundRetained mirSound = soundAtom.sound;
                SoundRetained sound = mirSound.sgSound;
                int sampleId = soundAtom.sampleId;
                int status = soundAtom.status;
                if (soundAtom.status == 4 || soundAtom.schedulingAction == 0 || sampleId == -1) continue;
                if (soundAtom.schedulingAction == 12 || soundAtom.schedulingAction == 7 || soundAtom.schedulingAction == 2 || soundAtom.schedulingAction == 8) {
                    if (status != 2) {
                        this.audioDevice3D.muteSample(sampleId);
                    }
                    soundAtom.numberChannels = numberChannels = this.audioDevice3D.getNumberOfChannelsUsed(sampleId);
                    totalChannelsUsed += numberChannels;
                    continue;
                }
                numberChannels = this.audioDevice3D.getNumberOfChannelsUsed(sampleId, false);
                if (totalChannelsUsed + numberChannels > this.totalChannels) {
                    if (soundAtom.schedulingAction == 11 || soundAtom.schedulingAction == 3) {
                        soundAtom.schedulingAction = 12;
                    } else if (soundAtom.schedulingAction == 5) {
                        soundAtom.schedulingAction = 7;
                    } else if (soundAtom.schedulingAction == 6) {
                        soundAtom.schedulingAction = 8;
                    } else if (soundAtom.schedulingAction == 13) {
                        soundAtom.schedulingAction = 14;
                    } else if (soundAtom.schedulingAction == 15) {
                        soundAtom.schedulingAction = 16;
                    }
                    this.audioDevice3D.muteSample(sampleId);
                } else if (status != 1) {
                    this.audioDevice3D.unmuteSample(sampleId);
                }
                soundAtom.numberChannels = numberChannels = this.audioDevice3D.getNumberOfChannelsUsed(sampleId);
                totalChannelsUsed += numberChannels;
            }
        }
    }

    void muteSilentSound(SoundSchedulerAtom soundAtom) {
        SoundRetained mirSound = soundAtom.sound;
        SoundRetained sound = mirSound.sgSound;
        int sampleId = soundAtom.sampleId;
        int status = soundAtom.status;
        if (status == 4) {
            return;
        }
        if (sampleId == -1) {
            return;
        }
        if ((soundAtom.schedulingAction == 12 || soundAtom.schedulingAction == 7 || soundAtom.schedulingAction == 2 || soundAtom.schedulingAction == 8) && status != 2) {
            this.audioDevice3D.muteSample(sampleId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long shortestTimeToFinish() {
        long currentTime = J3dClock.currentTimeMillis();
        long shortestTime = -1L;
        ArrayList<SoundSchedulerAtom> arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            int nAtoms = this.prioritizedSounds.size();
            for (int i = 0; i < nAtoms; ++i) {
                long endTime;
                SoundSchedulerAtom soundAtom = this.prioritizedSounds.get(i);
                if (soundAtom.status == 0 || soundAtom.status == 4 || (endTime = soundAtom.endTime) < 0L) continue;
                long timeLeft = endTime - currentTime;
                if (timeLeft < 0L) {
                    timeLeft = 0L;
                }
                if (shortestTime < 0L) {
                    shortestTime = timeLeft;
                    continue;
                }
                if (timeLeft >= shortestTime) continue;
                shortestTime = timeLeft;
            }
        }
        return shortestTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int performActions() {
        int numActiveSounds = 0;
        ArrayList<SoundSchedulerAtom> arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            int nAtoms = this.prioritizedSounds.size();
            for (int i = 0; i < nAtoms; ++i) {
                SoundSchedulerAtom soundAtom = this.prioritizedSounds.get(i);
                SoundRetained mirSound = soundAtom.sound;
                SoundRetained sound = mirSound.sgSound;
                int sampleId = soundAtom.sampleId;
                if (sampleId == -1) continue;
                this.resetAA = false;
                AuralAttributesRetained attribs = sound.getInImmCtx() ? (this.graphicsCtx != null && this.graphicsCtx.auralAttributes != null ? (this.aaImmed = (AuralAttributesRetained)this.graphicsCtx.auralAttributes.retained) : null) : this.aaRetained;
                this.updateAuralAttribs(attribs);
                switch (soundAtom.schedulingAction) {
                    case 5: {
                        this.turnOff(soundAtom);
                    }
                    case 6: {
                        if (soundAtom.paused == 3) {
                            this.pause(soundAtom);
                        }
                        if (soundAtom.paused == 2) {
                            this.unpause(soundAtom);
                        }
                        if (soundAtom.paused == 0) {
                            soundAtom.status = 1;
                            this.render(true, soundAtom, attribs);
                        } else {
                            soundAtom.status = 3;
                            soundAtom.setEnableState(2);
                        }
                        ++numActiveSounds;
                        break;
                    }
                    case 7: {
                        this.turnOff(soundAtom);
                    }
                    case 8: {
                        if (soundAtom.paused == 3) {
                            this.pause(soundAtom);
                        }
                        if (soundAtom.paused == 2) {
                            this.unpause(soundAtom);
                        }
                        if (soundAtom.paused == 0) {
                            soundAtom.status = 2;
                            this.render(true, soundAtom, attribs);
                        } else {
                            soundAtom.status = 3;
                            soundAtom.setEnableState(2);
                        }
                        ++numActiveSounds;
                        break;
                    }
                    case 15: {
                        this.unpause(soundAtom);
                    }
                    case 11: {
                        soundAtom.status = 1;
                        this.render(false, soundAtom, attribs);
                        ++numActiveSounds;
                        break;
                    }
                    case 16: {
                        this.unpause(soundAtom);
                    }
                    case 12: {
                        this.render(false, soundAtom, attribs);
                        soundAtom.status = 2;
                        ++numActiveSounds;
                        break;
                    }
                    case 13: 
                    case 14: {
                        this.pause(soundAtom);
                        soundAtom.status = 3;
                        ++numActiveSounds;
                        break;
                    }
                    case 18: {
                        this.render(false, soundAtom, attribs);
                        ++numActiveSounds;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        if (this.resetAA || soundAtom.testDirtyFlags()) {
                            this.render(false, soundAtom, attribs);
                        }
                        ++numActiveSounds;
                        break;
                    }
                    case 17: {
                        this.turnOff(soundAtom);
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 19: {
                        break;
                    }
                }
                soundAtom.clearStateDirtyFlag();
                soundAtom.clearAttribsDirtyFlag();
            }
        }
        this.resetAA = false;
        return numActiveSounds;
    }

    void render(boolean startFlag, SoundSchedulerAtom soundAtom, AuralAttributesRetained attribs) {
        SoundRetained mirrorSound = soundAtom.sound;
        SoundRetained sound = mirrorSound.sgSound;
        if (soundAtom.sampleId == -1 || soundAtom.soundData == null) {
            return;
        }
        int index = soundAtom.sampleId;
        if (startFlag) {
            if (sound instanceof PointSoundRetained || sound instanceof ConeSoundRetained) {
                this.updateXformedParams(true, soundAtom);
            }
            this.updateSoundParams(true, soundAtom, attribs);
            this.start(soundAtom);
        } else if (soundAtom.status == 1) {
            if (sound instanceof PointSoundRetained || sound instanceof ConeSoundRetained) {
                this.updateXformedParams(false, soundAtom);
            }
            this.updateSoundParams(false, soundAtom, attribs);
            this.update(soundAtom);
        }
    }

    void start(SoundSchedulerAtom soundAtom) {
        SoundRetained sound = soundAtom.sound.sgSound;
        int index = soundAtom.sampleId;
        int startStatus = -1;
        if (index != -1 && (startStatus = this.audioDevice3D.startSample(index)) >= 0) {
            soundAtom.playing = true;
            soundAtom.startTime = this.audioDevice3D.getStartTime(index);
            soundAtom.calculateEndTime();
        } else {
            soundAtom.startTime = 0L;
            soundAtom.endTime = 0L;
            soundAtom.playing = false;
        }
    }

    void update(SoundSchedulerAtom soundAtom) {
        int index = soundAtom.sampleId;
        if (index == -1) {
            return;
        }
        SoundRetained sound = soundAtom.sound;
        this.audioDevice3D.updateSample(index);
        soundAtom.calculateEndTime();
        if (sound instanceof PointSoundRetained || sound instanceof ConeSoundRetained) {
            this.positionalSoundUpdated = true;
        }
    }

    void stopSound(SoundSchedulerAtom soundAtom, boolean setPending) {
        if (this.audioDevice3D == null) {
            return;
        }
        switch (soundAtom.enabled) {
            case 1: {
                if (setPending) {
                    soundAtom.setEnableState(2);
                    break;
                }
                soundAtom.setEnableState(0);
                break;
            }
            case 3: {
                soundAtom.setEnableState(0);
                break;
            }
            case 2: {
                if (setPending) break;
                soundAtom.setEnableState(0);
                break;
            }
        }
        soundAtom.status = 0;
        this.turnOff(soundAtom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void deactivateAllSounds() {
        if (this.audioDevice3D == null) {
            return;
        }
        ArrayList<SoundSchedulerAtom> arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            if (this.prioritizedSounds != null) {
                int nAtoms = this.prioritizedSounds.size();
                for (int i = 0; i < nAtoms; ++i) {
                    SoundSchedulerAtom soundAtom = this.prioritizedSounds.get(i);
                    SoundRetained mirSound = soundAtom.sound;
                    SoundRetained sound = mirSound.sgSound;
                    if (sound.continuous) {
                        soundAtom.schedulingAction = soundAtom.calcInactiveSchedAction();
                        this.muteSilentSound(soundAtom);
                        continue;
                    }
                    this.stopSound(soundAtom, true);
                    soundAtom.schedulingAction = 1;
                }
            }
        }
        this.performActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void pauseAllSounds() {
        if (this.audioDevice3D == null) {
            return;
        }
        this.stallThread = true;
        ArrayList<SoundSchedulerAtom> arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            if (this.prioritizedSounds != null) {
                int nAtoms = this.prioritizedSounds.size();
                block6: for (int i = 0; i < nAtoms; ++i) {
                    SoundSchedulerAtom soundAtom = this.prioritizedSounds.get(i);
                    SoundRetained mirSound = soundAtom.sound;
                    SoundRetained sound = mirSound.sgSound;
                    switch (soundAtom.enabled) {
                        case 1: 
                        case 3: {
                            this.pause(soundAtom);
                            continue block6;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void resumeAllSounds() {
        if (this.audioDevice3D == null) {
            return;
        }
        ArrayList<SoundSchedulerAtom> arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            if (this.prioritizedSounds != null) {
                int nAtoms = this.prioritizedSounds.size();
                block6: for (int i = 0; i < nAtoms; ++i) {
                    SoundSchedulerAtom soundAtom = this.prioritizedSounds.get(i);
                    SoundRetained mirSound = soundAtom.sound;
                    SoundRetained sound = mirSound.sgSound;
                    switch (soundAtom.enabled) {
                        case 1: 
                        case 3: {
                            this.unpause(soundAtom);
                            continue block6;
                        }
                    }
                }
            }
        }
        this.stallThread = false;
    }

    synchronized void stopAllSounds() {
        this.stopAllSounds(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void stopAllSounds(boolean setPlayingSoundsPending) {
        if (this.audioDevice3D == null) {
            return;
        }
        if (this.lastEventReceived == 203) {
            return;
        }
        ArrayList<SoundSchedulerAtom> arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            if (this.prioritizedSounds != null) {
                int nAtoms = this.prioritizedSounds.size();
                for (int i = 0; i < nAtoms; ++i) {
                    SoundSchedulerAtom soundAtom = this.prioritizedSounds.get(i);
                    this.stopSound(soundAtom, setPlayingSoundsPending);
                }
            }
        }
    }

    void pause(SoundSchedulerAtom soundAtom) {
        if (soundAtom.sampleId == -1) {
            return;
        }
        this.audioDevice3D.pauseSample(soundAtom.sampleId);
        soundAtom.setPauseState(1);
    }

    void unpause(SoundSchedulerAtom soundAtom) {
        if (soundAtom.sampleId == -1) {
            return;
        }
        this.audioDevice3D.unpauseSample(soundAtom.sampleId);
        soundAtom.setPauseState(0);
    }

    void turnOff(SoundSchedulerAtom soundAtom) {
        if (soundAtom.sampleId == -1) {
            return;
        }
        if (this.audioDevice3D.stopSample(soundAtom.sampleId) < 0) {
            // empty if block
        }
        soundAtom.playing = false;
        soundAtom.startTime = 0L;
        soundAtom.endTime = 0L;
    }

    void updateXformedParams(boolean updateAll, SoundSchedulerAtom soundAtom) {
        PointSoundRetained mirrorPtSound = (PointSoundRetained)soundAtom.sound;
        PointSoundRetained ptSound = (PointSoundRetained)mirrorPtSound.sgSound;
        int index = soundAtom.sampleId;
        if (index == -1) {
            return;
        }
        PointSoundRetained ps = mirrorPtSound;
        if (updateAll || this.testListenerFlag() || soundAtom.testDirtyFlag(soundAtom.attribsDirty, 64) || soundAtom.testDirtyFlag(soundAtom.stateDirty, 32768)) {
            Point3f xformLocation = new Point3f();
            mirrorPtSound.getXformPosition(xformLocation);
            Point3d positionD = new Point3d(xformLocation);
            this.audioDevice3D.setPosition(index, positionD);
        }
        if (mirrorPtSound instanceof ConeSoundRetained) {
            ConeSoundRetained cn = (ConeSoundRetained)mirrorPtSound;
            ConeSoundRetained cnSound = (ConeSoundRetained)mirrorPtSound.sgSound;
            if (updateAll || soundAtom.testDirtyFlag(soundAtom.attribsDirty, 33280)) {
                Vector3f xformDirection = new Vector3f();
                cn.getXformDirection(xformDirection);
                Vector3d directionD = new Vector3d(xformDirection);
                this.audioDevice3D.setDirection(index, directionD);
            }
        }
    }

    void updateSoundParams(boolean updateAll, SoundSchedulerAtom soundAtom, AuralAttributesRetained attribs) {
        Point2f[] attenuation;
        int arraySize;
        ConeSoundRetained cnSound;
        SoundRetained mirrorSound = soundAtom.sound;
        SoundRetained sound = mirrorSound.sgSound;
        int index = soundAtom.sampleId;
        if (index == -1) {
            return;
        }
        if (updateAll || soundAtom.testDirtyFlag(soundAtom.attribsDirty, 2)) {
            if (attribs != null) {
                this.audioDevice3D.setSampleGain(index, sound.initialGain * attribs.attributeGain);
            } else {
                this.audioDevice3D.setSampleGain(index, sound.initialGain);
            }
        }
        if (updateAll || soundAtom.testDirtyFlag(soundAtom.attribsDirty, 4)) {
            this.audioDevice3D.setLoop(index, sound.loopCount);
        }
        if ((updateAll || soundAtom.testDirtyFlag(soundAtom.attribsDirty, 2048)) && this.audioDevice3DL2 != null) {
            this.audioDevice3DL2.setRateScaleFactor(index, sound.rate);
        }
        if (updateAll || soundAtom.testDirtyFlag(soundAtom.attribsDirty, 128)) {
            if (sound instanceof ConeSoundRetained) {
                cnSound = (ConeSoundRetained)sound;
                arraySize = cnSound.getDistanceGainLength();
                if (arraySize == 0) {
                    this.audioDevice3D.setDistanceGain(index, null, null, null, null);
                } else {
                    attenuation = new Point2f[arraySize];
                    Point2f[] backAttenuation = new Point2f[arraySize];
                    for (int i = 0; i < arraySize; ++i) {
                        attenuation[i] = new Point2f();
                        backAttenuation[i] = new Point2f();
                    }
                    cnSound.getDistanceGain(attenuation, backAttenuation);
                    double[] frontDistance = new double[arraySize];
                    float[] frontGain = new float[arraySize];
                    double[] backDistance = new double[arraySize];
                    float[] backGain = new float[arraySize];
                    for (int i = 0; i < arraySize; ++i) {
                        frontDistance[i] = attenuation[i].x;
                        frontGain[i] = attenuation[i].y;
                        backDistance[i] = backAttenuation[i].x;
                        backGain[i] = backAttenuation[i].y;
                    }
                    this.audioDevice3D.setDistanceGain(index, frontDistance, frontGain, backDistance, backGain);
                }
            } else if (sound instanceof PointSoundRetained) {
                PointSoundRetained ptSound = (PointSoundRetained)sound;
                arraySize = ptSound.getDistanceGainLength();
                if (arraySize == 0) {
                    this.audioDevice3D.setDistanceGain(index, null, null, null, null);
                } else {
                    attenuation = new Point2f[arraySize];
                    for (int i = 0; i < arraySize; ++i) {
                        attenuation[i] = new Point2f();
                    }
                    ptSound.getDistanceGain(attenuation);
                    double[] frontDistance = new double[arraySize];
                    float[] frontGain = new float[arraySize];
                    for (int i = 0; i < arraySize; ++i) {
                        frontDistance[i] = attenuation[i].x;
                        frontGain[i] = attenuation[i].y;
                    }
                    this.audioDevice3D.setDistanceGain(index, frontDistance, frontGain, null, null);
                }
            }
        }
        if (sound instanceof ConeSoundRetained && (updateAll || soundAtom.testDirtyFlag(soundAtom.attribsDirty, 1024))) {
            cnSound = (ConeSoundRetained)sound;
            arraySize = cnSound.getAngularAttenuationLength();
            if (arraySize == 0) {
                double[] angle = new double[2];
                float[] scaleFactor = new float[2];
                angle[0] = 0.0;
                angle[1] = 1.5707963267948966;
                scaleFactor[0] = 1.0f;
                scaleFactor[1] = 0.0f;
                this.audioDevice3D.setAngularAttenuation(index, -1, angle, scaleFactor, null);
            } else {
                attenuation = new Point3f[arraySize];
                for (int i = 0; i < arraySize; ++i) {
                    attenuation[i] = new Point3f();
                }
                cnSound.getAngularAttenuation((Point3f[])attenuation);
                double[] angle = new double[arraySize];
                float[] scaleFactor = new float[arraySize];
                float[] cutoff = new float[arraySize];
                for (int i = 0; i < arraySize; ++i) {
                    angle[i] = attenuation[i].x;
                    scaleFactor[i] = attenuation[i].y;
                    cutoff[i] = attenuation[i].z;
                }
                this.audioDevice3D.setAngularAttenuation(index, cnSound.filterType, angle, scaleFactor, cutoff);
            }
        }
    }

    boolean checkAudioDevice3D() {
        if (this.universe != null && this.universe.currentView != null && this.universe.currentView.physicalEnvironment != null) {
            this.audioDevice = this.universe.currentView.physicalEnvironment.audioDevice;
            if (this.audioDevice != null) {
                if (this.audioDevice instanceof AudioDevice3DL2) {
                    this.audioDevice3DL2 = (AudioDevice3DL2)this.audioDevice;
                }
                if (this.audioDevice instanceof AudioDevice3D) {
                    this.audioDevice3D = (AudioDevice3D)this.audioDevice;
                }
            } else {
                this.audioDevice3DL2 = null;
                this.audioDevice3D = null;
            }
        }
        if (this.audioDevice3D == null) {
            return false;
        }
        return this.audioDevice3D.getTotalChannels() != 0;
    }

    void clearSoundData(SoundSchedulerAtom soundAtom) {
        if (this.checkAudioDevice3D() && soundAtom.sampleId != -1) {
            this.stopSound(soundAtom, false);
            this.audioDevice3D.clearSound(soundAtom.sampleId);
        }
        soundAtom.sampleId = -1;
        soundAtom.loadStatus = 0;
        SoundRetained sound = soundAtom.sound;
        soundAtom.loadStatus = 0;
        soundAtom.soundData = null;
        sound.changeAtomList(soundAtom, 0);
    }

    void attachSoundData(SoundSchedulerAtom soundAtom, MediaContainer soundData, boolean forceReload) {
        if (!forceReload && soundAtom.soundData == soundData) {
            return;
        }
        SoundRetained sound = soundAtom.sound.sgSound;
        if (!this.checkAudioDevice3D()) {
            soundAtom.loadStatus = 1;
            sound.changeAtomList(soundAtom, 1);
            return;
        }
        if (soundAtom.soundData != null) {
            this.clearSoundData(soundAtom);
            if (soundData == null) {
                return;
            }
        }
        URL url = ((MediaContainerRetained)sound.soundData.retained).url;
        String path = ((MediaContainerRetained)sound.soundData.retained).urlString;
        InputStream stream = ((MediaContainerRetained)sound.soundData.retained).inputStream;
        if (url == null && path == null && stream == null) {
            if (soundAtom.sampleId != -1) {
                this.clearSoundData(soundAtom);
            }
            return;
        }
        sound.soundType = sound instanceof ConeSoundRetained ? 3 : (sound instanceof PointSoundRetained ? 2 : 1);
        MediaContainer cloneMediaContainer = new MediaContainer();
        cloneMediaContainer.duplicateAttributes(soundData, true);
        cloneMediaContainer.setCapability(0);
        cloneMediaContainer.setCapability(2);
        int id = this.audioDevice3D.prepareSound(sound.soundType, cloneMediaContainer);
        if (id == -1) {
            soundAtom.loadStatus = -1;
            sound.changeAtomList(soundAtom, -1);
        } else {
            long duration;
            soundAtom.sampleId = id;
            soundAtom.loopLength = soundAtom.sampleLength = (duration = this.audioDevice3D.getSampleDuration(id));
            soundAtom.loopStartOffset = 0L;
            soundAtom.attackLength = 0L;
            soundAtom.releaseLength = 0L;
            soundAtom.loadStatus = 2;
            soundAtom.soundData = soundData;
            sound.changeAtomList(soundAtom, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SoundSchedulerAtom findSoundAtom(SoundRetained node, int nthInstance) {
        if (node == null) {
            return null;
        }
        SoundSchedulerAtom returnAtom = null;
        ArrayList<SoundSchedulerAtom> arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            if (!this.prioritizedSounds.isEmpty()) {
                SoundSchedulerAtom soundAtom = null;
                int atomFound = 0;
                int arrSize = this.prioritizedSounds.size();
                for (int index = 0; index < arrSize; ++index) {
                    soundAtom = this.prioritizedSounds.get(index);
                    if (soundAtom.sound == null) continue;
                    if (soundAtom.sound.sgSound == node) {
                        if (++atomFound != nthInstance) continue;
                        returnAtom = soundAtom;
                        break;
                    }
                    if (soundAtom.sound.sgSound != node.sgSound) continue;
                    soundAtom.sound = node;
                    if (++atomFound != nthInstance) continue;
                    returnAtom = soundAtom;
                    break;
                }
            }
        }
        return returnAtom;
    }

    void setListenerFlag(int flag) {
        this.listenerUpdated |= flag;
    }

    void clearListenerFlag() {
        this.listenerUpdated = 0;
    }

    boolean testListenerFlag() {
        return this.listenerUpdated > 0;
    }

    void setAttribsDirtyFlag(SoundRetained node, int dirtyFlag) {
        SoundSchedulerAtom soundAtom = null;
        int i = 1;
        while ((soundAtom = this.findSoundAtom(node, i)) != null) {
            soundAtom.setAttribsDirtyFlag(dirtyFlag);
            ++i;
        }
    }

    void setStateDirtyFlag(SoundRetained node, int dirtyFlag) {
        SoundSchedulerAtom soundAtom = null;
        int i = 1;
        while ((soundAtom = this.findSoundAtom(node, i)) != null) {
            soundAtom.setStateDirtyFlag(dirtyFlag);
            ++i;
        }
    }

    void printAtomState(SoundSchedulerAtom atom) {
        SoundRetained sound = atom.sound.sgSound;
        this.debugPrint("                  this atom = " + atom + "       ");
        this.debugPrint("                 references sound = " + sound + "       ");
        this.debugPrint("                 enabled " + atom.enabled);
        this.debugPrint("                 status " + atom.status);
        this.debugPrint("                 activated " + atom.activated);
        this.debugPrint("                 released " + sound.release);
        this.debugPrint("                 continuous " + sound.continuous);
        this.debugPrint("                 scheduling " + atom.schedulingAction);
    }

    void debugPrint(String message) {
    }

    void processViewSpecificGroupChanged(J3dMessage m) {
        Object obj;
        int i;
        int size;
        int component = (Integer)m.args[0];
        Object[] objAry = (Object[])m.args[1];
        if ((component & 2) != 0 || (component & 1) != 0) {
            View v = (View)objAry[0];
            ArrayList leafList = (ArrayList)objAry[2];
            if (v == this.view) {
                size = leafList.size();
                for (i = 0; i < size; ++i) {
                    obj = leafList.get(i);
                    if (obj instanceof SoundRetained) {
                        ++this.nRetainedSounds;
                        this.addSound((SoundRetained)obj);
                        continue;
                    }
                    if (!(obj instanceof SoundscapeRetained)) continue;
                    this.auralAttribsChanged = true;
                }
            }
        }
        if ((component & 4) != 0 || (component & 1) != 0) {
            ArrayList leafList;
            View v;
            if ((component & 4) != 0) {
                v = (View)objAry[0];
                leafList = (ArrayList)objAry[2];
            } else {
                v = (View)objAry[4];
                leafList = (ArrayList)objAry[6];
            }
            if (v == this.view) {
                size = leafList.size();
                for (i = 0; i < size; ++i) {
                    obj = leafList.get(i);
                    if (obj instanceof SoundRetained) {
                        SoundSchedulerAtom soundAtom = null;
                        int arrIndx = 1;
                        while ((soundAtom = this.findSoundAtom((SoundRetained)obj, arrIndx)) != null) {
                            this.stopSound(soundAtom, false);
                            ++arrIndx;
                        }
                        continue;
                    }
                    if (!(obj instanceof SoundscapeRetained)) continue;
                    this.auralAttribsChanged = true;
                }
            }
        }
    }

    void processBoundingLeafChanged(J3dMessage m) {
        Object[] users = (Object[])m.args[3];
        for (int i = 0; i < users.length; ++i) {
            LeafRetained leaf = (LeafRetained)users[i];
            if (leaf instanceof SoundRetained && this.universe.soundStructure.isSoundScopedToView(leaf, this.view)) {
                this.auralAttribsChanged = true;
                continue;
            }
            if (!(leaf instanceof SoundscapeRetained) || !this.universe.soundStructure.isSoundscapeScopedToView(leaf, this.view)) continue;
            this.auralAttribsChanged = true;
        }
    }

    @Override
    void cleanup() {
    }
}

