/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BoundingBox;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.Font3D;
import javax.media.j3d.Geometry;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponent;
import javax.media.j3d.Text3DRetained;
import javax.vecmath.Point3f;

public class Text3D
extends Geometry {
    public static final int ALLOW_FONT3D_READ = 0;
    public static final int ALLOW_FONT3D_WRITE = 1;
    public static final int ALLOW_STRING_READ = 2;
    public static final int ALLOW_STRING_WRITE = 3;
    public static final int ALLOW_POSITION_READ = 4;
    public static final int ALLOW_POSITION_WRITE = 5;
    public static final int ALLOW_ALIGNMENT_READ = 6;
    public static final int ALLOW_ALIGNMENT_WRITE = 7;
    public static final int ALLOW_PATH_READ = 8;
    public static final int ALLOW_PATH_WRITE = 9;
    public static final int ALLOW_CHARACTER_SPACING_READ = 10;
    public static final int ALLOW_CHARACTER_SPACING_WRITE = 11;
    public static final int ALLOW_BOUNDING_BOX_READ = 12;
    public static final int ALIGN_CENTER = 0;
    public static final int ALIGN_FIRST = 1;
    public static final int ALIGN_LAST = 2;
    public static final int PATH_LEFT = 0;
    public static final int PATH_RIGHT = 1;
    public static final int PATH_UP = 2;
    public static final int PATH_DOWN = 3;
    private static final int[] readCapabilities = new int[]{0, 2, 4, 6, 8, 10, 12};

    public Text3D() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public Text3D(Font3D font3D) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((Text3DRetained)this.retained).setFont3D(font3D);
    }

    public Text3D(Font3D font3D, String string) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((Text3DRetained)this.retained).setFont3D(font3D);
        ((Text3DRetained)this.retained).setString(string);
    }

    public Text3D(Font3D font3D, String string, Point3f position) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((Text3DRetained)this.retained).setFont3D(font3D);
        ((Text3DRetained)this.retained).setString(string);
        ((Text3DRetained)this.retained).setPosition(position);
    }

    public Text3D(Font3D font3D, String string, Point3f position, int alignment, int path) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((Text3DRetained)this.retained).setFont3D(font3D);
        ((Text3DRetained)this.retained).setString(string);
        ((Text3DRetained)this.retained).setPosition(position);
        ((Text3DRetained)this.retained).setAlignment(alignment);
        ((Text3DRetained)this.retained).setPath(path);
    }

    @Override
    void createRetained() {
        this.retained = new Text3DRetained();
        this.retained.setSource(this);
    }

    public Font3D getFont3D() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Text3D0"));
        }
        return ((Text3DRetained)this.retained).getFont3D();
    }

    public void setFont3D(Font3D font3d) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Text3D1"));
        }
        ((Text3DRetained)this.retained).setFont3D(font3d);
    }

    public String getString() {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Text3D2"));
        }
        return ((Text3DRetained)this.retained).getString();
    }

    public void setString(String string) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Text3D3"));
        }
        ((Text3DRetained)this.retained).setString(string);
    }

    public void getPosition(Point3f position) {
        if (this.isLiveOrCompiled() && !this.getCapability(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Text3D4"));
        }
        ((Text3DRetained)this.retained).getPosition(position);
    }

    public void setPosition(Point3f position) {
        if (this.isLiveOrCompiled() && !this.getCapability(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Text3D5"));
        }
        ((Text3DRetained)this.retained).setPosition(position);
    }

    public int getAlignment() {
        if (this.isLiveOrCompiled() && !this.getCapability(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Text3D6"));
        }
        return ((Text3DRetained)this.retained).getAlignment();
    }

    public void setAlignment(int alignment) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Text3D7"));
        }
        ((Text3DRetained)this.retained).setAlignment(alignment);
    }

    public int getPath() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Text3D8"));
        }
        return ((Text3DRetained)this.retained).getPath();
    }

    public void setPath(int path) {
        if (this.isLiveOrCompiled() && !this.getCapability(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Text3D9"));
        }
        ((Text3DRetained)this.retained).setPath(path);
    }

    public void getBoundingBox(BoundingBox bounds) {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Text3D10"));
        }
        ((Text3DRetained)this.retained).getBoundingBox(bounds);
    }

    public float getCharacterSpacing() {
        if (this.isLiveOrCompiled() && !this.getCapability(10)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Text3D11"));
        }
        return ((Text3DRetained)this.retained).getCharacterSpacing();
    }

    public void setCharacterSpacing(float characterSpacing) {
        if (this.isLiveOrCompiled() && !this.getCapability(11)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Text3D12"));
        }
        ((Text3DRetained)this.retained).setCharacterSpacing(characterSpacing);
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        Text3D t = new Text3D();
        t.duplicateNodeComponent(this);
        return t;
    }

    @Override
    void duplicateAttributes(NodeComponent originalNodeComponent, boolean forceDuplicate) {
        String s;
        super.duplicateAttributes(originalNodeComponent, forceDuplicate);
        Text3DRetained text = (Text3DRetained)originalNodeComponent.retained;
        Text3DRetained rt = (Text3DRetained)this.retained;
        Font3D font3D = text.getFont3D();
        if (font3D != null) {
            rt.setFont3D(font3D);
        }
        if ((s = text.getString()) != null) {
            rt.setString(s);
        }
        Point3f p = new Point3f();
        text.getPosition(p);
        rt.setPosition(p);
        rt.setAlignment(text.getAlignment());
        rt.setPath(text.getPath());
        rt.setCharacterSpacing(text.getCharacterSpacing());
    }
}

