/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;

class UnorderList
implements Cloneable,
Serializable {
    transient Object[] elementData;
    transient Object[] cloneData;
    transient int cloneSize;
    transient boolean isDirty = true;
    Class componentType;
    int size;

    UnorderList(int initialCapacity, Class componentType) {
        this.componentType = componentType;
        this.elementData = (Object[])Array.newInstance(componentType, initialCapacity);
    }

    UnorderList(Class componentType) {
        this(10, componentType);
    }

    UnorderList(int initialCapacity) {
        this(initialCapacity, Object.class);
    }

    UnorderList() {
        this(10, Object.class);
    }

    final int size() {
        return this.size;
    }

    final int arraySize() {
        return this.cloneSize;
    }

    final boolean isEmpty() {
        return this.size == 0;
    }

    final synchronized boolean contains(Object o) {
        if (o != null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!o.equals(this.elementData[i])) continue;
                return true;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.elementData[i] != null) continue;
                return true;
            }
        }
        return false;
    }

    final synchronized boolean addUnique(Object o) {
        if (!this.contains(o)) {
            this.add(o);
            return true;
        }
        return false;
    }

    final synchronized int indexOf(Object o) {
        if (o != null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!o.equals(this.elementData[i])) continue;
                return i;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        }
        return -1;
    }

    protected final synchronized Object clone() {
        try {
            UnorderList v = (UnorderList)super.clone();
            v.elementData = (Object[])Array.newInstance(this.componentType, this.size);
            System.arraycopy(this.elementData, 0, v.elementData, 0, this.size);
            this.isDirty = true;
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    final synchronized Object[] toArray(boolean copy) {
        if (copy) {
            if (this.isDirty) {
                if (this.cloneData == null || this.cloneData.length < this.size) {
                    this.cloneData = (Object[])Array.newInstance(this.componentType, this.size);
                }
                System.arraycopy(this.elementData, 0, this.cloneData, 0, this.size);
                this.cloneSize = this.size;
                this.isDirty = false;
            }
            return this.cloneData;
        }
        this.cloneSize = this.size;
        return this.elementData;
    }

    final synchronized Object[] toArray() {
        return this.toArray(true);
    }

    final synchronized Object[] toArray(Object startElement) {
        int idx = this.indexOf(startElement);
        if (idx < 0) {
            return (Object[])Array.newInstance(this.componentType, 0);
        }
        int s = this.size - idx;
        Object[] data = (Object[])Array.newInstance(this.componentType, s);
        System.arraycopy(this.elementData, idx, data, 0, s);
        return data;
    }

    final synchronized void toArrayAndClear(Object[] objs) {
        System.arraycopy(this.elementData, 0, objs, 0, this.size);
        Arrays.fill(this.elementData, 0, this.size, null);
        this.size = 0;
        this.isDirty = true;
    }

    final synchronized void trimToSize() {
        if (this.elementData.length > this.size) {
            Object[] oldData = this.elementData;
            this.elementData = (Object[])Array.newInstance(this.componentType, this.size);
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    final synchronized Object get(int index) {
        return this.elementData[index];
    }

    final synchronized void set(int index, Object element) {
        this.elementData[index] = element;
        this.isDirty = true;
    }

    final synchronized void add(Object o) {
        if (this.elementData.length == this.size) {
            Object[] oldData = this.elementData;
            this.elementData = (Object[])Array.newInstance(this.componentType, this.size << 1);
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
        this.elementData[this.size++] = o;
        this.isDirty = true;
    }

    final synchronized void remove(int index) {
        this.elementData[index] = this.elementData[--this.size];
        this.elementData[this.size] = null;
        this.isDirty = true;
    }

    final synchronized void removeOrdered(int index) {
        --this.size;
        if (index < this.size) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, this.size - index);
        }
        this.elementData[this.size] = null;
        this.isDirty = true;
    }

    final synchronized Object removeLastElement() {
        Object elm = this.elementData[--this.size];
        this.elementData[this.size] = null;
        this.isDirty = true;
        return elm;
    }

    final synchronized void shift(Object[] objs, int idx) {
        int oldsize = this.size;
        System.arraycopy(this.elementData, 0, objs, 0, idx);
        this.size -= idx;
        if (this.size > 0) {
            System.arraycopy(this.elementData, idx, this.elementData, 0, this.size);
        }
        Arrays.fill(this.elementData, this.size, oldsize, null);
    }

    final synchronized boolean remove(Object o) {
        --this.size;
        if (o != null) {
            for (int i = this.size; i >= 0; --i) {
                if (!o.equals(this.elementData[i])) continue;
                this.elementData[i] = this.elementData[this.size];
                this.elementData[this.size] = null;
                this.isDirty = true;
                return true;
            }
        } else {
            for (int i = this.size; i >= 0; --i) {
                if (this.elementData[i] != null) continue;
                this.elementData[i] = this.elementData[this.size];
                this.elementData[this.size] = null;
                this.isDirty = true;
                return true;
            }
        }
        ++this.size;
        return false;
    }

    final synchronized void clear() {
        if (this.size > 0) {
            Arrays.fill(this.elementData, 0, this.size, null);
            this.size = 0;
            this.isDirty = true;
        }
    }

    final synchronized void clearMirror() {
        if (this.cloneData != null) {
            Arrays.fill(this.cloneData, 0, this.cloneData.length, null);
        }
        this.cloneSize = 0;
        this.isDirty = true;
    }

    final Class getComponentType() {
        return this.componentType;
    }

    public synchronized String toString() {
        StringBuffer sb = new StringBuffer("Size = " + this.size + "\n[");
        int len = this.size - 1;
        for (int i = 0; i < this.size; ++i) {
            Object obj = this.elementData[i];
            if (obj != null) {
                sb.append(this.elementData[i].toString());
            } else {
                sb.append("NULL");
            }
            if (i == len) continue;
            sb.append(", ");
        }
        sb.append("]\n");
        return sb.toString();
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.elementData.length);
        for (int i = 0; i < this.size; ++i) {
            s.writeObject(this.elementData[i]);
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int arrayLength = s.readInt();
        this.elementData = (Object[])Array.newInstance(this.componentType, arrayLength);
        for (int i = 0; i < this.size; ++i) {
            this.elementData[i] = s.readObject();
        }
    }
}

