/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.AWTEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Vector;
import javax.media.j3d.BadTransformException;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.CanvasViewCache;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.J3dClock;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.MasterControl;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.RenderBin;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.Screen3D;
import javax.media.j3d.Sensor;
import javax.media.j3d.SoundScheduler;
import javax.media.j3d.Transform3D;
import javax.media.j3d.UnorderList;
import javax.media.j3d.ViewCache;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.ViewPlatformRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;

public class View {
    public static final int NOMINAL_HEAD = 0;
    public static final int NOMINAL_FEET = 1;
    public static final int NOMINAL_SCREEN = 2;
    public static final int SCALE_SCREEN_SIZE = 0;
    public static final int SCALE_EXPLICIT = 1;
    public static final int VIRTUAL_SCREEN = 0;
    public static final int PHYSICAL_SCREEN = 1;
    public static final int VIRTUAL_EYE = 2;
    public static final int PHYSICAL_EYE = 3;
    public static final int VIRTUAL_WORLD = 0;
    public static final int PHYSICAL_WORLD = 1;
    public static final int RELATIVE_TO_SCREEN = 0;
    public static final int RELATIVE_TO_WINDOW = 1;
    public static final int RELATIVE_TO_FIELD_OF_VIEW = 2;
    public static final int RELATIVE_TO_COEXISTENCE = 3;
    public static final int LEFT_EYE_VIEW = 0;
    public static final int RIGHT_EYE_VIEW = 1;
    public static final int CYCLOPEAN_EYE_VIEW = 2;
    public static final int SCREEN_VIEW = 0;
    public static final int HMD_VIEW = 1;
    public static final int PARALLEL_PROJECTION = 0;
    public static final int PERSPECTIVE_PROJECTION = 1;
    public static final int VISIBILITY_DRAW_VISIBLE = 0;
    public static final int VISIBILITY_DRAW_INVISIBLE = 1;
    public static final int VISIBILITY_DRAW_ALL = 2;
    public static final int TRANSPARENCY_SORT_NONE = 0;
    public static final int TRANSPARENCY_SORT_GEOMETRY = 1;
    private Vector<Canvas3D> canvases = new Vector(3);
    VirtualUniverse universe = null;
    RenderBin renderBin = null;
    SoundScheduler soundScheduler = null;
    static final int NUMBER_FRAME_START_TIMES = 10;
    long[] frameStartTimes = new long[10];
    long[] frameNumbers = new long[10];
    int currentFrameIndex = 0;
    long currentFrameStartTime = 0L;
    long currentFrameDuration = 0L;
    long currentFrameNumber = 0L;
    long frameNumber = 0L;
    long startTime = 0L;
    long stopTime = 0L;
    long minFrameCycleTime;
    boolean stopBehavior;
    ViewCache viewCache = null;
    static final int COMPATIBILITY_MODE_DIRTY = 1;
    static final int SCREEN_SCALE_POLICY_DIRTY = 2;
    static final int SCREEN_SCALE_DIRTY = 4;
    static final int WINDOW_RESIZE_POLICY_DIRTY = 8;
    static final int VIEW_POLICY_DIRTY = 16;
    static final int CLIP_DIRTY = 32;
    static final int PROJECTION_POLICY_DIRTY = 64;
    static final int WINDOW_MOVEMENT_POLICY_DIRTY = 128;
    static final int WINDOW_EYE_POINT_POLICY_DIRTY = 256;
    static final int MONOSCOPIC_VIEW_POLICY_DIRTY = 512;
    static final int FIELD_OF_VIEW_DIRTY = 1024;
    static final int TRACKING_ENABLE_DIRTY = 2048;
    static final int USER_HEAD_TO_VWORLD_ENABLE_DIRTY = 4096;
    static final int COEXISTENCE_CENTERING_ENABLE_DIRTY = 8192;
    static final int LEFT_MANUAL_EYE_IN_COEXISTENCE_DIRTY = 16384;
    static final int RIGHT_MANUAL_EYE_IN_COEXISTENCE_DIRTY = 32768;
    static final int VISIBILITY_POLICY_DIRTY = 65536;
    static final int VPR_VIEW_ATTACH_POLICY_DIRTY = 65536;
    static final int VPR_VIEWPLATFORM_DIRTY = 131072;
    static final int PE_COE_TO_TRACKER_BASE_DIRTY = 0x100000;
    static final int PE_TRACKING_AVAILABLE_DIRTY = 0x200000;
    static final int PE_COE_CENTER_IN_PWORLD_POLICY_DIRTY = 0x400000;
    static final int PB_EYE_POSITION_DIRTY = 0x1000000;
    static final int PB_EAR_POSITION_DIRTY = 0x2000000;
    static final int PB_NOMINAL_EYE_HEIGHT_FROM_GROUND_DIRTY = 0x4000000;
    static final int PB_NOMINAL_EYE_OFFSET_FROM_NOMINAL_SCREEN_DIRTY = 0x8000000;
    int vDirtyMask = 131071;
    PhysicalBody physicalBody;
    PhysicalEnvironment physicalEnvironment;
    boolean compatibilityModeEnable = false;
    boolean coexistenceCenteringEnable = true;
    Point3d leftManualEyeInCoexistence = new Point3d();
    Point3d rightManualEyeInCoexistence = new Point3d();
    int viewPolicy = 0;
    int projectionPolicy = 1;
    double fieldOfView = 0.7853981633974483;
    double frontClipDistance = 0.1;
    double backClipDistance = 10.0;
    int screenScalePolicy = 0;
    double screenScale = 1.0;
    int windowResizePolicy = 1;
    int windowMovementPolicy = 1;
    int windowEyepointPolicy = 2;
    int monoscopicViewPolicy = 2;
    int frontClipPolicy = 3;
    int backClipPolicy = 3;
    int visibilityPolicy = 0;
    int transparencySortingPolicy = 0;
    boolean trackingEnable = false;
    boolean userHeadToVworldEnable = false;
    private ViewPlatform viewPlatform = null;
    Transform3D compatVpcToEc = new Transform3D();
    Transform3D compatLeftProjection = new Transform3D();
    Transform3D compatRightProjection = new Transform3D();
    Integer viewId = null;
    int viewIndex = -1;
    boolean primaryView = false;
    boolean active = false;
    boolean activeStatus = false;
    volatile boolean isRunning = true;
    boolean inCanvasCallback = false;
    boolean depthBufferFreezeTransparent = true;
    boolean sceneAntialiasingEnable = false;
    boolean localEyeLightingEnable = false;
    private ArrayList<Screen3D> screenList = new ArrayList();
    private ArrayList<ArrayList<Canvas3D>> canvasList = new ArrayList();
    private Canvas3D[][] cachedCanvasList;
    private Canvas3D[] cachedCanvases;
    private Screen3D[] cachedScreens;
    private int longestScreenList = 0;
    private boolean canvasesDirty = true;
    volatile boolean renderOnceFinish = true;
    private Object startStopViewLock = new Object();
    private Object evaluateLock = new Object();
    int stopViewCount = -1;
    boolean isMinCycleTimeAchieve = true;
    long sleepTime = 0L;
    volatile boolean inRenderThreadData = false;
    boolean renderBinReady = false;
    long universeCount = 0L;
    long resetUnivCount = 0L;
    volatile boolean doneUnregister = false;
    static final int TRANSP_SORT_POLICY_CHANGED = 1;
    static final int OTHER_ATTRS_CHANGED = 2;

    public View() {
        this.viewCache = new ViewCache(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setViewPolicy(int policy) {
        Object object;
        if (policy != 1 && policy != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("View0"));
        }
        if (policy == 1) {
            object = this.canvasList;
            synchronized (object) {
                for (int i = this.canvases.size() - 1; i >= 0; --i) {
                    Canvas3D c3d = this.canvases.elementAt(i);
                    if (c3d.monoscopicViewPolicy != 2 || c3d.useStereo) continue;
                    throw new IllegalStateException(J3dI18N.getString("View31"));
                }
            }
        }
        object = this;
        synchronized (object) {
            this.viewPolicy = policy;
            this.vDirtyMask |= 0x10;
        }
        this.repaint();
    }

    public int getViewPolicy() {
        return this.viewPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProjectionPolicy(int policy) {
        if (policy != 1 && policy != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("View1"));
        }
        View view = this;
        synchronized (view) {
            this.projectionPolicy = policy;
            this.vDirtyMask |= 0x40;
        }
        this.repaint();
    }

    public int getProjectionPolicy() {
        return this.projectionPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScreenScalePolicy(int policy) {
        View view = this;
        synchronized (view) {
            this.screenScalePolicy = policy;
            this.vDirtyMask |= 2;
        }
        this.repaint();
    }

    public int getScreenScalePolicy() {
        return this.screenScalePolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWindowResizePolicy(int policy) {
        View view = this;
        synchronized (view) {
            this.windowResizePolicy = policy;
            this.vDirtyMask |= 8;
        }
        this.repaint();
    }

    public int getWindowResizePolicy() {
        return this.windowResizePolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWindowMovementPolicy(int policy) {
        View view = this;
        synchronized (view) {
            this.windowMovementPolicy = policy;
            this.vDirtyMask |= 0x80;
        }
        this.repaint();
    }

    public int getWindowMovementPolicy() {
        return this.windowMovementPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWindowEyepointPolicy(int policy) {
        View view = this;
        synchronized (view) {
            this.windowEyepointPolicy = policy;
            this.vDirtyMask |= 0x100;
        }
        this.repaint();
    }

    public int getWindowEyepointPolicy() {
        return this.windowEyepointPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMonoscopicViewPolicy(int policy) {
        View view = this;
        synchronized (view) {
            this.monoscopicViewPolicy = policy;
            this.vDirtyMask |= 0x200;
        }
        this.repaint();
    }

    public int getMonoscopicViewPolicy() {
        return this.monoscopicViewPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCoexistenceCenteringEnable(boolean flag) {
        View view = this;
        synchronized (view) {
            this.coexistenceCenteringEnable = flag;
            this.vDirtyMask |= 0x2000;
        }
        this.repaint();
    }

    public boolean getCoexistenceCenteringEnable() {
        return this.coexistenceCenteringEnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCompatibilityModeEnable(boolean flag) {
        View view = this;
        synchronized (view) {
            this.compatibilityModeEnable = flag;
            this.vDirtyMask |= 1;
        }
        this.repaint();
    }

    public boolean getCompatibilityModeEnable() {
        return this.compatibilityModeEnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLeftProjection(Transform3D projection) {
        if (!this.compatibilityModeEnable) {
            throw new RestrictedAccessException(J3dI18N.getString("View2"));
        }
        View view = this;
        synchronized (view) {
            this.compatLeftProjection.setWithLock(projection);
            this.vDirtyMask |= 1;
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRightProjection(Transform3D projection) {
        if (!this.compatibilityModeEnable) {
            throw new RestrictedAccessException(J3dI18N.getString("View2"));
        }
        View view = this;
        synchronized (view) {
            this.compatRightProjection.setWithLock(projection);
            this.vDirtyMask |= 1;
        }
        this.repaint();
    }

    public void getLeftProjection(Transform3D projection) {
        if (!this.compatibilityModeEnable) {
            throw new RestrictedAccessException(J3dI18N.getString("View4"));
        }
        projection.set(this.compatLeftProjection);
    }

    public void getRightProjection(Transform3D projection) {
        if (!this.compatibilityModeEnable) {
            throw new RestrictedAccessException(J3dI18N.getString("View4"));
        }
        projection.set(this.compatRightProjection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVpcToEc(Transform3D vpcToEc) {
        if (!this.compatibilityModeEnable) {
            throw new RestrictedAccessException(J3dI18N.getString("View6"));
        }
        if (!vpcToEc.isAffine()) {
            throw new BadTransformException(J3dI18N.getString("View7"));
        }
        View view = this;
        synchronized (view) {
            this.compatVpcToEc.setWithLock(vpcToEc);
            this.vDirtyMask |= 1;
        }
        this.repaint();
    }

    public void getVpcToEc(Transform3D vpcToEc) {
        if (!this.compatibilityModeEnable) {
            throw new RestrictedAccessException(J3dI18N.getString("View8"));
        }
        vpcToEc.set(this.compatVpcToEc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPhysicalBody(PhysicalBody physicalBody) {
        ArrayList<ArrayList<Canvas3D>> arrayList = this.canvasList;
        synchronized (arrayList) {
            if (this.activeStatus) {
                if (this.physicalBody != null) {
                    this.physicalBody.removeUser(this);
                }
                physicalBody.addUser(this);
            }
        }
        this.physicalBody = physicalBody;
        this.repaint();
    }

    public PhysicalBody getPhysicalBody() {
        return this.physicalBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPhysicalEnvironment(PhysicalEnvironment physicalEnvironment) {
        ArrayList<ArrayList<Canvas3D>> arrayList = this.canvasList;
        synchronized (arrayList) {
            if (this.activeStatus) {
                if (this.physicalEnvironment != null) {
                    this.physicalEnvironment.removeUser(this);
                }
                physicalEnvironment.addUser(this);
            }
        }
        this.physicalEnvironment = physicalEnvironment;
        if (this.viewPlatform != null && this.viewPlatform.isLive()) {
            VirtualUniverse.mc.postRequest(MasterControl.PHYSICAL_ENV_CHANGE, this);
        }
        this.repaint();
    }

    public PhysicalEnvironment getPhysicalEnvironment() {
        return this.physicalEnvironment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScreenScale(double scale) {
        View view = this;
        synchronized (view) {
            this.screenScale = scale;
            this.vDirtyMask |= 4;
        }
        this.repaint();
    }

    public double getScreenScale() {
        return this.screenScale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFieldOfView(double fieldOfView) {
        View view = this;
        synchronized (view) {
            this.fieldOfView = fieldOfView;
            this.vDirtyMask |= 0x400;
        }
        this.repaint();
    }

    public double getFieldOfView() {
        return this.fieldOfView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLeftManualEyeInCoexistence(Point3d position) {
        View view = this;
        synchronized (view) {
            this.leftManualEyeInCoexistence.set((Tuple3d)position);
            this.vDirtyMask |= 0x4000;
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRightManualEyeInCoexistence(Point3d position) {
        View view = this;
        synchronized (view) {
            this.rightManualEyeInCoexistence.set((Tuple3d)position);
            this.vDirtyMask |= 0x8000;
        }
        this.repaint();
    }

    public void getLeftManualEyeInCoexistence(Point3d position) {
        position.set((Tuple3d)this.leftManualEyeInCoexistence);
    }

    public void getRightManualEyeInCoexistence(Point3d position) {
        position.set((Tuple3d)this.rightManualEyeInCoexistence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFrontClipDistance(double distance) {
        View view = this;
        synchronized (view) {
            this.frontClipDistance = distance;
            this.vDirtyMask |= 0x20;
        }
        this.repaint();
    }

    public double getFrontClipDistance() {
        return this.frontClipDistance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackClipDistance(double distance) {
        View view = this;
        synchronized (view) {
            this.backClipDistance = distance;
            this.vDirtyMask |= 0x20;
        }
        this.repaint();
    }

    public double getBackClipDistance() {
        return this.backClipDistance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getUserHeadToVworld(Transform3D t) {
        if (this.userHeadToVworldEnable) {
            Canvas3D canvas = this.canvases.firstElement();
            CanvasViewCache canvasViewCache = canvas.canvasViewCache;
            synchronized (canvasViewCache) {
                t.set(canvas.canvasViewCache.getHeadToVworld());
            }
        } else {
            throw new RestrictedAccessException(J3dI18N.getString("View9"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFrontClipPolicy(int policy) {
        View view = this;
        synchronized (view) {
            this.frontClipPolicy = policy;
            this.vDirtyMask |= 0x20;
        }
        this.repaint();
    }

    public int getFrontClipPolicy() {
        return this.frontClipPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackClipPolicy(int policy) {
        View view = this;
        synchronized (view) {
            this.backClipPolicy = policy;
            this.vDirtyMask |= 0x20;
        }
        this.repaint();
    }

    public int getBackClipPolicy() {
        return this.backClipPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisibilityPolicy(int policy) {
        View view = this;
        synchronized (view) {
            this.visibilityPolicy = policy;
            this.vDirtyMask |= 0x10000;
        }
        if (this.activeStatus && this.isRunning) {
            J3dMessage vpMessage = new J3dMessage();
            vpMessage.universe = this.universe;
            vpMessage.view = this;
            vpMessage.type = 4;
            vpMessage.threads = 128;
            vpMessage.args[0] = this;
            BoundingSphere boundingSphere = ((ViewPlatformRetained)this.viewPlatform.retained).sphere;
            synchronized (boundingSphere) {
                vpMessage.args[1] = new Float(((ViewPlatformRetained)this.viewPlatform.retained).sphere.radius);
            }
            vpMessage.args[2] = new Integer(2);
            vpMessage.args[3] = new Integer(this.transparencySortingPolicy);
            VirtualUniverse.mc.processMessage(vpMessage);
        }
    }

    public int getVisibilityPolicy() {
        return this.visibilityPolicy;
    }

    public void setTransparencySortingPolicy(int policy) {
        if (policy == this.transparencySortingPolicy) {
            return;
        }
        this.transparencySortingPolicy = policy;
        if (this.activeStatus && this.isRunning) {
            J3dMessage vpMessage = new J3dMessage();
            vpMessage.universe = this.universe;
            vpMessage.view = this;
            vpMessage.type = 4;
            vpMessage.threads = 128;
            vpMessage.args[0] = this;
            vpMessage.args[1] = null;
            vpMessage.args[2] = new Integer(1);
            vpMessage.args[3] = new Integer(policy);
            VirtualUniverse.mc.processMessage(vpMessage);
        }
    }

    public int getTransparencySortingPolicy() {
        return this.transparencySortingPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTrackingEnable(boolean flag) {
        View view = this;
        synchronized (view) {
            this.trackingEnable = flag;
            this.vDirtyMask |= 0x800;
        }
        this.repaint();
    }

    public boolean getTrackingEnable() {
        return this.trackingEnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserHeadToVworldEnable(boolean flag) {
        View view = this;
        synchronized (view) {
            this.userHeadToVworldEnable = flag;
            this.vDirtyMask |= 0x1000;
        }
        this.repaint();
    }

    public boolean getUserHeadToVworldEnable() {
        return this.userHeadToVworldEnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSensorToVworld(Sensor sensor, Transform3D t) {
        Canvas3D canvas = this.canvases.firstElement();
        Transform3D localTrans = new Transform3D();
        CanvasViewCache canvasViewCache = canvas.canvasViewCache;
        synchronized (canvasViewCache) {
            t.set(canvas.canvasViewCache.getVworldToTrackerBase());
        }
        t.invert();
        sensor.getRead(localTrans);
        t.mul(localTrans);
    }

    public void getSensorHotspotInVworld(Sensor sensor, Point3f position) {
        Transform3D sensorToVworld = new Transform3D();
        Point3d hotspot3d = new Point3d();
        this.getSensorToVworld(sensor, sensorToVworld);
        sensor.getHotspot(hotspot3d);
        position.set((Tuple3d)hotspot3d);
        sensorToVworld.transform(position);
    }

    public void getSensorHotspotInVworld(Sensor sensor, Point3d position) {
        Transform3D sensorToVworld = new Transform3D();
        this.getSensorToVworld(sensor, sensorToVworld);
        sensor.getHotspot(position);
        sensorToVworld.transform(position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCanvas3D(Canvas3D canvas3D, int index) {
        Canvas3D cv;
        if (this.viewPolicy == 1 && canvas3D.monoscopicViewPolicy == 2 && !canvas3D.useStereo) {
            throw new IllegalStateException(J3dI18N.getString("View31"));
        }
        ArrayList<ArrayList<Canvas3D>> arrayList = this.canvasList;
        synchronized (arrayList) {
            if (canvas3D.getView() != null) {
                throw new IllegalSharingException(J3dI18N.getString("View10"));
            }
            cv = this.canvases.elementAt(index);
            this.canvases.setElementAt(canvas3D, index);
            this.removeFromCanvasList(cv);
            this.addToCanvasList(canvas3D);
            this.canvasesDirty = true;
        }
        canvas3D.setView(this);
        cv.setView(null);
        if (canvas3D.added) {
            this.evaluateActive();
        }
        if (cv.added) {
            this.evaluateActive();
        }
    }

    public Canvas3D getCanvas3D(int index) {
        return this.canvases.elementAt(index);
    }

    public Enumeration<Canvas3D> getAllCanvas3Ds() {
        return this.canvases.elements();
    }

    public int numCanvas3Ds() {
        return this.canvases.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCanvas3D(Canvas3D canvas3D) {
        if (this.viewPolicy == 1 && canvas3D.monoscopicViewPolicy == 2 && !canvas3D.useStereo) {
            throw new IllegalStateException(J3dI18N.getString("View31"));
        }
        ArrayList<ArrayList<Canvas3D>> arrayList = this.canvasList;
        synchronized (arrayList) {
            if (canvas3D.getView() != null) {
                throw new IllegalSharingException(J3dI18N.getString("View10"));
            }
            this.canvases.addElement(canvas3D);
            this.addToCanvasList(canvas3D);
            this.canvasesDirty = true;
        }
        canvas3D.setView(this);
        if (canvas3D.added) {
            if ((canvas3D.visible || canvas3D.offScreen) && canvas3D.firstPaintCalled) {
                canvas3D.active = true;
            }
            this.evaluateActive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertCanvas3D(Canvas3D canvas3D, int index) {
        if (this.viewPolicy == 1 && canvas3D.monoscopicViewPolicy == 2 && !canvas3D.useStereo) {
            throw new IllegalStateException(J3dI18N.getString("View31"));
        }
        ArrayList<ArrayList<Canvas3D>> arrayList = this.canvasList;
        synchronized (arrayList) {
            if (canvas3D.getView() != null) {
                throw new IllegalSharingException(J3dI18N.getString("View10"));
            }
            this.canvases.insertElementAt(canvas3D, index);
            this.addToCanvasList(canvas3D);
            this.canvasesDirty = true;
        }
        canvas3D.setView(this);
        if (canvas3D.added) {
            if ((canvas3D.visible || canvas3D.offScreen) && canvas3D.firstPaintCalled) {
                canvas3D.active = true;
            }
            this.evaluateActive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCanvas3D(int index) {
        Canvas3D cv;
        if (index == -1) {
            return;
        }
        ArrayList<ArrayList<Canvas3D>> arrayList = this.canvasList;
        synchronized (arrayList) {
            cv = this.canvases.elementAt(index);
            this.canvases.removeElementAt(index);
            this.removeFromCanvasList(cv);
            this.canvasesDirty = true;
        }
        VirtualUniverse.mc.postRequest(MasterControl.RESET_CANVAS, cv);
        cv.pendingView = null;
        this.computeCanvasesCached();
        if (cv.added) {
            cv.active = false;
            this.evaluateActive();
        }
        if (this.universe != null) {
            this.universe.waitForMC();
        }
    }

    public int indexOfCanvas3D(Canvas3D canvas3D) {
        return this.canvases.indexOf(canvas3D);
    }

    public void removeCanvas3D(Canvas3D canvas3D) {
        this.removeCanvas3D(this.canvases.indexOf(canvas3D));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllCanvas3Ds() {
        LinkedList<Canvas3D> tmpCanvases = new LinkedList<Canvas3D>();
        ArrayList<ArrayList<Canvas3D>> arrayList = this.canvasList;
        synchronized (arrayList) {
            int numCanvases = this.canvases.size();
            for (int index = numCanvases - 1; index >= 0; --index) {
                Canvas3D cv = this.canvases.elementAt(index);
                tmpCanvases.add(cv);
                this.canvases.removeElementAt(index);
                this.removeFromCanvasList(cv);
                this.canvasesDirty = true;
            }
        }
        for (Canvas3D cv : tmpCanvases) {
            VirtualUniverse.mc.postRequest(MasterControl.RESET_CANVAS, cv);
            cv.pendingView = null;
            if (!cv.added) continue;
            cv.active = false;
        }
        this.computeCanvasesCached();
        this.evaluateActive();
        if (this.universe != null) {
            this.universe.waitForMC();
        }
    }

    private void addToCanvasList(Canvas3D c) {
        for (int i = this.screenList.size() - 1; i >= 0; --i) {
            if (this.screenList.get(i) != c.screen) continue;
            this.canvasList.get(i).add(c);
            this.canvasesDirty = true;
            return;
        }
        this.screenList.add(c.screen);
        ArrayList<Canvas3D> clist = new ArrayList<Canvas3D>();
        this.canvasList.add(clist);
        clist.add(c);
        this.canvasesDirty = true;
    }

    private void removeFromCanvasList(Canvas3D c) {
        for (int i = this.screenList.size() - 1; i >= 0; --i) {
            if (this.screenList.get(i) != c.screen) continue;
            ArrayList<Canvas3D> clist = this.canvasList.get(i);
            clist.remove(clist.indexOf(c));
            if (clist.size() == 0) {
                this.canvasList.remove(i);
                this.screenList.remove(i);
                this.canvasesDirty = true;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeCanvasesCached() {
        ArrayList<ArrayList<Canvas3D>> arrayList = this.canvasList;
        synchronized (arrayList) {
            int i;
            int len = this.canvases.size();
            Canvas3D[] newCachedCanvases = new Canvas3D[len];
            for (i = 0; i < len; ++i) {
                newCachedCanvases[i] = this.canvases.get(i);
            }
            this.cachedCanvases = newCachedCanvases;
            len = 0;
            this.longestScreenList = 0;
            this.cachedCanvasList = new Canvas3D[this.canvasList.size()][0];
            for (i = 0; i < this.cachedCanvasList.length; ++i) {
                ArrayList<Canvas3D> cv = this.canvasList.get(i);
                len = cv.size();
                this.cachedCanvasList[i] = new Canvas3D[len];
                for (int j = 0; j < len; ++j) {
                    this.cachedCanvasList[i][j] = cv.get(j);
                }
                if (len <= this.longestScreenList) continue;
                this.longestScreenList = len;
            }
            len = this.screenList.size();
            Screen3D[] newCachedScreens = new Screen3D[len];
            for (int i2 = 0; i2 < len; ++i2) {
                newCachedScreens[i2] = this.screenList.get(i2);
            }
            this.cachedScreens = newCachedScreens;
            this.canvasesDirty = false;
        }
    }

    Canvas3D[][] getCanvasList(boolean canCompute) {
        if (this.canvasesDirty && canCompute) {
            this.computeCanvasesCached();
        }
        return this.cachedCanvasList;
    }

    int getLongestScreenList() {
        return this.longestScreenList;
    }

    Canvas3D[] getCanvases() {
        return this.cachedCanvases;
    }

    Screen3D[] getScreens() {
        return this.cachedScreens;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Canvas3D getFirstCanvas() {
        ArrayList<ArrayList<Canvas3D>> arrayList = this.canvasList;
        synchronized (arrayList) {
            if (this.canvases.size() > 0) {
                return this.canvases.elementAt(0);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCurrentFrameStartTime() {
        long[] lArray = this.frameStartTimes;
        synchronized (this.frameStartTimes) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.currentFrameStartTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastFrameDuration() {
        long[] lArray = this.frameStartTimes;
        synchronized (this.frameStartTimes) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.currentFrameDuration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFrameNumber() {
        long[] lArray = this.frameStartTimes;
        synchronized (this.frameStartTimes) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.currentFrameNumber;
        }
    }

    public static int getMaxFrameStartTimes() {
        return 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFrameStartTimes(long[] times) {
        long[] lArray = this.frameStartTimes;
        synchronized (this.frameStartTimes) {
            int i;
            int index = this.currentFrameIndex - 1;
            if (index < 0) {
                index = 9;
            }
            long lastFrameNumber = this.frameNumbers[index];
            int loopCount = times.length <= 10 ? times.length : 10;
            for (i = 0; i < loopCount; ++i) {
                times[i] = this.frameStartTimes[index];
                if (--index >= 0) continue;
                index = 9;
            }
            if (times.length > 10) {
                while (i < times.length) {
                    times[i] = 0L;
                    ++i;
                }
            }
            // ** MonitorExit[var7_2] (shouldn't be in output)
            return lastFrameNumber;
        }
    }

    public void setMinimumFrameCycleTime(long minimumTime) {
        if (minimumTime < 0L) {
            throw new IllegalArgumentException(J3dI18N.getString("View27"));
        }
        this.minFrameCycleTime = minimumTime;
        VirtualUniverse.mc.setWork();
    }

    public long getMinimumFrameCycleTime() {
        return this.minFrameCycleTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFrameTimingValues() {
        long[] lArray = this.frameStartTimes;
        synchronized (this.frameStartTimes) {
            if (this.currentFrameIndex == 10) {
                this.currentFrameIndex = 0;
            }
            this.frameNumbers[this.currentFrameIndex] = this.frameNumber;
            this.frameStartTimes[this.currentFrameIndex++] = this.startTime;
            this.currentFrameStartTime = this.startTime;
            this.currentFrameDuration = this.stopTime - this.startTime;
            this.currentFrameNumber = this.frameNumber;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void computeCycleTime() {
        if (this.minFrameCycleTime == 0L) {
            this.isMinCycleTimeAchieve = true;
            this.sleepTime = 0L;
        } else {
            this.sleepTime = this.minFrameCycleTime - (J3dClock.currentTimeMillis() - this.startTime);
            this.isMinCycleTimeAchieve = this.sleepTime <= 0L;
        }
    }

    public void setDepthBufferFreezeTransparent(boolean flag) {
        this.depthBufferFreezeTransparent = flag;
        this.repaint();
    }

    public boolean getDepthBufferFreezeTransparent() {
        return this.depthBufferFreezeTransparent;
    }

    public void setSceneAntialiasingEnable(boolean flag) {
        this.sceneAntialiasingEnable = flag;
        this.repaint();
    }

    public boolean getSceneAntialiasingEnable() {
        return this.sceneAntialiasingEnable;
    }

    public void setLocalEyeLightingEnable(boolean flag) {
        this.localEyeLightingEnable = flag;
        this.repaint();
    }

    public boolean getLocalEyeLightingEnable() {
        return this.localEyeLightingEnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachViewPlatform(ViewPlatform vp) {
        if (vp != null && vp == this.viewPlatform) {
            return;
        }
        if (this.viewPlatform != null) {
            ((ViewPlatformRetained)this.viewPlatform.retained).removeView(this);
            if (this.viewPlatform.isLive()) {
                Object object = this.evaluateLock;
                synchronized (object) {
                    this.viewPlatform = null;
                    this.evaluateActive();
                    this.viewPlatform = vp;
                }
                if (this.universe != null) {
                    this.universe.waitForMC();
                }
            } else {
                this.viewPlatform = vp;
            }
        } else {
            this.viewPlatform = vp;
        }
        if (vp != null) {
            if (vp.isLive()) {
                this.checkView();
                this.setUniverse(((ViewPlatformRetained)vp.retained).universe);
            }
            ((ViewPlatformRetained)vp.retained).setView(this);
        }
        this.evaluateActive();
        if (vp == null && this.universe != null) {
            this.universe.waitForMC();
        }
    }

    public ViewPlatform getViewPlatform() {
        return this.viewPlatform;
    }

    void checkView() {
        if (this.physicalBody == null) {
            throw new IllegalStateException(J3dI18N.getString("View13"));
        }
        if (this.physicalEnvironment == null) {
            throw new IllegalStateException(J3dI18N.getString("View14"));
        }
    }

    public final long[] stopBehaviorScheduler() {
        long[] intervalTime = new long[2];
        if (this.checkBehaviorSchedulerState("View15", "View16")) {
            if (this.activeStatus && this.isRunning && this.universe.behaviorScheduler != null) {
                this.universe.behaviorScheduler.stopBehaviorScheduler(intervalTime);
            } else if (this.universe != null && this.universe.behaviorScheduler != null) {
                this.universe.behaviorScheduler.userStop = true;
            }
        }
        this.stopBehavior = true;
        return intervalTime;
    }

    public final void startBehaviorScheduler() {
        if (this.checkBehaviorSchedulerState("View17", "View18")) {
            if (this.activeStatus && this.isRunning && this.universe.behaviorScheduler != null) {
                this.universe.behaviorScheduler.startBehaviorScheduler();
            } else if (this.universe != null && this.universe.behaviorScheduler != null) {
                this.universe.behaviorScheduler.userStop = false;
            }
        }
        this.stopBehavior = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkBehaviorSchedulerState(String s1, String s2) {
        Thread me = Thread.currentThread();
        if (this.inCanvasCallback) {
            ArrayList<ArrayList<Canvas3D>> arrayList = this.canvasList;
            synchronized (arrayList) {
                for (int i = this.canvases.size() - 1; i >= 0; --i) {
                    if (this.canvases.elementAt((int)i).screen.renderer != me) continue;
                    throw new IllegalStateException(J3dI18N.getString(s1));
                }
            }
        }
        if (this.viewPlatform != null && this.viewPlatform.isLive()) {
            if (this.universe.inBehavior && this.universe.behaviorScheduler == me) {
                throw new IllegalStateException(J3dI18N.getString(s2));
            }
            return true;
        }
        return false;
    }

    public final boolean isBehaviorSchedulerRunning() {
        return this.universe != null && !this.stopBehavior && this.universe.behaviorScheduler != null ? !this.universe.behaviorScheduler.userStop : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopView() {
        this.checkViewState("View19", "View20");
        Object object = this.startStopViewLock;
        synchronized (object) {
            if (this.activeStatus && this.isRunning) {
                VirtualUniverse.mc.postRequest(MasterControl.STOP_VIEW, this);
                while (this.isRunning) {
                    MasterControl.threadYield();
                }
            } else {
                this.isRunning = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startView() {
        this.checkViewState("View21", "View22");
        Object object = this.startStopViewLock;
        synchronized (object) {
            if (this.activeStatus && !this.isRunning) {
                VirtualUniverse.mc.postRequest(MasterControl.START_VIEW, this);
                while (!this.isRunning) {
                    MasterControl.threadYield();
                }
                VirtualUniverse.mc.sendRunMessage(this, 16);
            } else {
                this.isRunning = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkViewState(String s1, String s2) throws IllegalStateException {
        if (this.inCanvasCallback) {
            Thread me = Thread.currentThread();
            ArrayList<ArrayList<Canvas3D>> arrayList = this.canvasList;
            synchronized (arrayList) {
                for (int i = this.canvases.size() - 1; i >= 0; --i) {
                    Canvas3D cv = this.canvases.elementAt(i);
                    if (cv.screen.renderer != me) continue;
                    throw new IllegalStateException(J3dI18N.getString(s1));
                }
            }
        }
        if (this.viewPlatform != null && this.viewPlatform.isLive() && this.universe.inBehavior && Thread.currentThread() == this.universe.behaviorScheduler) {
            throw new IllegalStateException(J3dI18N.getString(s2));
        }
    }

    public final boolean isViewRunning() {
        return this.isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderOnce() {
        this.checkViewState("View28", "View29");
        Object object = this.startStopViewLock;
        synchronized (object) {
            if (this.isRunning) {
                throw new IllegalStateException(J3dI18N.getString("View30"));
            }
            this.renderOnceFinish = false;
            VirtualUniverse.mc.postRequest(MasterControl.RENDER_ONCE, this);
            while (!this.renderOnceFinish) {
                MasterControl.threadYield();
            }
            this.renderOnceFinish = true;
        }
    }

    public void repaint() {
        if (this.activeStatus && this.isRunning) {
            VirtualUniverse.mc.sendRunMessage(this, 16);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void updateViewCache() {
        Object object = this;
        synchronized (object) {
            this.viewCache.snapshot();
            this.viewCache.computeDerivedData();
        }
        object = this.canvasList;
        synchronized (object) {
            int i = this.canvases.size() - 1;
            while (i >= 0) {
                Screen3D scr;
                if ((scr = this.canvases.elementAt(i--).getScreen3D()) == null) continue;
                scr.updateViewCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void evaluateActive() {
        Object object = this.evaluateLock;
        synchronized (object) {
            if (this.universe == null) {
                return;
            }
            if (this.viewPlatform == null || !this.viewPlatform.isLive() || !((ViewPlatformRetained)this.viewPlatform.retained).switchState.currentSwitchOn) {
                if (this.activeStatus) {
                    this.deactivate();
                    this.activeStatus = false;
                }
                if (VirtualUniverse.mc.isRegistered(this) && (this.universe.isEmpty() || this.canvases.isEmpty() && (this.viewPlatform == null || !this.viewPlatform.isLive()))) {
                    this.universe.unRegViewWaiting = this;
                    this.resetUnivCount = this.universeCount;
                    VirtualUniverse.mc.postRequest(MasterControl.UNREGISTER_VIEW, this);
                }
            } else {
                int i;
                VirtualUniverse u = null;
                ArrayList<ArrayList<Canvas3D>> arrayList = this.canvasList;
                synchronized (arrayList) {
                    for (i = this.canvases.size() - 1; i >= 0; --i) {
                        Canvas3D cv = this.canvases.elementAt(i);
                        if (!cv.active) continue;
                        if (this.activeStatus || this.universeCount <= this.resetUnivCount) break;
                        u = this.universe;
                        break;
                    }
                }
                if (u != null) {
                    this.activate(u);
                    this.activeStatus = true;
                    return;
                }
                if (i < 0 && this.activeStatus) {
                    this.deactivate();
                    this.activeStatus = false;
                    return;
                }
                if (VirtualUniverse.mc.isRegistered(this)) {
                    VirtualUniverse.mc.postRequest(MasterControl.REEVALUATE_CANVAS, this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setUniverse(VirtualUniverse universe) {
        UnorderList unorderList = VirtualUniverse.mc.requestObjList;
        synchronized (unorderList) {
            if (this.renderBin == null || this.renderBin.universe != universe) {
                if (this.renderBin != null) {
                    this.renderBin.cleanup();
                }
                this.renderBin = new RenderBin(universe, this);
                this.renderBin.universe = universe;
            }
            if (this.soundScheduler == null || this.soundScheduler.universe != universe) {
                if (this.soundScheduler != null) {
                    this.soundScheduler.cleanup();
                }
                this.soundScheduler = new SoundScheduler(universe, this);
            }
            ++this.universeCount;
            this.universe = universe;
        }
        this.evaluateActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void activate(VirtualUniverse universe) {
        universe.checkForEnableEvents();
        if (this.physicalBody != null) {
            this.physicalBody.addUser(this);
        }
        if (!VirtualUniverse.mc.isRegistered(this)) {
            universe.regViewWaiting = this;
        }
        VirtualUniverse.mc.postRequest(MasterControl.ACTIVATE_VIEW, this);
        if (!universe.isSceneGraphLock) {
            universe.waitForMC();
        }
        if (this.soundScheduler != null) {
            this.soundScheduler.reset();
        }
        J3dMessage vpMessage = new J3dMessage();
        vpMessage.universe = universe;
        vpMessage.view = this;
        vpMessage.type = 4;
        vpMessage.threads = 386;
        vpMessage.args[0] = this;
        BoundingSphere boundingSphere = ((ViewPlatformRetained)this.viewPlatform.retained).sphere;
        synchronized (boundingSphere) {
            vpMessage.args[1] = new Float(((ViewPlatformRetained)this.viewPlatform.retained).sphere.radius);
        }
        vpMessage.args[2] = new Integer(2);
        vpMessage.args[3] = new Integer(this.transparencySortingPolicy);
        VirtualUniverse.mc.processMessage(vpMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deactivate() {
        VirtualUniverse.mc.postRequest(MasterControl.DEACTIVATE_VIEW, this);
        if (this.physicalBody != null) {
            this.physicalBody.removeUser(this);
        }
        if (VirtualUniverse.mc.forceReleaseView) {
            this.universe.addViewIdToFreeList(this.viewId);
        }
        J3dMessage vpMessage = new J3dMessage();
        vpMessage.universe = this.universe;
        vpMessage.view = this;
        vpMessage.type = 4;
        vpMessage.threads = 386;
        vpMessage.args[0] = this;
        if (this.viewPlatform != null) {
            BoundingSphere boundingSphere = ((ViewPlatformRetained)this.viewPlatform.retained).sphere;
            synchronized (boundingSphere) {
                vpMessage.args[1] = new Float(((ViewPlatformRetained)this.viewPlatform.retained).sphere.radius);
            }
        } else {
            vpMessage.args[1] = new Float(0.0f);
        }
        vpMessage.args[2] = new Integer(2);
        vpMessage.args[3] = new Integer(this.transparencySortingPolicy);
        VirtualUniverse.mc.processMessage(vpMessage);
    }

    void cleanupViewId() {
        this.universe.addViewIdToFreeList(this.viewId);
        this.viewId = null;
    }

    void assignViewId() {
        if (this.viewId == null) {
            this.viewId = this.universe.getViewId();
            this.viewIndex = this.viewId;
        }
    }

    void sendEventToSoundScheduler(AWTEvent evt) {
        if (this.soundScheduler != null) {
            this.soundScheduler.receiveAWTEvent(evt);
        }
    }

    void reset() {
        for (int i = 0; i < this.canvases.size(); ++i) {
            this.canvases.get(i).reset();
        }
        this.renderBinReady = false;
        this.soundScheduler.cleanup();
        this.soundScheduler = null;
        this.viewCache = new ViewCache(this);
        this.getCanvasList(true);
        this.cleanupViewId();
        this.renderBin.cleanup();
        this.renderBin = null;
        this.universe = null;
    }
}

