/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BehaviorRetained;
import javax.media.j3d.WakeupOnElapsedTime;

class WakeupOnElapsedTimeHeap
implements Cloneable {
    WakeupOnElapsedTime[] data;
    int size = 0;

    WakeupOnElapsedTimeHeap(int initCapacity) {
        this.data = new WakeupOnElapsedTime[initCapacity + 1];
    }

    WakeupOnElapsedTimeHeap() {
        this(10);
    }

    final int size() {
        return this.size;
    }

    final boolean isEmpty() {
        return this.size == 0;
    }

    final WakeupOnElapsedTime getMin() {
        return this.data[1];
    }

    final void insert(WakeupOnElapsedTime key) {
        if (this.data.length == this.size + 1) {
            WakeupOnElapsedTime[] oldData = this.data;
            this.data = new WakeupOnElapsedTime[oldData.length << 1];
            System.arraycopy(oldData, 0, this.data, 0, oldData.length);
        }
        int i = ++this.size;
        int parentIdx = i >> 1;
        WakeupOnElapsedTime parentKey = this.data[parentIdx];
        long time = key.triggeredTime;
        while (i > 1 && parentKey.triggeredTime > time) {
            this.data[i] = parentKey;
            i = parentIdx;
            parentKey = this.data[parentIdx >>= 1];
        }
        this.data[i] = key;
    }

    final void extract(BehaviorRetained behav) {
        for (int i = 1; i <= this.size; ++i) {
            if (this.data[i].behav != behav) continue;
            this.extract(i);
        }
    }

    final boolean extract(WakeupOnElapsedTime wakeup) {
        for (int i = 1; i <= this.size; ++i) {
            if (this.data[i] != wakeup) continue;
            this.extract(i);
            return true;
        }
        return false;
    }

    final WakeupOnElapsedTime extractMin() {
        return this.extract(1);
    }

    final WakeupOnElapsedTime extract(int i) {
        WakeupOnElapsedTime min = this.data[i];
        this.data[i] = this.data[this.size];
        this.data[this.size] = null;
        --this.size;
        while (true) {
            int l = i << 1;
            int r = l + 1;
            int smallest = l <= this.size && this.data[l].triggeredTime < this.data[i].triggeredTime ? l : i;
            if (r <= this.size && this.data[r].triggeredTime < this.data[smallest].triggeredTime) {
                smallest = r;
            }
            if (smallest == i) break;
            WakeupOnElapsedTime temp = this.data[smallest];
            this.data[smallest] = this.data[i];
            this.data[i] = temp;
            i = smallest;
        }
        return min;
    }

    final void trimToSize() {
        if (this.data.length > this.size + 1) {
            WakeupOnElapsedTime[] oldData = this.data;
            this.data = new WakeupOnElapsedTime[this.size + 1];
            System.arraycopy(oldData, 0, this.data, 0, this.data.length);
        }
    }

    protected final Object clone() {
        try {
            WakeupOnElapsedTimeHeap heap = (WakeupOnElapsedTimeHeap)super.clone();
            heap.data = new WakeupOnElapsedTime[this.size + 1];
            System.arraycopy(this.data, 0, heap.data, 0, this.size + 1);
            return heap;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[ ");
        if (this.size > 0) {
            sb.append(this.data[1]);
        }
        for (int i = 2; i <= this.size; ++i) {
            sb.append("," + this.data[i]);
        }
        sb.append(" ]");
        return sb.toString();
    }
}

