/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import java.util.ArrayList;
import org.scijava.java3d.NodeRetained;
import org.scijava.java3d.SceneGraphObjectRetained;
import org.scijava.java3d.Shape3DRetained;

class NodeComponentRetained
extends SceneGraphObjectRetained {
    boolean duplicateOnCloneTree = false;
    int refCount = 0;
    int refCnt = 0;
    private boolean inImmCtx = false;
    ArrayList users = new ArrayList(1);
    NodeComponentRetained mirror = null;
    int changedFrequent = 0;
    int compChanged = 0;

    NodeComponentRetained() {
    }

    void doSetLive(boolean inBackgroundGroup, int refCount) {
        int oldRefCount = this.refCount;
        this.refCount += refCount;
        if (oldRefCount <= 0) {
            super.doSetLive(inBackgroundGroup);
            this.createMirrorObject();
        }
    }

    void setLive(boolean inBackgroundGroup, int refCount) {
        int oldRefCount = this.refCount;
        this.doSetLive(inBackgroundGroup, refCount);
        if (oldRefCount <= 0) {
            super.markAsLive();
        }
    }

    void clearLive(int refCount) {
        this.refCount -= refCount;
        if (this.refCount <= 0) {
            super.clearLive();
        }
    }

    synchronized void incRefCnt() {
        ++this.refCnt;
    }

    synchronized void decRefCnt() {
        --this.refCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAMirrorUser(Shape3DRetained ms) {
        ArrayList arrayList = this.mirror.users;
        synchronized (arrayList) {
            this.mirror.users.remove(ms);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAMirrorUser(Shape3DRetained ms) {
        ArrayList arrayList = this.mirror.users;
        synchronized (arrayList) {
            this.mirror.users.add(ms);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyMirrorUsers(NodeComponentRetained node) {
        ArrayList arrayList = this.mirror.users;
        synchronized (arrayList) {
            ArrayList arrayList2 = node.mirror.users;
            synchronized (arrayList2) {
                int size = node.mirror.users.size();
                for (int i = 0; i < size; ++i) {
                    this.mirror.users.add(node.mirror.users.get(i));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMirrorUsers(NodeComponentRetained node) {
        ArrayList arrayList = this.mirror.users;
        synchronized (arrayList) {
            ArrayList arrayList2 = node.mirror.users;
            synchronized (arrayList2) {
                for (int i = node.mirror.users.size() - 1; i >= 0; --i) {
                    this.mirror.users.remove(this.mirror.users.indexOf(node.mirror.users.get(i)));
                }
            }
        }
    }

    synchronized void removeUser(NodeRetained node) {
        if (node.source.isLive()) {
            this.users.remove(this.users.indexOf(node));
        }
    }

    synchronized void addUser(NodeRetained node) {
        if (node.source.isLive()) {
            this.users.add(node);
        }
    }

    synchronized void notifyUsers() {
        if (this.source == null || !this.source.isLive()) {
            return;
        }
        for (int i = this.users.size() - 1; i >= 0; --i) {
            ((NodeRetained)this.users.get(i)).notifySceneGraphChanged(false);
        }
    }

    void setInImmCtx(boolean inCtx) {
        this.inImmCtx = inCtx;
    }

    boolean getInImmCtx() {
        return this.inImmCtx;
    }

    void setDuplicateOnCloneTree(boolean duplicate) {
        this.duplicateOnCloneTree = duplicate;
    }

    boolean getDuplicateOnCloneTree() {
        return this.duplicateOnCloneTree;
    }

    void initMirrorObject() {
    }

    void updateMirrorObject(int component, Object obj) {
    }

    void createMirrorObject() {
        this.initMirrorObject();
        this.mirror = null;
    }

    void setFrequencyChangeMask(int bit, int mask) {
        if (this.source.getCapabilityIsFrequent(bit)) {
            this.changedFrequent |= mask;
        } else if (!this.source.isLive()) {
            this.changedFrequent &= ~mask;
        }
    }

    @Override
    protected Object clone() {
        NodeComponentRetained ncr = (NodeComponentRetained)super.clone();
        ncr.changedFrequent = this.changedFrequent;
        return ncr;
    }

    protected void set(NodeComponentRetained nc) {
        this.changedFrequent = nc.changedFrequent;
    }
}

