/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import org.scijava.java3d.Canvas3D;
import org.scijava.java3d.Context;
import org.scijava.java3d.ImageComponentRetained;
import org.scijava.java3d.ImageComponentUpdateInfo;
import org.scijava.java3d.Pipeline;
import org.scijava.java3d.TextureRetained;

class Texture3DRetained
extends TextureRetained {
    int boundaryModeR = 3;
    int depth = 1;

    Texture3DRetained() {
    }

    final void setDepth(int depth) {
        this.depth = depth;
    }

    final int getDepth() {
        return this.depth;
    }

    final void initBoundaryModeR(int boundaryModeR) {
        this.boundaryModeR = boundaryModeR;
    }

    final int getBoundaryModeR() {
        return this.boundaryModeR;
    }

    @Override
    void bindTexture(Context ctx, int objectId, boolean enable) {
        Pipeline.getPipeline().bindTexture3D(ctx, objectId, enable);
    }

    void updateTextureBoundary(Context ctx, int boundaryModeS, int boundaryModeT, int boundaryModeR, float boundaryRed, float boundaryGreen, float boundaryBlue, float boundaryAlpha) {
        Pipeline.getPipeline().updateTexture3DBoundary(ctx, boundaryModeS, boundaryModeT, boundaryModeR, boundaryRed, boundaryGreen, boundaryBlue, boundaryAlpha);
    }

    @Override
    void updateTextureFilterModes(Context ctx, int minFilter, int magFilter) {
        Pipeline.getPipeline().updateTexture3DFilterModes(ctx, minFilter, magFilter);
    }

    @Override
    void updateTextureSharpenFunc(Context ctx, int numSharpenTextureFuncPts, float[] sharpenTextureFuncPts) {
        Pipeline.getPipeline().updateTexture3DSharpenFunc(ctx, numSharpenTextureFuncPts, sharpenTextureFuncPts);
    }

    @Override
    void updateTextureFilter4Func(Context ctx, int numFilter4FuncPts, float[] filter4FuncPts) {
        Pipeline.getPipeline().updateTexture3DFilter4Func(ctx, numFilter4FuncPts, filter4FuncPts);
    }

    @Override
    void updateTextureAnisotropicFilter(Context ctx, float degree) {
        Pipeline.getPipeline().updateTexture3DAnisotropicFilter(ctx, degree);
    }

    void updateTextureImage(Canvas3D cv, int face, int numLevels, int level, int textureFormat, int imageFormat, int width, int height, int depth, int boundaryWidth, int imageDataType, Object imageData) {
        Pipeline.getPipeline().updateTexture3DImage(cv.ctx, numLevels, level, textureFormat, imageFormat, width, height, depth, boundaryWidth, imageDataType, imageData, this.useAutoMipMapGeneration(cv));
    }

    void updateTextureSubImage(Canvas3D cv, int face, int level, int xoffset, int yoffset, int zoffset, int textureFormat, int imageFormat, int imgXOffset, int imgYOffset, int imgZOffset, int tilew, int tileh, int width, int height, int depth, int imageDataType, Object imageData) {
        Pipeline.getPipeline().updateTexture3DSubImage(cv.ctx, level, xoffset, yoffset, zoffset, textureFormat, imageFormat, imgXOffset, imgYOffset, imgZOffset, tilew, tileh, width, height, depth, imageDataType, imageData, this.useAutoMipMapGeneration(cv));
    }

    @Override
    void updateTextureDimensions(Canvas3D cv) {
        if (this.images[0][0] != null) {
            this.updateTextureImage(cv, this.maxLevels, 0, 0, this.format, this.images[0][0].getImageFormatTypeIntValue(false), this.width, this.height, this.depth, this.boundaryWidth, this.images[0][0].getImageDataTypeIntValue(), null);
        }
    }

    @Override
    void updateTextureBoundary(Canvas3D cv) {
        this.updateTextureBoundary(cv.ctx, this.boundaryModeS, this.boundaryModeT, this.boundaryModeR, this.boundaryColor.x, this.boundaryColor.y, this.boundaryColor.z, this.boundaryColor.w);
    }

    @Override
    void updateTextureLodRange(Context ctx, int baseLevel, int maximumLevel, float minimumLod, float maximumLod) {
        Pipeline.getPipeline().updateTexture3DLodRange(ctx, baseLevel, maximumLevel, minimumLod, maximumLod);
    }

    @Override
    void updateTextureLodOffset(Context ctx, float lodOffsetX, float lodOffsetY, float lodOffsetZ) {
        Pipeline.getPipeline().updateTexture3DLodOffset(ctx, lodOffsetX, lodOffsetY, lodOffsetZ);
    }

    @Override
    void reloadTextureImage(Canvas3D cv, int face, int level, ImageComponentRetained image, int numLevels) {
        ImageComponentRetained.ImageData imageData = image.getImageData(false);
        this.updateTextureImage(cv, 0, numLevels, level, this.format, image.getImageFormatTypeIntValue(false), image.width, image.height, this.depth, this.boundaryWidth, image.getImageDataTypeIntValue(), imageData.get());
    }

    @Override
    void reloadTextureSubImage(Canvas3D cv, int level, int face, ImageComponentUpdateInfo info, ImageComponentRetained image) {
        int x = info.x;
        int y = info.y;
        int z = info.z;
        int width = info.width;
        int height = info.height;
        int xoffset = x;
        int yoffset = y;
        ImageComponentRetained.ImageData imageData = image.getImageData(false);
        this.updateTextureSubImage(cv, 0, level, xoffset, yoffset, z, this.format, image.getImageFormatTypeIntValue(false), xoffset, yoffset, z, image.width, image.height, width, height, 1, image.getImageDataTypeIntValue(), imageData.get());
    }
}

