/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import org.scijava.java3d.BehaviorRetained;
import org.scijava.java3d.BehaviorStructure;
import org.scijava.java3d.Bounds;
import org.scijava.java3d.J3dI18N;
import org.scijava.java3d.ViewPlatform;
import org.scijava.java3d.ViewPlatformRetained;
import org.scijava.java3d.WakeupCriterion;
import org.scijava.java3d.WakeupIndexedList;

public final class WakeupOnViewPlatformExit
extends WakeupCriterion {
    static final int COND_IN_BS_LIST = 0;
    static final int BOUNDSEXIT_IN_BS_LIST = 1;
    static final int TOTAL_INDEXED_UNORDER_SET_TYPES = 2;
    Bounds region;
    Bounds transformedRegion;
    ViewPlatformRetained triggeredVP;

    public WakeupOnViewPlatformExit(Bounds region) {
        this.region = (Bounds)region.clone();
        WakeupIndexedList.init(this, 2);
    }

    public Bounds getBounds() {
        return (Bounds)this.region.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewPlatform getTriggeringViewPlatform() {
        if (this.behav == null) {
            throw new IllegalStateException(J3dI18N.getString("WakeupOnViewPlatformExit0"));
        }
        BehaviorRetained behaviorRetained = this.behav;
        synchronized (behaviorRetained) {
            if (!this.behav.inCallback) {
                throw new IllegalStateException(J3dI18N.getString("WakeupOnViewPlatformExit0"));
            }
        }
        return this.triggeredVP != null ? (ViewPlatform)this.triggeredVP.source : null;
    }

    void updateTransformRegion(BehaviorRetained b) {
        if (this.transformedRegion != null) {
            this.transformedRegion.set(this.region);
        } else {
            this.transformedRegion = (Bounds)this.region.clone();
        }
        this.transformedRegion.transform(b.getCurrentLocalToVworld(null));
    }

    @Override
    void addBehaviorCondition(BehaviorStructure bs) {
        this.updateTransformRegion(this.behav);
        this.behav.wakeupArray[3] = this.behav.wakeupArray[3] + 1;
        this.behav.wakeupMask |= 8;
        bs.addVPExitCondition(this);
    }

    @Override
    void removeBehaviorCondition(BehaviorStructure bs) {
        bs.removeVPExitCondition(this);
        this.behav.wakeupArray[3] = this.behav.wakeupArray[3] - 1;
        if (this.behav.wakeupArray[3] == 0) {
            this.behav.wakeupMask &= 0xFFFFFFF7;
        }
    }

    @Override
    void resetBehaviorCondition(BehaviorStructure bs) {
    }
}

