/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.loaders.objectfile;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

class RgbFile
extends BufferedInputStream {
    short dimension;
    short xSize;
    short ySize;
    short zSize;
    String filename;
    private static final int DEBUG = 0;

    short getShort() throws IOException {
        short t1 = (short)this.read();
        if (t1 == -1) {
            throw new IOException("Unexpected EOF");
        }
        short t2 = (short)this.read();
        if (t2 == -1) {
            throw new IOException("Unexpected EOF");
        }
        return (short)(t1 << 8 | t2);
    }

    byte getByte() throws IOException {
        int t = this.read();
        if (t == -1) {
            throw new IOException("Unexpected EOF");
        }
        return (byte)t;
    }

    int getInt() throws IOException {
        int ret = 0;
        for (int i = 0; i < 4; ++i) {
            int t = this.read();
            if (t == -1) {
                throw new IOException("Unexpected EOF");
            }
            ret = ret << 8 | t;
        }
        return ret;
    }

    public BufferedImage getImage() throws IOException {
        int[] nBits;
        ColorSpace cs;
        short magic = this.getShort();
        if (magic != 474) {
            throw new IOException("Unrecognized file format.");
        }
        byte storage = this.getByte();
        if (storage != 0) {
            throw new IOException("RLE Compressed files not supported");
        }
        byte bpc = this.getByte();
        this.dimension = this.getShort();
        this.xSize = this.getShort();
        this.ySize = this.getShort();
        this.zSize = this.getShort();
        int pixMin = this.getInt();
        int pixMax = this.getInt();
        this.skip(84L);
        int colorMap = this.getInt();
        if (pixMin != 0 || pixMax != 255 || colorMap != 0 || bpc != 1) {
            throw new IOException("Unsupported options in file");
        }
        this.skip(404L);
        ComponentColorModel cm = null;
        if (this.zSize == 1) {
            cs = ColorSpace.getInstance(1003);
            nBits = new int[]{8};
            cm = new ComponentColorModel(cs, nBits, false, false, 1, 0);
        } else if (this.zSize == 2) {
            cs = ColorSpace.getInstance(1003);
            nBits = new int[]{8, 8};
            cm = new ComponentColorModel(cs, nBits, true, false, 3, 0);
        } else if (this.zSize == 3) {
            cs = ColorSpace.getInstance(1000);
            nBits = new int[]{8, 8, 8};
            cm = new ComponentColorModel(cs, nBits, false, false, 1, 0);
        } else if (this.zSize == 4) {
            cs = ColorSpace.getInstance(1000);
            nBits = new int[]{8, 8, 8, 8};
            cm = new ComponentColorModel(cs, nBits, true, false, 3, 0);
        } else {
            throw new IOException("Unsupported options in file");
        }
        WritableRaster r = cm.createCompatibleWritableRaster(this.xSize, this.ySize);
        BufferedImage bi = new BufferedImage(cm, r, false, null);
        byte[] image = ((DataBufferByte)r.getDataBuffer()).getData();
        for (short z = 0; z < this.zSize; z = (short)(z + 1)) {
            for (int y = this.ySize - 1; y >= 0; --y) {
                for (short x = 0; x < this.xSize; x = (short)(x + 1)) {
                    int t = this.read();
                    if (t == -1) {
                        throw new IOException("Unexpected EOF");
                    }
                    image[y * (this.xSize * this.zSize) + x * this.zSize + z] = (byte)t;
                }
            }
        }
        return bi;
    }

    public RgbFile(InputStream s) {
        super(s);
    }
}

