/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.geometry;

import org.scijava.java3d.utils.geometry.GeomBuffer;

class Quadrics {
    Quadrics() {
    }

    GeomBuffer disk(double r, int xdiv, double y, boolean outside, boolean texCoordYUp) {
        double sign = outside ? 1.0 : -1.0;
        double dtheta = Math.PI * 2 / (double)xdiv;
        GeomBuffer gbuf = new GeomBuffer(xdiv + 2);
        gbuf.begin(16);
        gbuf.normal3d(0.0, 1.0 * sign, 0.0);
        gbuf.texCoord2d(0.5, 0.5);
        gbuf.vertex3d(0.0, y, 0.0);
        if (!outside) {
            for (int i = 0; i <= xdiv; ++i) {
                double theta = (double)i * dtheta;
                double sinTheta = Math.sin(theta - 1.5707963267948966);
                double cosTheta = Math.cos(theta - 1.5707963267948966);
                gbuf.normal3d(0.0, 1.0 * sign, 0.0);
                if (texCoordYUp) {
                    gbuf.texCoord2d(0.5 + cosTheta * 0.5, 1.0 - (0.5 + sinTheta * 0.5));
                } else {
                    gbuf.texCoord2d(0.5 + cosTheta * 0.5, 0.5 + sinTheta * 0.5);
                }
                gbuf.vertex3d(r * cosTheta, y, r * sinTheta);
            }
        } else {
            for (int i = xdiv; i >= 0; --i) {
                double theta = (double)i * dtheta;
                double sinTheta = Math.sin(theta - 1.5707963267948966);
                double cosTheta = Math.cos(theta - 1.5707963267948966);
                gbuf.normal3d(0.0, 1.0 * sign, 0.0);
                if (texCoordYUp) {
                    gbuf.texCoord2d(0.5 + cosTheta * 0.5, 1.0 - (0.5 - sinTheta * 0.5));
                } else {
                    gbuf.texCoord2d(0.5 + cosTheta * 0.5, 0.5 - sinTheta * 0.5);
                }
                gbuf.vertex3d(cosTheta * r, y, sinTheta * r);
            }
        }
        gbuf.end();
        return gbuf;
    }

    GeomBuffer cylinder(double height, double radius, int xdiv, int ydiv, boolean outside, boolean texCoordYUp) {
        double sign = outside ? 1.0 : -1.0;
        double dtheta = Math.PI * 2 / (double)xdiv;
        double dy = height / (double)ydiv;
        double du = 1.0 / (double)xdiv;
        double dv = 1.0 / (double)ydiv;
        GeomBuffer gbuf = new GeomBuffer(ydiv * 2 * (xdiv + 1));
        double s = 0.0;
        double t = 0.0;
        double py = -height / 2.0;
        gbuf.begin(1);
        for (int i = 0; i < ydiv; ++i) {
            int j;
            double qz;
            double qx;
            double pz;
            double px;
            double qy = py + dy;
            if (outside) {
                px = Math.cos((double)xdiv * dtheta - 1.5707963267948966);
                pz = Math.sin((double)xdiv * dtheta - 1.5707963267948966);
                qx = Math.cos((double)(xdiv - 1) * dtheta - 1.5707963267948966);
                qz = Math.sin((double)(xdiv - 1) * dtheta - 1.5707963267948966);
                gbuf.normal3d(px * sign, 0.0, pz * sign);
                if (texCoordYUp) {
                    gbuf.texCoord2d(s, 1.0 - (t + dv));
                } else {
                    gbuf.texCoord2d(s, t + dv);
                }
                gbuf.vertex3d(px * radius, qy, pz * radius);
                gbuf.normal3d(px * sign, 0.0, pz * sign);
                if (texCoordYUp) {
                    gbuf.texCoord2d(s, 1.0 - t);
                } else {
                    gbuf.texCoord2d(s, t);
                }
                gbuf.vertex3d(px * radius, py, pz * radius);
                gbuf.normal3d(qx * sign, 0.0, qz * sign);
                if (texCoordYUp) {
                    gbuf.texCoord2d(s + du, 1.0 - (t + dv));
                } else {
                    gbuf.texCoord2d(s + du, t + dv);
                }
                gbuf.vertex3d(qx * radius, qy, qz * radius);
                gbuf.normal3d(qx * sign, 0.0, qz * sign);
                if (texCoordYUp) {
                    gbuf.texCoord2d(s + du, 1.0 - t);
                } else {
                    gbuf.texCoord2d(s + du, t);
                }
                gbuf.vertex3d(qx * radius, py, qz * radius);
                s += du * 2.0;
                for (j = xdiv - 2; j >= 0; --j) {
                    px = Math.cos((double)j * dtheta - 1.5707963267948966);
                    pz = Math.sin((double)j * dtheta - 1.5707963267948966);
                    gbuf.normal3d(px * sign, 0.0, pz * sign);
                    if (texCoordYUp) {
                        gbuf.texCoord2d(s, 1.0 - (t + dv));
                    } else {
                        gbuf.texCoord2d(s, t + dv);
                    }
                    gbuf.vertex3d(px * radius, qy, pz * radius);
                    gbuf.normal3d(px * sign, 0.0, pz * sign);
                    if (texCoordYUp) {
                        gbuf.texCoord2d(s, 1.0 - t);
                    } else {
                        gbuf.texCoord2d(s, t);
                    }
                    gbuf.vertex3d(px * radius, py, pz * radius);
                    s += du;
                }
            } else {
                px = Math.cos(-1.5707963267948966);
                pz = Math.sin(-1.5707963267948966);
                qx = Math.cos(dtheta - 1.5707963267948966);
                qz = Math.sin(dtheta - 1.5707963267948966);
                gbuf.normal3d(px * sign, 0.0, pz * sign);
                if (texCoordYUp) {
                    gbuf.texCoord2d(s, 1.0 - (t + dv));
                } else {
                    gbuf.texCoord2d(s, t + dv);
                }
                gbuf.vertex3d(px * radius, qy, pz * radius);
                gbuf.normal3d(px * sign, 0.0, pz * sign);
                if (texCoordYUp) {
                    gbuf.texCoord2d(s, 1.0 - t);
                } else {
                    gbuf.texCoord2d(s, t);
                }
                gbuf.vertex3d(px * radius, py, pz * radius);
                gbuf.normal3d(qx * sign, 0.0, qz * sign);
                if (texCoordYUp) {
                    gbuf.texCoord2d(s + du, 1.0 - (t + dv));
                } else {
                    gbuf.texCoord2d(s + du, t + dv);
                }
                gbuf.vertex3d(qx * radius, qy, qz * radius);
                gbuf.normal3d(qx * sign, 0.0, qz * sign);
                if (texCoordYUp) {
                    gbuf.texCoord2d(s + du, 1.0 - t);
                } else {
                    gbuf.texCoord2d(s + du, t);
                }
                gbuf.vertex3d(qx * radius, py, qz * radius);
                s += du * 2.0;
                for (j = 2; j <= xdiv; ++j) {
                    px = Math.cos((double)j * dtheta - 1.5707963267948966);
                    pz = Math.sin((double)j * dtheta - 1.5707963267948966);
                    gbuf.normal3d(px * sign, 0.0, pz * sign);
                    if (texCoordYUp) {
                        gbuf.texCoord2d(s, 1.0 - (t + dv));
                    } else {
                        gbuf.texCoord2d(s, t + dv);
                    }
                    gbuf.vertex3d(px * radius, qy, pz * radius);
                    gbuf.normal3d(px * sign, 0.0, pz * sign);
                    if (texCoordYUp) {
                        gbuf.texCoord2d(s, 1.0 - t);
                    } else {
                        gbuf.texCoord2d(s, t);
                    }
                    gbuf.vertex3d(px * radius, py, pz * radius);
                    s += du;
                }
            }
            s = 0.0;
            t += dv;
            py += dy;
        }
        gbuf.end();
        return gbuf;
    }

    GeomBuffer coneBody(double bottom, double top, double bottomR, double topR, int xdiv, int ydiv, double dv, boolean outside, boolean texCoordYUp) {
        double sign = outside ? 1.0 : -1.0;
        double dtheta = Math.PI * 2 / (double)xdiv;
        double dr = (topR - bottomR) / (double)ydiv;
        double height = top - bottom;
        double dy = height / (double)ydiv;
        double ynormal = (bottomR - topR) / height;
        double du = 1.0 / (double)xdiv;
        GeomBuffer gbuf = new GeomBuffer(ydiv * 2 * (xdiv + 1));
        double s = 0.0;
        double t = 0.0;
        double py = bottom;
        double r = bottomR;
        gbuf.begin(1);
        for (int i = 0; i < ydiv; ++i) {
            int j;
            double qz;
            double qx;
            double pz;
            double px;
            double qy = py + dy;
            if (outside) {
                px = Math.cos((double)xdiv * dtheta - 1.5707963267948966);
                pz = Math.sin((double)xdiv * dtheta - 1.5707963267948966);
                qx = Math.cos((double)(xdiv - 1) * dtheta - 1.5707963267948966);
                qz = Math.sin((double)(xdiv - 1) * dtheta - 1.5707963267948966);
                gbuf.normal3d(px * sign, ynormal * sign, pz * sign);
                if (texCoordYUp) {
                    gbuf.texCoord2d(s, 1.0 - (t + dv));
                } else {
                    gbuf.texCoord2d(s, t + dv);
                }
                gbuf.vertex3d(px * (r + dr), qy, pz * (r + dr));
                gbuf.normal3d(px * sign, ynormal * sign, pz * sign);
                if (texCoordYUp) {
                    gbuf.texCoord2d(s, 1.0 - t);
                } else {
                    gbuf.texCoord2d(s, t);
                }
                gbuf.vertex3d(px * r, py, pz * r);
                gbuf.normal3d(qx * sign, ynormal * sign, qz * sign);
                if (texCoordYUp) {
                    gbuf.texCoord2d(s + du, 1.0 - (t + dv));
                } else {
                    gbuf.texCoord2d(s + du, t + dv);
                }
                gbuf.vertex3d(qx * (r + dr), qy, qz * (r + dr));
                gbuf.normal3d(qx * sign, ynormal * sign, qz * sign);
                if (texCoordYUp) {
                    gbuf.texCoord2d(s + du, 1.0 - t);
                } else {
                    gbuf.texCoord2d(s + du, t);
                }
                gbuf.vertex3d(qx * r, py, qz * r);
                s += du * 2.0;
                for (j = xdiv - 2; j >= 0; --j) {
                    px = Math.cos((double)j * dtheta - 1.5707963267948966);
                    pz = Math.sin((double)j * dtheta - 1.5707963267948966);
                    gbuf.normal3d(px * sign, ynormal * sign, pz * sign);
                    if (texCoordYUp) {
                        gbuf.texCoord2d(s, 1.0 - (t + dv));
                    } else {
                        gbuf.texCoord2d(s, t + dv);
                    }
                    gbuf.vertex3d(px * (r + dr), qy, pz * (r + dr));
                    gbuf.normal3d(px * sign, ynormal * sign, pz * sign);
                    if (texCoordYUp) {
                        gbuf.texCoord2d(s, 1.0 - t);
                    } else {
                        gbuf.texCoord2d(s, t);
                    }
                    gbuf.vertex3d(px * r, py, pz * r);
                    s += du;
                }
            } else {
                px = Math.cos(-1.5707963267948966);
                pz = Math.sin(-1.5707963267948966);
                qx = Math.cos(dtheta - 1.5707963267948966);
                qz = Math.sin(dtheta - 1.5707963267948966);
                gbuf.normal3d(px * sign, ynormal * sign, pz * sign);
                if (texCoordYUp) {
                    gbuf.texCoord2d(s, 1.0 - (t + dv));
                } else {
                    gbuf.texCoord2d(s, t + dv);
                }
                gbuf.vertex3d(px * (r + dr), qy, pz * (r + dr));
                gbuf.normal3d(px * sign, ynormal * sign, pz * sign);
                if (texCoordYUp) {
                    gbuf.texCoord2d(s, 1.0 - t);
                } else {
                    gbuf.texCoord2d(s, t);
                }
                gbuf.vertex3d(px * r, py, pz * r);
                gbuf.normal3d(qx * sign, ynormal * sign, qz * sign);
                if (texCoordYUp) {
                    gbuf.texCoord2d(s + du, 1.0 - (t + dv));
                } else {
                    gbuf.texCoord2d(s + du, t + dv);
                }
                gbuf.vertex3d(qx * (r + dr), qy, qz * (r + dr));
                gbuf.normal3d(qx * sign, ynormal * sign, qz * sign);
                if (texCoordYUp) {
                    gbuf.texCoord2d(s + du, 1.0 - t);
                } else {
                    gbuf.texCoord2d(s + du, t);
                }
                gbuf.vertex3d(qx * r, py, qz * r);
                s += du * 2.0;
                for (j = 2; j <= xdiv; ++j) {
                    px = Math.cos((double)j * dtheta - 1.5707963267948966);
                    pz = Math.sin((double)j * dtheta - 1.5707963267948966);
                    gbuf.normal3d(px * sign, ynormal * sign, pz * sign);
                    if (texCoordYUp) {
                        gbuf.texCoord2d(s, 1.0 - (t + dv));
                    } else {
                        gbuf.texCoord2d(s, t + dv);
                    }
                    gbuf.vertex3d(px * (r + dr), qy, pz * (r + dr));
                    gbuf.normal3d(px * sign, ynormal * sign, pz * sign);
                    if (texCoordYUp) {
                        gbuf.texCoord2d(s, 1.0 - t);
                    } else {
                        gbuf.texCoord2d(s, t);
                    }
                    gbuf.vertex3d(px * r, py, pz * r);
                    s += du;
                }
            }
            s = 0.0;
            t += dv;
            py += dy;
            r += dr;
        }
        gbuf.end();
        return gbuf;
    }

    GeomBuffer coneTop(double bottom, double radius, double height, int xdiv, double t, boolean outside, boolean texCoordYUp) {
        double sign = outside ? 1.0 : -1.0;
        double dtheta = Math.PI * 2 / (double)xdiv;
        double ynormal = radius / height;
        double du = 1.0 / (double)xdiv;
        double top = bottom + height;
        GeomBuffer gbuf = new GeomBuffer(xdiv + 2);
        gbuf.begin(16);
        gbuf.normal3d(0.0, ynormal * sign, 0.0);
        if (texCoordYUp) {
            gbuf.texCoord2d(0.5, 0.0);
        } else {
            gbuf.texCoord2d(0.5, 1.0);
        }
        gbuf.vertex3d(0.0, top, 0.0);
        double s = 0.0;
        if (outside) {
            for (int i = xdiv; i >= 0; --i) {
                double px = Math.cos((double)i * dtheta - 1.5707963267948966);
                double pz = Math.sin((double)i * dtheta - 1.5707963267948966);
                gbuf.normal3d(px * sign, ynormal * sign, pz * sign);
                if (texCoordYUp) {
                    gbuf.texCoord2d(s, 1.0 - t);
                } else {
                    gbuf.texCoord2d(s, t);
                }
                gbuf.vertex3d(px * radius, bottom, pz * radius);
                s += du;
            }
        } else {
            for (int i = 0; i <= xdiv; ++i) {
                double px = Math.cos((double)i * dtheta - 1.5707963267948966);
                double pz = Math.sin((double)i * dtheta - 1.5707963267948966);
                gbuf.normal3d(px * sign, ynormal * sign, pz * sign);
                if (texCoordYUp) {
                    gbuf.texCoord2d(s, 1.0 - t);
                } else {
                    gbuf.texCoord2d(s, t);
                }
                gbuf.vertex3d(px * radius, bottom, pz * radius);
                s += du;
            }
        }
        gbuf.end();
        return gbuf;
    }
}

