/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.util.FileUtils;

public class FileUtilsTest {
    private static final boolean isWindows = System.getProperty("os.name").startsWith("Win");

    @Test
    public void testGetPath() {
        Assert.assertEquals((Object)"C:/path/to/my-windows-file", (Object)FileUtils.getPath((String)"C:\\path\\to\\my-windows-file", (String)"\\"));
        Assert.assertEquals((Object)"/path/to/my-nix-file", (Object)FileUtils.getPath((String)"/path/to/my-nix-file", (String)"/"));
        Assert.assertEquals((Object)"/path/to/my-nix-file", (Object)FileUtils.getPath((String)"/path/to/my-nix-file", (String)"\\"));
    }

    @Test
    public void testGetExtension() {
        Assert.assertEquals((Object)"ext", (Object)FileUtils.getExtension((String)"/path/to/file.ext"));
        Assert.assertEquals((Object)"", (Object)FileUtils.getExtension((String)"/path/to/file"));
        Assert.assertEquals((Object)"a", (Object)FileUtils.getExtension((String)"/etc/init.d/xyz/file.a"));
        Assert.assertEquals((Object)"", (Object)FileUtils.getExtension((String)"/etc/init.d/xyz/file"));
    }

    @Test
    public void testURLToFile() throws MalformedURLException {
        String jqpublic = isWindows ? "C:/Users/jqpublic/" : "/Users/jqpublic/";
        String filePath = jqpublic + "imagej/ImageJ.class";
        String fileURL = new File(filePath).toURI().toURL().toString();
        File fileFile = FileUtils.urlToFile((String)fileURL);
        FileUtilsTest.assertEqualsPath(filePath, fileFile.getPath());
        File spaceFileOriginal = new File(jqpublic.replace("jqpublic", "Spaceman Spiff") + "stun/Blaster.class");
        URL spaceURL = spaceFileOriginal.toURI().toURL();
        File spaceFileResult = FileUtils.urlToFile((URL)spaceURL);
        FileUtilsTest.assertEqualsPath(spaceFileOriginal.getPath(), spaceFileResult.getPath());
        String alphaLo = "abcdefghijklmnopqrstuvwxyz";
        String alphaHi = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        String numbers = "1234567890";
        String special = "_~!@#$%^&*()+`-=";
        File specialFileOriginal = new File(jqpublic.replace("jqpublic", "abcdefghijklmnopqrstuvwxyz") + "ABCDEFGHIJKLMNOPQRSTUVWXYZ" + "/" + "1234567890" + "/" + "_~!@#$%^&*()+`-=" + "/foo/Bar.class");
        URL specialURL = specialFileOriginal.toURI().toURL();
        File specialFileResult = FileUtils.urlToFile((URL)specialURL);
        FileUtilsTest.assertEqualsPath(specialFileOriginal.getPath(), specialFileResult.getPath());
        String jarPath = "/Users/jqpublic/imagej/ij-core.jar";
        String jarURL = "jar:file:/Users/jqpublic/imagej/ij-core.jar!/imagej/ImageJ.class";
        File jarFile = FileUtils.urlToFile((String)"jar:file:/Users/jqpublic/imagej/ij-core.jar!/imagej/ImageJ.class");
        FileUtilsTest.assertEqualsPath("/Users/jqpublic/imagej/ij-core.jar", jarFile.getPath());
        String bundleURL = "bundleresource://346.fwk2106232034:4/imagej/ImageJ.class";
        try {
            File bundleFile = FileUtils.urlToFile((String)"bundleresource://346.fwk2106232034:4/imagej/ImageJ.class");
            Assert.fail((String)("Expected exception not thrown; result=" + bundleFile));
        }
        catch (IllegalArgumentException exc) {
            // empty catch block
        }
    }

    @Test
    public void testShortenPath() {
        Assert.assertEquals((Object)"C:\\Documents and Settings\\All Users\\Application Data\\Apple Computer\\...\\SC Info.txt", (Object)FileUtils.shortenPath((String)"C:\\Documents and Settings\\All Users\\Application Data\\Apple Computer\\iTunes\\SC Info\\SC Info.txt"));
        Assert.assertEquals((Object)"C:\\Documents and Settings\\All Users\\Application Data\\Apple Computer\\iTunes\\...\\SC Info.txt", (Object)FileUtils.shortenPath((String)"C:\\Documents and Settings\\All Users\\Application Data\\Apple Computer\\iTunes\\SC Info\\SC Info.txt", (int)5));
        Assert.assertEquals((Object)"C:\\temp", (Object)FileUtils.shortenPath((String)"C:\\temp"));
        Assert.assertEquals((Object)"C:\\1\\2\\3\\4\\...\\test.txt", (Object)FileUtils.shortenPath((String)"C:\\1\\2\\3\\4\\5\\test.txt"));
        Assert.assertEquals((Object)"C:/1/2/test.txt", (Object)FileUtils.shortenPath((String)"C:/1/2/test.txt"));
        Assert.assertEquals((Object)"C:/1/2/3/4/.../test.txt", (Object)FileUtils.shortenPath((String)"C:/1/2/3/4/5/test.txt"));
        Assert.assertEquals((Object)"\\\\server\\p1\\p2\\p3\\p4\\...\\p6", (Object)FileUtils.shortenPath((String)"\\\\server\\p1\\p2\\p3\\p4\\p5\\p6"));
        Assert.assertEquals((Object)"\\\\server\\p1\\p2\\p3", (Object)FileUtils.shortenPath((String)"\\\\server\\p1\\p2\\p3"));
        Assert.assertEquals((Object)"http://www.rgagnon.com/p1/p2/p3/.../pb.html", (Object)FileUtils.shortenPath((String)"http://www.rgagnon.com/p1/p2/p3/p4/p5/pb.html"));
    }

    @Test
    public void testLimitPath() {
        Assert.assertEquals((Object)"C:\\Doc...SC Info.txt", (Object)FileUtils.limitPath((String)"C:\\Documents and Settings\\All Users\\Application Data\\Apple Computer\\iTunes\\SC Info\\SC Info.txt", (int)20));
        Assert.assertEquals((Object)"C:\\temp", (Object)FileUtils.limitPath((String)"C:\\temp", (int)20));
        Assert.assertEquals((Object)"C:\\1\\2\\3\\...test.txt", (Object)FileUtils.limitPath((String)"C:\\1\\2\\3\\4\\5\\test.txt", (int)20));
        Assert.assertEquals((Object)"...testfile.txt", (Object)FileUtils.limitPath((String)"C:/1/2/testfile.txt", (int)15));
        Assert.assertEquals((Object)"C:/1...test.txt", (Object)FileUtils.limitPath((String)"C:/1/2/3/4/5/test.txt", (int)15));
        Assert.assertEquals((Object)"\\\\server\\p1\\p2\\...p6", (Object)FileUtils.limitPath((String)"\\\\server\\p1\\p2\\p3\\p4\\p5\\p6", (int)20));
        Assert.assertEquals((Object)"http://www...pb.html", (Object)FileUtils.limitPath((String)"http://www.rgagnon.com/p1/p2/p3/p4/p5/pb.html", (int)20));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListContents() throws IOException, URISyntaxException {
        File nonExisting;
        int i = 0;
        while ((nonExisting = new File("" + i)).exists()) {
            ++i;
        }
        try {
            Collection urls = FileUtils.listContents((URL)nonExisting.toURI().toURL());
            Assert.assertNotNull((Object)urls);
            Assert.assertEquals((long)0L, (long)urls.size());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        String subDir = "sub \ud834\udd1edirectory/";
        String subSubDir = "more \ud834\udd22stuff/";
        File jarFile = File.createTempFile("listContentsTest", ".jar");
        FileOutputStream out = new FileOutputStream(jarFile);
        JarOutputStream jarOut = new JarOutputStream(out);
        try {
            jarOut.putNextEntry(new JarEntry("sub \ud834\udd1edirectory/"));
            jarOut.closeEntry();
            jarOut.putNextEntry(new JarEntry("sub \ud834\udd1edirectory/more \ud834\udd22stuff/"));
            jarOut.closeEntry();
            jarOut.putNextEntry(new JarEntry("foo.txt"));
            jarOut.write("bar".getBytes());
            jarOut.closeEntry();
            jarOut.putNextEntry(new JarEntry("sub \ud834\udd1edirectory/hello.txt"));
            jarOut.write("world".getBytes());
            jarOut.closeEntry();
            jarOut.putNextEntry(new JarEntry("sub \ud834\udd1edirectory/rock.txt"));
            jarOut.write("roll".getBytes());
            jarOut.closeEntry();
            jarOut.putNextEntry(new JarEntry("sub \ud834\udd1edirectory/more \ud834\udd22stuff/fox.txt"));
            jarOut.write("the quick brown fox".getBytes());
            jarOut.closeEntry();
            jarOut.putNextEntry(new JarEntry("sub \ud834\udd1edirectory/more \ud834\udd22stuff/dog.txt"));
            jarOut.write("jumps over the lazy dog".getBytes());
            jarOut.closeEntry();
            jarOut.close();
        }
        finally {
            out.close();
        }
        String uriPath = new URI(null, null, "!/sub \ud834\udd1edirectory/", null).toString();
        String urlPath = "jar:" + jarFile.toURI().toURL() + uriPath;
        URL url = new URL(urlPath);
        URL subSubURL = new URL(urlPath + "more%20\ud834\udd22stuff/");
        URL helloURL = new URL(urlPath + "hello.txt");
        URL rockURL = new URL(urlPath + "rock.txt");
        URL foxURL = new URL(urlPath + "more%20\ud834\udd22stuff/fox.txt");
        URL dogURL = new URL(urlPath + "more%20\ud834\udd22stuff/dog.txt");
        Collection setTT = FileUtils.listContents((URL)url, (boolean)true, (boolean)true);
        Object[] listTT = setTT.toArray(new URL[setTT.size()]);
        Assert.assertArrayEquals((Object[])new URL[]{helloURL, rockURL, foxURL, dogURL}, (Object[])listTT);
        Collection setTF = FileUtils.listContents((URL)url, (boolean)true, (boolean)false);
        Object[] listTF = setTF.toArray(new URL[setTF.size()]);
        Assert.assertArrayEquals((Object[])new URL[]{subSubURL, helloURL, rockURL, foxURL, dogURL}, (Object[])listTF);
        Collection setFT = FileUtils.listContents((URL)url, (boolean)false, (boolean)true);
        Object[] listFT = setFT.toArray(new URL[setFT.size()]);
        Assert.assertArrayEquals((Object[])new URL[]{helloURL, rockURL}, (Object[])listFT);
        Collection setFF = FileUtils.listContents((URL)url, (boolean)false, (boolean)false);
        Object[] listFF = setFF.toArray(new URL[setFF.size()]);
        Assert.assertArrayEquals((Object[])new URL[]{subSubURL, helloURL, rockURL}, (Object[])listFF);
        Assert.assertTrue((boolean)jarFile.delete());
    }

    private static void assertEqualsPath(String a, String b) {
        if (isWindows) {
            Assert.assertEquals((Object)a.replace('\\', '/'), (Object)b.replace('\\', '/'));
        } else {
            Assert.assertEquals((Object)a, (Object)b);
        }
    }

    @Test
    public void testStripVersionFromFilename() {
        Assert.assertEquals((Object)"jars/bio-formats.jar", (Object)FileUtils.stripFilenameVersion((String)"jars/bio-formats-4.4-imagej-2.0.0-beta1.jar"));
        Assert.assertEquals((Object)FileUtils.stripFilenameVersion((String)"jars/ij-data-2.0.0.1-beta1.jar"), (Object)FileUtils.stripFilenameVersion((String)"jars/ij-data-2.0.0.1-SNAPSHOT.jar"));
        Assert.assertEquals((Object)FileUtils.stripFilenameVersion((String)"jars/ij-1.44.jar"), (Object)FileUtils.stripFilenameVersion((String)"jars/ij-1.46b.jar"));
        Assert.assertEquals((Object)FileUtils.stripFilenameVersion((String)"jars/javassist.jar"), (Object)FileUtils.stripFilenameVersion((String)"jars/javassist-3.9.0.GA.jar"));
        Assert.assertEquals((Object)FileUtils.stripFilenameVersion((String)"jars/javassist.jar"), (Object)FileUtils.stripFilenameVersion((String)"jars/javassist-3.16.1-GA.jar"));
        Assert.assertEquals((Object)FileUtils.stripFilenameVersion((String)"jars/bsh.jar"), (Object)FileUtils.stripFilenameVersion((String)"jars/bsh-2.0b4.jar"));
        Assert.assertEquals((Object)FileUtils.stripFilenameVersion((String)"jars/mpicbg.jar"), (Object)FileUtils.stripFilenameVersion((String)"jars/mpicbg-20111128.jar"));
        Assert.assertEquals((Object)FileUtils.stripFilenameVersion((String)"jars/miglayout-swing.jar"), (Object)FileUtils.stripFilenameVersion((String)"jars/miglayout-3.7.3.1-swing.jar"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetAllVersions() throws IOException {
        String withClassifier = "miglayout-3.7.3.1-swing.jar";
        String withoutClassifier = "miglayout-3.7.3.1.jar";
        File tmp = FileUtils.createTemporaryDirectory((String)"delete-other-", (String)"");
        try {
            FileUtilsTest.writeEmptyFile(new File(tmp, "miglayout-3.7.3.1-swing.jar"));
            FileUtilsTest.writeEmptyFile(new File(tmp, "miglayout-3.7.3.1.jar"));
            Assert.assertArrayEquals((Object[])new File[]{new File(tmp, "miglayout-3.7.3.1-swing.jar")}, (Object[])FileUtils.getAllVersions((File)tmp, (String)"miglayout-3.7.3.1-swing.jar"));
            Assert.assertArrayEquals((Object[])new File[]{new File(tmp, "miglayout-3.7.3.1.jar")}, (Object[])FileUtils.getAllVersions((File)tmp, (String)"miglayout-3.7.3.1.jar"));
        }
        finally {
            FileUtils.deleteRecursively((File)tmp);
        }
    }

    private static void writeEmptyFile(File file) throws FileNotFoundException, IOException {
        FileOutputStream out = new FileOutputStream(file);
        out.flush();
        ((OutputStream)out).close();
    }
}

