/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.event;

import java.lang.ref.WeakReference;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.event.EventHandler;
import org.scijava.event.EventService;
import org.scijava.event.SciJavaEvent;
import org.scijava.service.AbstractService;
import org.scijava.service.event.ServicesLoadedEvent;

public class EventServiceTest {
    private int counter = 0;

    @Test
    public void testWeakEventHandlers() {
        WeakReference<MyEventHandler> reference = new WeakReference<MyEventHandler>(new MyEventHandler());
        EventServiceTest.gc();
        Assert.assertNull(reference.get());
        Context context = new Context(new Class[]{EventService.class});
        EventService eventService = (EventService)context.getService(EventService.class);
        MyEventHandler handler = new MyEventHandler();
        eventService.subscribe((Object)handler);
        EventServiceTest.gc();
        Assert.assertEquals((long)0L, (long)this.counter);
        eventService.publish((SciJavaEvent)new MyEvent());
        Assert.assertEquals((long)1L, (long)this.counter);
        handler = null;
        EventServiceTest.gc();
        eventService.publish((SciJavaEvent)new MyEvent());
        Assert.assertEquals((long)1L, (long)this.counter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEventHandlerDependencies() throws InterruptedException {
        Context context = new Context(new Class[]{ServiceNeedingAnEventService.class});
        EventService eventService = (EventService)context.getService(EventService.class);
        ServiceNeedingAnEventService snaeService = (ServiceNeedingAnEventService)context.getService(ServiceNeedingAnEventService.class);
        Assert.assertNotNull((Object)eventService);
        ServiceNeedingAnEventService serviceNeedingAnEventService = snaeService;
        synchronized (serviceNeedingAnEventService) {
            ((Object)((Object)snaeService)).wait(500L);
        }
        Assert.assertTrue((boolean)snaeService.isContextCreated());
    }

    private static void gc() {
        System.gc();
        System.gc();
    }

    public static class ServiceNeedingAnEventService
    extends AbstractService {
        private boolean contextCreated;

        public boolean isContextCreated() {
            return this.contextCreated;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @EventHandler
        public void onEvent(ServicesLoadedEvent evt) {
            this.contextCreated = true;
            ServiceNeedingAnEventService serviceNeedingAnEventService = this;
            synchronized (serviceNeedingAnEventService) {
                ((Object)((Object)this)).notifyAll();
            }
        }
    }

    public static class MyEventHandler {
        @EventHandler
        public void onEvent(MyEvent e) {
            e.inc();
        }
    }

    private class MyEvent
    extends SciJavaEvent {
        private MyEvent() {
        }

        public void inc() {
            EventServiceTest.this.counter++;
        }
    }
}

