/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.util.Collection;
import java.util.Iterator;
import org.scijava.util.AbstractPrimitiveArray;

public class CharArray
extends AbstractPrimitiveArray<char[], Character> {
    private char[] array;

    public CharArray() {
        super(Character.TYPE);
    }

    public CharArray(int size) {
        super(Character.TYPE, size);
    }

    public CharArray(char[] array) {
        super(Character.TYPE, array);
    }

    public void addValue(char value) {
        this.addValue(this.size(), value);
    }

    public boolean removeValue(char value) {
        int index = this.indexOf(value);
        if (index < 0) {
            return false;
        }
        this.delete(index, 1);
        return true;
    }

    public char getValue(int index) {
        this.checkBounds(index);
        return this.array[index];
    }

    public char setValue(int index, char value) {
        this.checkBounds(index);
        char oldValue = this.getValue(index);
        this.array[index] = value;
        return oldValue;
    }

    public void addValue(int index, char value) {
        this.insert(index, 1);
        this.array[index] = value;
    }

    public int indexOf(char value) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(char value) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (this.array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(char value) {
        return this.indexOf(value) >= 0;
    }

    @Override
    public char[] getArray() {
        return this.array;
    }

    @Override
    public void setArray(char[] array) {
        if (array.length < this.size()) {
            throw new IllegalArgumentException("Array too small");
        }
        this.array = array;
    }

    @Override
    public Character get(int index) {
        return Character.valueOf(this.getValue(index));
    }

    @Override
    public Character set(int index, Character element) {
        return Character.valueOf(this.setValue(index, (element == null ? this.defaultValue() : element).charValue()));
    }

    @Override
    public void add(int index, Character element) {
        this.addValue(index, element.charValue());
    }

    @Override
    public int indexOf(Object o) {
        if (!(o instanceof Character)) {
            return -1;
        }
        char value = ((Character)o).charValue();
        return this.indexOf(value);
    }

    @Override
    public int lastIndexOf(Object o) {
        if (!(o instanceof Character)) {
            return -1;
        }
        char value = ((Character)o).charValue();
        return this.lastIndexOf(value);
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof Character)) {
            return false;
        }
        char value = ((Character)o).charValue();
        return this.contains(value);
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Character)) {
            return false;
        }
        char value = ((Character)o).charValue();
        return this.removeValue(value);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (!(o instanceof Character)) {
                return false;
            }
            char value = ((Character)o).charValue();
            if (this.indexOf(value) >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Character> c) {
        if (c.size() == 0) {
            return false;
        }
        this.insert(index, c.size());
        int i = index;
        Iterator<? extends Character> i$ = c.iterator();
        while (i$.hasNext()) {
            char e = i$.next().charValue();
            this.setValue(i++, e);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            char value;
            boolean result;
            if (!(o instanceof Character) || !(result = this.removeValue(value = ((Character)o).charValue()))) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public Character defaultValue() {
        return Character.valueOf('\u0000');
    }
}

