/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.jar.Attributes;
import org.scijava.util.ClassUtils;

public class Manifest {
    private final java.util.jar.Manifest manifest;

    private Manifest(java.util.jar.Manifest manifest) {
        this.manifest = manifest;
    }

    public String getArchiverVersion() {
        return this.get("Archiver-Version");
    }

    public String getBuildJdk() {
        return this.get("Build-Jdk");
    }

    public String getBuiltBy() {
        return this.get("Built-By");
    }

    public String getCreatedBy() {
        return this.get("Created-By");
    }

    public String getImplementationBuild() {
        return this.get("Implementation-Build");
    }

    public String getImplementationDate() {
        return this.get("Implementation-Date");
    }

    public String getImplementationTitle() {
        return this.get("Implementation-Title");
    }

    public String getImplementationVendor() {
        return this.get("Implementation-Vendor");
    }

    public String getImplementationVendorId() {
        return this.get("Implementation-Vendor-Id");
    }

    public String getImplementationVersion() {
        return this.get("Implementation-Version");
    }

    public String getManifestVersion() {
        return this.get("Manifest-Version");
    }

    public String getPackage() {
        return this.get("Package");
    }

    public String getSpecificationTitle() {
        return this.get("Specification-Title");
    }

    public String getSpecificationVendor() {
        return this.get("Specification-Vendor");
    }

    public String getSpecificationVersion() {
        return this.get("Specification-Version");
    }

    public String get(String key) {
        if (this.manifest == null) {
            return null;
        }
        Attributes mainAttrs = this.manifest.getMainAttributes();
        if (mainAttrs == null) {
            return null;
        }
        return mainAttrs.getValue(key);
    }

    public Map<Object, Object> getAll() {
        if (this.manifest == null) {
            return null;
        }
        Attributes mainAttrs = this.manifest.getMainAttributes();
        if (mainAttrs == null) {
            return null;
        }
        return Collections.unmodifiableMap(mainAttrs);
    }

    public static Manifest getManifest(Class<?> c) {
        try {
            URL location = new URL("jar:" + ClassUtils.getLocation(c) + "!/");
            return new Manifest(((JarURLConnection)location.openConnection()).getManifest());
        }
        catch (IOException e) {
            return null;
        }
    }
}

