/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.module.run;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.ItemIO;
import org.scijava.module.DefaultMutableModule;
import org.scijava.module.DefaultMutableModuleInfo;
import org.scijava.module.DefaultMutableModuleItem;
import org.scijava.module.ModuleInfo;
import org.scijava.module.ModuleItem;
import org.scijava.module.ModuleService;
import org.scijava.module.run.ModuleCodeRunner;

public class ModuleCodeRunnerTest {
    private Context context;
    private ModuleCodeRunner runner;

    @Before
    public void setUp() {
        this.context = new Context(new Class[]{ModuleService.class});
        ((ModuleService)this.context.service(ModuleService.class)).addModule((ModuleInfo)new AlphabetModuleInfo());
        this.runner = new ModuleCodeRunner();
        this.context.inject((Object)this.runner);
    }

    @After
    public void tearDown() {
        this.context.dispose();
    }

    @Test
    public void testRunList() throws InvocationTargetException {
        StringBuilder sb = new StringBuilder();
        this.runner.run((Object)("module:" + AlphabetModule.class.getName()), new Object[]{"buffer", sb, "length", 3});
        Assert.assertEquals((Object)"ABC", (Object)sb.toString());
    }

    @Test
    public void testRunMap() throws InvocationTargetException {
        StringBuilder sb = new StringBuilder();
        HashMap<String, Comparable<StringBuilder>> inputMap = new HashMap<String, Comparable<StringBuilder>>();
        inputMap.put("buffer", sb);
        inputMap.put("length", Integer.valueOf(4));
        this.runner.run((Object)("module:" + AlphabetModule.class.getName()), inputMap);
        Assert.assertEquals((Object)"ABCD", (Object)sb.toString());
    }

    @Test
    public void testSupports() {
        Assert.assertTrue((boolean)this.runner.supports((Object)("module:" + AlphabetModule.class.getName())));
        Assert.assertFalse((boolean)this.runner.supports((Object)("module:" + this.getClass().getName())));
    }

    public static class AlphabetModuleInfo
    extends DefaultMutableModuleInfo {
        public AlphabetModuleInfo() {
            this.setModuleClass(AlphabetModule.class);
            DefaultMutableModuleItem bufferItem = new DefaultMutableModuleItem((ModuleInfo)this, "buffer", StringBuilder.class);
            bufferItem.setIOType(ItemIO.BOTH);
            this.addInput((ModuleItem)bufferItem);
            this.addInput((ModuleItem)new DefaultMutableModuleItem((ModuleInfo)this, "length", Integer.TYPE));
        }
    }

    public static class AlphabetModule
    extends DefaultMutableModule {
        public AlphabetModuleInfo getInfo() {
            return new AlphabetModuleInfo();
        }

        public void run() {
            StringBuilder sb = (StringBuilder)this.getInput("buffer");
            int length = (Integer)this.getInput("length");
            sb.setLength(0);
            for (int i = 0; i < length; ++i) {
                char letter = (char)(65 + i);
                sb.append(letter);
            }
        }
    }
}

