/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.command;

import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.Cancelable;
import org.scijava.Context;
import org.scijava.command.Command;
import org.scijava.command.CommandInfo;
import org.scijava.command.CommandModule;
import org.scijava.command.CommandService;
import org.scijava.command.ContextCommand;
import org.scijava.module.Module;
import org.scijava.module.process.AbstractPreprocessorPlugin;
import org.scijava.module.process.PreprocessorPlugin;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

public class CommandModuleTest {
    @Test
    public void testCancelable() throws InterruptedException, ExecutionException {
        Context context = new Context(new Class[]{CommandService.class});
        CommandService commandService = (CommandService)context.service(CommandService.class);
        CommandModule ice = (CommandModule)commandService.run(IceCommand.class, true, new Object[0]).get();
        Cancelable c = (Cancelable)ice.getDelegateObject();
        Assert.assertTrue((boolean)ice.isCanceled());
        Assert.assertTrue((boolean)c.isCanceled());
        Assert.assertEquals((Object)"Stop! Collaborate and listen!", (Object)ice.getCancelReason());
        Assert.assertEquals((Object)"Stop! Collaborate and listen!", (Object)c.getCancelReason());
        CommandModule crow = (CommandModule)commandService.run(CrowCommand.class, true, new Object[0]).get();
        Assert.assertFalse((boolean)crow.isCanceled());
    }

    @Test
    public void testNotCancelable() throws InterruptedException, ExecutionException {
        Context context = new Context(new Class[]{CommandService.class});
        CommandService commandService = (CommandService)context.service(CommandService.class);
        CommandModule fire = (CommandModule)commandService.run(FireCommand.class, true, new Object[0]).get();
        Assert.assertFalse((boolean)(fire.getDelegateObject() instanceof Cancelable));
        Assert.assertTrue((boolean)fire.isCanceled());
        Assert.assertEquals((Object)"NO SINGING!", (Object)fire.getCancelReason());
    }

    @Test
    public void testDefaultValues() {
        Context context = new Context(new Class[]{CommandService.class});
        CommandService commandService = (CommandService)context.service(CommandService.class);
        CommandInfo info = commandService.getCommand(CommandWithDefaultValues.class);
        Assert.assertEquals((Object)5, (Object)info.getInput("weekdays").getDefaultValue());
        long defaultTime = (Long)info.getInput("time").getDefaultValue();
        long timeDiff = System.currentTimeMillis() - defaultTime;
        Assert.assertTrue((timeDiff >= 0L && timeDiff < 50L ? 1 : 0) != 0);
        String defaultName = (String)info.getInput("name").getDefaultValue();
        Assert.assertEquals((Object)"John Jacob Jingleheimer Schmidt", (Object)defaultName);
        Assert.assertEquals(null, (Object)info.getInput("thing").getDefaultValue());
    }

    @Plugin(type=Command.class)
    public static class CommandWithDefaultValues
    extends ContextCommand {
        @Parameter
        private int weekdays = 5;
        @Parameter
        private long time = System.currentTimeMillis();
        @Parameter
        private String name = "John Jacob Jingleheimer Schmidt";
        @Parameter
        private Object thing;

        public void run() {
            this.weekdays = 0;
            this.time = 0L;
        }
    }

    @Plugin(type=PreprocessorPlugin.class)
    public static class CommandCanceler
    extends AbstractPreprocessorPlugin {
        public void process(Module module) {
            Object command = module.getDelegateObject();
            if (command instanceof IceCommand || command instanceof FireCommand) {
                this.cancel("NO SINGING!");
            }
        }
    }

    @Plugin(type=Command.class)
    public static class CrowCommand
    extends ContextCommand {
        public void run() {
        }
    }

    @Plugin(type=Command.class)
    public static class FireCommand
    implements Command {
        public void run() {
            throw new IllegalStateException("Unexpected");
        }
    }

    @Plugin(type=Command.class, initializer="init")
    public static class IceCommand
    extends ContextCommand {
        public void init() {
            this.cancel("Stop! Collaborate and listen!");
        }

        public void run() {
            throw new IllegalStateException("Unexpected");
        }
    }
}

