/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.module;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.scijava.Identifiable;
import org.scijava.MenuPath;
import org.scijava.Priority;
import org.scijava.convert.ConvertService;
import org.scijava.event.EventService;
import org.scijava.input.Accelerator;
import org.scijava.log.LogService;
import org.scijava.module.Module;
import org.scijava.module.ModuleException;
import org.scijava.module.ModuleIndex;
import org.scijava.module.ModuleInfo;
import org.scijava.module.ModuleItem;
import org.scijava.module.ModuleRunner;
import org.scijava.module.ModuleService;
import org.scijava.module.event.ModulesAddedEvent;
import org.scijava.module.event.ModulesRemovedEvent;
import org.scijava.module.process.ModulePostprocessor;
import org.scijava.module.process.ModulePreprocessor;
import org.scijava.module.process.PostprocessorPlugin;
import org.scijava.module.process.PreprocessorPlugin;
import org.scijava.object.ObjectService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.plugin.PluginService;
import org.scijava.prefs.PrefService;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import org.scijava.thread.ThreadService;
import org.scijava.util.ClassUtils;

@Plugin(type=Service.class)
public class DefaultModuleService
extends AbstractService
implements ModuleService {
    @Parameter
    private LogService log;
    @Parameter
    private EventService eventService;
    @Parameter
    private PluginService pluginService;
    @Parameter
    private ObjectService objectService;
    @Parameter
    private ThreadService threadService;
    @Parameter
    private PrefService prefService;
    @Parameter
    private ConvertService convertService;
    private ModuleIndex moduleIndex;

    @Override
    public ModuleIndex getIndex() {
        return this.moduleIndex;
    }

    @Override
    public void addModule(ModuleInfo module) {
        if (this.moduleIndex.add(module)) {
            this.eventService.publish(new ModulesAddedEvent(module));
        }
    }

    @Override
    public void removeModule(ModuleInfo module) {
        if (this.moduleIndex.remove(module)) {
            this.eventService.publish(new ModulesRemovedEvent(module));
        }
    }

    @Override
    public void addModules(Collection<? extends ModuleInfo> modules) {
        if (this.moduleIndex.addAll(modules)) {
            this.eventService.publish(new ModulesAddedEvent(modules));
        }
    }

    @Override
    public void removeModules(Collection<? extends ModuleInfo> modules) {
        if (this.moduleIndex.removeAll(modules)) {
            this.eventService.publish(new ModulesRemovedEvent(modules));
        }
    }

    @Override
    public List<ModuleInfo> getModules() {
        return this.moduleIndex.getAll();
    }

    @Override
    public ModuleInfo getModuleById(String id) {
        for (ModuleInfo info : this.getModules()) {
            String infoID;
            if (!(info instanceof Identifiable) || !id.equals(infoID = ((Identifiable)((Object)info)).getIdentifier())) continue;
            return info;
        }
        return null;
    }

    @Override
    public ModuleInfo getModuleForAccelerator(Accelerator acc) {
        for (ModuleInfo info : this.getModules()) {
            MenuPath menuPath = info.getMenuPath();
            if (menuPath == null || menuPath.isEmpty() || !acc.equals(menuPath.getLeaf().getAccelerator())) continue;
            return info;
        }
        return null;
    }

    @Override
    public Module createModule(ModuleInfo info) {
        Module existing = this.getRegisteredModuleInstance(info);
        if (existing != null) {
            return existing;
        }
        try {
            Module module = info.createModule();
            this.getContext().inject(module);
            Priority.inject(module, info.getPriority());
            return module;
        }
        catch (ModuleException exc) {
            this.log.error("Cannot create module: " + info.getDelegateClassName(), exc);
            return null;
        }
    }

    @Override
    public Future<Module> run(ModuleInfo info, boolean process, Object ... inputs) {
        return this.run((Module)((Object)info), (List<? extends ModulePreprocessor>)this.pre(process), (List<? extends ModulePostprocessor>)this.post(process), inputs);
    }

    @Override
    public Future<Module> run(ModuleInfo info, boolean process, Map<String, Object> inputMap) {
        return this.run((Module)((Object)info), (List<? extends ModulePreprocessor>)this.pre(process), (List<? extends ModulePostprocessor>)this.post(process), inputMap);
    }

    @Override
    public Future<Module> run(ModuleInfo info, List<? extends ModulePreprocessor> pre, List<? extends ModulePostprocessor> post, Object ... inputs) {
        return this.run((Module)((Object)info), pre, post, this.createMap(inputs));
    }

    @Override
    public Future<Module> run(ModuleInfo info, List<? extends ModulePreprocessor> pre, List<? extends ModulePostprocessor> post, Map<String, Object> inputMap) {
        Module module = this.createModule(info);
        if (module == null) {
            return null;
        }
        return this.run(module, pre, post, inputMap);
    }

    @Override
    public <M extends Module> Future<M> run(M module, boolean process, Object ... inputs) {
        return this.run(module, this.pre(process), this.post(process), inputs);
    }

    @Override
    public <M extends Module> Future<M> run(M module, boolean process, Map<String, Object> inputMap) {
        return this.run(module, this.pre(process), this.post(process), inputMap);
    }

    @Override
    public <M extends Module> Future<M> run(M module, List<? extends ModulePreprocessor> pre, List<? extends ModulePostprocessor> post, Object ... inputs) {
        return this.run(module, pre, post, this.createMap(inputs));
    }

    @Override
    public <M extends Module> Future<M> run(M module, List<? extends ModulePreprocessor> pre, List<? extends ModulePostprocessor> post, Map<String, Object> inputMap) {
        ModuleRunner runner;
        this.assignInputs(module, inputMap);
        ModuleRunner callable = runner = new ModuleRunner(this.getContext(), module, pre, post);
        Future<Module> future = this.threadService.run(callable);
        return future;
    }

    @Override
    public <M extends Module> M waitFor(Future<M> future) {
        try {
            return (M)((Module)future.get());
        }
        catch (InterruptedException e) {
            this.log.error("Module execution interrupted", e);
        }
        catch (ExecutionException e) {
            this.log.error("Error during module execution", e);
        }
        return null;
    }

    @Override
    public <T> ModuleItem<T> getSingleInput(Module module, Class<T> type) {
        return this.getTypedSingleItem(module, type, module.getInfo().inputs());
    }

    @Override
    public <T> ModuleItem<T> getSingleOutput(Module module, Class<T> type) {
        return this.getTypedSingleItem(module, type, module.getInfo().outputs());
    }

    @Override
    public ModuleItem<?> getSingleInput(Module module, Collection<Class<?>> types) {
        return this.getSingleItem(module, types, module.getInfo().inputs());
    }

    @Override
    public ModuleItem<?> getSingleOutput(Module module, Collection<Class<?>> types) {
        return this.getSingleItem(module, types, module.getInfo().outputs());
    }

    @Override
    public <T> void save(ModuleItem<T> item, T value) {
        String sValue;
        if (!item.isPersisted()) {
            return;
        }
        if (Objects.equals(item.getDefaultValue(), value)) {
            return;
        }
        String string = sValue = value == null ? "" : value.toString();
        if (!this.convertService.supports((Object)sValue, item.getType())) {
            return;
        }
        String persistKey = item.getPersistKey();
        if (persistKey == null || persistKey.isEmpty()) {
            Class<?> prefClass = this.delegateClass(item);
            String prefKey = item.getName();
            this.prefService.put(prefClass, prefKey, sValue);
        } else {
            this.prefService.put(persistKey, sValue);
        }
    }

    @Override
    public <T> T load(ModuleItem<T> item) {
        String sValue;
        if (!item.isPersisted()) {
            return null;
        }
        String persistKey = item.getPersistKey();
        if (persistKey == null || persistKey.isEmpty()) {
            Class<?> prefClass = this.delegateClass(item);
            String prefKey = item.getName();
            sValue = this.prefService.get(prefClass, prefKey);
        } else {
            sValue = this.prefService.get(persistKey);
        }
        if (sValue == null) {
            return null;
        }
        return this.convertService.convert((Object)sValue, item.getType());
    }

    @Override
    public <T> T getDefaultValue(ModuleItem<T> item) {
        T zero;
        T defaultValue = item.getDefaultValue();
        if (defaultValue != null) {
            return defaultValue;
        }
        T min = item.getMinimumValue();
        if (min != null) {
            return min;
        }
        T softMin = item.getSoftMinimum();
        if (softMin != null) {
            return softMin;
        }
        T max = item.getMaximumValue();
        if (max != null) {
            return max;
        }
        T softMax = item.getSoftMaximum();
        if (softMax != null) {
            return softMax;
        }
        if (Number.class.isAssignableFrom(item.getType()) && (zero = this.convertService.convert((Object)"0", item.getType())) != null) {
            return zero;
        }
        return null;
    }

    @Override
    public void initialize() {
        this.moduleIndex = new ModuleIndex();
    }

    private List<? extends PreprocessorPlugin> pre(boolean process) {
        if (!process) {
            return null;
        }
        return this.pluginService.createInstancesOfType(PreprocessorPlugin.class);
    }

    private List<? extends PostprocessorPlugin> post(boolean process) {
        if (!process) {
            return null;
        }
        return this.pluginService.createInstancesOfType(PostprocessorPlugin.class);
    }

    private Module getRegisteredModuleInstance(ModuleInfo info) {
        Class<?> type = ClassUtils.loadClass(info.getDelegateClassName());
        if (type == null || !Module.class.isAssignableFrom(type)) {
            return null;
        }
        Class<?> moduleType = type;
        List<?> objects = this.objectService.getObjects(moduleType);
        if (objects == null || objects.isEmpty()) {
            return null;
        }
        if (objects.size() > 1) {
            this.log.warn("Ignoring multiple candidate module instances for class: " + type.getName());
            return null;
        }
        return (Module)objects.get(0);
    }

    private Map<String, Object> createMap(Object[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        HashMap<String, Object> inputMap = new HashMap<String, Object>();
        if (values.length % 2 != 0) {
            this.log.error("Ignoring extraneous argument: " + values[values.length - 1]);
        }
        int numPairs = values.length / 2;
        for (int i = 0; i < numPairs; ++i) {
            Object key = values[2 * i];
            Object value = values[2 * i + 1];
            if (!(key instanceof String)) {
                this.log.error("Invalid input name: " + key);
                continue;
            }
            String name = (String)key;
            inputMap.put(name, value);
        }
        return inputMap;
    }

    private void assignInputs(Module module, Map<String, Object> inputMap) {
        if (inputMap == null) {
            return;
        }
        for (String name : inputMap.keySet()) {
            Object converted;
            ModuleItem<?> input = module.getInfo().getInput(name);
            Object value = inputMap.get(name);
            if (input == null) {
                if (!name.startsWith(".")) {
                    this.log.warn("Unmatched input: " + name);
                }
                converted = value;
            } else {
                Class<?> type = input.getType();
                converted = this.convertService.convert(value, type);
                if (value != null && converted == null) {
                    this.log.error("For input " + name + ": incompatible object " + value.getClass().getName() + " for type " + type.getName());
                    continue;
                }
            }
            module.setInput(name, converted);
            module.resolveInput(name);
        }
    }

    private <T> ModuleItem<T> getTypedSingleItem(Module module, Class<T> type, Iterable<ModuleItem<?>> items) {
        HashSet types = new HashSet();
        types.add(type);
        ModuleItem<?> result = this.getSingleItem(module, types, items);
        return result;
    }

    private ModuleItem<?> getSingleItem(Module module, Collection<Class<?>> types, Iterable<ModuleItem<?>> items) {
        ModuleItem<?> result = null;
        block0: for (ModuleItem<?> item : items) {
            String name = item.getName();
            boolean resolved = module.isInputResolved(name);
            if (resolved || !item.isAutoFill()) continue;
            Class<?> itemType = item.getType();
            for (Class<?> type : types) {
                if (!type.isAssignableFrom(itemType)) continue;
                if (result != null) {
                    return null;
                }
                result = item;
                continue block0;
            }
        }
        return result;
    }

    private <T> Class<?> delegateClass(ModuleItem<T> item) {
        try {
            return item.getInfo().loadDelegateClass();
        }
        catch (ClassNotFoundException exc) {
            throw new IllegalStateException(exc);
        }
    }
}

