/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui;

import org.scijava.module.Module;
import org.scijava.module.ModuleItem;
import org.scijava.module.process.AbstractPreprocessorPlugin;
import org.scijava.module.process.PreprocessorPlugin;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.UIService;
import org.scijava.ui.UserInterface;

@Plugin(type=PreprocessorPlugin.class, priority=10000.0)
public class UIPreprocessor
extends AbstractPreprocessorPlugin {
    @Parameter(required=false)
    private UIService uiService;

    @Override
    public void process(Module module) {
        if (this.uiService == null) {
            return;
        }
        UserInterface ui = this.uiService.getDefaultUI();
        if (ui == null) {
            return;
        }
        for (ModuleItem<?> input : module.getInfo().inputs()) {
            Class<?> type;
            if (!input.isAutoFill() || !(type = input.getType()).isAssignableFrom(ui.getClass())) continue;
            String name = input.getName();
            module.setInput(name, ui);
            module.resolveInput(name);
        }
    }
}

