/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.io.Serializable;
import java.lang.reflect.Type;
import org.scijava.convert.ConversionRequest;
import org.scijava.convert.ConvertService;
import org.scijava.convert.Converter;
import org.scijava.convert.DefaultConverter;
import org.scijava.util.GenericUtils;

public class ConversionUtils {
    private static ConvertService convertService;
    private static Converter<?, ?> converterNoContext;
    private static double servicePriority;

    private ConversionUtils() {
    }

    public static <T> T convertToEnum(String src, Class<T> dest) {
        if (src == null || !dest.isEnum()) {
            return null;
        }
        try {
            T result;
            T typedResult = result = Enum.valueOf(dest, src);
            return typedResult;
        }
        catch (IllegalArgumentException exc) {
            return null;
        }
    }

    public static <T> T cast(Object src, Class<T> dest) {
        if (!ConversionUtils.canCast(src, dest)) {
            return null;
        }
        Object result = src;
        return (T)result;
    }

    public static boolean canCast(Class<?> src, Class<?> dest) {
        if (dest == null) {
            return false;
        }
        return src == null || dest.isAssignableFrom(src);
    }

    public static boolean canCast(Object src, Class<?> dest) {
        if (dest == null) {
            return false;
        }
        return src == null || ConversionUtils.canCast(src.getClass(), dest);
    }

    public static <T> Class<T> getPrimitiveType(Class<T> type) {
        Class<Object> destType = type == Boolean.class ? Boolean.TYPE : (type == Byte.class ? Byte.TYPE : (type == Character.class ? Character.TYPE : (type == Double.class ? Double.TYPE : (type == Float.class ? Float.TYPE : (type == Integer.class ? Integer.TYPE : (type == Long.class ? Long.TYPE : (type == Short.class ? Short.TYPE : (type == Void.class ? Void.TYPE : type))))))));
        Class<Boolean> result = destType;
        return result;
    }

    public static <T> Class<T> getNonprimitiveType(Class<T> type) {
        Class destType = type == Boolean.TYPE ? Boolean.class : (type == Byte.TYPE ? Byte.class : (type == Character.TYPE ? Character.class : (type == Double.TYPE ? Double.class : (type == Float.TYPE ? Float.class : (type == Integer.TYPE ? Integer.class : (type == Long.TYPE ? Long.class : (type == Short.TYPE ? Short.class : (type == Void.TYPE ? Void.class : type))))))));
        Class<Boolean> result = destType;
        return result;
    }

    public static <T> T getNullValue(Class<T> type) {
        Serializable defaultValue = type == Boolean.TYPE ? Boolean.valueOf(false) : (type == Byte.TYPE ? Byte.valueOf((byte)0) : (type == Character.TYPE ? (Serializable)Character.valueOf('\u0000') : (Serializable)(type == Double.TYPE ? (Number)0.0 : (Number)(type == Float.TYPE ? (Number)Float.valueOf(0.0f) : (Number)(type == Integer.TYPE ? (Number)0 : (Number)(type == Long.TYPE ? (Number)0L : (Number)(type == Short.TYPE ? Short.valueOf((short)0) : null)))))));
        Boolean result = defaultValue;
        return (T)result;
    }

    public static void setDelegateService(ConvertService convertService, double priority) {
        if (ConversionUtils.convertService == null || Double.compare(priority, servicePriority) > 0) {
            ConversionUtils.convertService = convertService;
            servicePriority = priority;
        }
    }

    @Deprecated
    public static Object convert(Object src, Type dest) {
        Converter<?, ?> handler = ConversionUtils.handler(new ConversionRequest(src, dest));
        return handler == null ? null : handler.convert(src, dest);
    }

    @Deprecated
    public static <T> T convert(Object src, Class<T> dest) {
        Converter<?, ?> handler = ConversionUtils.handler(new ConversionRequest(src, dest));
        return handler == null ? null : (T)handler.convert(src, dest);
    }

    @Deprecated
    public static boolean canConvert(Class<?> src, Type dest) {
        Converter<?, ?> handler = ConversionUtils.handler(new ConversionRequest(src, dest));
        return handler == null ? false : handler.canConvert(src, dest);
    }

    @Deprecated
    public static boolean canConvert(Class<?> src, Class<?> dest) {
        Converter<?, ?> handler = ConversionUtils.handler(new ConversionRequest(src, dest));
        return handler == null ? false : handler.canConvert(src, dest);
    }

    @Deprecated
    public static boolean canConvert(Object src, Type dest) {
        Converter<?, ?> handler = ConversionUtils.handler(new ConversionRequest(src, dest));
        return handler == null ? false : handler.canConvert(src, dest);
    }

    @Deprecated
    public static boolean canConvert(Object src, Class<?> dest) {
        Converter<?, ?> handler = ConversionUtils.handler(new ConversionRequest(src, dest));
        return handler == null ? false : handler.canConvert(src, dest);
    }

    @Deprecated
    public static Class<?> getClass(Type type) {
        return GenericUtils.getClass(type);
    }

    @Deprecated
    public static Class<?> getComponentClass(Type type) {
        return GenericUtils.getComponentClass(type);
    }

    private static Converter<?, ?> handler(ConversionRequest data) {
        if (convertService != null) {
            return (Converter)convertService.getHandler(data);
        }
        if (converterNoContext == null) {
            converterNoContext = new DefaultConverter();
        }
        return converterNoContext;
    }

    static {
        servicePriority = 0.0;
    }
}

