/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.task;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.scijava.event.EventService;
import org.scijava.task.Task;
import org.scijava.task.event.TaskEvent;
import org.scijava.thread.ThreadService;

public class DefaultTask
implements Task {
    private final ThreadService threadService;
    private final EventService eventService;
    private Future<?> future;
    private boolean canceled;
    private String cancelReason;
    private String status;
    private long step;
    private long max;
    private String name;

    public DefaultTask(ThreadService threadService, EventService eventService) {
        this.threadService = threadService;
        this.eventService = eventService;
    }

    @Override
    public void run(Runnable r) {
        if (r == null) {
            throw new NullPointerException();
        }
        this.future(r);
    }

    @Override
    public void waitFor() throws InterruptedException, ExecutionException {
        this.future().get();
    }

    @Override
    public boolean isDone() {
        return this.future != null && this.future.isDone();
    }

    @Override
    public String getStatusMessage() {
        return this.status;
    }

    @Override
    public long getProgressValue() {
        return this.step;
    }

    @Override
    public long getProgressMaximum() {
        return this.max;
    }

    @Override
    public void setStatusMessage(String status) {
        this.status = status;
        this.fireTaskEvent();
    }

    @Override
    public void setProgressValue(long step) {
        this.step = step;
        this.fireTaskEvent();
    }

    @Override
    public void setProgressMaximum(long max) {
        this.max = max;
        this.fireTaskEvent();
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void cancel(String reason) {
        this.canceled = true;
        this.cancelReason = reason;
    }

    @Override
    public String getCancelReason() {
        return this.cancelReason;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    private Future<?> future() {
        return this.future(null);
    }

    private Future<?> future(Runnable r) {
        if (this.future == null) {
            this.initFuture(r);
        }
        return this.future;
    }

    private synchronized void initFuture(Runnable r) {
        if (this.future != null) {
            return;
        }
        if (r == null) {
            throw new IllegalArgumentException("Must call run first");
        }
        this.future = this.threadService.run(r);
    }

    private void fireTaskEvent() {
        if (this.eventService != null) {
            this.eventService.publish(new TaskEvent(this));
        }
    }
}

