/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io.handle;

import java.io.EOFException;
import java.io.IOException;
import org.scijava.io.ByteBank;
import org.scijava.io.handle.AbstractDataHandle;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.location.BytesLocation;
import org.scijava.plugin.Plugin;

@Plugin(type=DataHandle.class)
public class BytesHandle
extends AbstractDataHandle<BytesLocation> {
    private long offset = 0L;

    @Override
    public boolean isReadable() {
        return true;
    }

    @Override
    public boolean isWritable() {
        return !this.bytes().isReadOnly();
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public long length() {
        return this.bytes().size();
    }

    @Override
    public void setLength(long length) throws IOException {
        this.bytes().basicRangeCheck(0L, length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (this.offset + (long)len > this.length()) {
            len = (int)(this.length() - this.offset);
        }
        if (len == 0) {
            return -1;
        }
        this.bytes().getBytes(this.offset, b, off, len);
        this.offset += (long)len;
        return len;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos > this.length()) {
            this.setLength(pos);
        }
        this.offset = pos;
    }

    @Override
    public byte readByte() throws IOException {
        this.ensureReadable(1L);
        try {
            return this.bytes().getByte(this.offset++);
        }
        catch (Exception e) {
            throw this.eofException(e);
        }
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.ensureReadable(len);
        try {
            this.bytes().getBytes(this.offset, b, off, len);
            this.offset += (long)len;
        }
        catch (Exception e) {
            throw this.eofException(e);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.ensureWritable(len);
        this.bytes().setBytes(this.offset, b, off, len);
        this.offset += (long)len;
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureWritable(1L);
        this.bytes().setByte(this.offset, (byte)b);
        ++this.offset;
    }

    @Override
    public void close() {
    }

    @Override
    public Class<BytesLocation> getType() {
        return BytesLocation.class;
    }

    private ByteBank bytes() {
        return ((BytesLocation)this.get()).getByteBank();
    }

    private EOFException eofException(Throwable cause) {
        EOFException eof = new EOFException();
        eof.initCause(cause);
        return eof;
    }
}

