/*
 * Decompiled with CFR 0.152.
 */
package org.scijava;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.scijava.Disposable;
import org.scijava.NoSuchServiceException;
import org.scijava.event.ContextDisposingEvent;
import org.scijava.event.EventHandler;
import org.scijava.event.EventService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.PluginIndex;
import org.scijava.service.Service;
import org.scijava.service.ServiceHelper;
import org.scijava.service.ServiceIndex;
import org.scijava.util.ClassUtils;
import org.scijava.util.Query;
import org.scijava.util.Types;

public class Context
implements Disposable,
AutoCloseable {
    public static final String STRICT_PROPERTY = "scijava.context.strict";
    private final ServiceIndex serviceIndex = new ServiceIndex();
    private final PluginIndex pluginIndex;
    private boolean strict;
    private boolean disposed;

    public Context() {
        this(false);
    }

    public Context(boolean empty) {
        this(empty, false);
    }

    public Context(boolean noServices, boolean noPlugins) {
        this(Context.services(noServices), Context.plugins(noPlugins));
    }

    public Context(Class ... serviceClasses) {
        this(Context.serviceClassList(serviceClasses));
    }

    public Context(Collection<Class<? extends Service>> serviceClasses) {
        this(serviceClasses, null);
    }

    public Context(Collection<Class<? extends Service>> serviceClasses, boolean strict) {
        this(serviceClasses, null, strict);
    }

    public Context(PluginIndex pluginIndex) {
        this(Context.services(false), pluginIndex);
    }

    public Context(Collection<Class<? extends Service>> serviceClasses, PluginIndex pluginIndex) {
        this(serviceClasses, pluginIndex, Context.strict());
    }

    public Context(Collection<Class<? extends Service>> serviceClasses, PluginIndex pluginIndex, boolean strict) {
        this.pluginIndex = pluginIndex == null ? new PluginIndex() : pluginIndex;
        this.pluginIndex.discover();
        this.setStrict(strict);
        if (!serviceClasses.isEmpty()) {
            ServiceHelper serviceHelper = new ServiceHelper(this, serviceClasses, strict);
            serviceHelper.loadServices();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.doDispose(false)));
    }

    public ServiceIndex getServiceIndex() {
        return this.serviceIndex;
    }

    public PluginIndex getPluginIndex() {
        return this.pluginIndex;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public <S extends Service> S service(Class<S> c) {
        S service = this.getService(c);
        if (service == null) {
            throw new NoSuchServiceException("Service " + c.getName() + " not found.");
        }
        return service;
    }

    public Service service(String className) {
        Class<?> c = Types.load(className, false);
        if (!Service.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException("Not a service class: " + c.getName());
        }
        Class<?> serviceClass = c;
        return this.service(serviceClass);
    }

    public <S extends Service> S getService(Class<S> c) {
        return this.serviceIndex.getService(c);
    }

    public Service getService(String className) {
        Class<?> c = Types.load(className);
        if (c == null) {
            return null;
        }
        if (!Service.class.isAssignableFrom(c)) {
            return null;
        }
        Class<?> serviceClass = c;
        return this.getService(serviceClass);
    }

    public void inject(Object o) {
        Query query = new Query();
        query.put(Parameter.class, Field.class);
        query.put(EventHandler.class, Method.class);
        ClassUtils.cacheAnnotatedObjects(o.getClass(), query);
        List<Field> fields = this.getParameterFields(o);
        for (Field f : fields) {
            this.inject(f, o);
        }
        this.subscribeToEvents(o);
    }

    public boolean isInjectable(Class<?> type) {
        if (Service.class.isAssignableFrom(type)) {
            return true;
        }
        return Context.class.isAssignableFrom(type) && type.isInstance(this);
    }

    @Override
    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.doDispose(true);
    }

    @Override
    public void close() {
        this.dispose();
    }

    public static List<Class<? extends Service>> serviceClassList(Class ... serviceClasses) {
        return serviceClasses != null ? Arrays.asList(serviceClasses) : Arrays.asList(Service.class);
    }

    public static ClassLoader getClassLoader() {
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        return contextCL != null ? contextCL : ClassLoader.getSystemClassLoader();
    }

    private List<Field> getParameterFields(Object o) {
        try {
            return ClassUtils.getAnnotatedFields(o.getClass(), Parameter.class);
        }
        catch (Throwable t) {
            this.handleSafely(t);
            return Collections.emptyList();
        }
    }

    private void inject(Field f, Object o) {
        try {
            Object value;
            f.setAccessible(true);
            Class<?> type = f.getType();
            if (Service.class.isAssignableFrom(type)) {
                Service existingService = (Service)ClassUtils.getValue(f, o);
                if (this.strict && existingService != null) {
                    throw new IllegalStateException("Context already injected: " + f.getDeclaringClass().getName() + "#" + f.getName());
                }
                Class<?> serviceType = type;
                Object service = this.getService(serviceType);
                if (service == null && f.getAnnotation(Parameter.class).required()) {
                    throw new IllegalArgumentException(this.createMissingServiceMessage(serviceType));
                }
                if (existingService != null && existingService != service) {
                    throw new IllegalStateException("Mismatched context: " + f.getDeclaringClass().getName() + "#" + f.getName());
                }
                ClassUtils.setValue(f, o, service);
            } else if (Context.class.isAssignableFrom(type) && type.isInstance(this)) {
                Context existingContext = (Context)ClassUtils.getValue(f, o);
                if (this.strict && existingContext != null) {
                    throw new IllegalStateException("Context already injected: " + f.getDeclaringClass().getName() + "#" + f.getName());
                }
                if (existingContext != null && existingContext != this) {
                    throw new IllegalStateException("Mismatched context: " + f.getDeclaringClass().getName() + "#" + f.getName());
                }
                ClassUtils.setValue(f, o, this);
            } else if (!type.isPrimitive() && (value = ClassUtils.getValue(f, o)) != null) {
                this.inject(value);
            }
        }
        catch (Throwable t) {
            this.handleSafely(t);
        }
    }

    private void subscribeToEvents(Object o) {
        try {
            EventService eventService = this.getService(EventService.class);
            if (eventService != null) {
                eventService.subscribe(o);
            }
        }
        catch (Throwable t) {
            this.handleSafely(t);
        }
    }

    private void handleSafely(Throwable t) {
        LogService log;
        if (this.isStrict()) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
        }
        if ((log = this.getService(LogService.class)) != null) {
            log.error(t);
        }
    }

    private String createMissingServiceMessage(Class<? extends Service> serviceType) {
        String nl = System.getProperty("line.separator");
        ClassLoader classLoader = Context.getClassLoader();
        StringBuilder msg = new StringBuilder("Required service is missing: " + serviceType.getName() + nl);
        msg.append("Context: " + this + nl);
        msg.append("ClassLoader: " + classLoader + nl);
        msg.append(nl + "-- Services known to context --" + nl);
        for (Service knownService : this.serviceIndex.getAll()) {
            msg.append(knownService + nl);
        }
        msg.append(nl + "-- Classpath of ClassLoader --" + nl);
        if (classLoader instanceof URLClassLoader) {
            for (URL url : ((URLClassLoader)classLoader).getURLs()) {
                msg.append(url.getPath() + nl);
            }
        } else {
            msg.append("ClassLoader was not a URLClassLoader. Could not print classpath.");
        }
        return msg.toString();
    }

    private synchronized void doDispose(boolean announce) {
        EventService eventService;
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        if (announce && (eventService = this.getService(EventService.class)) != null) {
            eventService.publish(new ContextDisposingEvent());
        }
        List services = this.serviceIndex.getAll();
        for (int s = services.size() - 1; s >= 0; --s) {
            ((Service)services.get(s)).dispose();
        }
    }

    private static PluginIndex plugins(boolean empty) {
        return empty ? new PluginIndex(null) : null;
    }

    private static List<Class<? extends Service>> services(boolean empty) {
        if (empty) {
            return Collections.emptyList();
        }
        return Arrays.asList(Service.class);
    }

    private static boolean strict() {
        return !"false".equals(System.getProperty(STRICT_PROPERTY));
    }
}

