/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io.nio;

import java.nio.ByteBuffer;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.scijava.io.ByteBank;
import org.scijava.io.ByteBankTest;
import org.scijava.io.nio.ByteBufferByteBank;

@RunWith(value=Parameterized.class)
public class ByteBufferByteBankTest
extends ByteBankTest {
    @Parameterized.Parameter
    public Function<Integer, ByteBuffer> supplier;

    @Parameterized.Parameters
    public static Object[] params() {
        Function<Integer, ByteBuffer> alloc = ByteBuffer::allocate;
        Function<Integer, ByteBuffer> allocDirect = ByteBuffer::allocateDirect;
        return new Function[]{alloc, allocDirect};
    }

    @Override
    public ByteBank createByteBank() {
        return new ByteBufferByteBank(this.supplier);
    }

    @Test
    public void testReadOnlyDefault() {
        ByteBufferByteBank bank = new ByteBufferByteBank();
        Assert.assertFalse((boolean)bank.isReadOnly());
    }

    @Test
    public void testReadOnlyAllocate() {
        ByteBufferByteBank bank = new ByteBufferByteBank(ByteBuffer::allocate);
        Assert.assertFalse((boolean)bank.isReadOnly());
        ByteBufferByteBank readOnlyBank = new ByteBufferByteBank(capacity -> ByteBuffer.allocate(capacity).asReadOnlyBuffer());
        Assert.assertTrue((boolean)readOnlyBank.isReadOnly());
    }

    @Test
    public void testReadOnlyAllocateDirect() {
        ByteBufferByteBank bank = new ByteBufferByteBank(ByteBuffer::allocateDirect);
        Assert.assertFalse((boolean)bank.isReadOnly());
        ByteBufferByteBank readOnlyBank = new ByteBufferByteBank(capacity -> ByteBuffer.allocateDirect(capacity).asReadOnlyBuffer());
        Assert.assertTrue((boolean)readOnlyBank.isReadOnly());
    }
}

